// Copyright 2020 Google LLC
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

#include <stdint.h>

#include <xnnpack/common.h>


// Table of exp2(k / 64) values decremented (as integer) by (k << 17), k = 0..63
XNN_INTERNAL const uint32_t xnn_table_exp2minus_k_over_64[64] = {
  0x3F800000, 0x3F7F64D2, 0x3F7ECD87, 0x3F7E3A29, 0x3F7DAAC3, 0x3F7D1F62, 0x3F7C980F, 0x3F7C14D5,
  0x3F7B95C2, 0x3F7B1ADF, 0x3F7AA43A, 0x3F7A31DC, 0x3F79C3D3, 0x3F795A2B, 0x3F78F4F0, 0x3F78942D,
  0x3F7837F0, 0x3F77E046, 0x3F778D3A, 0x3F773EDA, 0x3F76F532, 0x3F76B051, 0x3F767043, 0x3F763516,
  0x3F75FED7, 0x3F75CD94, 0x3F75A15B, 0x3F757A3A, 0x3F75583F, 0x3F753B79, 0x3F7523F6, 0x3F7511C4,
  0x3F7504F3, 0x3F74FD92, 0x3F74FBAF, 0x3F74FF5B, 0x3F7508A4, 0x3F75179A, 0x3F752C4D, 0x3F7546CD,
  0x3F75672A, 0x3F758D75, 0x3F75B9BE, 0x3F75EC15, 0x3F76248C, 0x3F766334, 0x3F76A81E, 0x3F76F35B,
  0x3F7744FD, 0x3F779D16, 0x3F77FBB8, 0x3F7860F5, 0x3F78CCDF, 0x3F793F89, 0x3F79B907, 0x3F7A396A,
  0x3F7AC0C7, 0x3F7B4F30, 0x3F7BE4BA, 0x3F7C8177, 0x3F7D257D, 0x3F7DD0DF, 0x3F7E83B3, 0x3F7F3E0C,
};
