/**************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the tools applications of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
**************************************************************************/
var ifwVersion;

function Component()
{
    // From 4.9.0 onwards telemetry is shown in the login page and implemented
    // in IFW extensions
    ifwVersion = installer.value("FrameworkVersion");

    installer.finishAllComponentsReset.connect(this, reselectComponentAfterRefresh);
    installer.finishUpdaterComponentsReset.connect(this, reselectComponentAfterRefresh);

    if (installer.versionMatches(ifwVersion, "<4.9.0"))
        component.loaded.connect(this, addTelemetryQuery);
    else
        installer.valueChanged.connect(this, onTelemetrySelectionChanged);
}

Component.prototype.createOperations = function()
{
    component.createOperations();
    if (installer.versionMatches(ifwVersion, "<4.9.0")) {
        component.addOperation("GlobalConfig", "QtProject", "UserFeedback.QtCreator",
            "UserFeedback/StatisticsCollectionMode", "DetailedUsageStatistics");
    }
}

onTelemetrySelectionChanged = function(key, value)
{
    if (key != "TelemetryPluginApproved")
        return;

    if (value == "true")
        selectTelemetry();
    else
        deselectTelemetry();
}

// called after refresh
function reselectComponentAfterRefresh()
{
    if (installer.value("TelemetryPluginApproved") == "true")
        selectTelemetry();
    else
        deselectTelemetry();
}

function enableNextButton()
{
    var widget = gui.pageWidgetByObjectName("DynamicTelemetryPluginForm");
    if (widget) {
        widget.complete = true;
    }
}

addTelemetryQuery = function()
{
    if (installer.isInstaller()) {
        var pageWidget = gui.currentPageWidget()
        if (installer.addWizardPage(component, "TelemetryPluginForm", QInstaller.TargetDirectory)) {
            component.userInterface("TelemetryPluginForm").statisticGroupBox.enableStatisticRadioButton.checked = false;
            component.userInterface("TelemetryPluginForm").statisticGroupBox.enableStatisticRadioButton.toggled.connect(installTelemetryPluginIfChecked);
            component.userInterface("TelemetryPluginForm").statisticGroupBox.disableStatisticRadioButton.checked = false;
            component.userInterface("TelemetryPluginForm").statisticGroupBox.disableStatisticRadioButton.toggled.connect(installTelemetryPluginIfChecked);
            var widget = gui.pageWidgetByObjectName("DynamicTelemetryPluginForm");

            if (widget != null) {
                //complete = false will disable next button
                widget.complete = false;
            }
        } else { //Command line instance
            var result = QMessageBox["question"]("telemetry-question", "Contribute to Qt Development",
                "Help us improve Qt and Qt Creator by allowing tracking of pseudonymous usage data in Qt Creator. " +
                "The tracking can be disabled at any time. Read the Qt Company data collection privacy statement " +
                "https://www.qt.io/terms-conditions/#privacy.", QMessageBox.Yes | QMessageBox.No, QMessageBox.Yes);
            if (result == QMessageBox.Yes) {
                selectTelemetry();
                installer.setValue("TelemetryPluginApproved", "true");
            } else {
                deselectTelemetry();
                installer.setValue("TelemetryPluginApproved", "false");
            }
        }
    }
}

installTelemetryPluginIfChecked = function(checked)
{
    // Select/unselect the telemetry plugin component for installation
    var widget = gui.pageWidgetByObjectName("DynamicTelemetryPluginForm");
    // Component cannot be selected if it is virtual, change value temporarily
    if (widget != null) {
        var componentSelectionPage = gui.pageWidgetByObjectName("ComponentSelectionPage");
        enableNextButton()
        var pluginForm = component.userInterface("TelemetryPluginForm")
        if (pluginForm && pluginForm.statisticGroupBox.enableStatisticRadioButton.checked == true) {
            // ComponentSelectionPage might not be visible. This is the case when using 'Default Install'
            // feature in 4.0.0. If that is the case use installer.selectComponent() instead which
            // is available from ifw version 4.0.0 onwards
            if (componentSelectionPage)
                componentSelectionPage.selectComponent(component.name);
            else
                installer.selectComponent(component.name);
            selectTelemetry();
            installer.setValue("TelemetryPluginApproved", "true");
        }
        if (pluginForm && pluginForm.statisticGroupBox.disableStatisticRadioButton.checked == true) {
            if (componentSelectionPage)
                componentSelectionPage.deselectComponent(component.name);
            else
                installer.deselectComponent(component.name);
            deselectTelemetry();
            installer.setValue("TelemetryPluginApproved", "false");
        }
        installer.clearComponentsToInstallCalculated();
        installer.calculateComponentsToInstall()
    } else {
        console.log("DynamicTelemetryPluginForm not found")
    }
}

function selectTelemetry()
{
    component.setValue("AutoDependOn", "qt.tools.qtcreator_gui")

    // user has fetched preview category, selected QtCreator preview and approved telemetry, decides to start over
    if (installer.componentByName("preview.qt.tools.qtcreator") && installer.componentByName("preview.qt.tools.qtcreator.telemetry")) {
        installer.componentByName("preview.qt.tools.qtcreator.telemetry").setValue("AutoDependOn", "preview.qt.tools.qtcreator");
    }
}

function deselectTelemetry()
{
    component.setValue("AutoDependOn", "")
    // user has fetched preview category, selected QtCreator preview, approved telemetry, decides to start over, declines telemetry
    if (installer.componentByName("preview.qt.tools.qtcreator.telemetry")) {
        installer.componentByName("preview.qt.tools.qtcreator.telemetry").setValue("AutoDependOn", "");
    }
}
