# Perfetto build instructions

The source of truth for the Perfetto codebase currently lives in AOSP:
https://android.googlesource.com/platform/external/perfetto/

Perfetto can be built both from the Android tree (AOSP) and standalone.
Standalone builds are meant only for local testing and are not shipped.
Due to the reduced dependencies they are faster to iterate on and the
suggested way to work on Perfetto.

Get the code
------------
**Standalone checkout**:  
```
$ git clone https://android.googlesource.com/platform/external/perfetto/
```

**Android tree**:  
Perfetto lives in `external/perfetto` in the AOSP tree.


Prerequisites
-------------
**Standalone checkout**:  
All dependent libraries are self-hosted and pulled through:
```
$ tools/install-build-deps [--android] [--ui]
```

**Android tree**:  
See https://source.android.com/setup


Building
--------
**Standalone checkout**:  
If you are a chromium developer and have depot_tools installed you can avoid
the `tools/` prefix below and just use gn/ninja from depot_tools.

`$ tools/gn args out/android` to generate build files and enter in the editor:

```
target_os = "android"                 # Only when building for Android
target_cpu = "arm" / "arm64" / "x64"  # Only when building for Android
is_debug = true / false
cc_wrapper = "ccache"                 # Optionally speed repeated builds with ccache
```

(See the [Build Configurations](#build-configurations) section below for more)

```
$ tools/ninja -C out/android
```

To build the UI (remember to run `tools/install-build-deps --ui` first):

```
$ tools/ninja -C out/android ui
```

**Android tree**:  
`$ mmma external/perfetto`
or
`$ m perfetto traced traced_probes`

This will generate artifacts `out/target/product/XXX/system/`.
Executables and shared libraries are stripped by default by the Android build
system. The unstripped artifacts are kept into `out/target/product/XXX/symbols`.

IDE setup
---------

Use a following command in the checkout directory in order to generate the
compilation database file:

```
$ tools/ninja -C out/android -t compdb cc cxx > compile_commands.json
```

After generating, it can be used in CLion (File -> Open -> Open As Project),
Visual Studio Code with C/C++ extension and any other tool and editor that
supports the compilation database format.

Build files
-----------
The source of truth of our build file is in the BUILD.gn files, which are based on [GN][gn-quickstart].
The Android build file ([Android.bp](../Android.bp)) is autogenerated from the GN files
through `tools/gen_android_bp`, which needs to be invoked whenever a change
touches GN files or introduces new ones.  
A presubmit check checks that the Android.bp is consistent with GN files when
submitting a CL through `git cl upload`.  
The generator has a whitelist of root targets that will be translated into the
Android.bp file. If you are adding a new target, add a new entry to the
`default_targets` variable inside [tools/gen_android_bp](../tools/gen_android_bp).


Supported platforms
-------------------
**Linux desktop** (Debian Rodete):
  - Hermetic clang + libcxx toolchain (both following chromium's revisions)
  - GCC-7 and libstdc++ 6

**Android**:
  - Android's NDK r15c (using NDK's libcxx)
  - AOSP's in-tree clang (using in-tree libcxx)

**Mac**:
 - XCode 9 / clang (currently maintained best-effort).



Build configurations
--------------------
*** aside
`tools/build_all_configs.py` can be used to generate out/XXX folders for most of
the supported configurations.
***

The following [GN args][gn-quickstart] are supported:

`target_os = "android" | "linux" | "mac"`:  
Defaults to the current host, set "android" to build for Android.

`target_cpu = "arm" | "arm64" | "x86" | "x64"`:  
Defaults to `"arm"` when `target_os` == `"android"`, `"x64"` when targeting the
host. 32-bit host builds are not supported.

`is_debug = true | false`:  
Toggles Debug (default) / Release mode.

`is_clang = true | false`:  
Use Clang (default: true) or GCC (false).
On Linux, by default it uses the self-hosted clang (see `is_hermetic_clang`).
On Android, by default it uses clang from the NDK (in `buildtools/ndk`).
On Mac, by default it uses the system version of clang (requires Xcode).

`is_hermetic_clang = true | false`:  
Use bundled toolchain from `buildtools/` rather than system-wide one.

`cc = "gcc" / cxx = "g++"`:  
Uses a different compiler binary (default: autodetected depending on is_clang).

`cc_wrapper = "tool"`:  
Prepends all build commands with a wrapper command. Using `"ccache"` here
enables the [ccache](https://github.com/ccache/ccache) caching compiler,
which can considerable speed up repeat builds.

`is_asan = true`:  
Enables [Address Sanitizer](https://github.com/google/sanitizers/wiki/AddressSanitizer)

`is_lsan = true`:  
Enables [Leak Sanitizer](https://github.com/google/sanitizers/wiki/AddressSanitizerLeakSanitizer)
(Linux/Mac only)

`is_msan = true`:  
Enables [Memory Sanitizer](https://github.com/google/sanitizers/wiki/MemorySanitizer)
(Linux only)

`is_tsan = true`:  
Enables [Thread Sanitizer](https://github.com/google/sanitizers/wiki/ThreadSanitizerCppManual)
(Linux/Mac only)

`is_ubsan = true`:  
Enables [Undefined Behavior Sanitizer](https://clang.llvm.org/docs/UndefinedBehaviorSanitizer.html)


[gn-quickstart]: https://gn.googlesource.com/gn/+/master/docs/quick_start.md
