// Copyright 2019 The libgav1 Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is just a convenience to separate out all the CDF constant
// definitions from the symbol decoder context functions.

constexpr uint16_t kDefaultPartitionCdf
    [kBlockWidthCount][kPartitionContexts][kMaxPartitionTypes + 1] = {
        // width 8
        {{13636, 7258, 2376, 0, 0},
         {18840, 12913, 4228, 0, 0},
         {20246, 9089, 4139, 0, 0},
         {22872, 13985, 6915, 0, 0}},
        // width 16
        {{17171, 11839, 8197, 6062, 5104, 3947, 3167, 2197, 866, 0, 0},
         {24843, 21725, 15983, 10298, 8797, 7725, 6117, 4067, 2934, 0, 0},
         {27354, 19499, 17657, 12280, 10408, 8268, 7231, 6432, 651, 0, 0},
         {30106, 26406, 24154, 11908, 9715, 7990, 6332, 4939, 1597, 0, 0}},
        // width 32
        {{14306, 11848, 9644, 5121, 4541, 3719, 3249, 2590, 1224, 0, 0},
         {25079, 23708, 20712, 7776, 7108, 6586, 5817, 4727, 3716, 0, 0},
         {26753, 23759, 22706, 8224, 7359, 6223, 5697, 5242, 721, 0, 0},
         {31374, 30560, 29972, 4154, 3707, 3302, 2928, 2583, 869, 0, 0}},
        // width 64
        {{12631, 11221, 9690, 3202, 2931, 2507, 2244, 1876, 1044, 0, 0},
         {26036, 25278, 23271, 4824, 4518, 4253, 3799, 3138, 2664, 0, 0},
         {26823, 25105, 24420, 4085, 3651, 3019, 2704, 2470, 530, 0, 0},
         {31898, 31556, 31281, 1570, 1374, 1194, 1025, 887, 436, 0, 0}},
        // width 128
        {{4869, 4549, 4239, 284, 229, 149, 129, 0, 0},
         {26161, 25778, 24500, 708, 549, 430, 397, 0, 0},
         {27339, 26092, 25646, 741, 541, 237, 186, 0, 0},
         {32057, 31802, 31596, 320, 230, 151, 104, 0, 0}}};

constexpr uint16_t kDefaultSegmentIdCdf[kSegmentIdContexts][kMaxSegments + 1] =
    {{27146, 24875, 16675, 14535, 4959, 4395, 235, 0, 0},
     {18494, 14538, 10211, 7833, 2788, 1917, 424, 0, 0},
     {5241, 4281, 4045, 3878, 371, 121, 89, 0, 0}};

constexpr uint16_t
    kDefaultUsePredictedSegmentIdCdf[kUsePredictedSegmentIdContexts]
                                    [kBooleanFieldCdfSize] = {{16384, 0, 0},
                                                              {16384, 0, 0},
                                                              {16384, 0, 0}};

constexpr uint16_t kDefaultSkipCdf[kSkipContexts][kBooleanFieldCdfSize] = {
    {1097, 0, 0}, {16253, 0, 0}, {28192, 0, 0}};

constexpr uint16_t
    kDefaultSkipModeCdf[kSkipModeContexts][kBooleanFieldCdfSize] = {
        {147, 0, 0}, {12060, 0, 0}, {24641, 0, 0}};

// This constant is also used for DeltaLf and DeltaLfMulti.
constexpr uint16_t kDefaultDeltaQCdf[kDeltaSymbolCount + 1] = {4608, 648, 91, 0,
                                                               0};

constexpr uint16_t kDefaultIntraBlockCopyCdf[kBooleanFieldCdfSize] = {2237, 0,
                                                                      0};

constexpr uint16_t
    kDefaultIntraFrameYModeCdf[kIntraModeContexts][kIntraModeContexts]
                              [kIntraPredictionModesY + 1] = {
                                  {{17180, 15741, 13430, 12550, 12086, 11658,
                                    10943, 9524, 8579, 4603, 3675, 2302, 0, 0},
                                   {20752, 14702, 13252, 12465, 12049, 11324,
                                    10880, 9736, 8334, 4110, 2596, 1359, 0, 0},
                                   {22716, 21997, 10472, 9980, 9713, 9529, 8635,
                                    7148, 6608, 3432, 2839, 1201, 0, 0},
                                   {18677, 17362, 16326, 13960, 13632, 13222,
                                    12770, 10672, 8022, 3183, 1810, 306, 0, 0},
                                   {20646, 19503, 17165, 16267, 14159, 12735,
                                    10377, 7185, 6331, 2507, 1695, 293, 0, 0}},
                                  {{22745, 13183, 11920, 11328, 10936, 10008,
                                    9679, 8745, 7387, 3754, 2286, 1332, 0, 0},
                                   {26785, 8669, 8208, 7882, 7702, 6973, 6855,
                                    6345, 5158, 2863, 1492, 974, 0, 0},
                                   {25324, 19987, 12591, 12040, 11691, 11161,
                                    10598, 9363, 8299, 4853, 3678, 2276, 0, 0},
                                   {24231, 18079, 17336, 15681, 15360, 14596,
                                    14360, 12943, 8119, 3615, 1672, 558, 0, 0},
                                   {25225, 18537, 17272, 16573, 14863, 12051,
                                    10784, 8252, 6767, 3093, 1787, 774, 0, 0}},
                                  {{20155, 19177, 11385, 10764, 10456, 10191,
                                    9367, 7713, 7039, 3230, 2463, 691, 0, 0},
                                   {23081, 19298, 14262, 13538, 13164, 12621,
                                    12073, 10706, 9549, 5025, 3557, 1861, 0, 0},
                                   {26585, 26263, 6744, 6516, 6402, 6334, 5686,
                                    4414, 4213, 2301, 1974, 682, 0, 0},
                                   {22050, 21034, 17814, 15544, 15203, 14844,
                                    14207, 11245, 8890, 3793, 2481, 516, 0, 0},
                                   {23574, 22910, 16267, 15505, 14344, 13597,
                                    11205, 6807, 6207, 2696, 2031, 305, 0, 0}},
                                  {{20166, 18369, 17280, 14387, 13990, 13453,
                                    13044, 11349, 7708, 3072, 1851, 359, 0, 0},
                                   {24565, 18947, 18244, 15663, 15329, 14637,
                                    14364, 13300, 7543, 3283, 1610, 426, 0, 0},
                                   {24317, 23037, 17764, 15125, 14756, 14343,
                                    13698, 11230, 8163, 3650, 2690, 750, 0, 0},
                                   {25054, 23720, 23252, 16101, 15951, 15774,
                                    15615, 14001, 6025, 2379, 1232, 240, 0, 0},
                                   {23925, 22488, 21272, 17451, 16116, 14825,
                                    13660, 10050, 6999, 2815, 1785, 283, 0, 0}},
                                  {{20190, 19097, 16789, 15934, 13693, 11855,
                                    9779, 7319, 6549, 2554, 1618, 291, 0, 0},
                                   {23205, 19142, 17688, 16876, 15012, 11905,
                                    10561, 8532, 7388, 3115, 1625, 491, 0, 0},
                                   {24412, 23867, 15152, 14512, 13418, 12662,
                                    10170, 6821, 6302, 2868, 2245, 507, 0, 0},
                                   {21933, 20953, 19644, 16726, 15750, 14729,
                                    13821, 10015, 8153, 3279, 1885, 286, 0, 0},
                                   {25150, 24480, 22909, 22259, 17382, 14111,
                                    9865, 3992, 3588, 1413, 966, 175, 0, 0}}};

constexpr uint16_t
    kDefaultYModeCdf[kYModeContexts][kIntraPredictionModesY + 1] = {
        {9967, 9279, 8475, 8012, 7167, 6645, 6162, 5350, 4823, 3540, 3083, 2419,
         0, 0},
        {14095, 12923, 10137, 9450, 8818, 8119, 7241, 5404, 4616, 3067, 2784,
         1916, 0, 0},
        {12998, 11789, 9372, 8829, 8527, 8114, 7632, 5695, 4938, 3408, 3038,
         2109, 0, 0},
        {12613, 11467, 9930, 9590, 9507, 9235, 9065, 7964, 7416, 6193, 5752,
         4719, 0, 0}};

constexpr uint16_t
    kDefaultAngleDeltaCdf[kDirectionalIntraModes][kAngleDeltaSymbolCount + 1] =
        {{30588, 27736, 25201, 9992, 5779, 2551, 0, 0},
         {30467, 27160, 23967, 9281, 5794, 2438, 0, 0},
         {28988, 21750, 19069, 13414, 9685, 1482, 0, 0},
         {28187, 21542, 17621, 15630, 10934, 4371, 0, 0},
         {31031, 21841, 18259, 13180, 10023, 3945, 0, 0},
         {30104, 22592, 20283, 15118, 11168, 2273, 0, 0},
         {30528, 21672, 17315, 12427, 10207, 3851, 0, 0},
         {29163, 22340, 20309, 15092, 11524, 2113, 0, 0}};

constexpr uint16_t
    kDefaultUVModeCdf[kBooleanSymbolCount][kIntraPredictionModesY]
                     [kIntraPredictionModesUV + 1] = {
                         // CFL not allowed.
                         {{10137, 8616, 7390, 7107, 6782, 6248, 5713, 4845,
                           4524, 2709, 1827, 807, 0, 0},
                          {23255, 5887, 5795, 5722, 5650, 5104, 5029, 4944,
                           4409, 3263, 2968, 972, 0, 0},
                          {22923, 22853, 4105, 4064, 4011, 3988, 3570, 2946,
                           2914, 2004, 991, 739, 0, 0},
                          {19129, 18871, 18597, 7437, 7162, 7041, 6815, 5620,
                           4191, 2156, 1413, 275, 0, 0},
                          {23004, 22933, 22838, 22814, 7382, 5715, 4810, 4620,
                           4525, 1667, 1024, 405, 0, 0},
                          {20943, 19179, 19091, 19048, 17720, 3555, 3467, 3310,
                           3057, 1607, 1327, 218, 0, 0},
                          {18593, 18369, 16160, 15947, 15050, 14993, 4217, 2568,
                           2523, 931, 426, 101, 0, 0},
                          {19883, 19730, 17790, 17178, 17095, 17020, 16592,
                           3640, 3501, 2125, 807, 307, 0, 0},
                          {20742, 19107, 18894, 17463, 17278, 17042, 16773,
                           16495, 4325, 2380, 2001, 352, 0, 0},
                          {13716, 12928, 12189, 11852, 11618, 11301, 10883,
                           10049, 9594, 3907, 2389, 593, 0, 0},
                          {14141, 13119, 11794, 11549, 11276, 10952, 10569,
                           9649, 9241, 5715, 1371, 620, 0, 0},
                          {15742, 13764, 12771, 12429, 12182, 11665, 11419,
                           10861, 10286, 6872, 6227, 949, 0, 0},
                          {20644, 19009, 17809, 17776, 17761, 17717, 17690,
                           17602, 17513, 17015, 16729, 16162, 0, 0}},
                         // CFL allowed.
                         {{22361, 21560, 19868, 19587, 18945, 18593, 17869,
                           17112, 16782, 12682, 11773, 10313, 8556, 0, 0},
                          {28236, 12988, 12711, 12553, 12340, 11697, 11569,
                           11317, 10669, 8540, 8075, 5736, 3296, 0, 0},
                          {27495, 27389, 12591, 12498, 12383, 12329, 11819,
                           11073, 10994, 9630, 8512, 8065, 6089, 0, 0},
                          {26028, 25601, 25106, 18616, 18232, 17983, 17734,
                           16027, 14397, 11248, 10562, 9379, 8586, 0, 0},
                          {27781, 27400, 26840, 26700, 13654, 12453, 10911,
                           10515, 10357, 7857, 7388, 6741, 6392, 0, 0},
                          {27398, 25879, 25521, 25375, 23270, 11654, 11366,
                           11015, 10787, 7988, 7382, 6251, 5592, 0, 0},
                          {27952, 27807, 25564, 25442, 24003, 23838, 12599,
                           12086, 11965, 9580, 9005, 8313, 7828, 0, 0},
                          {26160, 26028, 24239, 23719, 23511, 23412, 23033,
                           13941, 13709, 10432, 9564, 8804, 7975, 0, 0},
                          {26770, 25349, 24987, 23835, 23513, 23219, 23015,
                           22351, 13870, 10274, 9629, 8004, 6779, 0, 0},
                          {22108, 21470, 20218, 19811, 19446, 19144, 18728,
                           17764, 17234, 12054, 10979, 9325, 7907, 0, 0},
                          {22246, 21238, 20216, 19805, 19390, 18989, 18523,
                           17533, 16866, 12666, 10072, 8994, 6930, 0, 0},
                          {22669, 22077, 20129, 19719, 19382, 19103, 18643,
                           17605, 17132, 13092, 12294, 9249, 7560, 0, 0},
                          {29624, 27681, 25386, 25264, 25175, 25078, 24967,
                           24704, 24536, 23520, 22893, 22247, 3720, 0, 0}}};

constexpr uint16_t kDefaultCflAlphaSignsCdf[kCflAlphaSignsSymbolCount + 1] = {
    31350, 30645, 19428, 14363, 5796, 4425, 474, 0, 0};

constexpr uint16_t kDefaultCflAlphaCdf[kCflAlphaContexts][kCflAlphaSymbolCount +
                                                          1] = {
    {25131, 12049, 1367, 287, 111, 80, 76, 72, 68, 64, 60, 56, 52, 48, 44, 0,
     0},
    {18403, 9165, 4633, 1600, 601, 373, 281, 195, 148, 121, 100, 96, 92, 88, 84,
     0, 0},
    {21236, 10388, 4323, 1408, 419, 245, 184, 119, 95, 91, 87, 83, 79, 75, 71,
     0, 0},
    {5778, 1366, 486, 197, 76, 72, 68, 64, 60, 56, 52, 48, 44, 40, 36, 0, 0},
    {15520, 6710, 3864, 2160, 1463, 891, 642, 447, 374, 304, 252, 208, 192, 175,
     146, 0, 0},
    {18030, 11090, 6989, 4867, 3744, 2466, 1788, 925, 624, 355, 248, 174, 146,
     112, 108, 0, 0}};

constexpr uint16_t
    kDefaultUseFilterIntraCdf[kMaxBlockSizes][kBooleanFieldCdfSize] = {
        {28147, 0, 0}, {26025, 0, 0}, {19998, 0, 0}, {26875, 0, 0},
        {24902, 0, 0}, {20217, 0, 0}, {12539, 0, 0}, {22400, 0, 0},
        {23374, 0, 0}, {20360, 0, 0}, {18467, 0, 0}, {16384, 0, 0},
        {14667, 0, 0}, {20012, 0, 0}, {10425, 0, 0}, {16384, 0, 0},
        {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
        {16384, 0, 0}, {16384, 0, 0}};

constexpr uint16_t kDefaultFilterIntraModeCdf[kNumFilterIntraPredictors + 1] = {
    23819, 19992, 15557, 3210, 0, 0};

constexpr uint16_t
    kDefaultTxDepthCdf[4][kTxDepthContexts][kMaxTxDepthSymbolCount + 1] = {
        {{12800, 0, 0}, {12800, 0, 0}, {8448, 0, 0}},
        {{20496, 2596, 0, 0}, {20496, 2596, 0, 0}, {14091, 1920, 0, 0}},
        {{19782, 17588, 0, 0}, {19782, 17588, 0, 0}, {8466, 7166, 0, 0}},
        {{26986, 21293, 0, 0}, {26986, 21293, 0, 0}, {15965, 10009, 0, 0}}};

constexpr uint16_t kDefaultTxSplitCdf[kTxSplitContexts][kBooleanFieldCdfSize] =
    {{4187, 0, 0},  {8922, 0, 0},  {11921, 0, 0}, {8453, 0, 0},  {14572, 0, 0},
     {20635, 0, 0}, {13977, 0, 0}, {21881, 0, 0}, {21763, 0, 0}, {5589, 0, 0},
     {12764, 0, 0}, {21487, 0, 0}, {6219, 0, 0},  {13460, 0, 0}, {18544, 0, 0},
     {4753, 0, 0},  {11222, 0, 0}, {18368, 0, 0}, {4603, 0, 0},  {10367, 0, 0},
     {16680, 0, 0}};

/* clang-format off */
constexpr uint16_t kDefaultAllZeroCdf[kCoefficientQuantizerContexts]
                                 [kNumSquareTransformSizes][kAllZeroContexts]
                                 [kBooleanFieldCdfSize] = {
  {
    {{919, 0, 0}, {26876, 0, 0}, {20656, 0, 0}, {10833, 0, 0}, {12479, 0, 0},
     {5295, 0, 0}, {281, 0, 0}, {25114, 0, 0}, {13295, 0, 0}, {2784, 0, 0},
     {22807, 0, 0}, {2526, 0, 0}, {651, 0, 0}},
    {{1220, 0, 0}, {31219, 0, 0}, {22638, 0, 0}, {16112, 0, 0}, {14177, 0, 0},
     {6460, 0, 0}, {231, 0, 0}, {27365, 0, 0}, {14672, 0, 0}, {2765, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{2811, 0, 0}, {27377, 0, 0}, {14729, 0, 0}, {9202, 0, 0}, {10337, 0, 0},
     {6946, 0, 0}, {571, 0, 0}, {28990, 0, 0}, {17432, 0, 0}, {3787, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{14848, 0, 0}, {30950, 0, 0}, {25486, 0, 0}, {7495, 0, 0}, {21845, 0, 0},
     {1214, 0, 0}, {144, 0, 0}, {31402, 0, 0}, {17140, 0, 0}, {2306, 0, 0},
     {32622, 0, 0}, {27636, 0, 0}, {1111, 0, 0}},
    {{26460, 0, 0}, {32651, 0, 0}, {31130, 0, 0}, {30607, 0, 0}, {16384, 0, 0},
     {21845, 0, 0}, {2521, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}}
  },
  {
    {{2397, 0, 0}, {25198, 0, 0}, {19613, 0, 0}, {12017, 0, 0}, {11799, 0, 0},
     {5701, 0, 0}, {755, 0, 0}, {27273, 0, 0}, {14826, 0, 0}, {4488, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{986, 0, 0}, {30932, 0, 0}, {22079, 0, 0}, {15164, 0, 0}, {11146, 0, 0},
     {5250, 0, 0}, {369, 0, 0}, {28349, 0, 0}, {16474, 0, 0}, {4423, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{867, 0, 0}, {22457, 0, 0}, {14721, 0, 0}, {7962, 0, 0}, {9480, 0, 0},
     {4854, 0, 0}, {472, 0, 0}, {28553, 0, 0}, {17012, 0, 0}, {4427, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{6042, 0, 0}, {31723, 0, 0}, {21065, 0, 0}, {12178, 0, 0}, {14214, 0, 0},
     {6798, 0, 0}, {830, 0, 0}, {27185, 0, 0}, {11455, 0, 0}, {3378, 0, 0},
     {32127, 0, 0}, {10503, 0, 0}, {1316, 0, 0}},
    {{6184, 0, 0}, {32580, 0, 0}, {23921, 0, 0}, {8249, 0, 0}, {9830, 0, 0},
     {2185, 0, 0}, {160, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}}
  },
  {
    {{3154, 0, 0}, {23700, 0, 0}, {19844, 0, 0}, {13230, 0, 0}, {15031, 0, 0},
     {8149, 0, 0}, {2126, 0, 0}, {28649, 0, 0}, {16742, 0, 0}, {7111, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{811, 0, 0}, {29538, 0, 0}, {21615, 0, 0}, {14645, 0, 0}, {12625, 0, 0},
     {6232, 0, 0}, {782, 0, 0}, {29718, 0, 0}, {18165, 0, 0}, {7613, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{405, 0, 0}, {22076, 0, 0}, {13678, 0, 0}, {8411, 0, 0}, {8326, 0, 0},
     {4456, 0, 0}, {599, 0, 0}, {29120, 0, 0}, {17078, 0, 0}, {5953, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{2099, 0, 0}, {28936, 0, 0}, {21105, 0, 0}, {13879, 0, 0}, {12986, 0, 0},
     {9455, 0, 0}, {1438, 0, 0}, {27644, 0, 0}, {14049, 0, 0}, {4300, 0, 0},
     {29686, 0, 0}, {11786, 0, 0}, {3325, 0, 0}},
    {{4195, 0, 0}, {29585, 0, 0}, {14966, 0, 0}, {6791, 0, 0}, {6091, 0, 0},
     {4936, 0, 0}, {381, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}}
  },
  {
    {{5881, 0, 0}, {26039, 0, 0}, {22407, 0, 0}, {15326, 0, 0}, {17723, 0, 0},
     {10290, 0, 0}, {3696, 0, 0}, {30055, 0, 0}, {20907, 0, 0}, {11995, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{865, 0, 0}, {30724, 0, 0}, {25240, 0, 0}, {18150, 0, 0}, {16586, 0, 0},
     {8600, 0, 0}, {1731, 0, 0}, {29982, 0, 0}, {21574, 0, 0}, {12613, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{258, 0, 0}, {24338, 0, 0}, {15450, 0, 0}, {8614, 0, 0}, {9094, 0, 0},
     {3979, 0, 0}, {629, 0, 0}, {29328, 0, 0}, {19651, 0, 0}, {10066, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}},
    {{1097, 0, 0}, {30712, 0, 0}, {21022, 0, 0}, {15916, 0, 0}, {14133, 0, 0},
     {8053, 0, 0}, {1284, 0, 0}, {28112, 0, 0}, {16694, 0, 0}, {8064, 0, 0},
     {30962, 0, 0}, {18123, 0, 0}, {7432, 0, 0}},
    {{1229, 0, 0}, {24335, 0, 0}, {12192, 0, 0}, {4864, 0, 0}, {4916, 0, 0},
     {2742, 0, 0}, {327, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
     {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}}
  }
};
/* clang-format on */

constexpr uint16_t
    kDefaultInterTxTypeCdf[3][kNumExtendedTransformSizes][kNumTransformTypes +
                                                          1] = {
        {{28310, 27208, 25073, 23059, 19438, 17979, 15231, 12502, 11264, 9920,
          8834, 7294, 5041, 3853, 2137, 0, 0},
         {31123, 30195, 27990, 27057, 24961, 24146, 22246, 17411, 15094, 12360,
          10251, 7758, 5652, 3912, 2019, 0, 0},
         {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
          10240, 8192, 6144, 4096, 2048, 0, 0},
         {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
          10240, 8192, 6144, 4096, 2048, 0, 0}},
        {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
         {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
         // Only 16x16 is used in this case.
         {31998, 30347, 27543, 19861, 16949, 13841, 11207, 8679, 6173, 4242,
          2239, 0},
         {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
        {{16384, 0, 0}, {28601, 0, 0}, {30770, 0, 0}, {32020, 0, 0}}};

constexpr uint16_t kDefaultIntraTxTypeCdf
    [2][kNumExtendedTransformSizes][kIntraPredictionModesY]
    [kNumTransformTypes + 1] = {
        {{{31233, 24733, 23307, 20017, 9301, 4943, 0, 0},
          {32204, 29433, 23059, 21898, 14625, 4674, 0, 0},
          {32096, 29521, 29092, 20786, 13353, 9641, 0, 0},
          {27489, 18883, 17281, 14724, 9241, 2516, 0, 0},
          {28345, 26694, 24783, 22352, 7075, 3470, 0, 0},
          {31282, 28527, 23308, 22106, 16312, 5074, 0, 0},
          {32329, 29930, 29246, 26031, 14710, 9014, 0, 0},
          {31578, 28535, 27913, 21098, 12487, 8391, 0, 0},
          {31723, 28456, 24121, 22609, 14124, 3433, 0, 0},
          {32566, 29034, 28021, 25470, 15641, 8752, 0, 0},
          {32321, 28456, 25949, 23884, 16758, 8910, 0, 0},
          {32491, 28399, 27513, 23863, 16303, 10497, 0, 0},
          {29359, 27332, 22169, 17169, 13081, 8728, 0, 0}},
         {{30898, 19026, 18238, 16270, 8998, 5070, 0, 0},
          {32442, 23972, 18136, 17689, 13496, 5282, 0, 0},
          {32284, 25192, 25056, 18325, 13609, 10177, 0, 0},
          {31642, 17428, 16873, 15745, 11872, 2489, 0, 0},
          {32113, 27914, 27519, 26855, 10669, 5630, 0, 0},
          {31469, 26310, 23883, 23478, 17917, 7271, 0, 0},
          {32457, 27473, 27216, 25883, 16661, 10096, 0, 0},
          {31885, 24709, 24498, 21510, 15479, 11219, 0, 0},
          {32027, 25188, 23450, 22423, 16080, 3722, 0, 0},
          {32658, 25362, 24853, 23573, 16727, 9439, 0, 0},
          {32405, 24794, 23411, 22095, 17139, 8294, 0, 0},
          {32615, 25121, 24656, 22832, 17461, 12772, 0, 0},
          {29257, 26436, 21603, 17433, 13445, 9174, 0, 0}}},
        {{{26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0}},
         {{26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0},
          {26214, 19661, 13107, 6554, 0, 0}},
         {{31641, 19954, 9996, 5285, 0, 0},
          {32623, 26007, 20788, 6101, 0, 0},
          {32406, 26881, 21090, 16043, 0, 0},
          {32383, 17555, 14181, 2075, 0, 0},
          {32743, 29854, 9634, 4865, 0, 0},
          {32708, 28298, 21019, 8777, 0, 0},
          {32731, 29436, 18257, 11320, 0, 0},
          {32611, 26448, 19732, 15329, 0, 0},
          {32649, 26049, 19862, 3372, 0, 0},
          {32721, 27231, 20192, 11269, 0, 0},
          {32499, 26692, 21510, 9653, 0, 0},
          {32685, 27153, 20767, 15540, 0, 0},
          {30800, 27212, 20745, 14221, 0, 0}}}};

constexpr uint16_t kDefaultEobPt16Cdf[kCoefficientQuantizerContexts]
                                     [kNumPlaneTypes][kEobPtContexts]
                                     [kEobPt16SymbolCount + 1] = {
                                         {{{31928, 31729, 30788, 27873, 0, 0},
                                           {32398, 32097, 30885, 28297, 0, 0}},
                                          {{29521, 27818, 23080, 18205, 0, 0},
                                           {30864, 29414, 25005, 18121, 0, 0}}},
                                         {{{30643, 30217, 27603, 23822, 0, 0},
                                           {32255, 32003, 30909, 26429, 0, 0}},
                                          {{25131, 23270, 18509, 13660, 0, 0},
                                           {30271, 28672, 23902, 15775, 0, 0}}},
                                         {{{28752, 27871, 23887, 17800, 0, 0},
                                           {32052, 31663, 30122, 22712, 0, 0}},
                                          {{21629, 19498, 14527, 9202, 0, 0},
                                           {29576, 27736, 22471, 13013, 0, 0}}},
                                         {{{26060, 23810, 18022, 10635, 0, 0},
                                           {31546, 30694, 27985, 17358, 0, 0}},
                                          {{13193, 11002, 6724, 3059, 0, 0},
                                           {25471, 22001, 13495, 4574, 0, 0}}}};
constexpr uint16_t
    kDefaultEobPt32Cdf[kCoefficientQuantizerContexts][kNumPlaneTypes]
                      [kEobPtContexts][kEobPt32SymbolCount + 1] = {
                          {{{32368, 32248, 31791, 30666, 26226, 0, 0},
                            {32558, 32363, 31453, 29442, 25231, 0, 0}},
                           {{30132, 28495, 25180, 20974, 12367, 0, 0},
                            {30982, 29589, 25866, 21411, 13714, 0, 0}}},
                          {{{31779, 31519, 30749, 28617, 21983, 0, 0},
                            {32455, 32327, 31669, 29851, 24206, 0, 0}},
                           {{24374, 22416, 18836, 13913, 6754, 0, 0},
                            {30190, 28644, 24587, 19098, 8534, 0, 0}}},
                          {{{30253, 29765, 28316, 24606, 16727, 0, 0},
                            {32194, 31947, 30932, 27679, 19640, 0, 0}},
                           {{19300, 16465, 12407, 7663, 3487, 0, 0},
                            {29226, 27266, 22353, 16008, 7124, 0, 0}}},
                          {{{28151, 27059, 24322, 19184, 9633, 0, 0},
                            {31612, 31066, 29093, 23494, 12229, 0, 0}},
                           {{10682, 8486, 5758, 2998, 1025, 0, 0},
                            {25069, 21871, 11877, 5842, 1140, 0, 0}}}};
constexpr uint16_t
    kDefaultEobPt64Cdf[kCoefficientQuantizerContexts][kNumPlaneTypes]
                      [kEobPtContexts][kEobPt64SymbolCount + 1] = {
                          {{{32439, 32270, 31667, 30984, 29503, 25010, 0, 0},
                            {32433, 32038, 31309, 27274, 24013, 19771, 0, 0}},
                           {{29263, 27464, 22682, 18954, 15084, 9398, 0, 0},
                            {31205, 30068, 27892, 21857, 18062, 10288, 0, 0}}},
                          {{{31508, 31322, 30515, 29056, 26116, 19399, 0, 0},
                            {32367, 32163, 31739, 30205, 26923, 20142, 0, 0}},
                           {{24159, 22156, 18144, 14054, 10154, 3744, 0, 0},
                            {30845, 29641, 26901, 23065, 18491, 5668, 0, 0}}},
                          {{{30394, 29996, 28185, 25492, 20480, 13062, 0, 0},
                            {32271, 31958, 31453, 29768, 25764, 17127, 0, 0}},
                           {{17718, 15642, 11358, 7882, 4612, 2042, 0, 0},
                            {28734, 26478, 22533, 17786, 11554, 4277, 0, 0}}},
                          {{{26461, 25227, 20708, 16410, 10215, 4903, 0, 0},
                            {31479, 30448, 28797, 24842, 18615, 8477, 0, 0}},
                           {{8556, 7060, 4500, 2733, 1461, 719, 0, 0},
                            {24042, 20390, 13359, 6318, 2730, 306, 0, 0}}}};
constexpr uint16_t kDefaultEobPt128Cdf
    [kCoefficientQuantizerContexts][kNumPlaneTypes][kEobPtContexts]
    [kEobPt128SymbolCount + 1] = {
        {{{32549, 32286, 31628, 30677, 29088, 26740, 20182, 0, 0},
          {32397, 32069, 31514, 27938, 23289, 20206, 15271, 0, 0}},
         {{27523, 25312, 19888, 16916, 12735, 8836, 5160, 0, 0},
          {30714, 29296, 26899, 18536, 14526, 12178, 6016, 0, 0}}},
        {{{32083, 31835, 31280, 30054, 28002, 24206, 13514, 0, 0},
          {32551, 32416, 32150, 30465, 27507, 22799, 15296, 0, 0}},
         {{24723, 21568, 17271, 13173, 8820, 5360, 1830, 0, 0},
          {30458, 28608, 25297, 17771, 14837, 12000, 2528, 0, 0}}},
        {{{31402, 31030, 30241, 27752, 23413, 16971, 8125, 0, 0},
          {32414, 32210, 31824, 30008, 25481, 18731, 10989, 0, 0}},
         {{19141, 16522, 12595, 8339, 4820, 2353, 905, 0, 0},
          {26493, 22879, 17999, 9604, 4780, 2275, 496, 0, 0}}},
        {{{29296, 27883, 25279, 20287, 14251, 8232, 3133, 0, 0},
          {31882, 31037, 29497, 24299, 17199, 10642, 4385, 0, 0}},
         {{8455, 6706, 4383, 2661, 1551, 870, 423, 0, 0},
          {23603, 19486, 11618, 2482, 874, 197, 56, 0, 0}}}};

constexpr uint16_t kDefaultEobPt256Cdf
    [kCoefficientQuantizerContexts][kNumPlaneTypes][kEobPtContexts]
    [kEobPt256SymbolCount + 1] = {
        {{{32458, 32184, 30881, 29179, 26600, 24157, 21416, 17116, 0, 0},
          {31770, 30918, 29770, 27164, 15427, 12880, 9869, 7185, 0, 0}},
         {{30248, 29528, 26816, 23898, 20191, 15210, 12814, 8600, 0, 0},
          {30565, 28638, 25333, 22029, 12116, 9087, 7159, 5507, 0, 0}}},
        {{{31320, 30659, 28617, 26505, 23439, 19508, 14824, 9468, 0, 0},
          {32369, 31749, 31019, 29730, 22324, 17222, 10029, 5474, 0, 0}},
         {{26366, 24620, 20145, 17696, 14040, 9921, 6321, 3391, 0, 0},
          {31094, 29516, 27034, 22609, 10371, 8966, 7947, 1828, 0, 0}}},
        {{{29679, 28848, 26730, 23308, 18502, 12887, 7002, 3592, 0, 0},
          {31684, 30410, 29280, 27646, 21285, 14665, 6745, 2969, 0, 0}},
         {{21254, 18974, 15288, 12014, 8407, 5390, 3276, 1491, 0, 0},
          {26197, 23158, 17252, 10942, 3676, 1939, 926, 60, 0, 0}}},
        {{{27420, 25655, 20948, 16844, 10662, 5991, 2434, 1011, 0, 0},
          {30315, 28294, 26461, 23991, 16294, 9793, 3768, 1221, 0, 0}},
         {{9658, 8171, 5628, 3874, 2601, 1841, 1376, 674, 0, 0},
          {22770, 15107, 7590, 4671, 1460, 730, 365, 73, 0, 0}}}};

constexpr uint16_t kDefaultEobPt512Cdf
    [kCoefficientQuantizerContexts][kNumPlaneTypes][kEobPt512SymbolCount + 1] =
        {{{32127, 31785, 29061, 27338, 22534, 17810, 13980, 9356, 6707, 0, 0},
          {27673, 26322, 22772, 19414, 16751, 14782, 11849, 6639, 3628, 0, 0}},
         {{31538, 30490, 27733, 24992, 20897, 17422, 13178, 8184, 4019, 0, 0},
          {25503, 22789, 16949, 13518, 10988, 8922, 6290, 4372, 957, 0, 0}},
         {{30144, 28832, 26288, 23082, 18789, 15042, 9501, 4358, 1690, 0, 0},
          {20753, 17999, 13180, 10716, 8546, 6956, 5468, 3549, 654, 0, 0}},
         {{26841, 24959, 21845, 18171, 13329, 8633, 4312, 1626, 708, 0, 0},
          {11675, 9725, 7026, 5110, 3671, 3052, 2695, 1948, 812, 0, 0}}};

constexpr uint16_t
    kDefaultEobPt1024Cdf[kCoefficientQuantizerContexts][kNumPlaneTypes]
                        [kEobPt1024SymbolCount + 1] = {
                            {{32375, 32347, 32017, 31145, 29608, 26416, 19423,
                              14721, 10197, 6938, 0, 0},
                             {30903, 30780, 29838, 28526, 22235, 16230, 11414,
                              5513, 4222, 984, 0, 0}},
                            {{32072, 31820, 29623, 27066, 23062, 19551, 14917,
                              10912, 7076, 4734, 0, 0},
                             {30096, 29177, 23438, 15684, 10043, 8484, 6241,
                              4741, 4391, 1892, 0, 0}},
                            {{29984, 28937, 25727, 22247, 17921, 13924, 9613,
                              6086, 3539, 1723, 0, 0},
                             {23191, 20302, 15029, 12018, 10707, 9553, 8167,
                              7285, 6925, 712, 0, 0}},
                            {{26070, 24434, 20807, 17006, 12582, 8906, 5334,
                              3442, 1686, 718, 0, 0},
                             {12199, 10342, 7199, 5909, 4715, 3855, 3282, 3044,
                              2961, 198, 0, 0}}};

/* clang-format off */
constexpr uint16_t kDefaultEobExtraCdf[kCoefficientQuantizerContexts]
                                  [kNumSquareTransformSizes][kNumPlaneTypes]
                                  [kEobExtraContexts][kBooleanFieldCdfSize] = {
  {
    {
      {{15807, 0, 0}, {15545, 0, 0}, {25147, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{13699, 0, 0}, {10243, 0, 0}, {19391, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{12367, 0, 0}, {15743, 0, 0}, {19923, 0, 0}, {19895, 0, 0},
       {18674, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{12087, 0, 0}, {12067, 0, 0}, {17518, 0, 0}, {17751, 0, 0},
       {17840, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{8863, 0, 0}, {15574, 0, 0}, {16598, 0, 0}, {15073, 0, 0},
       {18942, 0, 0}, {16958, 0, 0}, {20732, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{8809, 0, 0}, {11969, 0, 0}, {13747, 0, 0}, {16565, 0, 0},
       {14882, 0, 0}, {18624, 0, 0}, {20758, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{5369, 0, 0}, {16441, 0, 0}, {14697, 0, 0}, {13184, 0, 0},
       {12047, 0, 0}, {14336, 0, 0}, {13208, 0, 0}, {22618, 0, 0},
       {23963, 0, 0}},
      {{7836, 0, 0}, {11935, 0, 0}, {20741, 0, 0}, {16098, 0, 0},
       {12854, 0, 0}, {17662, 0, 0}, {15106, 0, 0}, {18985, 0, 0},
       {4012, 0, 0}}
    },
    {
      {{9362, 0, 0}, {10923, 0, 0}, {14336, 0, 0}, {16384, 0, 0},
       {15672, 0, 0}, {20207, 0, 0}, {15448, 0, 0}, {10373, 0, 0},
       {11398, 0, 0}},
      {{16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    }
  },
  {
    {
      {{15297, 0, 0}, {12545, 0, 0}, {21411, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{12433, 0, 0}, {11101, 0, 0}, {17950, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{12338, 0, 0}, {12106, 0, 0}, {17401, 0, 0}, {15798, 0, 0},
       {18111, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{10651, 0, 0}, {10740, 0, 0}, {14118, 0, 0}, {16726, 0, 0},
       {16883, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{10359, 0, 0}, {11756, 0, 0}, {17118, 0, 0}, {15373, 0, 0},
       {17299, 0, 0}, {12563, 0, 0}, {13257, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{8548, 0, 0}, {10288, 0, 0}, {15031, 0, 0}, {13852, 0, 0},
       {13500, 0, 0}, {14356, 0, 0}, {13924, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{6777, 0, 0}, {12454, 0, 0}, {15037, 0, 0}, {13090, 0, 0},
       {14119, 0, 0}, {15461, 0, 0}, {10970, 0, 0}, {15219, 0, 0},
       {17138, 0, 0}},
      {{6183, 0, 0}, {11299, 0, 0}, {12336, 0, 0}, {15033, 0, 0},
       {13488, 0, 0}, {17533, 0, 0}, {12471, 0, 0}, {10297, 0, 0},
       {3771, 0, 0}}
    },
    {
      {{6163, 0, 0}, {21464, 0, 0}, {16042, 0, 0}, {16208, 0, 0},
       {11902, 0, 0}, {9244, 0, 0}, {12890, 0, 0}, {19299, 0, 0},
       {9684, 0, 0}},
      {{16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    }
  },
  {
    {
      {{13785, 0, 0}, {12256, 0, 0}, {17883, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{12678, 0, 0}, {13324, 0, 0}, {15482, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{13629, 0, 0}, {11281, 0, 0}, {13809, 0, 0}, {11858, 0, 0},
       {13679, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{12232, 0, 0}, {12104, 0, 0}, {12143, 0, 0}, {13645, 0, 0},
       {17906, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{12935, 0, 0}, {11266, 0, 0}, {15283, 0, 0}, {12501, 0, 0},
       {14415, 0, 0}, {9439, 0, 0}, {11290, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{10727, 0, 0}, {9334, 0, 0}, {12767, 0, 0}, {12214, 0, 0},
       {11817, 0, 0}, {12623, 0, 0}, {17206, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{9456, 0, 0}, {11161, 0, 0}, {16242, 0, 0}, {13811, 0, 0},
       {14734, 0, 0}, {13834, 0, 0}, {8521, 0, 0}, {15847, 0, 0},
       {15688, 0, 0}},
      {{6189, 0, 0}, {7858, 0, 0}, {14131, 0, 0}, {12968, 0, 0},
       {12380, 0, 0}, {22881, 0, 0}, {17126, 0, 0}, {2570, 0, 0},
       {8047, 0, 0}}
    },
    {
      {{5770, 0, 0}, {16031, 0, 0}, {14930, 0, 0}, {13846, 0, 0},
       {13253, 0, 0}, {14132, 0, 0}, {15435, 0, 0}, {16992, 0, 0},
       {10110, 0, 0}},
      {{16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    }
  },
  {
    {
      {{12591, 0, 0}, {11979, 0, 0}, {12506, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{11352, 0, 0}, {11913, 0, 0}, {9358, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{12530, 0, 0}, {11711, 0, 0}, {13609, 0, 0}, {10431, 0, 0},
       {12609, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{12643, 0, 0}, {12209, 0, 0}, {11061, 0, 0}, {10472, 0, 0},
       {15435, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{12827, 0, 0}, {12241, 0, 0}, {11298, 0, 0}, {10281, 0, 0},
       {13210, 0, 0}, {10414, 0, 0}, {12437, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}},
      {{10016, 0, 0}, {7762, 0, 0}, {10693, 0, 0}, {11192, 0, 0},
       {15028, 0, 0}, {11078, 0, 0}, {13557, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    },
    {
      {{11326, 0, 0}, {10410, 0, 0}, {14265, 0, 0}, {12477, 0, 0},
       {12823, 0, 0}, {11474, 0, 0}, {11590, 0, 0}, {13368, 0, 0},
       {22212, 0, 0}},
      {{8120, 0, 0}, {7819, 0, 0}, {12060, 0, 0}, {8863, 0, 0},
       {12267, 0, 0}, {23210, 0, 0}, {23345, 0, 0}, {2403, 0, 0},
       {13515, 0, 0}}
    },
    {
      {{6704, 0, 0}, {10670, 0, 0}, {13155, 0, 0}, {12243, 0, 0},
       {15173, 0, 0}, {16150, 0, 0}, {12271, 0, 0}, {13779, 0, 0},
       {17255, 0, 0}},
      {{16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
       {16384, 0, 0}}
    }
  }
};

constexpr uint16_t kDefaultCoeffBaseEobCdf[kCoefficientQuantizerContexts]
                                      [kNumSquareTransformSizes][kNumPlaneTypes]
                                      [kCoeffBaseEobContexts]
                                      [kCoeffBaseEobSymbolCount + 1] = {
  {
    {
      {{14931, 3713, 0, 0}, {3168, 1322, 0, 0}, {1924, 890, 0, 0},
       {7842, 3820, 0, 0}},
      {{11403, 2742, 0, 0}, {2256, 345, 0, 0}, {1110, 147, 0, 0},
       {3138, 887, 0, 0}}
    },
    {
      {{27051, 6291, 0, 0}, {2277, 1065, 0, 0}, {1218, 610, 0, 0},
       {3120, 1277, 0, 0}},
      {{20160, 4948, 0, 0}, {2088, 543, 0, 0}, {1959, 433, 0, 0},
       {1469, 345, 0, 0}}
    },
    {
      {{30982, 20156, 0, 0}, {2105, 1143, 0, 0}, {429, 300, 0, 0},
       {1620, 935, 0, 0}},
      {{13911, 8903, 0, 0}, {1340, 340, 0, 0}, {1024, 395, 0, 0},
       {993, 242, 0, 0}}
    },
    {
      {{30981, 30236, 0, 0}, {1936, 1106, 0, 0}, {944, 86, 0, 0},
       {635, 199, 0, 0}},
      {{19017, 10533, 0, 0}, {679, 359, 0, 0}, {5684, 4848, 0, 0},
       {3477, 174, 0, 0}}
    },
    {
      {{31043, 29319, 0, 0}, {1666, 833, 0, 0}, {311, 155, 0, 0},
       {356, 119, 0, 0}},
      {{21845, 10923, 0, 0}, {21845, 10923, 0, 0}, {21845, 10923, 0, 0},
       {21845, 10923, 0, 0}}
    }
  },
  {
    {
      {{15208, 2880, 0, 0}, {3097, 1219, 0, 0}, {1761, 712, 0, 0},
       {5482, 2762, 0, 0}},
      {{6174, 1556, 0, 0}, {1560, 186, 0, 0}, {933, 131, 0, 0},
       {2173, 562, 0, 0}}
    },
    {
      {{17529, 2836, 0, 0}, {1453, 673, 0, 0}, {638, 334, 0, 0},
       {1904, 772, 0, 0}},
      {{6489, 1800, 0, 0}, {1626, 273, 0, 0}, {1055, 228, 0, 0},
       {839, 174, 0, 0}}
    },
    {
      {{30124, 7570, 0, 0}, {730, 317, 0, 0}, {129, 73, 0, 0},
       {602, 250, 0, 0}},
      {{15581, 5100, 0, 0}, {1054, 218, 0, 0}, {485, 90, 0, 0},
       {838, 205, 0, 0}}
    },
    {
      {{31724, 30511, 0, 0}, {2013, 845, 0, 0}, {560, 75, 0, 0},
       {524, 153, 0, 0}},
      {{11451, 6561, 0, 0}, {3635, 1900, 0, 0}, {3457, 1537, 0, 0},
       {3111, 1681, 0, 0}}
    },
    {
      {{32290, 30934, 0, 0}, {1763, 781, 0, 0}, {451, 44, 0, 0},
       {1903, 120, 0, 0}},
      {{21845, 10923, 0, 0}, {21845, 10923, 0, 0}, {21845, 10923, 0, 0},
       {21845, 10923, 0, 0}}
    }
  },
  {
    {
      {{12676, 1994, 0, 0}, {2073, 748, 0, 0}, {1637, 665, 0, 0},
       {4102, 1898, 0, 0}},
      {{5510, 1673, 0, 0}, {964, 145, 0, 0}, {1005, 240, 0, 0},
       {1330, 262, 0, 0}}
    },
    {
      {{14719, 2279, 0, 0}, {1062, 482, 0, 0}, {605, 295, 0, 0},
       {1218, 584, 0, 0}},
      {{5652, 1926, 0, 0}, {797, 170, 0, 0}, {680, 192, 0, 0},
       {701, 104, 0, 0}}
    },
    {
      {{19914, 3675, 0, 0}, {496, 210, 0, 0}, {101, 39, 0, 0},
       {462, 183, 0, 0}},
      {{7292, 2402, 0, 0}, {599, 81, 0, 0}, {289, 79, 0, 0},
       {1095, 134, 0, 0}}
    },
    {
      {{29959, 13467, 0, 0}, {563, 146, 0, 0}, {430, 38, 0, 0},
       {982, 152, 0, 0}},
      {{10031, 3663, 0, 0}, {1958, 406, 0, 0}, {2754, 141, 0, 0},
       {2240, 194, 0, 0}}
    },
    {
      {{31833, 29386, 0, 0}, {1979, 859, 0, 0}, {302, 12, 0, 0},
       {1908, 255, 0, 0}},
      {{21845, 10923, 0, 0}, {21845, 10923, 0, 0}, {21845, 10923, 0, 0},
       {21845, 10923, 0, 0}}
    }
  },
  {
    {
      {{10271, 1570, 0, 0}, {1053, 273, 0, 0}, {1162, 431, 0, 0},
       {2380, 778, 0, 0}},
      {{4891, 1184, 0, 0}, {598, 40, 0, 0}, {613, 80, 0, 0},
       {549, 66, 0, 0}}
    },
    {
      {{11311, 1725, 0, 0}, {817, 285, 0, 0}, {615, 206, 0, 0},
       {1295, 553, 0, 0}},
      {{5210, 1617, 0, 0}, {748, 128, 0, 0}, {671, 193, 0, 0},
       {526, 49, 0, 0}}
    },
    {
      {{12788, 2177, 0, 0}, {549, 171, 0, 0}, {187, 62, 0, 0},
       {965, 481, 0, 0}},
      {{6295, 2261, 0, 0}, {337, 45, 0, 0}, {572, 157, 0, 0},
       {1180, 240, 0, 0}}
    },
    {
      {{8121, 2305, 0, 0}, {356, 73, 0, 0}, {300, 48, 0, 0},
       {1499, 245, 0, 0}},
      {{4286, 1263, 0, 0}, {616, 67, 0, 0}, {1036, 170, 0, 0},
       {1001, 56, 0, 0}}
    },
    {
      {{20410, 7791, 0, 0}, {1437, 383, 0, 0}, {134, 12, 0, 0},
       {2357, 220, 0, 0}},
      {{21845, 10923, 0, 0}, {21845, 10923, 0, 0}, {21845, 10923, 0, 0},
       {21845, 10923, 0, 0}}
    }
  }
};
/* clang-format on */

constexpr uint16_t kDefaultCoeffBaseCdf
    [kCoefficientQuantizerContexts][kNumSquareTransformSizes][kNumPlaneTypes]
    [kCoeffBaseContexts][kCoeffBaseSymbolCount + 1] = {
        {{{{28734, 23838, 20041, 0, 0}, {14686, 3027, 891, 0, 0},
           {20172, 6644, 2275, 0, 0},   {23322, 11650, 5763, 0, 0},
           {26460, 17627, 11489, 0, 0}, {30305, 26411, 22985, 0, 0},
           {12101, 2222, 839, 0, 0},    {19725, 6645, 2634, 0, 0},
           {24617, 14011, 7990, 0, 0},  {27513, 19929, 14136, 0, 0},
           {29948, 25562, 21607, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {17032, 5215, 2164, 0, 0},
           {21558, 8974, 3981, 0, 0},   {26821, 18894, 13067, 0, 0},
           {28553, 23445, 18877, 0, 0}, {29935, 26306, 22709, 0, 0},
           {13163, 2375, 1186, 0, 0},   {19245, 6516, 2520, 0, 0},
           {24322, 14146, 8256, 0, 0},  {28950, 22425, 16794, 0, 0},
           {31287, 28651, 25972, 0, 0}, {10119, 1466, 578, 0, 0},
           {17939, 5641, 2319, 0, 0},   {24455, 15066, 9464, 0, 0},
           {29746, 24467, 19982, 0, 0}, {31232, 28356, 25584, 0, 0},
           {10414, 2994, 1396, 0, 0},   {18045, 7296, 3554, 0, 0},
           {26095, 19023, 14106, 0, 0}, {30700, 27002, 23446, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{26466, 16324, 11007, 0, 0}, {9728, 1230, 293, 0, 0},
           {17572, 4316, 1272, 0, 0},   {22748, 9822, 4254, 0, 0},
           {26235, 15906, 9267, 0, 0},  {29230, 22952, 17692, 0, 0},
           {8324, 893, 243, 0, 0},      {16887, 3844, 1133, 0, 0},
           {22846, 9895, 4302, 0, 0},   {26241, 15802, 9077, 0, 0},
           {28654, 21465, 15548, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {12567, 1998, 559, 0, 0},
           {18014, 4697, 1510, 0, 0},   {24390, 12582, 6251, 0, 0},
           {26852, 17469, 10790, 0, 0}, {28500, 21185, 14867, 0, 0},
           {8407, 743, 187, 0, 0},      {14095, 2663, 825, 0, 0},
           {22572, 10524, 5192, 0, 0},  {27273, 18419, 12351, 0, 0},
           {30092, 25353, 21270, 0, 0}, {8090, 810, 183, 0, 0},
           {14139, 2862, 937, 0, 0},    {23404, 12044, 6453, 0, 0},
           {28127, 20450, 14674, 0, 0}, {30010, 25381, 21189, 0, 0},
           {7335, 926, 299, 0, 0},      {13973, 3479, 1357, 0, 0},
           {25124, 15184, 9176, 0, 0},  {29360, 23754, 17721, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{28232, 22696, 18767, 0, 0}, {7309, 1352, 562, 0, 0},
           {16163, 4720, 1950, 0, 0},   {21760, 9911, 5049, 0, 0},
           {25853, 16500, 10453, 0, 0}, {30143, 25956, 22231, 0, 0},
           {8511, 980, 269, 0, 0},      {15888, 3314, 889, 0, 0},
           {20810, 7714, 2990, 0, 0},   {24852, 14050, 7684, 0, 0},
           {29385, 23991, 19322, 0, 0}, {10048, 1165, 375, 0, 0},
           {17808, 4643, 1433, 0, 0},   {23037, 10558, 4840, 0, 0},
           {26464, 16936, 10491, 0, 0}, {29858, 24950, 20602, 0, 0},
           {12393, 2141, 637, 0, 0},    {18864, 5484, 1881, 0, 0},
           {23400, 11210, 5624, 0, 0},  {26831, 17802, 11649, 0, 0},
           {30101, 25543, 21449, 0, 0}, {8798, 1298, 390, 0, 0},
           {15595, 3034, 750, 0, 0},    {19973, 7327, 2803, 0, 0},
           {23787, 13088, 6875, 0, 0},  {28040, 21396, 15866, 0, 0},
           {8481, 971, 329, 0, 0},      {16065, 3623, 1072, 0, 0},
           {21935, 9214, 4043, 0, 0},   {26300, 16202, 9711, 0, 0},
           {30353, 26206, 22490, 0, 0}, {6158, 373, 109, 0, 0},
           {14178, 2270, 651, 0, 0},    {20348, 7012, 2818, 0, 0},
           {25129, 14022, 8058, 0, 0},  {29767, 24682, 20421, 0, 0},
           {7692, 704, 188, 0, 0},      {14822, 2640, 740, 0, 0},
           {20744, 7783, 3390, 0, 0},   {25251, 14378, 8464, 0, 0},
           {29525, 23987, 19437, 0, 0}, {24576, 16384, 8192, 0, 0}},
          {{26731, 15997, 10811, 0, 0}, {7994, 1064, 342, 0, 0},
           {15938, 4179, 1712, 0, 0},   {22166, 9940, 5008, 0, 0},
           {26035, 15939, 9697, 0, 0},  {29518, 23854, 19212, 0, 0},
           {7186, 548, 100, 0, 0},      {14109, 2426, 545, 0, 0},
           {20222, 6619, 2253, 0, 0},   {24348, 12317, 5967, 0, 0},
           {28132, 20348, 14424, 0, 0}, {5187, 406, 129, 0, 0},
           {13781, 2685, 790, 0, 0},    {21441, 8520, 3684, 0, 0},
           {25504, 15049, 8648, 0, 0},  {28773, 22000, 16599, 0, 0},
           {6875, 937, 281, 0, 0},      {16191, 4181, 1389, 0, 0},
           {22579, 10020, 4586, 0, 0},  {25936, 15674, 9212, 0, 0},
           {29060, 22658, 17434, 0, 0}, {6864, 486, 112, 0, 0},
           {13047, 1976, 492, 0, 0},    {19949, 6525, 2357, 0, 0},
           {24196, 12154, 5877, 0, 0},  {27404, 18709, 12301, 0, 0},
           {6188, 330, 91, 0, 0},       {11916, 1543, 428, 0, 0},
           {20333, 7068, 2801, 0, 0},   {24077, 11943, 5792, 0, 0},
           {28322, 20559, 15499, 0, 0}, {5418, 339, 72, 0, 0},
           {11396, 1791, 496, 0, 0},    {20095, 7498, 2915, 0, 0},
           {23560, 11843, 6128, 0, 0},  {27750, 19417, 14036, 0, 0},
           {5417, 289, 55, 0, 0},       {11370, 1559, 381, 0, 0},
           {20606, 7721, 2926, 0, 0},   {24872, 14077, 7449, 0, 0},
           {28098, 19886, 13887, 0, 0}, {24576, 16384, 8192, 0, 0}}},
         {{{27281, 22308, 19060, 0, 0}, {11171, 4465, 2094, 0, 0},
           {21731, 10815, 6292, 0, 0},  {24621, 14806, 9816, 0, 0},
           {27526, 19707, 14236, 0, 0}, {30879, 27560, 24586, 0, 0},
           {5994, 635, 178, 0, 0},      {14924, 3204, 1001, 0, 0},
           {21078, 8330, 3597, 0, 0},   {25226, 14553, 8309, 0, 0},
           {29775, 24718, 20449, 0, 0}, {4745, 440, 177, 0, 0},
           {14117, 2642, 814, 0, 0},    {20604, 7622, 3179, 0, 0},
           {25006, 14238, 7997, 0, 0},  {29276, 23585, 18848, 0, 0},
           {5177, 760, 277, 0, 0},      {15619, 3915, 1258, 0, 0},
           {21283, 8765, 3908, 0, 0},   {25071, 14682, 8558, 0, 0},
           {29693, 24769, 20550, 0, 0}, {4500, 286, 114, 0, 0},
           {13137, 1717, 364, 0, 0},    {18908, 5508, 1748, 0, 0},
           {23163, 11155, 5174, 0, 0},  {27892, 20606, 14860, 0, 0},
           {5520, 452, 192, 0, 0},      {13813, 2311, 693, 0, 0},
           {20944, 8771, 3973, 0, 0},   {25422, 14572, 8121, 0, 0},
           {29365, 23521, 18657, 0, 0}, {3057, 113, 33, 0, 0},
           {11599, 1374, 351, 0, 0},    {19281, 5570, 1811, 0, 0},
           {23940, 11085, 5154, 0, 0},  {28498, 21317, 15730, 0, 0},
           {4060, 190, 37, 0, 0},       {12648, 1527, 286, 0, 0},
           {19076, 5218, 1447, 0, 0},   {23350, 10254, 4329, 0, 0},
           {27769, 19485, 13306, 0, 0}, {24576, 16384, 8192, 0, 0}},
          {{27095, 18466, 13057, 0, 0}, {6517, 2067, 934, 0, 0},
           {19986, 8985, 4965, 0, 0},   {23641, 12111, 6960, 0, 0},
           {26400, 16560, 11306, 0, 0}, {30303, 25591, 21946, 0, 0},
           {2807, 205, 49, 0, 0},       {14450, 2877, 819, 0, 0},
           {21407, 8254, 3411, 0, 0},   {24868, 13165, 7161, 0, 0},
           {28766, 22178, 17222, 0, 0}, {3131, 458, 173, 0, 0},
           {14472, 2855, 959, 0, 0},    {22624, 11253, 5897, 0, 0},
           {27410, 18446, 12374, 0, 0}, {29701, 24406, 19422, 0, 0},
           {4116, 298, 92, 0, 0},       {15230, 1997, 559, 0, 0},
           {18844, 5886, 2274, 0, 0},   {22272, 9931, 4899, 0, 0},
           {25532, 16372, 11147, 0, 0}, {2025, 81, 22, 0, 0},
           {9762, 1092, 279, 0, 0},     {18274, 4940, 1648, 0, 0},
           {22594, 9967, 4416, 0, 0},   {26526, 17487, 11725, 0, 0},
           {6951, 525, 48, 0, 0},       {14150, 1401, 443, 0, 0},
           {18771, 4450, 890, 0, 0},    {20513, 6234, 1385, 0, 0},
           {23207, 11180, 4318, 0, 0},  {4580, 133, 44, 0, 0},
           {10708, 403, 40, 0, 0},      {14666, 2078, 240, 0, 0},
           {18572, 3904, 769, 0, 0},    {20506, 6976, 1903, 0, 0},
           {8592, 659, 140, 0, 0},      {14488, 3087, 805, 0, 0},
           {22563, 9065, 3104, 0, 0},   {24879, 12743, 5092, 0, 0},
           {26708, 16025, 8798, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{27627, 25672, 24508, 0, 0}, {5582, 3746, 2979, 0, 0},
           {26100, 20200, 17086, 0, 0}, {30596, 26587, 24130, 0, 0},
           {31642, 29389, 28237, 0, 0}, {32325, 31407, 30514, 0, 0},
           {6685, 1615, 332, 0, 0},     {19282, 8165, 4285, 0, 0},
           {26260, 17928, 12858, 0, 0}, {29382, 23968, 19482, 0, 0},
           {31238, 28446, 25714, 0, 0}, {3129, 688, 220, 0, 0},
           {16871, 5216, 2478, 0, 0},   {24180, 12721, 7385, 0, 0},
           {27879, 19429, 13499, 0, 0}, {30528, 25897, 22270, 0, 0},
           {4603, 571, 251, 0, 0},      {12033, 2341, 1200, 0, 0},
           {18443, 8097, 5076, 0, 0},   {27649, 20214, 14963, 0, 0},
           {30958, 27327, 24507, 0, 0}, {1556, 44, 20, 0, 0},
           {9416, 1002, 223, 0, 0},     {18099, 5198, 1709, 0, 0},
           {24276, 11874, 5496, 0, 0},  {29124, 22574, 17564, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{30307, 25755, 23397, 0, 0}, {8019, 3168, 1782, 0, 0},
           {23302, 13731, 10351, 0, 0}, {29184, 23488, 18368, 0, 0},
           {31263, 28839, 27335, 0, 0}, {32091, 31268, 30032, 0, 0},
           {8781, 2066, 651, 0, 0},     {19214, 8197, 3505, 0, 0},
           {26557, 18212, 11613, 0, 0}, {29633, 21796, 17143, 0, 0},
           {30333, 25641, 21341, 0, 0}, {1468, 236, 218, 0, 0},
           {18011, 2403, 814, 0, 0},    {28363, 21156, 14215, 0, 0},
           {32188, 28636, 25446, 0, 0}, {31073, 22599, 18644, 0, 0},
           {2760, 486, 177, 0, 0},      {13524, 2660, 1020, 0, 0},
           {21588, 8610, 3213, 0, 0},   {27118, 17796, 13559, 0, 0},
           {30654, 27659, 24312, 0, 0}, {912, 52, 20, 0, 0},
           {9756, 1104, 196, 0, 0},     {19074, 6112, 2132, 0, 0},
           {24626, 13260, 6675, 0, 0},  {28515, 21813, 16044, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{32167, 31785, 31457, 0, 0}, {14043, 9362, 4681, 0, 0},
           {27307, 24576, 21845, 0, 0}, {28987, 17644, 11343, 0, 0},
           {30181, 25007, 20696, 0, 0}, {32662, 32310, 31958, 0, 0},
           {10486, 3058, 874, 0, 0},    {24260, 11842, 6784, 0, 0},
           {29042, 20055, 14685, 0, 0}, {31148, 25656, 21875, 0, 0},
           {32039, 30532, 29273, 0, 0}, {2605, 294, 84, 0, 0},
           {14464, 2304, 768, 0, 0},    {21325, 6242, 3121, 0, 0},
           {26761, 17476, 11469, 0, 0}, {30534, 26065, 23831, 0, 0},
           {1814, 591, 197, 0, 0},      {15405, 3206, 1692, 0, 0},
           {23082, 10304, 5358, 0, 0},  {24576, 16384, 11378, 0, 0},
           {31013, 24722, 21504, 0, 0}, {1600, 34, 20, 0, 0},
           {10282, 1327, 297, 0, 0},    {19935, 7141, 3030, 0, 0},
           {25788, 15389, 9646, 0, 0},  {29657, 23881, 19289, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0}}}},
        {{{{26727, 20914, 16841, 0, 0}, {12442, 1863, 517, 0, 0},
           {18604, 5937, 2043, 0, 0},   {23008, 12121, 6183, 0, 0},
           {26352, 17815, 11549, 0, 0}, {29802, 25617, 21877, 0, 0},
           {9201, 1394, 514, 0, 0},     {17790, 5352, 1822, 0, 0},
           {23334, 12543, 6514, 0, 0},  {26110, 18210, 12233, 0, 0},
           {28852, 24091, 19779, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {14680, 3223, 1181, 0, 0},
           {19706, 6925, 2695, 0, 0},   {23828, 15941, 10517, 0, 0},
           {25114, 19548, 14795, 0, 0}, {27035, 22452, 18312, 0, 0},
           {9889, 1380, 654, 0, 0},     {17553, 4775, 1813, 0, 0},
           {23371, 13323, 7790, 0, 0},  {29326, 22955, 17424, 0, 0},
           {31400, 28832, 26236, 0, 0}, {7274, 735, 362, 0, 0},
           {15996, 4805, 2050, 0, 0},   {23349, 14603, 9508, 0, 0},
           {30091, 25267, 20971, 0, 0}, {31252, 28424, 25598, 0, 0},
           {6212, 1314, 667, 0, 0},     {15640, 5733, 2660, 0, 0},
           {24444, 17424, 12519, 0, 0}, {30865, 27072, 23299, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{24313, 13765, 8400, 0, 0},  {9205, 747, 164, 0, 0},
           {16531, 3322, 833, 0, 0},    {22044, 8769, 3410, 0, 0},
           {26043, 15240, 8352, 0, 0},  {28841, 21841, 15943, 0, 0},
           {6455, 480, 134, 0, 0},      {15338, 2673, 673, 0, 0},
           {21652, 8162, 3089, 0, 0},   {25573, 14384, 7499, 0, 0},
           {28042, 19916, 13453, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {9946, 1120, 285, 0, 0},
           {16044, 3135, 839, 0, 0},    {22507, 9735, 4043, 0, 0},
           {25739, 14928, 8240, 0, 0},  {27901, 18882, 11266, 0, 0},
           {7470, 876, 277, 0, 0},      {14959, 3438, 1256, 0, 0},
           {23100, 11439, 6189, 0, 0},  {27994, 19812, 13792, 0, 0},
           {30446, 25738, 21228, 0, 0}, {7296, 848, 225, 0, 0},
           {14811, 3381, 1136, 0, 0},   {23572, 12175, 6368, 0, 0},
           {28088, 20063, 13566, 0, 0}, {29851, 24312, 19332, 0, 0},
           {6297, 709, 194, 0, 0},      {14310, 2985, 859, 0, 0},
           {24368, 13304, 6812, 0, 0},  {28956, 21795, 15562, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{25989, 19025, 15090, 0, 0}, {7962, 971, 311, 0, 0},
           {15152, 3721, 1396, 0, 0},   {21705, 9593, 4765, 0, 0},
           {26247, 16658, 10444, 0, 0}, {30004, 25264, 21114, 0, 0},
           {7502, 401, 131, 0, 0},      {13714, 2215, 593, 0, 0},
           {20629, 7556, 2961, 0, 0},   {25457, 14606, 8064, 0, 0},
           {29371, 23604, 18694, 0, 0}, {6780, 560, 246, 0, 0},
           {16515, 3856, 1242, 0, 0},   {23617, 11381, 5396, 0, 0},
           {27080, 17853, 11272, 0, 0}, {30051, 25141, 20764, 0, 0},
           {9624, 913, 325, 0, 0},      {16698, 4277, 1443, 0, 0},
           {24066, 12301, 6251, 0, 0},  {27525, 18812, 12401, 0, 0},
           {30147, 25433, 21201, 0, 0}, {6132, 428, 138, 0, 0},
           {12778, 1718, 427, 0, 0},    {19525, 6663, 2453, 0, 0},
           {24180, 13247, 6850, 0, 0},  {28051, 21183, 15464, 0, 0},
           {6924, 476, 186, 0, 0},      {13678, 2133, 671, 0, 0},
           {20805, 8222, 3829, 0, 0},   {26550, 16681, 10414, 0, 0},
           {30428, 26160, 22342, 0, 0}, {4722, 192, 74, 0, 0},
           {11590, 1455, 472, 0, 0},    {19282, 6584, 2898, 0, 0},
           {25619, 14897, 9045, 0, 0},  {29935, 24810, 20509, 0, 0},
           {5058, 240, 82, 0, 0},       {12094, 1692, 500, 0, 0},
           {20355, 7813, 3525, 0, 0},   {26092, 15841, 9671, 0, 0},
           {29802, 24435, 19849, 0, 0}, {24576, 16384, 8192, 0, 0}},
          {{24129, 13429, 8339, 0, 0},  {8364, 931, 243, 0, 0},
           {15771, 3343, 984, 0, 0},    {21515, 8534, 3619, 0, 0},
           {26017, 15374, 8740, 0, 0},  {29278, 22938, 17577, 0, 0},
           {6485, 297, 54, 0, 0},       {13169, 1600, 326, 0, 0},
           {19622, 5814, 1875, 0, 0},   {24554, 12180, 5878, 0, 0},
           {28069, 19687, 13468, 0, 0}, {4556, 310, 99, 0, 0},
           {14174, 2452, 668, 0, 0},    {21549, 8360, 3534, 0, 0},
           {25903, 15112, 8619, 0, 0},  {29090, 22406, 16762, 0, 0},
           {6943, 632, 152, 0, 0},      {15455, 2915, 747, 0, 0},
           {21571, 8297, 3296, 0, 0},   {25821, 14987, 8363, 0, 0},
           {29000, 22108, 16507, 0, 0}, {5416, 268, 62, 0, 0},
           {11918, 1300, 299, 0, 0},    {18747, 5061, 1635, 0, 0},
           {23804, 11020, 4930, 0, 0},  {27331, 18103, 11581, 0, 0},
           {6464, 276, 70, 0, 0},       {12359, 1388, 383, 0, 0},
           {19086, 5546, 2136, 0, 0},   {23794, 11532, 6083, 0, 0},
           {28534, 21103, 15834, 0, 0}, {6495, 411, 57, 0, 0},
           {12096, 1526, 327, 0, 0},    {18596, 5514, 1866, 0, 0},
           {22898, 10870, 5493, 0, 0},  {27604, 19262, 13498, 0, 0},
           {6043, 309, 40, 0, 0},       {11777, 1326, 241, 0, 0},
           {19697, 6334, 1957, 0, 0},   {24584, 12678, 6026, 0, 0},
           {27965, 19513, 12873, 0, 0}, {24576, 16384, 8192, 0, 0}}},
         {{{25213, 17826, 14267, 0, 0}, {8358, 1590, 481, 0, 0},
           {18374, 6030, 2515, 0, 0},   {24355, 13214, 7573, 0, 0},
           {28002, 19844, 13983, 0, 0}, {30739, 26962, 23561, 0, 0},
           {5992, 404, 105, 0, 0},      {14036, 2801, 837, 0, 0},
           {21763, 8982, 3916, 0, 0},   {26302, 15859, 9258, 0, 0},
           {29724, 24130, 19349, 0, 0}, {3560, 186, 64, 0, 0},
           {12700, 1911, 560, 0, 0},    {20765, 7683, 3173, 0, 0},
           {25821, 15018, 8579, 0, 0},  {29523, 23665, 18761, 0, 0},
           {5409, 303, 99, 0, 0},       {13347, 2154, 594, 0, 0},
           {20853, 7758, 3189, 0, 0},   {25818, 15092, 8694, 0, 0},
           {29761, 24295, 19672, 0, 0}, {3766, 92, 33, 0, 0},
           {10666, 919, 192, 0, 0},     {18360, 4759, 1363, 0, 0},
           {23741, 11089, 4837, 0, 0},  {28074, 20090, 14020, 0, 0},
           {4552, 240, 86, 0, 0},       {11919, 1504, 450, 0, 0},
           {20012, 6953, 3017, 0, 0},   {25203, 13967, 7845, 0, 0},
           {29259, 23235, 18291, 0, 0}, {2635, 81, 29, 0, 0},
           {9705, 858, 253, 0, 0},      {18180, 4717, 1636, 0, 0},
           {23683, 11119, 5311, 0, 0},  {28507, 21114, 15504, 0, 0},
           {3250, 77, 20, 0, 0},        {10317, 809, 155, 0, 0},
           {17904, 4046, 1068, 0, 0},   {23073, 9804, 4052, 0, 0},
           {27836, 19410, 13266, 0, 0}, {24576, 16384, 8192, 0, 0}},
          {{26303, 15810, 11080, 0, 0}, {7569, 1254, 408, 0, 0},
           {17994, 5619, 2161, 0, 0},   {23511, 11330, 5796, 0, 0},
           {27045, 17585, 10886, 0, 0}, {29618, 23889, 19037, 0, 0},
           {5779, 506, 86, 0, 0},       {15372, 2831, 683, 0, 0},
           {21381, 7867, 2984, 0, 0},   {25479, 13947, 7220, 0, 0},
           {29034, 22191, 16682, 0, 0}, {3040, 267, 73, 0, 0},
           {15337, 3067, 865, 0, 0},    {22847, 9942, 4468, 0, 0},
           {26872, 17334, 10700, 0, 0}, {29338, 23122, 18011, 0, 0},
           {4154, 257, 63, 0, 0},       {13404, 2130, 505, 0, 0},
           {19639, 6514, 2366, 0, 0},   {24014, 12284, 6328, 0, 0},
           {28390, 21161, 15658, 0, 0}, {2476, 97, 24, 0, 0},
           {10988, 1165, 267, 0, 0},    {18454, 4939, 1477, 0, 0},
           {23157, 10441, 4505, 0, 0},  {27878, 19681, 13703, 0, 0},
           {6906, 201, 35, 0, 0},       {11974, 718, 201, 0, 0},
           {15525, 2143, 514, 0, 0},    {19485, 5140, 1294, 0, 0},
           {23099, 10236, 3850, 0, 0},  {5333, 71, 20, 0, 0},
           {7846, 378, 54, 0, 0},       {11319, 1264, 232, 0, 0},
           {16376, 3039, 936, 0, 0},    {21076, 7884, 3692, 0, 0},
           {8575, 478, 33, 0, 0},       {13859, 1664, 205, 0, 0},
           {20532, 5927, 1365, 0, 0},   {24597, 10928, 3686, 0, 0},
           {25544, 15488, 7493, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{29690, 25929, 22878, 0, 0}, {18931, 12318, 8289, 0, 0},
           {26854, 18546, 13440, 0, 0}, {28902, 22501, 18006, 0, 0},
           {30156, 25560, 21726, 0, 0}, {31701, 29777, 27992, 0, 0},
           {6951, 1122, 239, 0, 0},     {19060, 6430, 2383, 0, 0},
           {25440, 14183, 7898, 0, 0},  {28077, 19688, 13492, 0, 0},
           {30943, 27515, 24416, 0, 0}, {3382, 453, 144, 0, 0},
           {15608, 3767, 1408, 0, 0},   {23166, 10906, 5372, 0, 0},
           {26853, 16996, 10620, 0, 0}, {29982, 24989, 20721, 0, 0},
           {3522, 318, 105, 0, 0},      {14072, 2839, 950, 0, 0},
           {22258, 9399, 4208, 0, 0},   {26539, 16269, 9643, 0, 0},
           {30160, 25320, 21063, 0, 0}, {2015, 58, 20, 0, 0},
           {11130, 1281, 265, 0, 0},    {19831, 5914, 1898, 0, 0},
           {24586, 12172, 5798, 0, 0},  {29131, 22499, 17271, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{27524, 20618, 15862, 0, 0}, {12282, 5910, 3067, 0, 0},
           {25012, 14451, 9033, 0, 0},  {29316, 23512, 19622, 0, 0},
           {30748, 27562, 24539, 0, 0}, {30967, 27775, 24865, 0, 0},
           {5717, 910, 237, 0, 0},      {16780, 5237, 2149, 0, 0},
           {23580, 11284, 6049, 0, 0},  {26495, 15582, 8968, 0, 0},
           {29660, 23413, 18004, 0, 0}, {1692, 248, 88, 0, 0},
           {14649, 2731, 918, 0, 0},    {22524, 9799, 5296, 0, 0},
           {28076, 18691, 13495, 0, 0}, {29074, 21091, 15212, 0, 0},
           {2708, 187, 48, 0, 0},       {11757, 1993, 648, 0, 0},
           {20837, 7948, 3479, 0, 0},   {25649, 15106, 8412, 0, 0},
           {28935, 22062, 16464, 0, 0}, {814, 37, 20, 0, 0},
           {8855, 1044, 279, 0, 0},     {17248, 4708, 1482, 0, 0},
           {21251, 9760, 4197, 0, 0},   {26575, 18260, 12139, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{31733, 29961, 28612, 0, 0}, {19606, 14630, 11829, 0, 0},
           {30072, 26135, 24013, 0, 0}, {31395, 28607, 25915, 0, 0},
           {31669, 30022, 28052, 0, 0}, {32428, 31747, 31169, 0, 0},
           {9942, 2349, 633, 0, 0},     {22373, 11006, 5826, 0, 0},
           {28042, 20361, 15407, 0, 0}, {30321, 25688, 22175, 0, 0},
           {31541, 29051, 26757, 0, 0}, {4612, 1344, 834, 0, 0},
           {15853, 5014, 2395, 0, 0},   {23620, 11778, 6337, 0, 0},
           {26818, 17253, 11620, 0, 0}, {30276, 25441, 21242, 0, 0},
           {2166, 291, 98, 0, 0},       {12742, 2813, 1200, 0, 0},
           {21548, 9140, 4663, 0, 0},   {26116, 15749, 9795, 0, 0},
           {29704, 24232, 19725, 0, 0}, {999, 44, 20, 0, 0},
           {10538, 1881, 395, 0, 0},    {20534, 7689, 3037, 0, 0},
           {25442, 13952, 7415, 0, 0},  {28835, 21861, 16152, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0}}}},
        {{{{23872, 16541, 12138, 0, 0}, {9139, 986, 241, 0, 0},
           {17595, 5013, 1447, 0, 0},   {22610, 11535, 5386, 0, 0},
           {26348, 17911, 11210, 0, 0}, {29499, 24613, 20122, 0, 0},
           {7933, 759, 272, 0, 0},      {16259, 4347, 1189, 0, 0},
           {21811, 11254, 5350, 0, 0},  {24887, 16838, 10672, 0, 0},
           {27380, 21808, 16850, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {12023, 1995, 675, 0, 0},
           {17568, 5547, 1907, 0, 0},   {19736, 11895, 7101, 0, 0},
           {20483, 14105, 9274, 0, 0},  {21205, 15287, 11279, 0, 0},
           {6508, 786, 448, 0, 0},      {17371, 4685, 1668, 0, 0},
           {23026, 13551, 7944, 0, 0},  {29507, 23139, 17406, 0, 0},
           {31288, 28446, 25269, 0, 0}, {5169, 512, 308, 0, 0},
           {15911, 5109, 1994, 0, 0},   {23217, 14478, 9020, 0, 0},
           {29716, 23835, 18665, 0, 0}, {30747, 26858, 22981, 0, 0},
           {3763, 753, 376, 0, 0},      {15091, 5074, 1905, 0, 0},
           {23564, 15412, 9549, 0, 0},  {30365, 25252, 19954, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{21960, 10712, 5872, 0, 0},  {7029, 455, 92, 0, 0},
           {15480, 2565, 547, 0, 0},    {21409, 7890, 2872, 0, 0},
           {25819, 15001, 7875, 0, 0},  {28481, 20972, 14697, 0, 0},
           {4888, 247, 63, 0, 0},       {13730, 1764, 354, 0, 0},
           {20204, 6423, 2000, 0, 0},   {24499, 12821, 5989, 0, 0},
           {27094, 18111, 11094, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {7026, 449, 97, 0, 0},
           {13211, 1604, 314, 0, 0},    {19387, 6387, 2013, 0, 0},
           {22667, 11302, 6046, 0, 0},  {23559, 13118, 5943, 0, 0},
           {5661, 851, 336, 0, 0},      {14712, 3875, 1565, 0, 0},
           {22568, 11334, 6004, 0, 0},  {28108, 19855, 13266, 0, 0},
           {30400, 25838, 20264, 0, 0}, {5808, 610, 155, 0, 0},
           {14140, 2763, 737, 0, 0},    {22535, 10326, 4536, 0, 0},
           {27297, 18138, 11252, 0, 0}, {29533, 22001, 15659, 0, 0},
           {5072, 328, 76, 0, 0},       {12736, 1601, 330, 0, 0},
           {24068, 11427, 4326, 0, 0},  {27106, 17937, 10973, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{23064, 15474, 11636, 0, 0}, {6006, 490, 135, 0, 0},
           {14386, 3148, 949, 0, 0},    {21877, 9293, 4045, 0, 0},
           {26410, 16185, 9459, 0, 0},  {29520, 23650, 18627, 0, 0},
           {5564, 195, 69, 0, 0},       {12950, 1944, 439, 0, 0},
           {20996, 7648, 2727, 0, 0},   {25773, 14735, 7729, 0, 0},
           {29016, 22326, 16670, 0, 0}, {5546, 512, 209, 0, 0},
           {17412, 4369, 1293, 0, 0},   {23947, 12133, 5711, 0, 0},
           {27257, 18364, 11529, 0, 0}, {29833, 24546, 19717, 0, 0},
           {7893, 648, 239, 0, 0},      {17535, 4503, 1323, 0, 0},
           {24163, 12198, 5836, 0, 0},  {27337, 18355, 11572, 0, 0},
           {29774, 24427, 19545, 0, 0}, {4567, 164, 68, 0, 0},
           {11727, 1322, 312, 0, 0},    {19547, 6555, 2293, 0, 0},
           {24513, 13383, 6731, 0, 0},  {27838, 20183, 13938, 0, 0},
           {4000, 320, 141, 0, 0},      {13063, 2207, 747, 0, 0},
           {21196, 9179, 4548, 0, 0},   {27236, 17734, 11322, 0, 0},
           {30308, 25618, 21312, 0, 0}, {2894, 149, 69, 0, 0},
           {11147, 1697, 567, 0, 0},    {20257, 8021, 3776, 0, 0},
           {26487, 16373, 10020, 0, 0}, {29522, 23490, 18271, 0, 0},
           {3053, 143, 56, 0, 0},       {11810, 1757, 485, 0, 0},
           {21535, 9097, 3962, 0, 0},   {26756, 16640, 9900, 0, 0},
           {29341, 22917, 17354, 0, 0}, {24576, 16384, 8192, 0, 0}},
          {{21752, 10657, 5974, 0, 0},  {6822, 411, 91, 0, 0},
           {14878, 2316, 516, 0, 0},    {21090, 7626, 2952, 0, 0},
           {26048, 15234, 8184, 0, 0},  {28538, 21103, 14948, 0, 0},
           {4368, 145, 21, 0, 0},       {11604, 1100, 193, 0, 0},
           {19196, 5380, 1586, 0, 0},   {24534, 12018, 5410, 0, 0},
           {27703, 18713, 11871, 0, 0}, {3787, 221, 63, 0, 0},
           {14087, 2225, 529, 0, 0},    {21849, 8693, 3482, 0, 0},
           {26337, 15569, 8691, 0, 0},  {28949, 22304, 16150, 0, 0},
           {5898, 301, 75, 0, 0},       {13727, 1937, 421, 0, 0},
           {20974, 7557, 2752, 0, 0},   {25880, 14749, 7798, 0, 0},
           {28398, 20405, 13776, 0, 0}, {3190, 98, 24, 0, 0},
           {9609, 761, 155, 0, 0},      {17453, 4099, 1092, 0, 0},
           {23470, 10161, 3986, 0, 0},  {26624, 16855, 9800, 0, 0},
           {4658, 269, 99, 0, 0},       {11194, 1831, 753, 0, 0},
           {20009, 7950, 4041, 0, 0},   {26223, 16007, 9726, 0, 0},
           {29119, 22171, 15935, 0, 0}, {4605, 216, 40, 0, 0},
           {10667, 1299, 304, 0, 0},    {19608, 7296, 2625, 0, 0},
           {25465, 14084, 7300, 0, 0},  {27527, 18793, 11813, 0, 0},
           {4368, 137, 24, 0, 0},       {10664, 975, 165, 0, 0},
           {19211, 6197, 1922, 0, 0},   {25019, 12907, 6093, 0, 0},
           {27895, 18738, 11534, 0, 0}, {24576, 16384, 8192, 0, 0}}},
         {{{22968, 15133, 11695, 0, 0}, {6615, 883, 241, 0, 0},
           {17730, 4916, 1762, 0, 0},   {24050, 12204, 6282, 0, 0},
           {27640, 18692, 12254, 0, 0}, {30132, 25202, 20843, 0, 0},
           {5217, 264, 67, 0, 0},       {14458, 2714, 668, 0, 0},
           {22557, 9348, 3686, 0, 0},   {26546, 15892, 8852, 0, 0},
           {29306, 22814, 17270, 0, 0}, {2777, 135, 47, 0, 0},
           {12885, 2017, 567, 0, 0},    {21627, 8584, 3483, 0, 0},
           {26348, 15828, 8994, 0, 0},  {29376, 23015, 17650, 0, 0},
           {4303, 152, 56, 0, 0},       {12918, 2066, 524, 0, 0},
           {21785, 8744, 3545, 0, 0},   {26474, 15998, 9186, 0, 0},
           {29524, 23485, 18259, 0, 0}, {2745, 51, 20, 0, 0},
           {9828, 736, 142, 0, 0},      {18486, 4840, 1295, 0, 0},
           {24206, 11441, 4854, 0, 0},  {27922, 19375, 12849, 0, 0},
           {2787, 178, 73, 0, 0},       {12303, 1805, 602, 0, 0},
           {21289, 9189, 4573, 0, 0},   {26852, 17120, 10695, 0, 0},
           {29737, 24163, 19370, 0, 0}, {1622, 77, 29, 0, 0},
           {9662, 1044, 324, 0, 0},     {18985, 6030, 2329, 0, 0},
           {24916, 13300, 6961, 0, 0},  {28908, 21644, 15915, 0, 0},
           {1754, 44, 20, 0, 0},        {9139, 659, 140, 0, 0},
           {18021, 4653, 1365, 0, 0},   {24223, 11526, 5290, 0, 0},
           {28194, 19987, 13701, 0, 0}, {24576, 16384, 8192, 0, 0}},
          {{23583, 13074, 8080, 0, 0},  {6687, 783, 147, 0, 0},
           {16753, 3768, 981, 0, 0},    {22226, 9078, 3562, 0, 0},
           {26036, 14823, 8091, 0, 0},  {28852, 21729, 16046, 0, 0},
           {4544, 202, 24, 0, 0},       {13668, 1630, 283, 0, 0},
           {20240, 6148, 1889, 0, 0},   {25027, 12491, 5883, 0, 0},
           {28202, 19923, 13778, 0, 0}, {2835, 175, 50, 0, 0},
           {15098, 2435, 613, 0, 0},    {22383, 9168, 3859, 0, 0},
           {26525, 16532, 10361, 0, 0}, {28792, 22379, 16751, 0, 0},
           {4391, 207, 30, 0, 0},       {13402, 1593, 286, 0, 0},
           {19441, 5593, 1674, 0, 0},   {24510, 11999, 5625, 0, 0},
           {28065, 19570, 13241, 0, 0}, {1682, 62, 20, 0, 0},
           {9915, 866, 185, 0, 0},      {18009, 4582, 1349, 0, 0},
           {23484, 10386, 4420, 0, 0},  {27183, 17576, 10900, 0, 0},
           {4477, 116, 22, 0, 0},       {12919, 661, 197, 0, 0},
           {17934, 5950, 3554, 0, 0},   {22462, 10174, 4096, 0, 0},
           {26153, 15384, 9384, 0, 0},  {3821, 164, 23, 0, 0},
           {7143, 479, 122, 0, 0},      {14010, 4096, 1365, 0, 0},
           {22751, 9338, 4245, 0, 0},   {25906, 17499, 10637, 0, 0},
           {8835, 259, 29, 0, 0},       {12841, 1273, 137, 0, 0},
           {20865, 6745, 2147, 0, 0},   {25742, 12674, 5516, 0, 0},
           {26770, 14662, 8331, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{28312, 21494, 17235, 0, 0}, {11549, 3689, 1152, 0, 0},
           {21595, 8994, 4201, 0, 0},   {25486, 14475, 8505, 0, 0},
           {27878, 19482, 13653, 0, 0}, {30878, 27260, 24109, 0, 0},
           {6117, 632, 121, 0, 0},      {18138, 4514, 1313, 0, 0},
           {24052, 11481, 5373, 0, 0},  {27153, 17437, 10760, 0, 0},
           {30093, 25068, 20618, 0, 0}, {2814, 242, 78, 0, 0},
           {16642, 3786, 1135, 0, 0},   {23738, 11407, 5416, 0, 0},
           {27357, 17975, 11497, 0, 0}, {29825, 24346, 19605, 0, 0},
           {3229, 167, 38, 0, 0},       {14643, 2383, 567, 0, 0},
           {22346, 8678, 3300, 0, 0},   {26300, 15281, 8330, 0, 0},
           {29798, 24115, 19237, 0, 0}, {1856, 53, 20, 0, 0},
           {12102, 1395, 271, 0, 0},    {20259, 6128, 1851, 0, 0},
           {24710, 12139, 5478, 0, 0},  {28537, 20762, 14716, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{22566, 12135, 7284, 0, 0},  {5432, 1323, 416, 0, 0},
           {20348, 8384, 4216, 0, 0},   {25120, 14653, 8912, 0, 0},
           {27106, 18427, 12866, 0, 0}, {29157, 22440, 17378, 0, 0},
           {1823, 152, 32, 0, 0},       {14086, 2263, 515, 0, 0},
           {21255, 7432, 2565, 0, 0},   {25319, 13316, 6620, 0, 0},
           {28286, 19717, 13882, 0, 0}, {746, 78, 21, 0, 0},
           {14190, 2267, 622, 0, 0},    {21519, 9400, 4137, 0, 0},
           {27123, 15810, 10610, 0, 0}, {27759, 21324, 16131, 0, 0},
           {1411, 58, 20, 0, 0},        {11216, 1274, 264, 0, 0},
           {18877, 5091, 1428, 0, 0},   {23717, 10670, 4596, 0, 0},
           {27578, 19391, 13282, 0, 0}, {404, 28, 20, 0, 0},
           {7929, 861, 217, 0, 0},      {15608, 3989, 1072, 0, 0},
           {20316, 8631, 3166, 0, 0},   {26603, 17379, 10291, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{30193, 25487, 21691, 0, 0}, {18766, 11902, 7366, 0, 0},
           {26425, 17712, 13110, 0, 0}, {28294, 20910, 15727, 0, 0},
           {29903, 24469, 20234, 0, 0}, {31424, 28819, 26377, 0, 0},
           {8048, 1529, 309, 0, 0},     {20183, 7412, 2800, 0, 0},
           {25587, 14522, 8324, 0, 0},  {27743, 19101, 12883, 0, 0},
           {30247, 25464, 21163, 0, 0}, {2860, 516, 184, 0, 0},
           {15347, 3612, 1193, 0, 0},   {22879, 10580, 4986, 0, 0},
           {26890, 17121, 10645, 0, 0}, {29954, 24103, 19445, 0, 0},
           {2585, 200, 55, 0, 0},       {14240, 2573, 719, 0, 0},
           {21786, 8162, 3111, 0, 0},   {25811, 14603, 7537, 0, 0},
           {29260, 22650, 17300, 0, 0}, {1007, 32, 20, 0, 0},
           {11727, 1440, 222, 0, 0},    {20200, 6036, 1602, 0, 0},
           {24716, 12048, 5035, 0, 0},  {28432, 20576, 14372, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0}}}},
        {{{{25706, 16296, 10449, 0, 0}, {8230, 507, 94, 0, 0},
           {19093, 4727, 989, 0, 0},    {24178, 12094, 5137, 0, 0},
           {27083, 18093, 10755, 0, 0}, {29113, 22870, 17037, 0, 0},
           {6275, 350, 110, 0, 0},      {16392, 3426, 678, 0, 0},
           {22174, 10119, 3798, 0, 0},  {24592, 15598, 8465, 0, 0},
           {27163, 20074, 13629, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {8880, 866, 226, 0, 0},
           {14156, 3081, 781, 0, 0},    {16523, 7916, 3519, 0, 0},
           {17003, 10160, 5209, 0, 0},  {12873, 8069, 5258, 0, 0},
           {4367, 556, 311, 0, 0},      {17494, 4943, 1788, 0, 0},
           {23404, 14640, 8436, 0, 0},  {30485, 24575, 17686, 0, 0},
           {31540, 28796, 24887, 0, 0}, {3313, 299, 148, 0, 0},
           {14787, 4523, 1380, 0, 0},   {21847, 12670, 6528, 0, 0},
           {29025, 20939, 14111, 0, 0}, {30394, 23175, 17053, 0, 0},
           {1700, 302, 133, 0, 0},      {12447, 3196, 797, 0, 0},
           {21997, 12513, 5649, 0, 0},  {29973, 22358, 15407, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{23448, 10666, 4928, 0, 0},  {5711, 304, 44, 0, 0},
           {16437, 2500, 459, 0, 0},    {22449, 8833, 3048, 0, 0},
           {26579, 16320, 8662, 0, 0},  {29179, 21884, 13960, 0, 0},
           {3742, 144, 20, 0, 0},       {13542, 1261, 181, 0, 0},
           {20076, 5847, 1565, 0, 0},   {25719, 13236, 5133, 0, 0},
           {25041, 17099, 9516, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {4712, 143, 20, 0, 0},
           {10385, 693, 99, 0, 0},      {17351, 5670, 1019, 0, 0},
           {14641, 6275, 5578, 0, 0},   {27307, 16384, 10923, 0, 0},
           {4786, 677, 184, 0, 0},      {13723, 2900, 796, 0, 0},
           {22371, 10502, 4836, 0, 0},  {26778, 19071, 11268, 0, 0},
           {30976, 25856, 17664, 0, 0}, {4570, 267, 50, 0, 0},
           {11234, 1247, 199, 0, 0},    {21659, 7551, 2751, 0, 0},
           {27097, 17644, 6617, 0, 0},  {28087, 18725, 14043, 0, 0},
           {4080, 188, 27, 0, 0},       {10192, 689, 107, 0, 0},
           {22141, 10627, 4428, 0, 0},  {23406, 18725, 4681, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{25014, 15820, 10626, 0, 0}, {7098, 438, 77, 0, 0},
           {17105, 3543, 774, 0, 0},    {22890, 9480, 3610, 0, 0},
           {26349, 15680, 8432, 0, 0},  {28909, 21765, 15729, 0, 0},
           {5206, 173, 43, 0, 0},       {15193, 2180, 369, 0, 0},
           {21949, 7930, 2459, 0, 0},   {25644, 14082, 6852, 0, 0},
           {28289, 20080, 13428, 0, 0}, {4383, 292, 95, 0, 0},
           {17462, 3763, 830, 0, 0},    {23831, 11153, 4446, 0, 0},
           {26786, 17165, 9982, 0, 0},  {29148, 22501, 16632, 0, 0},
           {5488, 304, 101, 0, 0},      {17161, 3608, 764, 0, 0},
           {23677, 10633, 4028, 0, 0},  {26536, 16136, 8748, 0, 0},
           {28721, 21391, 15096, 0, 0}, {3548, 138, 50, 0, 0},
           {13118, 1548, 306, 0, 0},    {19718, 6456, 1941, 0, 0},
           {23540, 11898, 5300, 0, 0},  {26622, 17619, 10797, 0, 0},
           {2599, 287, 145, 0, 0},      {15556, 3457, 1214, 0, 0},
           {22857, 11457, 5886, 0, 0},  {28281, 19454, 12396, 0, 0},
           {30198, 24996, 19879, 0, 0}, {1844, 155, 60, 0, 0},
           {13278, 2562, 661, 0, 0},    {21536, 8770, 3492, 0, 0},
           {25999, 14813, 7733, 0, 0},  {28370, 20145, 13554, 0, 0},
           {2159, 141, 46, 0, 0},       {13398, 2186, 481, 0, 0},
           {22311, 9149, 3359, 0, 0},   {26325, 15131, 7934, 0, 0},
           {28123, 19532, 12662, 0, 0}, {24576, 16384, 8192, 0, 0}},
          {{24142, 12497, 6552, 0, 0},  {6061, 362, 57, 0, 0},
           {15769, 2439, 482, 0, 0},    {21323, 7645, 2482, 0, 0},
           {26357, 13940, 7167, 0, 0},  {25967, 20310, 12520, 0, 0},
           {2850, 86, 20, 0, 0},        {12119, 1029, 150, 0, 0},
           {19889, 4995, 1187, 0, 0},   {24872, 11017, 4524, 0, 0},
           {27508, 17898, 9070, 0, 0},  {3516, 175, 37, 0, 0},
           {15696, 2308, 474, 0, 0},    {22115, 8625, 3403, 0, 0},
           {26232, 15278, 8785, 0, 0},  {27839, 19598, 12683, 0, 0},
           {4631, 250, 53, 0, 0},       {14597, 1984, 361, 0, 0},
           {21331, 7332, 2309, 0, 0},   {25516, 14234, 6592, 0, 0},
           {28642, 19415, 11790, 0, 0}, {1606, 42, 20, 0, 0},
           {9751, 546, 67, 0, 0},       {17139, 3535, 722, 0, 0},
           {23381, 10147, 3288, 0, 0},  {25846, 15152, 7758, 0, 0},
           {3930, 503, 154, 0, 0},      {13067, 2562, 848, 0, 0},
           {21554, 10358, 4835, 0, 0},  {27448, 18591, 9734, 0, 0},
           {27719, 19887, 14941, 0, 0}, {5284, 297, 34, 0, 0},
           {11692, 1242, 207, 0, 0},    {20061, 6465, 1557, 0, 0},
           {24599, 11046, 4549, 0, 0},  {26723, 13362, 5726, 0, 0},
           {5015, 196, 23, 0, 0},       {11936, 890, 115, 0, 0},
           {19518, 5412, 1094, 0, 0},   {25050, 11260, 2910, 0, 0},
           {25559, 14418, 7209, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{24892, 15867, 11027, 0, 0}, {8767, 870, 143, 0, 0},
           {18239, 4809, 1317, 0, 0},   {24495, 11950, 5510, 0, 0},
           {27490, 18095, 11258, 0, 0}, {29785, 23925, 18729, 0, 0},
           {4752, 194, 36, 0, 0},       {15297, 2462, 467, 0, 0},
           {22544, 8705, 3040, 0, 0},   {26166, 14814, 7716, 0, 0},
           {28766, 21183, 15009, 0, 0}, {2578, 134, 29, 0, 0},
           {15271, 2486, 498, 0, 0},    {22539, 9039, 3230, 0, 0},
           {26424, 15557, 8328, 0, 0},  {28919, 21579, 15660, 0, 0},
           {4198, 185, 42, 0, 0},       {15247, 2607, 530, 0, 0},
           {22615, 9203, 3390, 0, 0},   {26313, 15427, 8325, 0, 0},
           {28861, 21726, 15744, 0, 0}, {2079, 53, 20, 0, 0},
           {11222, 928, 158, 0, 0},     {19221, 5187, 1309, 0, 0},
           {23856, 11011, 4459, 0, 0},  {27220, 17688, 10722, 0, 0},
           {1985, 228, 83, 0, 0},       {15228, 3240, 1100, 0, 0},
           {22608, 11300, 5985, 0, 0},  {28044, 19375, 12714, 0, 0},
           {30066, 24594, 19666, 0, 0}, {1120, 82, 26, 0, 0},
           {11814, 1674, 431, 0, 0},    {20348, 7070, 2589, 0, 0},
           {25464, 13448, 6520, 0, 0},  {28402, 20507, 13904, 0, 0},
           {1187, 45, 20, 0, 0},        {11395, 1182, 243, 0, 0},
           {20024, 6143, 1883, 0, 0},   {25337, 12446, 5818, 0, 0},
           {28076, 19445, 12657, 0, 0}, {24576, 16384, 8192, 0, 0}},
          {{24935, 14399, 8673, 0, 0},  {6118, 495, 66, 0, 0},
           {16397, 2807, 577, 0, 0},    {21713, 8686, 3139, 0, 0},
           {25876, 14124, 7368, 0, 0},  {27762, 19711, 13528, 0, 0},
           {2934, 102, 20, 0, 0},       {13191, 1433, 198, 0, 0},
           {20515, 6259, 1646, 0, 0},   {24777, 11996, 5057, 0, 0},
           {27091, 16858, 9709, 0, 0},  {2659, 236, 48, 0, 0},
           {16021, 2602, 516, 0, 0},    {22634, 9226, 3584, 0, 0},
           {26977, 16592, 9212, 0, 0},  {28406, 22354, 15484, 0, 0},
           {3276, 142, 20, 0, 0},       {12874, 1366, 243, 0, 0},
           {19826, 5697, 1899, 0, 0},   {24422, 11552, 5363, 0, 0},
           {26196, 15681, 8909, 0, 0},  {733, 33, 20, 0, 0},
           {9811, 930, 150, 0, 0},      {18044, 4196, 996, 0, 0},
           {22404, 8769, 3215, 0, 0},   {25764, 14335, 7113, 0, 0},
           {5240, 491, 87, 0, 0},       {15809, 1597, 672, 0, 0},
           {22282, 9175, 4806, 0, 0},   {24576, 16384, 9557, 0, 0},
           {23831, 14895, 11916, 0, 0}, {5053, 766, 153, 0, 0},
           {17695, 3277, 1092, 0, 0},   {21504, 8192, 4096, 0, 0},
           {30427, 14043, 9362, 0, 0},  {25486, 14564, 7282, 0, 0},
           {4221, 555, 111, 0, 0},      {11980, 2995, 529, 0, 0},
           {25988, 11299, 2260, 0, 0},  {26810, 17873, 8937, 0, 0},
           {16384, 10923, 5461, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{26776, 18464, 13003, 0, 0}, {10156, 1530, 312, 0, 0},
           {19312, 5606, 1681, 0, 0},   {24767, 12706, 6264, 0, 0},
           {27600, 18663, 12004, 0, 0}, {30136, 24997, 20383, 0, 0},
           {5734, 424, 59, 0, 0},       {16918, 3353, 771, 0, 0},
           {23274, 9992, 3927, 0, 0},   {26617, 15938, 8799, 0, 0},
           {29307, 22729, 17046, 0, 0}, {2634, 199, 37, 0, 0},
           {17130, 3346, 823, 0, 0},    {23618, 10903, 4550, 0, 0},
           {27121, 17049, 10092, 0, 0}, {29366, 22996, 17291, 0, 0},
           {4238, 182, 33, 0, 0},       {15629, 2470, 476, 0, 0},
           {22568, 8729, 3083, 0, 0},   {26349, 15094, 7982, 0, 0},
           {29224, 22543, 16944, 0, 0}, {1435, 42, 20, 0, 0},
           {12150, 1281, 224, 0, 0},    {19867, 5551, 1536, 0, 0},
           {24144, 11034, 4597, 0, 0},  {27664, 18577, 12020, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{21562, 11678, 6207, 0, 0},  {4009, 489, 97, 0, 0},
           {18597, 4816, 1199, 0, 0},   {23025, 9861, 3627, 0, 0},
           {25897, 14882, 7900, 0, 0},  {27808, 19616, 13453, 0, 0},
           {1691, 107, 20, 0, 0},       {13368, 1573, 253, 0, 0},
           {20016, 5910, 1728, 0, 0},   {24398, 10670, 4177, 0, 0},
           {27311, 17395, 10470, 0, 0}, {1071, 62, 20, 0, 0},
           {14908, 2111, 435, 0, 0},    {20258, 7956, 3507, 0, 0},
           {26588, 13644, 8046, 0, 0},  {27727, 19220, 14809, 0, 0},
           {1216, 52, 20, 0, 0},        {10860, 999, 145, 0, 0},
           {18298, 4567, 1203, 0, 0},   {23275, 9786, 4160, 0, 0},
           {25910, 15528, 8631, 0, 0},  {225, 16, 12, 0, 0},
           {8482, 671, 102, 0, 0},      {16810, 3551, 744, 0, 0},
           {22561, 8534, 2810, 0, 0},   {25839, 14463, 7116, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}}},
         {{{28631, 21921, 17086, 0, 0}, {14944, 5767, 2710, 0, 0},
           {22564, 9972, 4477, 0, 0},   {26692, 16833, 10643, 0, 0},
           {28916, 21831, 15952, 0, 0}, {30516, 26444, 22637, 0, 0},
           {6928, 752, 106, 0, 0},      {17659, 4500, 1237, 0, 0},
           {23383, 10537, 4428, 0, 0},  {26686, 16096, 9289, 0, 0},
           {29450, 23341, 18087, 0, 0}, {2174, 194, 50, 0, 0},
           {15932, 3216, 909, 0, 0},    {23212, 10226, 4412, 0, 0},
           {26463, 16043, 9228, 0, 0},  {29392, 22873, 17584, 0, 0},
           {3385, 151, 23, 0, 0},       {13877, 1959, 367, 0, 0},
           {21080, 6826, 2081, 0, 0},   {25300, 13299, 6117, 0, 0},
           {28859, 21410, 15756, 0, 0}, {1204, 32, 20, 0, 0},
           {11862, 1157, 168, 0, 0},    {19577, 5147, 1231, 0, 0},
           {24000, 10739, 4092, 0, 0},  {27689, 18659, 11862, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0},  {24576, 16384, 8192, 0, 0}},
          {{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0}}}}};

constexpr uint16_t kDefaultCoeffBaseRangeCdf
    [kCoefficientQuantizerContexts][kNumSquareTransformSizes][kNumPlaneTypes]
    [kCoeffBaseRangeContexts][kCoeffBaseRangeSymbolCount + 1] = {
        {{{{18470, 12050, 8594, 0, 0},  {20232, 13167, 8979, 0, 0},
           {24056, 17717, 13265, 0, 0}, {26598, 21441, 17334, 0, 0},
           {28026, 23842, 20230, 0, 0}, {28965, 25451, 22222, 0, 0},
           {31072, 29451, 27897, 0, 0}, {18376, 12817, 10012, 0, 0},
           {16790, 9550, 5950, 0, 0},   {20581, 13294, 8879, 0, 0},
           {23592, 17128, 12509, 0, 0}, {25700, 20113, 15740, 0, 0},
           {27112, 22326, 18296, 0, 0}, {30188, 27776, 25524, 0, 0},
           {20632, 14719, 11342, 0, 0}, {18984, 12047, 8287, 0, 0},
           {21932, 15147, 10868, 0, 0}, {24396, 18324, 13921, 0, 0},
           {26245, 20989, 16768, 0, 0}, {27431, 22870, 19008, 0, 0},
           {29734, 26908, 24306, 0, 0}},
          {{16801, 9863, 6482, 0, 0},   {19234, 12114, 8189, 0, 0},
           {23264, 16676, 12233, 0, 0}, {25793, 20200, 15865, 0, 0},
           {27404, 22677, 18748, 0, 0}, {28411, 24398, 20911, 0, 0},
           {30262, 27834, 25550, 0, 0}, {9736, 3953, 1832, 0, 0},
           {13228, 6064, 3049, 0, 0},   {17610, 9799, 5671, 0, 0},
           {21360, 13903, 9118, 0, 0},  {23883, 17320, 12518, 0, 0},
           {25660, 19915, 15352, 0, 0}, {28537, 24727, 21288, 0, 0},
           {12945, 6278, 3612, 0, 0},   {13878, 6839, 3836, 0, 0},
           {17108, 9277, 5335, 0, 0},   {20621, 12992, 8280, 0, 0},
           {23040, 15994, 11119, 0, 0}, {24849, 18491, 13702, 0, 0},
           {27328, 22598, 18583, 0, 0}}},
         {{{18362, 11906, 8354, 0, 0},  {20944, 13861, 9659, 0, 0},
           {24511, 18375, 13965, 0, 0}, {26908, 22021, 17990, 0, 0},
           {28293, 24282, 20784, 0, 0}, {29162, 25814, 22725, 0, 0},
           {31032, 29358, 27720, 0, 0}, {18338, 12722, 9886, 0, 0},
           {17175, 9869, 6059, 0, 0},   {20666, 13400, 8957, 0, 0},
           {23709, 17184, 12506, 0, 0}, {25769, 20165, 15720, 0, 0},
           {27084, 22271, 18215, 0, 0}, {29946, 27330, 24906, 0, 0},
           {16983, 11183, 8409, 0, 0},  {14421, 7539, 4502, 0, 0},
           {17794, 10281, 6379, 0, 0},  {21345, 14087, 9497, 0, 0},
           {23905, 17418, 12760, 0, 0}, {25615, 19916, 15490, 0, 0},
           {29061, 25732, 22786, 0, 0}},
          {{17308, 11072, 7299, 0, 0},  {20598, 13519, 9577, 0, 0},
           {24045, 17741, 13436, 0, 0}, {26340, 21064, 16894, 0, 0},
           {27846, 23476, 19716, 0, 0}, {28629, 25073, 21758, 0, 0},
           {30477, 28260, 26170, 0, 0}, {12912, 5848, 2940, 0, 0},
           {14845, 7479, 3976, 0, 0},   {18490, 10800, 6471, 0, 0},
           {21858, 14632, 9818, 0, 0},  {24345, 17953, 13141, 0, 0},
           {25997, 20485, 15994, 0, 0}, {28694, 25018, 21687, 0, 0},
           {12916, 6694, 4096, 0, 0},   {13397, 6658, 3779, 0, 0},
           {16503, 8895, 5105, 0, 0},   {20010, 12390, 7816, 0, 0},
           {22673, 15670, 10807, 0, 0}, {24518, 18140, 13317, 0, 0},
           {27563, 23023, 19146, 0, 0}}},
         {{{22205, 16535, 13005, 0, 0}, {22974, 16746, 12964, 0, 0},
           {26018, 20823, 17009, 0, 0}, {27805, 23582, 20016, 0, 0},
           {28923, 25333, 22141, 0, 0}, {29717, 26683, 23934, 0, 0},
           {31457, 30172, 28938, 0, 0}, {21522, 16364, 13079, 0, 0},
           {20453, 13857, 10037, 0, 0}, {22211, 15673, 11479, 0, 0},
           {24632, 18762, 14519, 0, 0}, {26420, 21294, 17203, 0, 0},
           {27572, 23113, 19368, 0, 0}, {30419, 28242, 26181, 0, 0},
           {19431, 14038, 11199, 0, 0}, {13462, 6697, 3886, 0, 0},
           {16816, 9228, 5514, 0, 0},   {20359, 12834, 8338, 0, 0},
           {23008, 16062, 11379, 0, 0}, {24764, 18548, 13950, 0, 0},
           {28630, 24974, 21807, 0, 0}},
          {{21898, 16084, 11819, 0, 0}, {23104, 17538, 14088, 0, 0},
           {25882, 20659, 17360, 0, 0}, {27943, 23868, 20463, 0, 0},
           {29138, 25606, 22454, 0, 0}, {29732, 26339, 23381, 0, 0},
           {31097, 29472, 27828, 0, 0}, {18949, 13609, 9742, 0, 0},
           {20784, 13660, 9648, 0, 0},  {22078, 15558, 11105, 0, 0},
           {24784, 18614, 14435, 0, 0}, {25900, 20474, 16644, 0, 0},
           {27494, 23774, 19900, 0, 0}, {29780, 26997, 24344, 0, 0},
           {13032, 6121, 3627, 0, 0},   {13835, 6698, 3784, 0, 0},
           {16989, 9720, 5568, 0, 0},   {20130, 12707, 8236, 0, 0},
           {22076, 15223, 10548, 0, 0}, {23551, 17517, 12714, 0, 0},
           {27690, 23484, 20174, 0, 0}}},
         {{{30437, 29106, 27524, 0, 0}, {29877, 27997, 26623, 0, 0},
           {28170, 25145, 23039, 0, 0}, {29248, 25923, 23569, 0, 0},
           {29351, 26649, 23444, 0, 0}, {30167, 27356, 25383, 0, 0},
           {32168, 31595, 31024, 0, 0}, {25096, 19482, 15299, 0, 0},
           {28536, 24976, 21975, 0, 0}, {29853, 27451, 25371, 0, 0},
           {30450, 28412, 26616, 0, 0}, {30641, 28768, 27214, 0, 0},
           {30918, 29290, 27493, 0, 0}, {31791, 30835, 29925, 0, 0},
           {14488, 8381, 4779, 0, 0},   {16916, 10097, 6583, 0, 0},
           {18923, 11817, 7979, 0, 0},  {21713, 14802, 10639, 0, 0},
           {23630, 17346, 12967, 0, 0}, {25314, 19623, 15312, 0, 0},
           {29398, 26375, 23755, 0, 0}},
          {{26926, 23539, 21930, 0, 0}, {30455, 29277, 28492, 0, 0},
           {29770, 26664, 25272, 0, 0}, {30348, 25321, 22900, 0, 0},
           {29734, 24273, 21845, 0, 0}, {28692, 23831, 21793, 0, 0},
           {31682, 30398, 29469, 0, 0}, {23054, 15514, 12324, 0, 0},
           {24225, 19070, 15645, 0, 0}, {27850, 23761, 20858, 0, 0},
           {28639, 25236, 22215, 0, 0}, {30404, 27235, 24710, 0, 0},
           {30934, 29222, 27205, 0, 0}, {31295, 29860, 28635, 0, 0},
           {17363, 11575, 7149, 0, 0},  {17077, 10816, 6207, 0, 0},
           {19806, 13574, 8603, 0, 0},  {22496, 14913, 10639, 0, 0},
           {24180, 17498, 12050, 0, 0}, {24086, 18099, 13268, 0, 0},
           {27898, 23132, 19563, 0, 0}}},
         {{{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}},
          {{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}}}},
        {{{{17773, 11427, 8019, 0, 0},  {19610, 12479, 8167, 0, 0},
           {23827, 17442, 12892, 0, 0}, {26471, 21227, 16961, 0, 0},
           {27951, 23739, 19992, 0, 0}, {29037, 25495, 22141, 0, 0},
           {30921, 29151, 27414, 0, 0}, {18296, 13109, 10425, 0, 0},
           {15962, 8606, 5235, 0, 0},   {19868, 12364, 8055, 0, 0},
           {23357, 16656, 11971, 0, 0}, {25712, 20071, 15620, 0, 0},
           {27224, 22429, 18308, 0, 0}, {29814, 27064, 24449, 0, 0},
           {20304, 14697, 11414, 0, 0}, {17286, 10240, 6734, 0, 0},
           {20698, 13499, 9144, 0, 0},  {23815, 17362, 12662, 0, 0},
           {25741, 20038, 15548, 0, 0}, {26881, 21855, 17628, 0, 0},
           {28975, 25490, 22321, 0, 0}},
          {{17197, 10536, 7019, 0, 0},  {18262, 11193, 7394, 0, 0},
           {22579, 15679, 11199, 0, 0}, {25452, 19467, 14853, 0, 0},
           {26985, 21856, 17578, 0, 0}, {28008, 23613, 19680, 0, 0},
           {29775, 26802, 23994, 0, 0}, {9344, 3865, 1990, 0, 0},
           {11993, 5102, 2478, 0, 0},   {16294, 8358, 4469, 0, 0},
           {20297, 12588, 7781, 0, 0},  {23358, 16281, 11329, 0, 0},
           {25232, 19154, 14239, 0, 0}, {27720, 23182, 19219, 0, 0},
           {11678, 5478, 3012, 0, 0},   {11972, 5366, 2742, 0, 0},
           {14949, 7283, 3799, 0, 0},   {18908, 10859, 6306, 0, 0},
           {21766, 14274, 9239, 0, 0},  {23815, 16839, 11871, 0, 0},
           {26320, 20850, 16314, 0, 0}}},
         {{{16769, 10560, 7319, 0, 0},  {19718, 12780, 8646, 0, 0},
           {24174, 17904, 13390, 0, 0}, {26735, 21689, 17530, 0, 0},
           {28214, 24085, 20421, 0, 0}, {29096, 25629, 22431, 0, 0},
           {30868, 28997, 27192, 0, 0}, {16980, 11428, 8819, 0, 0},
           {15943, 8533, 5010, 0, 0},   {19895, 12366, 7958, 0, 0},
           {23178, 16405, 11674, 0, 0}, {25416, 19559, 15035, 0, 0},
           {26808, 21779, 17584, 0, 0}, {29536, 26534, 23761, 0, 0},
           {17007, 12052, 9544, 0, 0},  {13450, 6779, 4009, 0, 0},
           {17239, 9674, 5839, 0, 0},   {21106, 13779, 9127, 0, 0},
           {23813, 17200, 12402, 0, 0}, {25487, 19662, 15060, 0, 0},
           {28520, 24709, 21328, 0, 0}},
          {{17869, 11551, 8265, 0, 0},  {19249, 12485, 8721, 0, 0},
           {23339, 16802, 12403, 0, 0}, {26068, 20413, 16116, 0, 0},
           {27680, 23064, 19052, 0, 0}, {28525, 24614, 21037, 0, 0},
           {30066, 27404, 24907, 0, 0}, {10023, 4380, 2314, 0, 0},
           {12533, 5622, 2846, 0, 0},   {16872, 9053, 5131, 0, 0},
           {20928, 13418, 8637, 0, 0},  {23646, 16836, 11888, 0, 0},
           {25280, 19187, 14406, 0, 0}, {27654, 23200, 19398, 0, 0},
           {11923, 6215, 3836, 0, 0},   {11787, 5396, 2884, 0, 0},
           {14987, 7433, 3983, 0, 0},   {19008, 11060, 6471, 0, 0},
           {21793, 14353, 9403, 0, 0},  {23723, 16979, 12082, 0, 0},
           {26638, 21569, 17345, 0, 0}}},
         {{{19219, 13044, 9610, 0, 0},  {20924, 14386, 10522, 0, 0},
           {24849, 19149, 14995, 0, 0}, {27282, 22625, 18822, 0, 0},
           {28602, 24785, 21444, 0, 0}, {29404, 26262, 23341, 0, 0},
           {31170, 29608, 28094, 0, 0}, {17487, 11789, 8987, 0, 0},
           {17829, 10649, 6816, 0, 0},  {21405, 14361, 9956, 0, 0},
           {24159, 17911, 13398, 0, 0}, {26031, 20584, 16288, 0, 0},
           {27262, 22505, 18506, 0, 0}, {29778, 26982, 24388, 0, 0},
           {12519, 7515, 5351, 0, 0},   {11698, 5250, 2767, 0, 0},
           {15914, 8299, 4694, 0, 0},   {19904, 12282, 7768, 0, 0},
           {22806, 15790, 10990, 0, 0}, {24694, 18430, 13720, 0, 0},
           {28274, 24289, 20862, 0, 0}},
          {{18808, 13151, 9939, 0, 0},  {21618, 15427, 11540, 0, 0},
           {25618, 19804, 15578, 0, 0}, {27437, 22766, 18901, 0, 0},
           {28601, 25024, 21711, 0, 0}, {29288, 26139, 23122, 0, 0},
           {30885, 28984, 27082, 0, 0}, {14016, 7108, 3856, 0, 0},
           {15800, 8182, 4738, 0, 0},   {19248, 11713, 7455, 0, 0},
           {22315, 15142, 10488, 0, 0}, {24382, 18263, 13652, 0, 0},
           {26026, 20173, 15760, 0, 0}, {28495, 24628, 21269, 0, 0},
           {10648, 4941, 2535, 0, 0},   {12205, 5410, 2873, 0, 0},
           {15692, 8124, 4615, 0, 0},   {19406, 11826, 7459, 0, 0},
           {21974, 14803, 10073, 0, 0}, {23754, 17116, 12449, 0, 0},
           {27060, 22256, 18271, 0, 0}}},
         {{{27063, 21838, 17043, 0, 0}, {24822, 20003, 16653, 0, 0},
           {25967, 20645, 16542, 0, 0}, {27306, 22633, 18568, 0, 0},
           {28579, 24757, 21261, 0, 0}, {29577, 26539, 23360, 0, 0},
           {31711, 30631, 29556, 0, 0}, {22750, 15701, 11277, 0, 0},
           {25388, 20186, 16315, 0, 0}, {26700, 21923, 18429, 0, 0},
           {27670, 23570, 20213, 0, 0}, {28456, 24758, 21649, 0, 0},
           {29068, 25802, 22987, 0, 0}, {31075, 29442, 27881, 0, 0},
           {14011, 7838, 4994, 0, 0},   {15120, 8172, 4951, 0, 0},
           {18061, 10716, 6742, 0, 0},  {21048, 13916, 9476, 0, 0},
           {23411, 16816, 12243, 0, 0}, {24958, 19015, 14558, 0, 0},
           {28889, 25435, 22440, 0, 0}},
          {{24490, 19526, 16846, 0, 0}, {22221, 16901, 13849, 0, 0},
           {23662, 16926, 12159, 0, 0}, {25935, 19761, 15550, 0, 0},
           {27957, 23056, 18845, 0, 0}, {28783, 25416, 21640, 0, 0},
           {31080, 29310, 27506, 0, 0}, {19817, 10907, 6258, 0, 0},
           {22980, 16724, 12492, 0, 0}, {26459, 21524, 17898, 0, 0},
           {27585, 23419, 20202, 0, 0}, {28379, 24539, 21276, 0, 0},
           {29135, 25823, 22148, 0, 0}, {29168, 25921, 22861, 0, 0},
           {11020, 4631, 2513, 0, 0},   {13332, 6187, 3208, 0, 0},
           {16409, 8567, 4815, 0, 0},   {18807, 11075, 6897, 0, 0},
           {21224, 14082, 9446, 0, 0},  {23396, 16306, 11816, 0, 0},
           {26630, 21558, 17378, 0, 0}}},
         {{{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}},
          {{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}}}},
        {{{{16630, 10545, 7259, 0, 0},  {17421, 10338, 6436, 0, 0},
           {23154, 16032, 11436, 0, 0}, {26168, 20493, 15861, 0, 0},
           {27957, 23344, 19221, 0, 0}, {29020, 24959, 21348, 0, 0},
           {30514, 28181, 25878, 0, 0}, {17572, 12484, 9591, 0, 0},
           {14451, 7299, 4317, 0, 0},   {18850, 11117, 6926, 0, 0},
           {22716, 15618, 10773, 0, 0}, {25269, 19138, 14181, 0, 0},
           {26610, 21351, 16765, 0, 0}, {28754, 24983, 21516, 0, 0},
           {17720, 11701, 8384, 0, 0},  {14566, 7422, 4215, 0, 0},
           {18466, 10749, 6412, 0, 0},  {21929, 14629, 9602, 0, 0},
           {24053, 17024, 11962, 0, 0}, {25232, 19192, 14224, 0, 0},
           {27355, 22433, 18270, 0, 0}},
          {{15374, 8267, 4873, 0, 0},   {16879, 9348, 5583, 0, 0},
           {21207, 13635, 8898, 0, 0},  {24483, 17956, 12924, 0, 0},
           {26272, 20725, 16218, 0, 0}, {27997, 23194, 19091, 0, 0},
           {29165, 25938, 22624, 0, 0}, {11112, 5064, 2568, 0, 0},
           {11444, 4853, 2257, 0, 0},   {15441, 7432, 3771, 0, 0},
           {19351, 11387, 6735, 0, 0},  {22636, 15343, 10430, 0, 0},
           {24188, 17752, 13135, 0, 0}, {27074, 21291, 16357, 0, 0},
           {8652, 2988, 1318, 0, 0},    {8915, 3073, 1177, 0, 0},
           {12683, 5154, 2340, 0, 0},   {17442, 8433, 4193, 0, 0},
           {20954, 13296, 7958, 0, 0},  {22547, 14157, 8001, 0, 0},
           {25079, 18210, 12447, 0, 0}}},
         {{{16554, 10388, 6998, 0, 0},  {18555, 11464, 7473, 0, 0},
           {23555, 16945, 12313, 0, 0}, {26373, 21010, 16629, 0, 0},
           {27989, 23581, 19702, 0, 0}, {28947, 25267, 21815, 0, 0},
           {30475, 28201, 25973, 0, 0}, {16909, 11485, 8948, 0, 0},
           {14364, 7166, 4042, 0, 0},   {18443, 10788, 6562, 0, 0},
           {22099, 14831, 10048, 0, 0}, {24471, 18126, 13321, 0, 0},
           {26022, 20379, 15875, 0, 0}, {28444, 24517, 20998, 0, 0},
           {16236, 11137, 8293, 0, 0},  {12101, 5618, 3100, 0, 0},
           {16040, 8258, 4593, 0, 0},   {19907, 12123, 7436, 0, 0},
           {22692, 15407, 10351, 0, 0}, {24373, 17828, 12805, 0, 0},
           {27037, 22085, 17856, 0, 0}},
          {{18335, 11613, 7830, 0, 0},  {18110, 11052, 7223, 0, 0},
           {22845, 15944, 11211, 0, 0}, {25786, 19716, 15047, 0, 0},
           {27349, 22265, 17718, 0, 0}, {27916, 23606, 19754, 0, 0},
           {29497, 26373, 23138, 0, 0}, {10558, 4935, 2659, 0, 0},
           {12018, 5400, 2947, 0, 0},   {15874, 7940, 4195, 0, 0},
           {19521, 11492, 7011, 0, 0},  {22730, 15503, 10205, 0, 0},
           {24181, 17821, 12441, 0, 0}, {27123, 21397, 17516, 0, 0},
           {10741, 5242, 3054, 0, 0},   {9670, 3622, 1547, 0, 0},
           {12882, 5427, 2496, 0, 0},   {17159, 9021, 4722, 0, 0},
           {20775, 12703, 7829, 0, 0},  {23131, 14501, 9097, 0, 0},
           {25143, 18967, 13624, 0, 0}}},
         {{{18330, 11970, 8679, 0, 0},  {20147, 13565, 9671, 0, 0},
           {24591, 18643, 14366, 0, 0}, {27094, 22267, 18312, 0, 0},
           {28532, 24529, 21035, 0, 0}, {29321, 26018, 22962, 0, 0},
           {30782, 28818, 26904, 0, 0}, {16560, 10669, 7838, 0, 0},
           {16231, 8743, 5183, 0, 0},   {19988, 12387, 7901, 0, 0},
           {23001, 16156, 11352, 0, 0}, {25082, 19030, 14370, 0, 0},
           {26435, 21154, 16804, 0, 0}, {28827, 25197, 21932, 0, 0},
           {9949, 5346, 3566, 0, 0},    {10544, 4254, 2047, 0, 0},
           {15108, 7335, 3855, 0, 0},   {19194, 11286, 6766, 0, 0},
           {22139, 14791, 9830, 0, 0},  {24156, 17470, 12503, 0, 0},
           {27161, 22277, 18172, 0, 0}},
          {{19199, 12968, 9562, 0, 0},  {19640, 12844, 8899, 0, 0},
           {24439, 17927, 13365, 0, 0}, {26638, 21792, 17711, 0, 0},
           {28086, 23929, 20250, 0, 0}, {29112, 25359, 22180, 0, 0},
           {30191, 27669, 25356, 0, 0}, {10341, 4084, 2183, 0, 0},
           {11855, 5018, 2629, 0, 0},   {16928, 8659, 4934, 0, 0},
           {20460, 12739, 8199, 0, 0},  {22552, 15983, 11310, 0, 0},
           {24459, 18565, 13655, 0, 0}, {26725, 21600, 17461, 0, 0},
           {9602, 3867, 1770, 0, 0},    {10869, 4363, 2017, 0, 0},
           {14355, 6677, 3325, 0, 0},   {17535, 9654, 5416, 0, 0},
           {20085, 12296, 7480, 0, 0},  {22066, 14509, 9359, 0, 0},
           {24643, 18304, 13542, 0, 0}}},
         {{{23728, 17982, 14408, 0, 0}, {22789, 17050, 13353, 0, 0},
           {24855, 18850, 14457, 0, 0}, {26909, 21879, 17584, 0, 0},
           {28175, 24091, 20258, 0, 0}, {28948, 25372, 21977, 0, 0},
           {31038, 29297, 27576, 0, 0}, {20965, 14403, 10059, 0, 0},
           {21349, 14710, 10543, 0, 0}, {23350, 16994, 12525, 0, 0},
           {25229, 19443, 15111, 0, 0}, {26535, 21451, 17384, 0, 0},
           {27631, 23112, 19223, 0, 0}, {29791, 26994, 24419, 0, 0},
           {11561, 5522, 3128, 0, 0},   {13221, 6190, 3271, 0, 0},
           {16599, 8897, 5078, 0, 0},   {19948, 12310, 7750, 0, 0},
           {22544, 15436, 10554, 0, 0}, {24242, 17720, 12884, 0, 0},
           {27731, 23358, 19650, 0, 0}},
          {{20429, 15439, 12628, 0, 0}, {19263, 12873, 9543, 0, 0},
           {22921, 15824, 11204, 0, 0}, {25488, 19512, 14420, 0, 0},
           {28056, 22759, 18314, 0, 0}, {28407, 24854, 20291, 0, 0},
           {29898, 27140, 24773, 0, 0}, {12707, 7264, 4242, 0, 0},
           {17533, 9890, 6623, 0, 0},   {19783, 12810, 8613, 0, 0},
           {22986, 16127, 11365, 0, 0}, {23312, 16408, 12008, 0, 0},
           {25913, 19828, 14211, 0, 0}, {27107, 22204, 17766, 0, 0},
           {7112, 2166, 874, 0, 0},     {10198, 3661, 1676, 0, 0},
           {13851, 6345, 3227, 0, 0},   {16828, 9119, 5014, 0, 0},
           {19965, 12187, 7549, 0, 0},  {21686, 14073, 9392, 0, 0},
           {24829, 18395, 13763, 0, 0}}},
         {{{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}},
          {{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}}}},
        {{{{14453, 8479, 5217, 0, 0},   {15914, 8700, 4933, 0, 0},
           {22628, 14841, 9595, 0, 0},  {26046, 19786, 14501, 0, 0},
           {28107, 22942, 18062, 0, 0}, {28936, 24603, 20474, 0, 0},
           {29973, 26670, 23523, 0, 0}, {15623, 9442, 6096, 0, 0},
           {12035, 5088, 2460, 0, 0},   {16736, 8307, 4222, 0, 0},
           {21115, 12675, 7687, 0, 0},  {23478, 16339, 10682, 0, 0},
           {24972, 18170, 12786, 0, 0}, {26266, 20390, 15327, 0, 0},
           {11087, 5036, 2448, 0, 0},   {10379, 3724, 1507, 0, 0},
           {13741, 6037, 2681, 0, 0},   {18029, 9013, 4144, 0, 0},
           {21410, 11990, 7257, 0, 0},  {21773, 14695, 8578, 0, 0},
           {23606, 17778, 12151, 0, 0}},
          {{11343, 4816, 2380, 0, 0},   {14706, 6930, 3734, 0, 0},
           {20812, 12887, 7960, 0, 0},  {25050, 17768, 11788, 0, 0},
           {27066, 21514, 16625, 0, 0}, {27870, 23680, 15904, 0, 0},
           {29089, 25992, 20861, 0, 0}, {9474, 2608, 1105, 0, 0},
           {8371, 2872, 932, 0, 0},     {13523, 5640, 2175, 0, 0},
           {19566, 12943, 6364, 0, 0},  {21190, 13471, 8811, 0, 0},
           {24695, 19471, 11398, 0, 0}, {27307, 21845, 13023, 0, 0},
           {5401, 2247, 834, 0, 0},     {7864, 2097, 828, 0, 0},
           {9693, 4308, 1469, 0, 0},    {18368, 9110, 2351, 0, 0},
           {18883, 8886, 4443, 0, 0},   {18022, 9830, 4915, 0, 0},
           {27307, 16384, 5461, 0, 0}}},
         {{{14494, 7955, 4878, 0, 0},   {17231, 9619, 5765, 0, 0},
           {23319, 16028, 10941, 0, 0}, {26068, 20270, 15507, 0, 0},
           {27780, 22902, 18570, 0, 0}, {28532, 24621, 20866, 0, 0},
           {29901, 26908, 24114, 0, 0}, {15644, 9597, 6667, 0, 0},
           {12372, 5291, 2620, 0, 0},   {16195, 8139, 4276, 0, 0},
           {20019, 11922, 7094, 0, 0},  {22535, 14890, 9950, 0, 0},
           {24243, 17436, 12405, 0, 0}, {26485, 21136, 16513, 0, 0},
           {12302, 6257, 3482, 0, 0},   {9709, 3594, 1577, 0, 0},
           {13287, 5505, 2527, 0, 0},   {17310, 9137, 4631, 0, 0},
           {20352, 12160, 7075, 0, 0},  {22507, 14757, 9507, 0, 0},
           {24752, 18113, 13102, 0, 0}},
          {{15152, 8182, 4656, 0, 0},   {16959, 9469, 5613, 0, 0},
           {22001, 13878, 8975, 0, 0},  {25041, 18513, 13903, 0, 0},
           {26639, 20842, 15886, 0, 0}, {28286, 23064, 17907, 0, 0},
           {29491, 25316, 21246, 0, 0}, {9812, 4217, 2038, 0, 0},
           {10044, 3831, 1807, 0, 0},   {14301, 6444, 3188, 0, 0},
           {19534, 12055, 7119, 0, 0},  {21587, 15176, 10287, 0, 0},
           {24477, 14410, 8192, 0, 0},  {25200, 20887, 17784, 0, 0},
           {7820, 3767, 1621, 0, 0},    {7094, 2149, 617, 0, 0},
           {11927, 5975, 3165, 0, 0},   {18099, 8412, 4102, 0, 0},
           {21434, 9175, 4549, 0, 0},   {23846, 18006, 9895, 0, 0},
           {24467, 19224, 12233, 0, 0}}},
         {{{15655, 9035, 5687, 0, 0},   {18629, 11362, 7316, 0, 0},
           {24216, 17766, 12992, 0, 0}, {26897, 21648, 17390, 0, 0},
           {28313, 24152, 20515, 0, 0}, {29299, 25858, 22382, 0, 0},
           {30513, 28215, 25986, 0, 0}, {14544, 8392, 5715, 0, 0},
           {13478, 6058, 3154, 0, 0},   {17832, 9777, 5584, 0, 0},
           {21530, 13817, 9006, 0, 0},  {23982, 17151, 12180, 0, 0},
           {25451, 19540, 14765, 0, 0}, {27667, 23256, 19275, 0, 0},
           {10129, 4546, 2558, 0, 0},   {9552, 3437, 1461, 0, 0},
           {13693, 6006, 2873, 0, 0},   {17754, 9655, 5311, 0, 0},
           {20830, 12911, 8016, 0, 0},  {22826, 15488, 10486, 0, 0},
           {25601, 19624, 15016, 0, 0}},
          {{16948, 10030, 6280, 0, 0},  {19238, 11883, 7552, 0, 0},
           {24373, 17238, 12316, 0, 0}, {26194, 20447, 16388, 0, 0},
           {27415, 22349, 18200, 0, 0}, {28155, 24322, 20387, 0, 0},
           {29328, 25610, 22865, 0, 0}, {8521, 3717, 1544, 0, 0},
           {10650, 4710, 2399, 0, 0},   {16270, 8000, 4379, 0, 0},
           {19848, 11593, 6631, 0, 0},  {22038, 14149, 7416, 0, 0},
           {22581, 16489, 9977, 0, 0},  {23458, 18137, 10641, 0, 0},
           {7798, 2210, 711, 0, 0},     {7967, 2826, 1070, 0, 0},
           {10336, 4315, 1913, 0, 0},   {13714, 7088, 3188, 0, 0},
           {18376, 9732, 4659, 0, 0},   {20273, 11821, 6118, 0, 0},
           {20326, 12442, 6554, 0, 0}}},
         {{{20606, 13983, 10120, 0, 0}, {20019, 13071, 8962, 0, 0},
           {24188, 17471, 12422, 0, 0}, {26599, 21019, 16225, 0, 0},
           {27932, 23377, 19320, 0, 0}, {28947, 25057, 21155, 0, 0},
           {30540, 28167, 25698, 0, 0}, {16449, 8043, 4488, 0, 0},
           {17070, 9491, 5600, 0, 0},   {20042, 12400, 7721, 0, 0},
           {22856, 15753, 10792, 0, 0}, {24880, 18548, 13589, 0, 0},
           {25991, 20484, 15750, 0, 0}, {28276, 24178, 20516, 0, 0},
           {9519, 3864, 1821, 0, 0},    {11718, 4860, 2256, 0, 0},
           {15328, 7428, 3819, 0, 0},   {18709, 10750, 6227, 0, 0},
           {21480, 13865, 8870, 0, 0},  {23357, 16426, 11340, 0, 0},
           {26490, 21180, 16824, 0, 0}},
          {{18787, 12701, 9542, 0, 0},  {15846, 9188, 5985, 0, 0},
           {21763, 13729, 8281, 0, 0},  {25379, 18550, 12970, 0, 0},
           {27170, 21263, 15562, 0, 0}, {26678, 21555, 17109, 0, 0},
           {28948, 25397, 22649, 0, 0}, {11686, 5843, 3093, 0, 0},
           {11506, 4141, 1640, 0, 0},   {14376, 6314, 2331, 0, 0},
           {17898, 9858, 5672, 0, 0},   {20148, 13284, 7860, 0, 0},
           {23478, 16215, 9966, 0, 0},  {26100, 18480, 12764, 0, 0},
           {5064, 1713, 819, 0, 0},     {8059, 2790, 980, 0, 0},
           {11100, 3504, 1111, 0, 0},   {14473, 5800, 2694, 0, 0},
           {16369, 8346, 3455, 0, 0},   {18421, 9742, 4664, 0, 0},
           {20398, 12962, 8291, 0, 0}}},
         {{{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}},
          {{24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}, {24576, 16384, 8192, 0, 0},
           {24576, 16384, 8192, 0, 0}}}}};

/* clang-format off */
constexpr uint16_t kDefaultDcSignCdf[kCoefficientQuantizerContexts][kNumPlaneTypes]
                                [kDcSignContexts][kBooleanFieldCdfSize] = {
  {{{16768, 0, 0}, {19712, 0, 0}, {13952, 0, 0}}, {{17536, 0, 0}, {19840, 0, 0},
    {15488, 0, 0}}},
  {{{16768, 0, 0}, {19712, 0, 0}, {13952, 0, 0}}, {{17536, 0, 0}, {19840, 0, 0},
    {15488, 0, 0}}},
  {{{16768, 0, 0}, {19712, 0, 0}, {13952, 0, 0}}, {{17536, 0, 0}, {19840, 0, 0},
    {15488, 0, 0}}},
  {{{16768, 0, 0}, {19712, 0, 0}, {13952, 0, 0}}, {{17536, 0, 0}, {19840, 0, 0},
    {15488, 0, 0}}}
};
/* clang-format on */
constexpr uint16_t kDefaultRestorationTypeCdf[kCoeffBaseRangeSymbolCount + 1] =
    {23355, 10187, 0, 0};

constexpr uint16_t kDefaultUseWienerCdf[kBooleanFieldCdfSize] = {21198, 0, 0};

constexpr uint16_t kDefaultUseSgrProjCdf[kBooleanFieldCdfSize] = {15913, 0, 0};

constexpr uint16_t
    kDefaultHasPaletteYCdf[kPaletteBlockSizeContexts][kPaletteYModeContexts]
                          [kBooleanFieldCdfSize] = {
                              {{1092, 0, 0}, {29349, 0, 0}, {31507, 0, 0}},
                              {{856, 0, 0}, {29909, 0, 0}, {31788, 0, 0}},
                              {{945, 0, 0}, {29368, 0, 0}, {31987, 0, 0}},
                              {{738, 0, 0}, {29207, 0, 0}, {31864, 0, 0}},
                              {{459, 0, 0}, {25431, 0, 0}, {31306, 0, 0}},
                              {{503, 0, 0}, {28753, 0, 0}, {31247, 0, 0}},
                              {{318, 0, 0}, {24822, 0, 0}, {32639, 0, 0}}};

constexpr uint16_t
    kDefaultPaletteYSizeCdf[kPaletteBlockSizeContexts]
                           [kPaletteSizeSymbolCount + 1] = {
                               {24816, 19768, 14619, 11290, 7241, 3527, 0, 0},
                               {25629, 21347, 16573, 13224, 9102, 4695, 0, 0},
                               {24980, 20027, 15443, 12268, 8453, 4238, 0, 0},
                               {24497, 18704, 14522, 11204, 7697, 4235, 0, 0},
                               {20043, 13588, 10905, 7929, 5233, 2648, 0, 0},
                               {23057, 17880, 15845, 11716, 7107, 4893, 0, 0},
                               {17828, 11971, 11090, 8582, 5735, 3769, 0, 0}};

constexpr uint16_t kDefaultHasPaletteUVCdf[kPaletteUVModeContexts]
                                          [kBooleanFieldCdfSize] = {
                                              {307, 0, 0}, {11280, 0, 0}};

constexpr uint16_t
    kDefaultPaletteUVSizeCdf[kPaletteBlockSizeContexts]
                            [kPaletteSizeSymbolCount + 1] = {
                                {24055, 12789, 5640, 3159, 1437, 496, 0, 0},
                                {26929, 17195, 9187, 5821, 2920, 1068, 0, 0},
                                {28342, 21508, 14769, 11285, 6905, 3338, 0, 0},
                                {29540, 23304, 17775, 14679, 10245, 5348, 0, 0},
                                {29000, 23882, 19677, 14916, 10273, 5561, 0, 0},
                                {30304, 24317, 19907, 11136, 7243, 4213, 0, 0},
                                {31499, 27333, 22335, 13805, 11068, 6903, 0,
                                 0}};

constexpr uint16_t kDefaultPaletteColorIndexCdf
    [kNumPlaneTypes][kPaletteSizeSymbolCount][kPaletteColorIndexContexts]
    [kPaletteColorIndexSymbolCount + 1] = {
        {{{4058, 0, 0},
          {16384, 0, 0},
          {22215, 0, 0},
          {5732, 0, 0},
          {1165, 0, 0}},
         {{4891, 2278, 0, 0},
          {21236, 7071, 0, 0},
          {26224, 2534, 0, 0},
          {9750, 4696, 0, 0},
          {853, 383, 0, 0}},
         {{7196, 4722, 2723, 0, 0},
          {23290, 11178, 5512, 0, 0},
          {25520, 5931, 2944, 0, 0},
          {13601, 8282, 4419, 0, 0},
          {1368, 943, 518, 0, 0}},
         {{7989, 5813, 4192, 2486, 0, 0},
          {24099, 12404, 8695, 4675, 0, 0},
          {28513, 5203, 3391, 1701, 0, 0},
          {12904, 9094, 6052, 3238, 0, 0},
          {1122, 875, 621, 342, 0, 0}},
         {{9636, 7361, 5798, 4333, 2695, 0, 0},
          {25325, 15526, 12051, 8006, 4786, 0, 0},
          {26468, 7906, 5824, 3984, 2097, 0, 0},
          {13852, 9873, 7501, 5333, 3116, 0, 0},
          {1498, 1218, 960, 709, 415, 0, 0}},
         {{9663, 7569, 6304, 5084, 3837, 2450, 0, 0},
          {25818, 17321, 13816, 10087, 7201, 4205, 0, 0},
          {25208, 9294, 7278, 5565, 3847, 2060, 0, 0},
          {14224, 10395, 8311, 6573, 4649, 2723, 0, 0},
          {1570, 1317, 1098, 886, 645, 377, 0, 0}},
         {{11079, 8885, 7605, 6416, 5262, 3941, 2573, 0, 0},
          {25876, 17383, 14928, 11162, 8481, 6015, 3564, 0, 0},
          {27117, 9586, 7726, 6250, 4786, 3376, 1868, 0, 0},
          {13419, 10190, 8350, 6774, 5244, 3737, 2320, 0, 0},
          {1740, 1498, 1264, 1063, 841, 615, 376, 0, 0}}},
        {{{3679, 0, 0},
          {16384, 0, 0},
          {24055, 0, 0},
          {3511, 0, 0},
          {1158, 0, 0}},
         {{7511, 3623, 0, 0},
          {20481, 5475, 0, 0},
          {25735, 4808, 0, 0},
          {12623, 7363, 0, 0},
          {2160, 1129, 0, 0}},
         {{8558, 5593, 2865, 0, 0},
          {22880, 10382, 5554, 0, 0},
          {26867, 6715, 3475, 0, 0},
          {14450, 10616, 4435, 0, 0},
          {2309, 1632, 842, 0, 0}},
         {{9788, 7289, 4987, 2782, 0, 0},
          {24355, 11360, 7909, 3894, 0, 0},
          {30511, 3319, 2174, 1170, 0, 0},
          {13579, 11566, 6853, 4148, 0, 0},
          {924, 724, 487, 250, 0, 0}},
         {{10551, 8201, 6131, 4085, 2220, 0, 0},
          {25461, 16362, 13132, 8136, 4344, 0, 0},
          {28327, 7704, 5889, 3826, 1849, 0, 0},
          {15558, 12240, 9449, 6018, 3186, 0, 0},
          {2094, 1815, 1372, 1033, 561, 0, 0}},
         {{11529, 9600, 7724, 5806, 4063, 2262, 0, 0},
          {26223, 17756, 14764, 10951, 7265, 4067, 0, 0},
          {29320, 6473, 5331, 4064, 2642, 1326, 0, 0},
          {16879, 14445, 11064, 8070, 5792, 3078, 0, 0},
          {1780, 1564, 1289, 1034, 785, 443, 0, 0}},
         {{11326, 9480, 8010, 6522, 5119, 3788, 2205, 0, 0},
          {26905, 17835, 15216, 12100, 9085, 6357, 3495, 0, 0},
          {29353, 6958, 5891, 4778, 3545, 2374, 1150, 0, 0},
          {14803, 12684, 10536, 8794, 6494, 4366, 2378, 0, 0},
          {1578, 1439, 1252, 1089, 943, 742, 446, 0, 0}}}};

constexpr uint16_t kDefaultIsInterCdf[kIsInterContexts][kBooleanFieldCdfSize] =
    {{31962, 0, 0}, {16106, 0, 0}, {12582, 0, 0}, {6230, 0, 0}};

constexpr uint16_t
    kDefaultUseCompoundReferenceCdf[kUseCompoundReferenceContexts]
                                   [kBooleanFieldCdfSize] = {{5940, 0, 0},
                                                             {8733, 0, 0},
                                                             {20737, 0, 0},
                                                             {22128, 0, 0},
                                                             {29867, 0, 0}};

constexpr uint16_t
    kDefaultCompoundReferenceTypeCdf[kCompoundReferenceTypeContexts]
                                    [kBooleanFieldCdfSize] = {{31570, 0, 0},
                                                              {30698, 0, 0},
                                                              {23602, 0, 0},
                                                              {25269, 0, 0},
                                                              {10293, 0, 0}};

constexpr uint16_t kDefaultCompoundReferenceCdf
    [kNumCompoundReferenceTypes][kReferenceContexts][3][kBooleanFieldCdfSize] =
        {{{{27484, 0, 0}, {28903, 0, 0}, {29640, 0, 0}},
          {{9616, 0, 0}, {18595, 0, 0}, {17498, 0, 0}},
          {{994, 0, 0}, {7648, 0, 0}, {6058, 0, 0}}},
         {{{27822, 0, 0}, {23300, 0, 0}, {31265, 0, 0}},
          {{12877, 0, 0}, {10327, 0, 0}, {17608, 0, 0}},
          {{2037, 0, 0}, {1709, 0, 0}, {5224, 0, 0}}}};

constexpr uint16_t
    kDefaultCompoundBackwardReferenceCdf[kReferenceContexts][2]
                                        [kBooleanFieldCdfSize] = {
                                            {{30533, 0, 0}, {31345, 0, 0}},
                                            {{15586, 0, 0}, {17593, 0, 0}},
                                            {{2162, 0, 0}, {2279, 0, 0}}};

/* clang-format off */
constexpr uint16_t kDefaultSingleReferenceCdf[kReferenceContexts][6]
                                         [kBooleanFieldCdfSize] = {
  {{27871, 0, 0}, {31213, 0, 0}, {28532, 0, 0}, {24118, 0, 0}, {31864, 0, 0},
   {31324, 0, 0}},
  {{15795, 0, 0}, {16017, 0, 0}, {13121, 0, 0}, {7995, 0, 0}, {21754, 0, 0},
   {17681, 0, 0}},
  {{3024, 0, 0}, {2489, 0, 0}, {1574, 0, 0}, {873, 0, 0}, {5893, 0, 0},
   {2464, 0, 0}}};
/* clang-format on */

constexpr uint16_t kDefaultCompoundPredictionModeCdf
    [kCompoundPredictionModeContexts][kNumCompoundInterPredictionModes + 1] = {
        {25008, 18945, 16960, 15127, 13612, 12102, 5877, 0, 0},
        {22038, 13316, 11623, 10019, 8729, 7637, 4044, 0, 0},
        {22104, 12547, 11180, 9862, 8473, 7381, 4332, 0, 0},
        {19470, 15784, 12297, 8586, 7701, 7032, 6346, 0, 0},
        {13864, 9443, 7526, 5336, 4870, 4510, 2010, 0, 0},
        {22043, 15314, 12644, 9948, 8573, 7600, 6722, 0, 0},
        {15643, 8495, 6954, 5276, 4554, 4064, 2176, 0, 0},
        {19722, 9554, 8263, 6826, 5333, 4326, 3438, 0, 0}};

constexpr uint16_t kDefaultNewMvCdf[kNewMvContexts][kBooleanFieldCdfSize] = {
    {8733, 0, 0},  {16138, 0, 0}, {17429, 0, 0},
    {24382, 0, 0}, {20546, 0, 0}, {28092, 0, 0}};

constexpr uint16_t kDefaultZeroMvCdf[kZeroMvContexts][kBooleanFieldCdfSize] = {
    {30593, 0, 0}, {31714, 0, 0}};

constexpr uint16_t
    kDefaultReferenceMvCdf[kReferenceMvContexts][kBooleanFieldCdfSize] = {
        {8794, 0, 0}, {8580, 0, 0}, {14920, 0, 0},
        {4146, 0, 0}, {8456, 0, 0}, {12845, 0, 0}};

// This is called drl_mode in the spec where DRL stands for Dynamic Reference
// List.
constexpr uint16_t
    kDefaultRefMvIndexCdf[kRefMvIndexContexts][kBooleanFieldCdfSize] = {
        {19664, 0, 0}, {8208, 0, 0}, {13823, 0, 0}};

constexpr uint16_t
    kDefaultIsInterIntraCdf[kInterIntraContexts][kBooleanFieldCdfSize] = {
        {5881, 0, 0}, {5171, 0, 0}, {2531, 0, 0}};

constexpr uint16_t kDefaultInterIntraModeCdf[kInterIntraContexts]
                                            [kNumInterIntraModes + 1] = {
                                                {30893, 21686, 5436, 0, 0},
                                                {30295, 22772, 6380, 0, 0},
                                                {28530, 21231, 6842, 0, 0}};

constexpr uint16_t
    kDefaultIsWedgeInterIntraCdf[kMaxBlockSizes][kBooleanFieldCdfSize] = {
        {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
        {12732, 0, 0}, {7811, 0, 0},  {16384, 0, 0}, {16384, 0, 0},
        {6064, 0, 0},  {5238, 0, 0},  {3204, 0, 0},  {16384, 0, 0},
        {16384, 0, 0}, {3324, 0, 0},  {5896, 0, 0},  {16384, 0, 0},
        {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
        {16384, 0, 0}, {16384, 0, 0}};

constexpr uint16_t
    kDefaultWedgeIndexCdf[kMaxBlockSizes][kWedgeIndexSymbolCount + 1] = {
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {30330, 28328, 26169, 24105, 21763, 19894, 17017, 14674, 12409, 10406,
         8641, 7066, 5016, 3318, 1597, 0, 0},
        {31962, 29502, 26763, 26030, 25550, 25401, 24997, 18180, 16445, 15401,
         14316, 13346, 9929, 6641, 3139, 0, 0},
        {32614, 31781, 30843, 30717, 30680, 30657, 30617, 9735, 9065, 8484,
         7783, 7084, 5509, 3885, 1857, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {29989, 29030, 28085, 25555, 24993, 24751, 24113, 18411, 14829, 11436,
         8248, 5298, 3312, 2239, 1112, 0, 0},
        {31084, 29143, 27093, 25660, 23466, 21494, 18339, 15624, 13605, 11807,
         9884, 8297, 6049, 4054, 1891, 0, 0},
        {31626, 29277, 26491, 25454, 24679, 24413, 23745, 19144, 17399, 16038,
         14654, 13455, 10247, 6756, 3218, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {31633, 31446, 31275, 30133, 30072, 30031, 29998, 11752, 9833, 7711,
         5517, 3595, 2679, 1808, 835, 0, 0},
        {30026, 28573, 27041, 24733, 23788, 23432, 22622, 18644, 15498, 12235,
         9334, 6796, 4824, 3198, 1352, 0, 0},
        {31041, 28820, 26667, 24972, 22927, 20424, 17002, 13824, 12130, 10730,
         8805, 7457, 5780, 4002, 1756, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0},
        {30720, 28672, 26624, 24576, 22528, 20480, 18432, 16384, 14336, 12288,
         10240, 8192, 6144, 4096, 2048, 0, 0}};

constexpr uint16_t kDefaultUseObmcCdf[kMaxBlockSizes][kBooleanFieldCdfSize] = {
    {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {22331, 0, 0},
    {23397, 0, 0}, {9104, 0, 0},  {16384, 0, 0}, {23467, 0, 0}, {15336, 0, 0},
    {18345, 0, 0}, {8760, 0, 0},  {11867, 0, 0}, {17626, 0, 0}, {6951, 0, 0},
    {9945, 0, 0},  {5889, 0, 0},  {10685, 0, 0}, {2640, 0, 0},  {1754, 0, 0},
    {1208, 0, 0},  {130, 0, 0}};

constexpr uint16_t kDefaultMotionModeCdf[kMaxBlockSizes][kNumMotionModes + 1] =
    {{21845, 10923, 0, 0}, {21845, 10923, 0, 0}, {21845, 10923, 0, 0},
     {21845, 10923, 0, 0}, {25117, 8008, 0, 0},  {28030, 8003, 0, 0},
     {3969, 1378, 0, 0},   {21845, 10923, 0, 0}, {27377, 7240, 0, 0},
     {13349, 5958, 0, 0},  {27645, 9162, 0, 0},  {3795, 1174, 0, 0},
     {6337, 1994, 0, 0},   {21162, 8460, 0, 0},  {6508, 3652, 0, 0},
     {12408, 4706, 0, 0},  {3026, 1565, 0, 0},   {11089, 5938, 0, 0},
     {3252, 2067, 0, 0},   {3870, 2371, 0, 0},   {1890, 1433, 0, 0},
     {261, 210, 0, 0}};

constexpr uint16_t
    kDefaultIsExplicitCompoundTypeCdf[kIsExplicitCompoundTypeContexts]
                                     [kBooleanFieldCdfSize] = {
                                         {6161, 0, 0},  {9877, 0, 0},
                                         {13928, 0, 0}, {8174, 0, 0},
                                         {12834, 0, 0}, {10094, 0, 0}};

constexpr uint16_t
    kDefaultIsCompoundTypeAverageCdf[kIsCompoundTypeAverageContexts]
                                    [kBooleanFieldCdfSize] = {
                                        {14524, 0, 0}, {19903, 0, 0},
                                        {25715, 0, 0}, {19509, 0, 0},
                                        {23434, 0, 0}, {28124, 0, 0}};

constexpr uint16_t kDefaultCompoundTypeCdf
    [kMaxBlockSizes][kNumExplicitCompoundPredictionTypes + 1] = {
        {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
        {9337, 0, 0},  {19597, 0, 0}, {20948, 0, 0}, {16384, 0, 0},
        {21298, 0, 0}, {22998, 0, 0}, {23668, 0, 0}, {16384, 0, 0},
        {25067, 0, 0}, {24535, 0, 0}, {26596, 0, 0}, {16384, 0, 0},
        {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0}, {16384, 0, 0},
        {16384, 0, 0}, {16384, 0, 0}};

constexpr uint16_t kDefaultInterpolationFilterCdf
    [kInterpolationFilterContexts][kNumExplicitInterpolationFilters + 1] = {
        {833, 48, 0, 0},      {27200, 49, 0, 0},    {32346, 29830, 0, 0},
        {4524, 160, 0, 0},    {1562, 815, 0, 0},    {27906, 647, 0, 0},
        {31998, 31616, 0, 0}, {11879, 7131, 0, 0},  {858, 44, 0, 0},
        {28648, 56, 0, 0},    {32463, 30521, 0, 0}, {5365, 132, 0, 0},
        {1746, 759, 0, 0},    {29805, 675, 0, 0},   {32167, 31825, 0, 0},
        {17799, 11370, 0, 0}};

constexpr uint16_t kDefaultMvJointCdf[kNumMvJointTypes + 1] = {28672, 21504,
                                                               13440, 0, 0};

constexpr uint16_t kDefaultMvSignCdf[kBooleanFieldCdfSize] = {16384, 0, 0};

constexpr uint16_t kDefaultMvClassCdf[kMvClassSymbolCount + 1] = {
    4096, 1792, 910, 448, 217, 112, 28, 11, 6, 1, 0};

constexpr uint16_t kDefaultMvClass0BitCdf[kBooleanFieldCdfSize] = {5120, 0, 0};

constexpr uint16_t kDefaultMvClass0FractionCdf[kBooleanSymbolCount]
                                              [kMvFractionSymbolCount + 1] = {
                                                  {16384, 8192, 6144, 0, 0},
                                                  {20480, 11520, 8640, 0, 0}};

constexpr uint16_t kDefaultMvClass0HighPrecisionCdf[kBooleanFieldCdfSize] = {
    12288, 0, 0};

constexpr uint16_t kDefaultMvBitCdf[kMvBitSymbolCount][kBooleanFieldCdfSize] = {
    {15360, 0, 0}, {14848, 0, 0}, {13824, 0, 0}, {12288, 0, 0}, {10240, 0, 0},
    {8192, 0, 0},  {4096, 0, 0},  {2816, 0, 0},  {2816, 0, 0},  {2048, 0, 0}};

constexpr uint16_t kDefaultMvFractionCdf[kMvFractionSymbolCount + 1] = {
    24576, 15360, 11520, 0, 0};

constexpr uint16_t kDefaultMvHighPrecisionCdf[kBooleanFieldCdfSize] = {16384, 0,
                                                                       0};
