/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;

class LineNumberCheck
implements NodeTraversal.Callback,
CompilerPass {
    static final DiagnosticType MISSING_LINE_INFO = DiagnosticType.error("JSC_MISSING_LINE_INFO", "No source location information associated with {0}.\nMost likely a Node has been created without setting the source file and line/column location.  Usually this is done using Node.useSourceInfoIfMissingFrom and supplying a Node from the source AST.");
    private static final DiagnosticType MISSING_LENGTH = DiagnosticType.error("JSC_MISSING_LENGTH", "Negative length associated with {0}.\nMost likely a Node's source information was set incorrectly at parse time.");
    private final AbstractCompiler compiler;
    private boolean requiresLineNumbers = false;

    LineNumberCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    public void setCheckSubTree(Node root) {
        this.requiresLineNumbers = true;
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void process(Node externs, Node root) {
        this.requiresLineNumbers = false;
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal unused, Node n, Node parent) {
        if (n.isScript()) {
            this.requiresLineNumbers = true;
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal unused, Node n, Node parent) {
        if (n.isScript()) {
            this.requiresLineNumbers = false;
        } else if (this.requiresLineNumbers) {
            if (n.getLineno() == -1) {
                this.compiler.report(JSError.make(n, MISSING_LINE_INFO, n.toStringTree()));
            } else if (n.getLength() < 0) {
                this.compiler.report(JSError.make(n, MISSING_LENGTH, n.toStringTree()));
            }
        }
    }
}

