/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi.conditions.evaluator.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.metrics.MetricAdapter;
import org.apache.unomi.metrics.MetricsService;
import org.apache.unomi.persistence.spi.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.spi.conditions.evaluator.ConditionEvaluator;
import org.apache.unomi.persistence.spi.conditions.evaluator.ConditionEvaluatorDispatcher;
import org.apache.unomi.scripting.ScriptExecutor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConditionEvaluatorDispatcher.class})
public class ConditionEvaluatorDispatcherImpl
implements ConditionEvaluatorDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConditionEvaluatorDispatcherImpl.class.getName());
    private Map<String, ConditionEvaluator> evaluators = new ConcurrentHashMap<String, ConditionEvaluator>();
    private MetricsService metricsService;
    private ScriptExecutor scriptExecutor;

    @Reference
    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    @Reference
    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    @Reference(service=ConditionEvaluator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindEvaluator(ConditionEvaluator evaluator, Map<String, Object> props) {
        this.evaluators.put((String)props.get("conditionEvaluatorId"), evaluator);
    }

    public void unbindEvaluator(ConditionEvaluator evaluator, Map<String, Object> props) {
        this.evaluators.remove((String)props.get("conditionEvaluatorId"));
    }

    @Override
    public boolean eval(Condition condition, Item item) {
        return this.eval(condition, item, new HashMap<String, Object>());
    }

    @Override
    public boolean eval(final Condition condition, final Item item, final Map<String, Object> context) {
        String conditionEvaluatorKey = condition.getConditionType().getConditionEvaluator();
        if (condition.getConditionType().getParentCondition() != null) {
            context.putAll(condition.getParameterValues());
            return this.eval(condition.getConditionType().getParentCondition(), item, context);
        }
        if (conditionEvaluatorKey == null) {
            throw new UnsupportedOperationException("No evaluator defined for : " + condition.getConditionTypeId());
        }
        if (this.evaluators.containsKey(conditionEvaluatorKey)) {
            final ConditionEvaluator evaluator = this.evaluators.get(conditionEvaluatorKey);
            final ConditionEvaluatorDispatcherImpl dispatcher = this;
            try {
                return (Boolean)new MetricAdapter<Boolean>(this.metricsService, this.getClass().getName() + ".conditions." + conditionEvaluatorKey){

                    public Boolean execute(Object ... args) throws Exception {
                        Condition contextualCondition = ConditionContextHelper.getContextualCondition(condition, context, ConditionEvaluatorDispatcherImpl.this.scriptExecutor);
                        if (contextualCondition != null) {
                            return evaluator.eval(contextualCondition, item, context, dispatcher);
                        }
                        return true;
                    }
                }.runWithTimer(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error executing condition evaluator with key={}", (Object)conditionEvaluatorKey, (Object)e);
            }
        }
        return false;
    }
}

