/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.healthcheck;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.unomi.healthcheck.HealthCheckConfig;
import org.apache.unomi.healthcheck.HealthCheckProvider;
import org.apache.unomi.healthcheck.HealthCheckResponse;
import org.apache.unomi.healthcheck.servlet.HealthCheckHttpContext;
import org.apache.unomi.healthcheck.servlet.HealthCheckServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheckService.class}, immediate=true)
public class HealthCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HealthCheckService.class.getName());
    private final List<HealthCheckProvider> providers = new ArrayList<HealthCheckProvider>();
    private ExecutorService executor;
    private boolean busy = false;
    private boolean registered = false;
    @Reference
    protected HttpService httpService;
    private HealthCheckConfig config;

    public HealthCheckService() {
        LOGGER.info("Building healthcheck service...");
    }

    @Activate
    public void activate() throws ServletException, NamespaceException {
        LOGGER.info("Activating healthcheck service...");
        this.executor = Executors.newSingleThreadExecutor();
        if (!this.registered) {
            this.setConfig(this.config);
        }
    }

    @Reference(service=HealthCheckConfig.class, policy=ReferencePolicy.DYNAMIC, updated="setConfig")
    private void setConfig(HealthCheckConfig config) throws ServletException, NamespaceException {
        this.config = config;
        if (this.httpService == null) {
            LOGGER.info("Healthcheck config with {} entrie(s) did not update the service as not fully started yet.", (Object)config.getSize());
            return;
        }
        if (config.isEnabled()) {
            LOGGER.info("Updating healthcheck service...");
            if (this.registered) {
                this.httpService.unregister("/health/check");
                this.registered = false;
            }
            this.httpService.registerServlet("/health/check", (Servlet)new HealthCheckServlet(this), null, (HttpContext)new HealthCheckHttpContext(config.get("authentication.realm")));
            this.registered = true;
        } else {
            this.httpService.unregister("/health/check");
            this.registered = false;
            LOGGER.info("Healthcheck service is disabled");
        }
    }

    private void unsetConfig(HealthCheckConfig config) {
        this.config = null;
    }

    @Deactivate
    public void deactivate() {
        LOGGER.info("Deactivating healthcheck service...");
        if (this.registered) {
            this.httpService.unregister("/health/check");
            this.registered = false;
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Reference(service=HealthCheckProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unbind")
    protected void bind(HealthCheckProvider provider) {
        LOGGER.info("Binding provider {}", (Object)provider.name());
        this.providers.add(provider);
    }

    protected void unbind(HealthCheckProvider provider) {
        LOGGER.info("Unbinding provider {}", (Object)provider.name());
        this.providers.remove(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HealthCheckResponse> check() throws RejectedExecutionException {
        if (this.config != null && this.config.isEnabled()) {
            LOGGER.debug("Health check called");
            if (this.busy) {
                throw new RejectedExecutionException("Health check already in progress");
            }
            try {
                this.busy = true;
                ArrayList<HealthCheckResponse> health = new ArrayList<HealthCheckResponse>();
                health.add(HealthCheckResponse.live("karaf"));
                for (HealthCheckProvider provider : this.providers.stream().filter(p -> this.config.getEnabledProviders().contains(p.name())).collect(Collectors.toList())) {
                    Future<HealthCheckResponse> future = this.executor.submit(provider::execute);
                    try {
                        HealthCheckResponse response = future.get(this.config.getTimeout(), TimeUnit.MILLISECONDS);
                        health.add(response);
                    }
                    catch (TimeoutException e) {
                        future.cancel(true);
                        health.add(provider.timeout());
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while executing health check", (Throwable)e);
                    }
                }
                ArrayList<HealthCheckResponse> arrayList = health;
                return arrayList;
            }
            finally {
                this.busy = false;
            }
        }
        LOGGER.info("Healthcheck service is disabled");
        return Collections.emptyList();
    }
}

