/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jstl.fn;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.myfaces.util.lang.StringUtils;

public final class JstlFunction {
    private JstlFunction() {
    }

    public static boolean contains(String name, String searchString) {
        if (name == null || searchString == null) {
            return false;
        }
        return -1 != name.indexOf(searchString);
    }

    public static boolean containsIgnoreCase(String name, String searchString) {
        if (name == null || searchString == null) {
            return false;
        }
        return -1 != name.toUpperCase().indexOf(searchString.toUpperCase());
    }

    public static boolean endsWith(String name, String searchString) {
        if (name == null || searchString == null) {
            return false;
        }
        return name.endsWith(searchString);
    }

    public static String escapeXml(String value) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            String app = null;
            char c = value.charAt(i);
            if (c < 'A') {
                switch (c) {
                    case '<': {
                        app = "&lt;";
                        break;
                    }
                    case '>': {
                        app = "&gt;";
                        break;
                    }
                    case '\'': {
                        app = "&#039;";
                        break;
                    }
                    case '\"': {
                        app = "&#034;";
                        break;
                    }
                    case '&': {
                        if (i + 4 < value.length()) {
                            if ('a' == value.charAt(i + 1) && 'm' == value.charAt(i + 2) && 'p' == value.charAt(i + 3) && ';' == value.charAt(i + 4)) break;
                            app = "&amp;";
                            break;
                        }
                        app = "&amp;";
                        break;
                    }
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuilder(value.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return value;
        }
        return sb.toString();
    }

    public static int indexOf(String name, String searchString) {
        if (name == null || searchString == null) {
            return -1;
        }
        return name.indexOf(searchString);
    }

    public static String join(String[] a, String delim) {
        if (a == null || delim == null) {
            return "";
        }
        if (a.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(a.length * (a[0].length() + delim.length()));
        for (int i = 0; i < a.length; ++i) {
            sb.append(a[i]);
            if (i >= a.length - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        throw new IllegalArgumentException("Object type not supported: " + obj.getClass().getName());
    }

    public static String replace(String value, String a, String b) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        if (StringUtils.isEmpty(a)) {
            return value;
        }
        if (b == null) {
            b = "";
        }
        return value.replaceAll(a, b);
    }

    public static String[] split(String value, String d) {
        if (StringUtils.isEmpty(value)) {
            return new String[]{""};
        }
        if (StringUtils.isEmpty(d)) {
            return new String[]{value};
        }
        StringTokenizer st = new StringTokenizer(value, d);
        int numTokens = st.countTokens();
        if (numTokens == 0) {
            return new String[]{value};
        }
        String[] array = new String[numTokens];
        int i = 0;
        while (st.hasMoreTokens()) {
            array[i] = st.nextToken();
            ++i;
        }
        return array;
    }

    public static boolean startsWith(String value, String p) {
        if (value == null || p == null) {
            return false;
        }
        return value.startsWith(p);
    }

    public static String substring(String v, int s, int e) {
        if (StringUtils.isEmpty(v)) {
            return "";
        }
        if (s >= v.length()) {
            return "";
        }
        if (s < 0) {
            s = 0;
        }
        if (e >= v.length()) {
            e = v.length();
        }
        if (e < s) {
            return "";
        }
        return v.substring(s, e);
    }

    public static String substringAfter(String v, String p) {
        if (StringUtils.isEmpty(v)) {
            return "";
        }
        int i = v.indexOf(p);
        if (i >= 0) {
            return v.substring(i + p.length());
        }
        return "";
    }

    public static String substringBefore(String v, String s) {
        if (StringUtils.isEmpty(v)) {
            return "";
        }
        int i = v.indexOf(s);
        if (i > 0) {
            return v.substring(0, i);
        }
        return "";
    }

    public static String toLowerCase(String v) {
        if (StringUtils.isEmpty(v)) {
            return "";
        }
        return v.toLowerCase();
    }

    public static String toUpperCase(String v) {
        if (StringUtils.isEmpty(v)) {
            return "";
        }
        return v.toUpperCase();
    }

    public static String trim(String v) {
        if (StringUtils.isEmpty(v)) {
            return "";
        }
        return v.trim();
    }
}

