/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.serializer;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.lang.reflect.Type;
import org.apache.johnzon.mapper.MappingParser;

public class JohnzonDeserializationContext
implements DeserializationContext {
    private final MappingParser runtime;
    private final JsonBuilderFactory builderFactory;
    private final JsonProvider jsonp;

    public JohnzonDeserializationContext(MappingParser runtime, JsonBuilderFactory builderFactory, JsonProvider jsonp) {
        this.runtime = runtime;
        this.builderFactory = builderFactory;
        this.jsonp = jsonp;
    }

    public <T> T deserialize(Class<T> clazz, JsonParser parser) {
        return (T)this.runtime.readObject(this.read(parser), clazz);
    }

    public <T> T deserialize(Type type, JsonParser parser) {
        return (T)this.runtime.readObject(this.read(parser), type);
    }

    private JsonValue read(JsonParser parser) {
        JsonParser.Event next = parser.next();
        switch (next) {
            case START_OBJECT: {
                JsonObjectBuilder objectBuilder = this.builderFactory.createObjectBuilder();
                this.parseObject(null, parser, objectBuilder);
                return objectBuilder.build();
            }
            case END_OBJECT: {
                return JsonValue.EMPTY_JSON_OBJECT;
            }
            case END_ARRAY: {
                return JsonValue.EMPTY_JSON_ARRAY;
            }
            case START_ARRAY: {
                JsonArrayBuilder arrayBuilder = this.builderFactory.createArrayBuilder();
                this.parseArray(parser, arrayBuilder);
                return arrayBuilder.build();
            }
            case KEY_NAME: {
                JsonObjectBuilder objectBuilder = this.builderFactory.createObjectBuilder();
                this.parseObject(parser.getString(), parser, objectBuilder);
                return objectBuilder.build();
            }
            case VALUE_STRING: {
                return this.jsonp.createValue(parser.getString());
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_NUMBER: {
                return this.jsonp.createValue(parser.getBigDecimal());
            }
        }
        throw new JsonParsingException("Unknown structure: " + String.valueOf(next), parser.getLocation());
    }

    private void parseObject(String originalKey, JsonParser parser, JsonObjectBuilder builder) {
        String key = originalKey;
        block12: while (parser.hasNext()) {
            JsonParser.Event next = parser.next();
            switch (next) {
                case KEY_NAME: {
                    key = parser.getString();
                    continue block12;
                }
                case VALUE_STRING: {
                    builder.add(key, (JsonValue)this.jsonp.createValue(parser.getString()));
                    continue block12;
                }
                case START_OBJECT: {
                    JsonObjectBuilder subObject = this.builderFactory.createObjectBuilder();
                    this.parseObject(null, parser, subObject);
                    builder.add(key, subObject);
                    continue block12;
                }
                case START_ARRAY: {
                    JsonArrayBuilder subArray = this.builderFactory.createArrayBuilder();
                    this.parseArray(parser, subArray);
                    builder.add(key, subArray);
                    continue block12;
                }
                case VALUE_NUMBER: {
                    if (parser.isIntegralNumber()) {
                        builder.add(key, (JsonValue)this.jsonp.createValue(parser.getLong()));
                        continue block12;
                    }
                    builder.add(key, (JsonValue)this.jsonp.createValue(parser.getBigDecimal()));
                    continue block12;
                }
                case VALUE_NULL: {
                    builder.addNull(key);
                    continue block12;
                }
                case VALUE_TRUE: {
                    builder.add(key, true);
                    continue block12;
                }
                case VALUE_FALSE: {
                    builder.add(key, false);
                    continue block12;
                }
                case END_OBJECT: {
                    return;
                }
                case END_ARRAY: {
                    throw new JsonParsingException("']', shouldn't occur", parser.getLocation());
                }
            }
            throw new JsonParsingException(next.name() + ", shouldn't occur", parser.getLocation());
        }
    }

    private void parseArray(JsonParser parser, JsonArrayBuilder builder) {
        block12: while (parser.hasNext()) {
            JsonParser.Event next = parser.next();
            switch (next) {
                case VALUE_STRING: {
                    builder.add((JsonValue)this.jsonp.createValue(parser.getString()));
                    continue block12;
                }
                case VALUE_NUMBER: {
                    if (parser.isIntegralNumber()) {
                        builder.add((JsonValue)this.jsonp.createValue(parser.getLong()));
                        continue block12;
                    }
                    builder.add((JsonValue)this.jsonp.createValue(parser.getBigDecimal()));
                    continue block12;
                }
                case START_OBJECT: {
                    JsonObjectBuilder subObject = this.builderFactory.createObjectBuilder();
                    this.parseObject(null, parser, subObject);
                    builder.add(subObject);
                    continue block12;
                }
                case START_ARRAY: {
                    JsonArrayBuilder subArray = this.builderFactory.createArrayBuilder();
                    this.parseArray(parser, subArray);
                    builder.add(subArray);
                    continue block12;
                }
                case END_ARRAY: {
                    return;
                }
                case VALUE_NULL: {
                    builder.addNull();
                    continue block12;
                }
                case VALUE_TRUE: {
                    builder.add(true);
                    continue block12;
                }
                case VALUE_FALSE: {
                    builder.add(false);
                    continue block12;
                }
                case KEY_NAME: {
                    throw new JsonParsingException("array doesn't have keys", parser.getLocation());
                }
                case END_OBJECT: {
                    throw new JsonParsingException("'}', shouldn't occur", parser.getLocation());
                }
            }
            throw new JsonParsingException(next.name() + ", shouldn't occur", parser.getLocation());
        }
    }
}

