/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import org.apache.batchee.container.impl.controller.chunk.CheckpointType;

public class CheckpointDataKey {
    private long jobInstanceId;
    private CheckpointType type;
    private String stepName;

    public CheckpointDataKey(long jobId, String stepName, CheckpointType bdsName) {
        this.jobInstanceId = jobId;
        this.stepName = stepName;
        this.type = bdsName;
    }

    public long getJobInstanceId() {
        return this.jobInstanceId;
    }

    public CheckpointType getType() {
        return this.type;
    }

    public String getStepName() {
        return this.stepName;
    }

    public String getCommaSeparatedKey() {
        return this.jobInstanceId + "," + this.stepName + "," + this.type.name();
    }

    public String toString() {
        return this.getCommaSeparatedKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointDataKey that = (CheckpointDataKey)CheckpointDataKey.class.cast(o);
        return this.jobInstanceId == that.jobInstanceId && this.type.equals((Object)that.type) && this.stepName.equals(that.stepName);
    }

    public int hashCode() {
        int result = (int)(this.jobInstanceId ^ this.jobInstanceId >>> 32);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.stepName.hashCode();
        return result;
    }
}

