/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.util.function.ArrayListSupplier;

public final class FoldStep<S, E>
extends ReducingBarrierStep<S, E> {
    private static final Set<TraverserRequirement> REQUIREMENTS = EnumSet.of(TraverserRequirement.OBJECT);
    private final boolean listFold;

    public FoldStep(Traversal.Admin traversal) {
        this(traversal, ArrayListSupplier.instance(), Operator.addAll);
    }

    public FoldStep(Traversal.Admin traversal, Supplier<E> seed, BiFunction<E, S, E> foldFunction) {
        super(traversal);
        this.listFold = seed.get() instanceof Collection;
        this.setSeedSupplier(seed);
        this.setReducingBiOperator(new FoldBiOperator(foldFunction));
    }

    @Override
    public E projectTraverser(Traverser.Admin<S> traverser) {
        if (this.listFold) {
            ArrayList list = new ArrayList();
            for (long i = 0L; i < traverser.bulk(); ++i) {
                list.add(traverser.get());
            }
            return (E)list;
        }
        return (E)traverser.get();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return REQUIREMENTS;
    }

    public boolean isListFold() {
        return this.listFold;
    }

    public static class FoldBiOperator<E>
    implements BinaryOperator<E>,
    Serializable {
        private BiFunction biFunction;

        private FoldBiOperator() {
        }

        public FoldBiOperator(BiFunction biFunction) {
            this.biFunction = biFunction;
        }

        @Override
        public E apply(E seed, E other) {
            return (E)this.biFunction.apply(seed, other);
        }
    }
}

