/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.datatable.column;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.string.ComponentRenderer;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.util.lang.Generics;
import org.wicketstuff.jquery.core.behavior.AjaxCallbackBehavior;
import org.wicketstuff.jquery.core.resource.JavaScriptPackageHeaderItem;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.kendo.ui.datatable.DataTable;
import org.wicketstuff.kendo.ui.datatable.column.PropertyColumn;

public abstract class AjaxPropertyColumn
extends PropertyColumn {
    private static final long serialVersionUID = 1L;

    protected AjaxPropertyColumn(String title, DataTable<?> datatable) {
        super(title);
        this.bind((Component)datatable);
    }

    protected AjaxPropertyColumn(String title, String property, DataTable<?> datatable) {
        super(title, property);
        this.bind((Component)datatable);
    }

    protected AjaxPropertyColumn(String title, int width, DataTable<?> datatable) {
        super(title, width);
        this.bind((Component)datatable);
    }

    protected AjaxPropertyColumn(String title, String property, int width, DataTable<?> datatable) {
        super(title, property, width);
        this.bind((Component)datatable);
    }

    protected AjaxPropertyColumn(IModel<String> title, String property, DataTable<?> datatable) {
        super(title, property);
        this.bind((Component)datatable);
    }

    protected AjaxPropertyColumn(IModel<String> title, String property, int width, DataTable<?> datatable) {
        super(title, property, width);
        this.bind((Component)datatable);
    }

    private final void bind(Component component) {
        component.add(new Behavior[]{new AjaxTemplateBehavior()});
    }

    @Override
    public final Boolean isEditable() {
        return false;
    }

    @Override
    public final String getTemplate() {
        return "#= loadAjaxPropertyColumn(data) #";
    }

    protected abstract Component getLazyComponent(String var1, String var2);

    protected class AjaxTemplateBehavior
    extends AjaxCallbackBehavior {
        private static final long serialVersionUID = 1L;

        public AjaxTemplateBehavior() {
            super("text/html");
        }

        public void renderHead(Component component, IHeaderResponse response) {
            super.renderHead(component, response);
            HashMap variables = Generics.newHashMap();
            variables.put("field", AjaxPropertyColumn.this.getField());
            variables.put("imageUrl", RequestCycleUtils.getAjaxIndicatorUrl());
            variables.put("callbackUrl", this.getCallbackUrl());
            response.render((HeaderItem)new JavaScriptPackageHeaderItem(AjaxPropertyColumn.class, (Map)variables));
        }

        protected String getResponse(IRequestParameters parameters) {
            String value = RequestCycleUtils.getQueryParameterValue((String)"id").toString();
            Component component = AjaxPropertyColumn.this.getLazyComponent(this.newMarkupId(), value);
            CharSequence response = ComponentRenderer.renderComponent((Component)component);
            return response != null ? response.toString() : "";
        }

        private String newMarkupId() {
            return "col-" + String.valueOf(UUID.randomUUID());
        }
    }
}

