/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.persistence.api.dao.AuditEventDAO;
import org.apache.syncope.core.persistence.api.dao.AuthModuleDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.MailTemplateDAO;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.WAConfigDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.AuditEventProcessor;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.data.AnyTypeClassDataBinder;
import org.apache.syncope.core.provisioning.api.data.AnyTypeDataBinder;
import org.apache.syncope.core.provisioning.api.data.AttrRepoDataBinder;
import org.apache.syncope.core.provisioning.api.data.AuditDataBinder;
import org.apache.syncope.core.provisioning.api.data.AuthModuleDataBinder;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.apache.syncope.core.provisioning.api.data.ClientAppDataBinder;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.provisioning.api.data.DelegationDataBinder;
import org.apache.syncope.core.provisioning.api.data.DynRealmDataBinder;
import org.apache.syncope.core.provisioning.api.data.FIQLQueryDataBinder;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.data.ImplementationDataBinder;
import org.apache.syncope.core.provisioning.api.data.NotificationDataBinder;
import org.apache.syncope.core.provisioning.api.data.OIDCJWKSDataBinder;
import org.apache.syncope.core.provisioning.api.data.PolicyDataBinder;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.apache.syncope.core.provisioning.api.data.RelationshipTypeDataBinder;
import org.apache.syncope.core.provisioning.api.data.RemediationDataBinder;
import org.apache.syncope.core.provisioning.api.data.ReportDataBinder;
import org.apache.syncope.core.provisioning.api.data.ResourceDataBinder;
import org.apache.syncope.core.provisioning.api.data.RoleDataBinder;
import org.apache.syncope.core.provisioning.api.data.SAML2IdPEntityDataBinder;
import org.apache.syncope.core.provisioning.api.data.SRARouteDataBinder;
import org.apache.syncope.core.provisioning.api.data.SchemaDataBinder;
import org.apache.syncope.core.provisioning.api.data.SecurityQuestionDataBinder;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.data.WAConfigDataBinder;
import org.apache.syncope.core.provisioning.api.data.wa.WAClientAppDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.EmptyClassLoader;
import org.apache.syncope.core.provisioning.api.jexl.JexlFunctions;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.apache.syncope.core.provisioning.api.jexl.SyncopeJexlFunctions;
import org.apache.syncope.core.provisioning.api.jexl.TemplateUtils;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.notification.NotificationJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.AsyncConnectorFacade;
import org.apache.syncope.core.provisioning.java.ConnectorLoader;
import org.apache.syncope.core.provisioning.java.DefaultAnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.java.DefaultAuditManager;
import org.apache.syncope.core.provisioning.java.DefaultConnIdBundleManager;
import org.apache.syncope.core.provisioning.java.DefaultConnectorManager;
import org.apache.syncope.core.provisioning.java.DefaultDerAttrHandler;
import org.apache.syncope.core.provisioning.java.DefaultGroupProvisioningManager;
import org.apache.syncope.core.provisioning.java.DefaultMappingManager;
import org.apache.syncope.core.provisioning.java.DefaultUserProvisioningManager;
import org.apache.syncope.core.provisioning.java.ProvisioningProperties;
import org.apache.syncope.core.provisioning.java.data.AccessTokenDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AnyObjectDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AnyTypeClassDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AnyTypeDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AttrRepoDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AuditDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AuthModuleDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AuthProfileDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ClientAppDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ConnInstanceDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.DelegationDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.DynRealmDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.FIQLQueryDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.GroupDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ImplementationDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.NotificationDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.OIDCJWKSDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.PolicyDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.RealmDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.RelationshipTypeDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.RemediationDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ReportDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ResourceDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.RoleDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.SAML2IdPEntityDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.SRARouteDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.SchemaDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.SecurityQuestionDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.TaskDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.UserDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.WAConfigDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.wa.WAClientAppDataBinderImpl;
import org.apache.syncope.core.provisioning.java.job.DefaultJobManager;
import org.apache.syncope.core.provisioning.java.job.JobStatusUpdater;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.apache.syncope.core.provisioning.java.job.SystemLoadReporterJob;
import org.apache.syncope.core.provisioning.java.job.notification.MailNotificationJobDelegate;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.apache.syncope.core.provisioning.java.notification.DefaultNotificationManager;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationManager;
import org.apache.syncope.core.provisioning.java.propagation.PriorityPropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.LiveSyncTaskSaver;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.jws.AccessTokenJWSSigner;
import org.apache.syncope.core.spring.task.VirtualThreadPoolTaskExecutor;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.apache.syncope.core.workflow.api.GroupWorkflowAdapter;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.SimpleAsyncTaskScheduler;

@EnableAsync
@EnableConfigurationProperties(value={ProvisioningProperties.class})
@Configuration(proxyBeanMethods=false)
public class ProvisioningContext {
    @ConditionalOnMissingBean
    @Bean
    public SyncopeJexlFunctions syncopeJexlFunctions() {
        return new SyncopeJexlFunctions();
    }

    @ConditionalOnMissingBean
    @Bean
    public JexlTools jexlTools(List<JexlFunctions> jexlFunctions) {
        JexlEngine jexlEngine = new JexlBuilder().loader((ClassLoader)new EmptyClassLoader()).permissions(JexlPermissions.RESTRICTED.compose(new String[]{"java.time.*", "org.apache.syncope.*"})).namespaces(jexlFunctions.stream().collect(Collectors.toMap(JexlFunctions::getNamespace, Function.identity()))).cache(512).silent(false).strict(false).create();
        return new JexlTools(jexlEngine);
    }

    @ConditionalOnMissingBean
    @Bean
    public AsyncConnectorFacade asyncConnectorFacade() {
        return new AsyncConnectorFacade();
    }

    @Bean
    @Primary
    public AsyncTaskExecutor asyncConnectorFacadeExecutor(ProvisioningProperties props) {
        VirtualThreadPoolTaskExecutor executor = new VirtualThreadPoolTaskExecutor();
        executor.setPoolSize(props.getAsyncConnectorFacadeExecutor().getPoolSize());
        executor.setAwaitTerminationSeconds(props.getAsyncConnectorFacadeExecutor().getAwaitTerminationSeconds());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setThreadNamePrefix("AsyncConnectorFacadeExecutor-");
        executor.initialize();
        return executor;
    }

    @Bean
    public AsyncConfigurer asyncConfigurer(final @Qualifier(value="asyncConnectorFacadeExecutor") AsyncTaskExecutor asyncConnectorFacadeExecutor) {
        return new AsyncConfigurer(){

            public Executor getAsyncExecutor() {
                return asyncConnectorFacadeExecutor;
            }
        };
    }

    @Bean
    public AsyncTaskExecutor propagationTaskExecutorAsyncExecutor(ProvisioningProperties props) {
        VirtualThreadPoolTaskExecutor executor = new VirtualThreadPoolTaskExecutor();
        executor.setPoolSize(props.getPropagationTaskExecutorAsyncExecutor().getPoolSize());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setAwaitTerminationSeconds(props.getPropagationTaskExecutorAsyncExecutor().getAwaitTerminationSeconds());
        executor.setThreadNamePrefix("PropagationTaskExecutor-");
        executor.initialize();
        return executor;
    }

    @Bean
    public SyncopeTaskScheduler taskScheduler(ProvisioningProperties props, JobStatusDAO jobStatusDAO) {
        SimpleAsyncTaskScheduler taskScheduler = new SimpleAsyncTaskScheduler();
        taskScheduler.setVirtualThreads(true);
        taskScheduler.setConcurrencyLimit(props.getScheduling().getPoolSize());
        taskScheduler.setTaskTerminationTimeout((long)(props.getScheduling().getAwaitTerminationSeconds() * 1000));
        taskScheduler.setThreadNamePrefix("TaskScheduler-");
        return new SyncopeTaskScheduler((TaskScheduler)taskScheduler, jobStatusDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public JobManager jobManager(DomainHolder<?> domainHolder, SecurityProperties securityProperties, SyncopeTaskScheduler scheduler, JobStatusDAO jobStatusDAO, TaskDAO taskDAO, ReportDAO reportDAO, ImplementationDAO implementationDAO, TaskUtilsFactory taskUtilsFactory, ConfParamOps confParamOps) {
        return new DefaultJobManager(domainHolder, scheduler, jobStatusDAO, taskDAO, reportDAO, implementationDAO, taskUtilsFactory, confParamOps, securityProperties);
    }

    @Bean
    public AsyncTaskExecutor jobStatusUpdaterThreadExecutor() {
        VirtualThreadPoolTaskExecutor executor = new VirtualThreadPoolTaskExecutor();
        executor.setPoolSize(1);
        executor.setThreadNamePrefix("JobStatusUpdaterThreadExecutor-");
        executor.initialize();
        return executor;
    }

    @ConditionalOnMissingBean
    @Bean
    public JobStatusUpdater jobStatusUpdater(JobStatusDAO jobStatusDAO) {
        return new JobStatusUpdater(jobStatusDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnectorManager connectorManager(EntityFactory entityFactory, ConnIdBundleManager connIdBundleManager, RealmDAO realmDAO, RealmSearchDAO realmSearchDAO, ExternalResourceDAO resourceDAO, ConnInstanceDataBinder connInstanceDataBinder, AsyncConnectorFacade asyncConnectorFacade) {
        return new DefaultConnectorManager(connIdBundleManager, realmDAO, realmSearchDAO, resourceDAO, connInstanceDataBinder, asyncConnectorFacade, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnectorLoader connectorLoader(ConnectorManager connectorManager) {
        return new ConnectorLoader(connectorManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public InboundMatcher inboundMatcher(AnyUtilsFactory anyUtilsFactory, UserDAO userDAO, AnyObjectDAO anyObjectDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, RealmDAO realmDAO, RealmSearchDAO realmSearchDAO, ImplementationDAO implementationDAO, IntAttrNameParser intAttrNameParser) {
        return new InboundMatcher(userDAO, anyObjectDAO, groupDAO, anySearchDAO, realmDAO, realmSearchDAO, implementationDAO, intAttrNameParser, anyUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public OutboundMatcher outboundMatcher(AnyUtilsFactory anyUtilsFactory, MappingManager mappingManager, UserDAO userDAO) {
        return new OutboundMatcher(mappingManager, userDAO, anyUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public DerAttrHandler derAttrHandler(AnyUtilsFactory anyUtilsFactory, JexlTools jexlTools) {
        return new DefaultDerAttrHandler(anyUtilsFactory, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public MappingManager mappingManager(AnyTypeDAO anyTypeDAO, UserDAO userDAO, AnyObjectDAO anyObjectDAO, GroupDAO groupDAO, RelationshipTypeDAO relationshipTypeDAO, RealmSearchDAO realmSearchDAO, ImplementationDAO implementationDAO, DerAttrHandler derAttrHandler, IntAttrNameParser intAttrNameParser, EncryptorManager encryptorManager, JexlTools jexlTools) {
        return new DefaultMappingManager(anyTypeDAO, userDAO, anyObjectDAO, groupDAO, relationshipTypeDAO, realmSearchDAO, implementationDAO, derAttrHandler, intAttrNameParser, encryptorManager, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public TemplateUtils templateUtils(UserDAO userDAO, GroupDAO groupDAO, JexlTools jexlTools) {
        return new TemplateUtils(userDAO, groupDAO, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnObjectUtils connObjectUtils(PasswordGenerator passwordGenerator, AnyUtilsFactory anyUtilsFactory, MappingManager mappingManager, TemplateUtils templateUtils, RealmSearchDAO realmSearchDAO, UserDAO userDAO, ExternalResourceDAO resourceDAO, EncryptorManager encryptorManager) {
        return new ConnObjectUtils(templateUtils, realmSearchDAO, userDAO, resourceDAO, passwordGenerator, mappingManager, anyUtilsFactory, encryptorManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public PropagationManager propagationManager(EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, ExternalResourceDAO resourceDAO, ConnObjectUtils connObjectUtils, MappingManager mappingManager, DerAttrHandler derAttrHandler, JexlTools jexlTools) {
        return new DefaultPropagationManager(resourceDAO, entityFactory, connObjectUtils, mappingManager, derAttrHandler, anyUtilsFactory, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnIdBundleManager connIdBundleManager(ProvisioningProperties props) {
        return new DefaultConnIdBundleManager(props.getConnIdLocation());
    }

    @ConditionalOnMissingBean
    @Bean
    public IntAttrNameParser intAttrNameParser(AnyUtilsFactory anyUtilsFactory, RealmUtils realmUtils, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO) {
        return new IntAttrNameParser(plainSchemaDAO, derSchemaDAO, anyUtilsFactory, realmUtils);
    }

    @ConditionalOnMissingBean
    @Bean
    public PropagationTaskExecutor propagationTaskExecutor(@Qualifier(value="propagationTaskExecutorAsyncExecutor") AsyncTaskExecutor propagationTaskExecutorAsyncExecutor, TaskUtilsFactory taskUtilsFactory, AnyUtilsFactory anyUtilsFactory, ConnectorManager connectorManager, ConnObjectUtils connObjectUtils, TaskDAO taskDAO, ExternalResourceDAO resourceDAO, PlainSchemaDAO plainSchemaDAO, NotificationManager notificationManager, AuditManager auditManager, TaskDataBinder taskDataBinder, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, ApplicationEventPublisher publisher) {
        return new PriorityPropagationTaskExecutor(connectorManager, connObjectUtils, taskDAO, resourceDAO, plainSchemaDAO, notificationManager, auditManager, taskDataBinder, anyUtilsFactory, taskUtilsFactory, outboundMatcher, validator, publisher, propagationTaskExecutorAsyncExecutor);
    }

    @ConditionalOnMissingBean
    @Bean
    public UserProvisioningManager userProvisioningManager(UserWorkflowAdapter uwfAdapter, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, UserDAO userDAO) {
        return new DefaultUserProvisioningManager(uwfAdapter, propagationManager, taskExecutor, userDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public GroupProvisioningManager groupProvisioningManager(GroupWorkflowAdapter gwfAdapter, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, GroupDataBinder groupDataBinder, GroupDAO groupDAO) {
        return new DefaultGroupProvisioningManager(gwfAdapter, propagationManager, taskExecutor, groupDataBinder, groupDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyObjectProvisioningManager anyObjectProvisioningManager(AnyObjectWorkflowAdapter awfAdapter, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, AnyObjectDAO anyObjectDAO) {
        return new DefaultAnyObjectProvisioningManager(awfAdapter, propagationManager, taskExecutor, anyObjectDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationManager notificationManager(EntityFactory entityFactory, SearchCondVisitor searchCondVisitor, DerSchemaDAO derSchemaDAO, NotificationDAO notificationDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, AnyMatchDAO anyMatchDAO, TaskDAO taskDAO, UserDataBinder userDataBinder, GroupDataBinder groupDataBinder, AnyObjectDataBinder anyObjectDataBinder, ConfParamOps confParamOps, DerAttrHandler derAttrHandler, IntAttrNameParser intAttrNameParser, JexlTools jexlTools) {
        return new DefaultNotificationManager(derSchemaDAO, notificationDAO, anyObjectDAO, userDAO, groupDAO, anySearchDAO, anyMatchDAO, taskDAO, derAttrHandler, userDataBinder, groupDataBinder, anyObjectDataBinder, confParamOps, entityFactory, intAttrNameParser, searchCondVisitor, jexlTools);
    }

    @Bean
    public AsyncTaskExecutor auditManagerThreadExecutor() {
        VirtualThreadPoolTaskExecutor executor = new VirtualThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("AuditManagerThreadExecutor-");
        executor.initialize();
        return executor;
    }

    @ConditionalOnMissingBean
    @Bean
    public AuditManager auditManager(AuditConfDAO auditConfDAO, AuditEventDAO auditEventDAO, EntityFactory entityFactory, List<AuditEventProcessor> auditEventProcessors, @Qualifier(value="auditManagerThreadExecutor") AsyncTaskExecutor taskExecutor) {
        return new DefaultAuditManager(auditConfDAO, auditEventDAO, entityFactory, auditEventProcessors, taskExecutor);
    }

    @ConditionalOnMissingBean
    @Bean
    public SystemLoadReporterJob systemLoadReporterJob(ApplicationContext ctx) {
        return new SystemLoadReporterJob((ApplicationEventPublisher)ctx);
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationJobDelegate notificationJobDelegate(TaskUtilsFactory taskUtilsFactory, TaskDAO taskDAO, AuditManager auditManager, NotificationManager notificationManager, ApplicationEventPublisher publisher, JavaMailSender mailSender) {
        return new MailNotificationJobDelegate(taskDAO, taskUtilsFactory, auditManager, notificationManager, publisher, mailSender);
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationJob notificationJob(NotificationJobDelegate delegate, DomainHolder<?> domainHolder, SecurityProperties securityProperties) {
        return new NotificationJob(securityProperties, domainHolder, delegate);
    }

    @ConditionalOnMissingBean
    @Bean
    public LiveSyncTaskSaver liveSyncTaskExecSaver(ExternalResourceDAO resourceDAO, TaskDAO taskDAO, TaskExecDAO taskExecDAO, TaskUtilsFactory taskUtilsFactory, NotificationManager notificationManager, AuditManager auditManager) {
        return new LiveSyncTaskSaver(resourceDAO, taskDAO, taskExecDAO, taskUtilsFactory, notificationManager, auditManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public AccessTokenDataBinder accessTokenDataBinder(EntityFactory entityFactory, SecurityProperties securityProperties, AccessTokenJWSSigner jwsSigner, AccessTokenDAO accessTokenDAO, ConfParamOps confParamOps, DefaultCredentialChecker credentialChecker) {
        return new AccessTokenDataBinderImpl(securityProperties, jwsSigner, accessTokenDAO, confParamOps, entityFactory, credentialChecker);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyObjectDataBinder anyObjectDataBinder(EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, JexlTools jexlTools) {
        return new AnyObjectDataBinderImpl(anyTypeDAO, realmSearchDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyTypeClassDataBinder anyTypeClassDataBinder(EntityFactory entityFactory, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, AnyTypeDAO anyTypeDAO) {
        return new AnyTypeClassDataBinderImpl(plainSchemaDAO, derSchemaDAO, anyTypeDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyTypeDataBinder anyTypeDataBinder(EntityFactory entityFactory, SecurityProperties securityProperties, EncryptorManager encryptorManager, AnyTypeDAO anyTypeDAO, AnyTypeClassDAO anyTypeClassDAO, AccessTokenDAO accessTokenDAO) {
        return new AnyTypeDataBinderImpl(securityProperties, encryptorManager, anyTypeDAO, anyTypeClassDAO, accessTokenDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuditDataBinder auditDataBinder() {
        return new AuditDataBinderImpl();
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthModuleDataBinder authModuleDataBinder(EntityFactory entityFactory, JexlTools jexlTools) {
        return new AuthModuleDataBinderImpl(entityFactory, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public AttrRepoDataBinder attrRepoDataBinder(EntityFactory entityFactory, JexlTools jexlTools) {
        return new AttrRepoDataBinderImpl(entityFactory, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthProfileDataBinder authProfileDataBinder(EntityFactory entityFactory) {
        return new AuthProfileDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ClientAppDataBinder clientAppDataBinder(PolicyDAO policyDAO, RealmSearchDAO realmSearchDAO, EntityFactory entityFactory) {
        return new ClientAppDataBinderImpl(policyDAO, realmSearchDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnInstanceDataBinder connInstanceDataBinder(EntityFactory entityFactory, ConnIdBundleManager connIdBundleManager, ConnInstanceDAO connInstanceDAO, RealmSearchDAO realmSearchDAO) {
        return new ConnInstanceDataBinderImpl(connIdBundleManager, connInstanceDAO, realmSearchDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public DelegationDataBinder delegationDataBinder(UserDAO userDAO, RoleDAO roleDAO, EntityFactory entityFactory) {
        return new DelegationDataBinderImpl(userDAO, roleDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public FIQLQueryDataBinder fiqlQueryDataBinder(SearchCondVisitor searchCondVisitor, UserDAO userDAO, EntityFactory entityFactory) {
        return new FIQLQueryDataBinderImpl(searchCondVisitor, userDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public DynRealmDataBinder dynRealmDataBinder(AnyTypeDAO anyTypeDAO, DynRealmDAO dynRealmDAO, SearchCondVisitor searchCondVisitor, EntityFactory entityFactory) {
        return new DynRealmDataBinderImpl(anyTypeDAO, dynRealmDAO, entityFactory, searchCondVisitor);
    }

    @ConditionalOnMissingBean
    @Bean
    public GroupDataBinder groupDataBinder(EntityFactory entityFactory, SearchCondVisitor searchCondVisitor, AnyUtilsFactory anyUtilsFactory, AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, JexlTools jexlTools) {
        return new GroupDataBinderImpl(anyTypeDAO, realmSearchDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, searchCondVisitor, validator, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public ImplementationDataBinder implementationDataBinder(EntityFactory entityFactory) {
        return new ImplementationDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationDataBinder notificationDataBinder(EntityFactory entityFactory, MailTemplateDAO mailTemplateDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, IntAttrNameParser intAttrNameParser) {
        return new NotificationDataBinderImpl(mailTemplateDAO, anyTypeDAO, implementationDAO, entityFactory, intAttrNameParser);
    }

    @ConditionalOnMissingBean
    @Bean
    public OIDCJWKSDataBinder oidcJWKSDataBinder(EntityFactory entityFactory) {
        return new OIDCJWKSDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public PolicyDataBinder policyDataBinder(EntityFactory entityFactory, ExternalResourceDAO resourceDAO, RealmDAO realmDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO) {
        return new PolicyDataBinderImpl(resourceDAO, realmDAO, anyTypeDAO, implementationDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public RealmDataBinder realmDataBinder(AnyTypeDAO anyTypeDAO, AnyTypeClassDAO anyTypeClassDAO, ImplementationDAO implementationDAO, RealmDAO realmDAO, PolicyDAO policyDAO, ExternalResourceDAO resourceDAO, PlainSchemaDAO plainSchemaDAO, EntityFactory entityFactory, DerAttrHandler derAttrHandler, PlainAttrValidationManager validator, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, JexlTools jexlTools, TemplateUtils templateUtils) {
        return new RealmDataBinderImpl(anyTypeDAO, anyTypeClassDAO, implementationDAO, realmDAO, policyDAO, resourceDAO, plainSchemaDAO, entityFactory, derAttrHandler, validator, mappingManager, intAttrNameParser, jexlTools, templateUtils);
    }

    @ConditionalOnMissingBean
    @Bean
    public RelationshipTypeDataBinder relationshipTypeDataBinder(AnyTypeDAO anyTypeDAO, EntityFactory entityFactory) {
        return new RelationshipTypeDataBinderImpl(anyTypeDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public RemediationDataBinder remediationDataBinder() {
        return new RemediationDataBinderImpl();
    }

    @ConditionalOnMissingBean
    @Bean
    public ReportDataBinder reportDataBinder(ReportExecDAO reportExecDAO, ImplementationDAO implementationDAO, SyncopeTaskScheduler scheduler) {
        return new ReportDataBinderImpl(reportExecDAO, implementationDAO, scheduler);
    }

    @ConditionalOnMissingBean
    @Bean
    public ResourceDataBinder resourceDataBinder(EntityFactory entityFactory, AnyTypeDAO anyTypeDAO, ConnInstanceDAO connInstanceDAO, PolicyDAO policyDAO, AnyTypeClassDAO anyTypeClassDAO, ImplementationDAO implementationDAO, PlainSchemaDAO plainSchemaDAO, IntAttrNameParser intAttrNameParser, PropagationTaskExecutor propagationTaskExecutor, JexlTools jexlTools) {
        return new ResourceDataBinderImpl(anyTypeDAO, connInstanceDAO, policyDAO, anyTypeClassDAO, implementationDAO, plainSchemaDAO, entityFactory, intAttrNameParser, propagationTaskExecutor, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public RoleDataBinder roleDataBinder(EntityFactory entityFactory, SearchCondVisitor searchCondVisitor, RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, RoleDAO roleDAO) {
        return new RoleDataBinderImpl(realmSearchDAO, dynRealmDAO, roleDAO, entityFactory, searchCondVisitor);
    }

    @ConditionalOnMissingBean
    @Bean
    public SAML2IdPEntityDataBinder saml2IdPEntityDataBinder(EntityFactory entityFactory) {
        return new SAML2IdPEntityDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public SRARouteDataBinder sraRouteDataBinder() {
        return new SRARouteDataBinderImpl();
    }

    @ConditionalOnMissingBean
    @Bean
    public SchemaDataBinder schemaDataBinder(EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, AnyTypeClassDAO anyTypeClassDAO, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, ExternalResourceDAO resourceDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, JexlTools jexlTools) {
        return new SchemaDataBinderImpl(anyTypeClassDAO, plainSchemaDAO, derSchemaDAO, resourceDAO, anyTypeDAO, implementationDAO, entityFactory, anyUtilsFactory, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public SecurityQuestionDataBinder securityQuestionDataBinder(EntityFactory entityFactory) {
        return new SecurityQuestionDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public TaskDataBinder taskDataBinder(EntityFactory entityFactory, TaskUtilsFactory taskUtilsFactory, RealmSearchDAO realmSearchDAO, ExternalResourceDAO resourceDAO, TaskExecDAO taskExecDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, SyncopeTaskScheduler scheduler, TemplateUtils templateUtils) {
        return new TaskDataBinderImpl(realmSearchDAO, resourceDAO, taskExecDAO, anyTypeDAO, implementationDAO, entityFactory, scheduler, taskUtilsFactory, templateUtils);
    }

    @ConditionalOnMissingBean
    @Bean
    public UserDataBinder userDataBinder(EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, SecurityProperties securityProperties, AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, RoleDAO roleDAO, SecurityQuestionDAO securityQuestionDAO, AccessTokenDAO accessTokenDAO, DelegationDAO delegationDAO, ConfParamOps confParamOps, JexlTools jexlTools) {
        return new UserDataBinderImpl(anyTypeDAO, realmSearchDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator, roleDAO, securityQuestionDAO, accessTokenDAO, delegationDAO, confParamOps, securityProperties, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public WAConfigDataBinder waConfigDataBinder(WAConfigDAO waConfigDAO, EntityFactory entityFactory) {
        return new WAConfigDataBinderImpl(waConfigDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public WAClientAppDataBinder waClientAppDataBinder(ClientAppDataBinder clientAppDataBinder, PolicyDataBinder policyDataBinder, AuthModuleDataBinder authModuleDataBinder, AuthModuleDAO authModuleDAO) {
        return new WAClientAppDataBinderImpl(clientAppDataBinder, policyDataBinder, authModuleDataBinder, authModuleDAO);
    }
}

