/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.authorization.checker.AuthorizationChecker;
import org.pac4j.core.authorization.checker.DefaultAuthorizationChecker;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.finder.ClientFinder;
import org.pac4j.core.client.finder.DefaultSecurityClientFinder;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.engine.AbstractExceptionAwareLogic;
import org.pac4j.core.engine.SecurityGrantedAccessAdapter;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.engine.savedrequest.DefaultSavedRequestHandler;
import org.pac4j.core.engine.savedrequest.SavedRequestHandler;
import org.pac4j.core.exception.http.ForbiddenAction;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.matching.checker.DefaultMatchingChecker;
import org.pac4j.core.matching.checker.MatchingChecker;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityLogic
extends AbstractExceptionAwareLogic
implements SecurityLogic {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSecurityLogic.class);
    public static final DefaultSecurityLogic INSTANCE = new DefaultSecurityLogic();
    private ClientFinder clientFinder = new DefaultSecurityClientFinder();
    private AuthorizationChecker authorizationChecker = new DefaultAuthorizationChecker();
    private MatchingChecker matchingChecker = new DefaultMatchingChecker();
    private SavedRequestHandler savedRequestHandler = new DefaultSavedRequestHandler();
    private boolean loadProfilesFromSession = true;

    @Override
    public Object perform(Config config, SecurityGrantedAccessAdapter securityGrantedAccessAdapter, String clients, String authorizers, String matchers, FrameworkParameters parameters) {
        HttpAction action;
        HttpActionAdapter httpActionAdapter;
        WebContext webContext;
        block11: {
            LOGGER.debug("=== SECURITY ===");
            CallContext ctx = this.buildContext(config, parameters);
            webContext = ctx.webContext();
            SessionStore sessionStore = ctx.sessionStore();
            httpActionAdapter = config.getHttpActionAdapter();
            CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
            try {
                CommonHelper.assertNotNull("clientFinder", this.clientFinder);
                CommonHelper.assertNotNull("authorizationChecker", this.authorizationChecker);
                CommonHelper.assertNotNull("matchingChecker", this.matchingChecker);
                Clients configClients = config.getClients();
                CommonHelper.assertNotNull("configClients", configClients);
                LOGGER.debug("url: {}", (Object)webContext.getFullRequestURL());
                LOGGER.debug("clients: {} | matchers: {}", (Object)clients, (Object)matchers);
                List<Client> currentClients = this.clientFinder.find(configClients, webContext, clients);
                LOGGER.debug("currentClients: {}", currentClients);
                if (this.matchingChecker.matches(ctx, matchers, config.getMatchers(), currentClients)) {
                    ProfileManager manager = (ProfileManager)ctx.profileManagerFactory().apply(webContext, sessionStore);
                    manager.setConfig(config);
                    List<UserProfile> profiles = this.loadProfilesFromSession ? this.loadProfiles(ctx, manager, currentClients) : List.of();
                    LOGGER.debug("Loaded profiles (from session: {}): {} ", (Object)this.loadProfilesFromSession, profiles);
                    if (CommonHelper.isEmpty(profiles) && !CommonHelper.isEmpty(currentClients)) {
                        boolean updated = false;
                        for (Client currentClient : currentClients) {
                            if (!(currentClient instanceof DirectClient)) continue;
                            DirectClient directClient = (DirectClient)currentClient;
                            LOGGER.debug("Performing authentication for direct client: {}", (Object)currentClient);
                            Credentials credentials = currentClient.getCredentials(ctx).orElse(null);
                            credentials = currentClient.validateCredentials(ctx, credentials).orElse(null);
                            LOGGER.debug("credentials: {}", (Object)credentials);
                            if (credentials == null || !credentials.isForAuthentication()) continue;
                            Optional<UserProfile> optProfile = currentClient.getUserProfile(ctx, credentials);
                            LOGGER.debug("profile: {}", optProfile);
                            if (!optProfile.isPresent()) continue;
                            UserProfile profile = optProfile.get();
                            Boolean saveProfileInSession = directClient.getSaveProfileInSession(webContext, profile);
                            boolean multiProfile = directClient.isMultiProfile(webContext, profile);
                            LOGGER.debug("saveProfileInSession: {} / multiProfile: {}", (Object)saveProfileInSession, (Object)multiProfile);
                            manager.save(saveProfileInSession, profile, multiProfile);
                            updated = true;
                            if (multiProfile) continue;
                            break;
                        }
                        if (updated) {
                            profiles = this.loadProfiles(ctx, manager, currentClients);
                            LOGGER.debug("Reloaded profiles: {}", profiles);
                        }
                    }
                    if (CommonHelper.isNotEmpty(profiles)) {
                        LOGGER.debug("authorizers: {}", (Object)authorizers);
                        if (this.authorizationChecker.isAuthorized(webContext, sessionStore, profiles, authorizers, config.getAuthorizers(), currentClients)) {
                            LOGGER.debug("authenticated and authorized -> grant access");
                            return securityGrantedAccessAdapter.adapt(webContext, sessionStore, profiles);
                        }
                        LOGGER.debug("forbidden");
                        action = this.forbidden(ctx, currentClients, profiles, authorizers);
                    } else if (this.startAuthentication(ctx, currentClients)) {
                        LOGGER.debug("Starting authentication");
                        this.saveRequestedUrl(ctx, currentClients, config.getClients().getAjaxRequestResolver());
                        action = this.redirectToIdentityProvider(ctx, currentClients);
                    } else {
                        LOGGER.debug("unauthorized");
                        action = this.unauthorized(ctx, currentClients);
                    }
                    break block11;
                }
                LOGGER.debug("no matching for this request -> grant access");
                return securityGrantedAccessAdapter.adapt(webContext, sessionStore, Collections.emptyList());
            }
            catch (Exception e) {
                return this.handleException(e, httpActionAdapter, webContext);
            }
        }
        return httpActionAdapter.adapt(action, webContext);
    }

    protected List<UserProfile> loadProfiles(CallContext ctx, ProfileManager manager, List<Client> clients) {
        return manager.getProfiles();
    }

    protected HttpAction forbidden(CallContext ctx, List<Client> currentClients, List<UserProfile> profiles, String authorizers) {
        return new ForbiddenAction();
    }

    protected boolean startAuthentication(CallContext ctx, List<Client> currentClients) {
        return CommonHelper.isNotEmpty(currentClients) && currentClients.get(0) instanceof IndirectClient;
    }

    protected void saveRequestedUrl(CallContext ctx, List<Client> currentClients, AjaxRequestResolver ajaxRequestResolver) {
        if (ajaxRequestResolver == null || !ajaxRequestResolver.isAjax(ctx)) {
            this.savedRequestHandler.save(ctx);
        }
    }

    protected HttpAction redirectToIdentityProvider(CallContext ctx, List<Client> currentClients) {
        IndirectClient currentClient = (IndirectClient)currentClients.get(0);
        return currentClient.getRedirectionAction(ctx).get();
    }

    protected HttpAction unauthorized(CallContext ctx, List<Client> currentClients) {
        return HttpActionHelper.buildUnauthenticatedAction(ctx.webContext());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientFinder getClientFinder() {
        return this.clientFinder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AuthorizationChecker getAuthorizationChecker() {
        return this.authorizationChecker;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MatchingChecker getMatchingChecker() {
        return this.matchingChecker;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SavedRequestHandler getSavedRequestHandler() {
        return this.savedRequestHandler;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isLoadProfilesFromSession() {
        return this.loadProfilesFromSession;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultSecurityLogic setClientFinder(ClientFinder clientFinder) {
        this.clientFinder = clientFinder;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultSecurityLogic setAuthorizationChecker(AuthorizationChecker authorizationChecker) {
        this.authorizationChecker = authorizationChecker;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultSecurityLogic setMatchingChecker(MatchingChecker matchingChecker) {
        this.matchingChecker = matchingChecker;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultSecurityLogic setSavedRequestHandler(SavedRequestHandler savedRequestHandler) {
        this.savedRequestHandler = savedRequestHandler;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultSecurityLogic setLoadProfilesFromSession(boolean loadProfilesFromSession) {
        this.loadProfilesFromSession = loadProfilesFromSession;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DefaultSecurityLogic(super=" + super.toString() + ", clientFinder=" + this.clientFinder + ", authorizationChecker=" + this.authorizationChecker + ", matchingChecker=" + this.matchingChecker + ", savedRequestHandler=" + this.savedRequestHandler + ", loadProfilesFromSession=" + this.loadProfilesFromSession + ")";
    }
}

