/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.http2.Http2Protocol;
import org.apereo.cas.adaptors.x509.authentication.X509CertificateExtractor;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.X509CasMultifactorWebflowCustomizer;
import org.apereo.cas.web.flow.X509CertificateCredentialsNonInteractiveAction;
import org.apereo.cas.web.flow.X509CertificateCredentialsRequestHeaderAction;
import org.apereo.cas.web.flow.X509WebflowConfigurer;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.tomcat.X509TomcatServletWebServiceFactoryCustomizer;
import org.apereo.cas.web.tomcat.X509TomcatServletWebServiceFactoryWebflowConfigurer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.X509})
@AutoConfiguration
public class CasX509AuthenticationWebflowAutoConfiguration {
    @ConditionalOnMissingBean(name={"x509WebflowConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowConfigurer x509WebflowConfigurer(@Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        return new X509WebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"x509CasMultifactorWebflowCustomizer"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasMultifactorWebflowCustomizer x509CasMultifactorWebflowCustomizer() {
        return new X509CasMultifactorWebflowCustomizer();
    }

    @ConditionalOnMissingBean(name={"x509Check"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action x509Check(ConfigurableApplicationContext applicationContext, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="x509CertificateExtractor") X509CertificateExtractor x509CertificateExtractor, @Qualifier(value="serviceTicketRequestWebflowEventResolver") CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, @Qualifier(value="adaptiveAuthenticationPolicy") AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, CasConfigurationProperties casProperties) {
        return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> {
            boolean extractCertFromRequestHeader = casProperties.getAuthn().getX509().isExtractCert();
            if (extractCertFromRequestHeader) {
                return new X509CertificateCredentialsRequestHeaderAction(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy, x509CertificateExtractor, casProperties);
            }
            return new X509CertificateCredentialsNonInteractiveAction(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy, casProperties);
        }).withId("x509Check").build().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"x509CasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer x509CasWebflowExecutionPlanConfigurer(@Qualifier(value="x509WebflowConfigurer") CasWebflowConfigurer x509WebflowConfigurer) {
        return plan -> plan.registerWebflowConfigurer(x509WebflowConfigurer);
    }

    @Configuration(value="X509TomcatServletWebServiceFactoryConfiguration", proxyBeanMethods=false)
    @ConditionalOnClass(value={Tomcat.class, Http2Protocol.class})
    @ConditionalOnProperty(value={"cas.authn.x509.webflow.port"})
    static class X509TomcatServletWebServiceFactoryConfiguration {
        X509TomcatServletWebServiceFactoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"x509TomcatServletWebServiceFactoryCustomizer"})
        @Bean
        public WebServerFactoryCustomizer x509TomcatServletWebServiceFactoryCustomizer(ServerProperties serverProperties, CasConfigurationProperties casProperties) {
            return new X509TomcatServletWebServiceFactoryCustomizer(serverProperties, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"x509TomcatWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer x509TomcatWebflowExecutionPlanConfigurer(@Qualifier(value="x509TomcatServletWebServiceFactoryWebflowConfigurer") CasWebflowConfigurer x509TomcatServletWebServiceFactoryWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(x509TomcatServletWebServiceFactoryWebflowConfigurer);
        }

        @ConditionalOnMissingBean(name={"x509TomcatServletWebServiceFactoryWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer x509TomcatServletWebServiceFactoryWebflowConfigurer(@Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new X509TomcatServletWebServiceFactoryWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        }
    }
}

