/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.widget.window;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.jquery.core.JQueryAbstractBehavior;
import org.wicketstuff.jquery.core.resource.StyleSheetPackageHeaderItem;
import org.wicketstuff.kendo.ui.form.TextField;
import org.wicketstuff.kendo.ui.widget.window.FormWindow;

public abstract class InputWindow<T>
extends FormWindow<T> {
    private static final long serialVersionUID = 1L;
    private IModel<String> labelModel;
    private FormComponent<T> textField;

    public InputWindow(String id, String title, String label) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), null, (IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public InputWindow(String id, IModel<String> title, IModel<String> label) {
        this(id, title, null, label);
    }

    public InputWindow(String id, String title, IModel<T> model, String label) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), model, (IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public InputWindow(String id, IModel<String> title, IModel<T> model, IModel<String> label) {
        super(id, title, model);
        this.labelModel = label;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new StyleSheetPackageHeaderItem(InputWindow.class));
    }

    public void detachModels() {
        super.detachModels();
        if (this.labelModel != null) {
            this.labelModel.detach();
        }
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        Form<?> form = this.getForm();
        form.add(new Component[]{this.newLabel("label", this.labelModel)});
        this.textField = this.newTextField("input", this.getModel());
        this.textField.setOutputMarkupId(true);
        this.textField.setRequired(this.isRequired());
        form.add(new Component[]{this.textField});
    }

    public String getLabel() {
        return (String)this.labelModel.getObject();
    }

    public void setLabel(String label) {
        this.labelModel.setObject((Object)label);
    }

    protected boolean isRequired() {
        return true;
    }

    public String getTextFieldMarkupId() {
        return this.textField.getMarkupId();
    }

    protected Component newLabel(String id, IModel<String> model) {
        return new Label(id, model);
    }

    protected FormComponent<T> newTextField(String id, IModel<T> model) {
        return new TextField<T>(id, model);
    }

    public static class AutoFocusBehavior
    extends JQueryAbstractBehavior {
        private static final long serialVersionUID = 1L;
        private InputWindow<?> window = null;

        public void bind(Component component) {
            super.bind(component);
            if (component instanceof InputWindow) {
                this.window = (InputWindow)component;
            }
        }

        protected String $() {
            if (this.window != null) {
                return String.format("%s.bind('activate', function() { jQuery('#%s').focus(); });", this.window.widget(), this.window.getTextFieldMarkupId());
            }
            return null;
        }
    }
}

