/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.scheduler.resource;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.lang.Generics;
import org.wicketstuff.kendo.ui.scheduler.resource.Resource;
import org.wicketstuff.kendo.ui.scheduler.resource.ResourceList;

public class ResourceListModel
extends ListModel<ResourceList> {
    private static final long serialVersionUID = 1L;

    public ResourceListModel() {
        super(new ArrayList());
    }

    public ResourceListModel(ResourceList list) {
        this();
        this.add(list);
    }

    public void clear() {
        ((List)this.getObject()).clear();
    }

    public void add(ResourceList list) {
        ((List)this.getObject()).add(list);
    }

    public List<String> getFields() {
        ArrayList fields = Generics.newArrayList();
        for (ResourceList list : (List)this.getObject()) {
            fields.add(list.getField());
        }
        return fields;
    }

    public List<String> getGroups() {
        ArrayList groups = Generics.newArrayList();
        for (ResourceList list : (List)this.getObject()) {
            String group = list.getGroup();
            if (group == null) continue;
            groups.add(group);
        }
        return groups;
    }

    public String toString() {
        JSONArray array = new JSONArray();
        for (ResourceList list : (List)this.getObject()) {
            JSONObject object = new JSONObject();
            array.put((Object)object);
            object.put("field", (Object)list.getField());
            if (list.getGroup() != null) {
                object.put("name", (Object)list.getGroup());
            }
            object.put("title", (Object)list.getTitle());
            object.put("multiple", list.isMultiple());
            JSONArray resources = new JSONArray();
            object.put("dataSource", (Object)resources);
            for (Resource resource : list) {
                resources.put((Object)Resource.toJSONObject(resource));
            }
        }
        return array.toString();
    }
}

