/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.form.buttongroup;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.kendo.ui.KendoUIBehavior;
import org.wicketstuff.kendo.ui.form.buttongroup.IButtonGroupListener;

public class ButtonGroupBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoMobileButtonGroup";
    static final int NONE = -1;
    private final IButtonGroupListener listener;
    private JQueryAjaxBehavior onSelectAjaxBehavior;

    public ButtonGroupBehavior(String selector, IButtonGroupListener listener) {
        this(selector, new Options(), listener);
    }

    public ButtonGroupBehavior(String selector, Options options, IButtonGroupListener listener) {
        super(selector, METHOD, options);
        this.listener = (IButtonGroupListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.onSelectAjaxBehavior = this.newOnSelectAjaxBehavior(this);
        component.add(new Behavior[]{this.onSelectAjaxBehavior});
    }

    @Override
    public void onConfigure(Component component) {
        this.setOption("select", this.onSelectAjaxBehavior.getCallbackFunction());
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SelectEvent) {
            this.listener.onSelect(target, ((SelectEvent)event).getIndex());
        }
    }

    protected JQueryAjaxBehavior newOnSelectAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSelectAjaxBehavior(source);
    }

    protected static class SelectEvent
    extends JQueryEvent {
        private final int index = RequestCycleUtils.getQueryParameterValue((String)"index").toInt(-1);

        public int getIndex() {
            return this.index;
        }
    }

    protected static class OnSelectAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSelectAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"index", (String)"e.index")};
        }

        protected JQueryEvent newEvent() {
            return new SelectEvent();
        }
    }
}

