/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;

public class Assignment
implements MemberAssignment {
    public static final Assignment EMPTY = new Assignment(Collections.emptyMap());
    private final Map<Uuid, Set<Integer>> partitions;

    public Assignment(Map<Uuid, Set<Integer>> partitions) {
        this.partitions = Collections.unmodifiableMap(Objects.requireNonNull(partitions));
    }

    public Map<Uuid, Set<Integer>> partitions() {
        return this.partitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assignment that = (Assignment)o;
        return this.partitions.equals(that.partitions);
    }

    public int hashCode() {
        return this.partitions.hashCode();
    }

    public String toString() {
        return "Assignment(partitions=" + this.partitions + ')';
    }

    public static Assignment fromRecord(ConsumerGroupTargetAssignmentMemberValue record) {
        return new Assignment(record.topicPartitions().stream().collect(Collectors.toMap(ConsumerGroupTargetAssignmentMemberValue.TopicPartition::topicId, topicPartitions -> new HashSet<Integer>(topicPartitions.partitions()))));
    }
}

