/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.aws.AmazonClientConfigurationBuilder;
import org.apereo.cas.aws.ChainingAWSCredentialsProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.aws.BaseAmazonWebServicesProperties;
import org.apereo.cas.configuration.model.support.pac4j.saml.Pac4jSamlServiceProviderMetadataAmazonS3Properties;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.s3.SAML2S3MetadataGenerator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication}, module="saml-s3", enabledByDefault=false)
@Configuration(value="DelegatedAuthenticationSaml2AmazonS3Configuration", proxyBeanMethods=false)
@ConditionalOnClass(value={S3Client.class})
class DelegatedAuthenticationSaml2AmazonS3Configuration {
    DelegatedAuthenticationSaml2AmazonS3Configuration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"delegatedSaml2ClientAmazonS3MetadataCustomizer"})
    public DelegatedClientFactoryCustomizer delegatedSaml2ClientAmazonS3MetadataCustomizer(CasConfigurationProperties casProperties, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
        return client -> {
            if (client instanceof SAML2Client) {
                SAML2Client saml2Client = (SAML2Client)client;
                SAML2Configuration configuration = saml2Client.getConfiguration();
                casProperties.getAuthn().getPac4j().getSaml().forEach(saml -> {
                    Pac4jSamlServiceProviderMetadataAmazonS3Properties amz = saml.getMetadata().getServiceProvider().getAmazonS3();
                    AwsCredentialsProvider credentials = ChainingAWSCredentialsProvider.getInstance((String)amz.getCredentialAccessKey(), (String)amz.getCredentialSecretKey(), (String)amz.getProfilePath(), (String)amz.getProfileName());
                    S3ClientBuilder builder = S3Client.builder();
                    AmazonClientConfigurationBuilder.prepareSyncClientBuilder((AwsSyncClientBuilder)builder, (AwsCredentialsProvider)credentials, (BaseAmazonWebServicesProperties)amz);
                    S3Client s3Client = (S3Client)builder.build();
                    SAML2S3MetadataGenerator metadataGenerator = new SAML2S3MetadataGenerator(s3Client, configuration.getServiceProviderEntityId());
                    configuration.setServiceProviderMetadataResource(ResourceUtils.NULL_RESOURCE);
                    configuration.setMetadataGenerator((SAML2MetadataGenerator)metadataGenerator);
                });
            }
        };
    }
}

