/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.context.Lifecycle;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.integration.core.Pausable;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.util.CustomizableThreadCreator;
import org.springframework.util.ReflectionUtils;

public class ControlBusMethodFilter
implements ReflectionUtils.MethodFilter {
    public boolean matches(Method method) {
        if (Modifier.isPublic(method.getModifiers())) {
            Class<?> declaringClass = method.getDeclaringClass();
            String methodName = method.getName();
            if ((Pausable.class.isAssignableFrom(declaringClass) || Lifecycle.class.isAssignableFrom(declaringClass)) && ReflectionUtils.findMethod(Pausable.class, (String)methodName, (Class[])method.getParameterTypes()) != null) {
                return true;
            }
            if (CustomizableThreadCreator.class.isAssignableFrom(declaringClass) && (methodName.startsWith("get") || methodName.startsWith("set") || methodName.equals("shutdown"))) {
                return true;
            }
            MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, (RepeatableContainers)RepeatableContainers.none(), (AnnotationFilter)AnnotationFilter.PLAIN);
            return mergedAnnotations.get(ManagedAttribute.class).isPresent() || mergedAnnotations.get(ManagedOperation.class).isPresent();
        }
        return false;
    }
}

