/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.graph;

import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.search.Search;
import io.micrometer.observation.ObservationConvention;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.graph.IntegrationNode;
import org.springframework.integration.graph.MessageChannelNode;
import org.springframework.integration.graph.MessageGatewayNode;
import org.springframework.integration.graph.MessageHandlerNode;
import org.springframework.integration.graph.MessageProducerNode;
import org.springframework.integration.graph.MessageSourceNode;
import org.springframework.integration.graph.PollableChannelNode;
import org.springframework.integration.graph.ReceiveCounters;
import org.springframework.integration.graph.ReceiveCountersAware;
import org.springframework.integration.graph.SendTimers;
import org.springframework.integration.graph.SendTimersAware;
import org.springframework.integration.graph.TimerStats;
import org.springframework.integration.support.management.observation.DefaultMessageReceiverObservationConvention;
import org.springframework.integration.support.management.observation.DefaultMessageRequestReplyReceiverObservationConvention;
import org.springframework.integration.support.management.observation.DefaultMessageSenderObservationConvention;
import org.springframework.integration.support.management.observation.IntegrationObservation;
import org.springframework.lang.Nullable;

public class MicrometerNodeEnhancer {
    private static final String UNUSED = "unused";
    private static final String TAG_TYPE = "type";
    private static final String TAG_NAME = "name";
    private static final String TAG_RESULT = "result";
    private static final TimerStats ZERO_TIMER_STATS = new TimerStats(0L, 0.0, 0.0);
    private final MeterRegistry registry;

    MicrometerNodeEnhancer(ApplicationContext applicationContext) {
        ObjectProvider meterRegistryProvider = applicationContext.getBeanProvider(MeterRegistry.class);
        this.registry = (MeterRegistry)meterRegistryProvider.getIfUnique();
    }

    <T extends IntegrationNode> T enhance(T node) {
        if (this.registry != null) {
            if (node instanceof MessageChannelNode) {
                this.enhanceWithTimers(node, "channel");
            } else if (node instanceof MessageHandlerNode || node instanceof MessageProducerNode) {
                this.enhanceWithTimers(node, "handler");
            }
            if (node instanceof PollableChannelNode) {
                this.enhanceWithCounts(node, "channel");
            } else if (node instanceof MessageSourceNode) {
                this.enhanceWithCounts(node, "source");
            } else if (node instanceof MessageGatewayNode) {
                this.enhanceWithTimers(node, "gateway");
            }
        }
        return node;
    }

    private <T extends IntegrationNode> void enhanceWithTimers(T node, String type) {
        ((SendTimersAware)((Object)node)).sendTimers(() -> this.retrieveTimers(node, type));
    }

    private <T extends IntegrationNode> SendTimers retrieveTimers(T node, String type) {
        Timer successTimer = this.obtainTimer(node, type, true);
        Timer failureTimer = this.obtainTimer(node, type, false);
        return new SendTimers(MicrometerNodeEnhancer.buildTimerStats(successTimer), MicrometerNodeEnhancer.buildTimerStats(failureTimer));
    }

    @Nullable
    private <T extends IntegrationNode> Timer obtainTimer(T node, String type, boolean success) {
        try {
            if (node.isObserved()) {
                return this.observationTimer(node, type, success);
            }
            return this.registry.get("spring.integration.send").tag(TAG_TYPE, type).tag(TAG_NAME, node.getName()).tag(TAG_RESULT, success ? "success" : "failure").timer();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    private <T extends IntegrationNode> Timer observationTimer(T node, String type, boolean success) {
        Search timerSearch;
        switch (type) {
            case "channel": {
                Search search = this.buildTimerSearch(DefaultMessageSenderObservationConvention.INSTANCE, IntegrationObservation.ProducerTags.COMPONENT_TYPE, "producer");
                break;
            }
            case "handler": {
                Search search = this.buildTimerSearch(DefaultMessageReceiverObservationConvention.INSTANCE, IntegrationObservation.HandlerTags.COMPONENT_TYPE, "handler");
                break;
            }
            case "gateway": {
                Search search = this.buildTimerSearch(DefaultMessageRequestReplyReceiverObservationConvention.INSTANCE, IntegrationObservation.GatewayTags.COMPONENT_TYPE, "gateway");
                break;
            }
            default: {
                Search search = timerSearch = null;
            }
        }
        if (timerSearch != null) {
            return timerSearch.tag(IntegrationObservation.HandlerTags.COMPONENT_NAME.asString(), node.getName()).tag("error", value -> success == "none".equals(value)).timer();
        }
        return null;
    }

    private Search buildTimerSearch(ObservationConvention<?> observationConvention, KeyName tagKey, String tagValue) {
        return this.registry.find(observationConvention.getName()).tag(tagKey.asString(), tagValue);
    }

    private <T extends IntegrationNode> void enhanceWithCounts(T node, String type) {
        ((ReceiveCountersAware)((Object)node)).receiveCounters(() -> this.retrieveCounters(node, type));
    }

    private <T extends IntegrationNode> ReceiveCounters retrieveCounters(T node, String type) {
        Counter successes = null;
        String name = node.getName();
        try {
            successes = this.registry.get("spring.integration.receive").tag(TAG_TYPE, type).tag(TAG_NAME, name).tag(TAG_RESULT, "success").counter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Counter failures = null;
        try {
            failures = this.registry.get("spring.integration.receive").tag(TAG_TYPE, type).tag(TAG_NAME, name).tag(TAG_RESULT, "failure").counter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ReceiveCounters((long)(successes == null ? 0.0 : successes.count()), (long)(failures == null ? 0.0 : failures.count()));
    }

    private static TimerStats buildTimerStats(@Nullable Timer timer) {
        return timer == null ? ZERO_TIMER_STATS : new TimerStats(timer.count(), timer.mean(TimeUnit.MILLISECONDS), timer.max(TimeUnit.MILLISECONDS));
    }
}

