/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.TemplateUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class AnyObjectLogic
extends AbstractAnyLogic<AnyObjectTO, AnyObjectCR, AnyObjectUR> {
    protected final AnyObjectDAO anyObjectDAO;
    protected final AnySearchDAO searchDAO;
    protected final AnyObjectDataBinder binder;
    protected final AnyObjectProvisioningManager provisioningManager;

    public AnyObjectLogic(RealmSearchDAO realmSearchDAO, AnyTypeDAO anyTypeDAO, TemplateUtils templateUtils, AnyObjectDAO anyObjectDAO, AnySearchDAO searchDAO, AnyObjectDataBinder binder, AnyObjectProvisioningManager provisioningManager) {
        super(realmSearchDAO, anyTypeDAO, templateUtils);
        this.anyObjectDAO = anyObjectDAO;
        this.searchDAO = searchDAO;
        this.binder = binder;
        this.provisioningManager = provisioningManager;
    }

    @Override
    @Transactional(readOnly=true)
    public AnyObjectTO read(String key) {
        return this.binder.getAnyObjectTO(key);
    }

    @Transactional(readOnly=true)
    public AnyObjectTO read(String type, String name) {
        return this.anyObjectDAO.findKey(type, name).map(arg_0 -> ((AnyObjectDataBinder)this.binder).getAnyObjectTO(arg_0)).orElseThrow(() -> new NotFoundException("AnyObject " + type + " " + name));
    }

    @Override
    @Transactional(readOnly=true)
    public Page<AnyObjectTO> search(SearchCond searchCond, Pageable pageable, String realm, boolean recursive, boolean details) {
        if (searchCond.hasAnyTypeCond() == null) {
            throw new UnsupportedOperationException("Need to specify " + AnyType.class.getSimpleName());
        }
        Realm base = (Realm)this.realmSearchDAO.findByFullPath(realm).orElseThrow(() -> new NotFoundException("Realm " + realm));
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.SEARCH.getFor(searchCond.hasAnyTypeCond()))), (String)realm);
        long count = this.searchDAO.count(base, recursive, authRealms, searchCond, AnyTypeKind.ANY_OBJECT);
        List matching = this.searchDAO.search(base, recursive, authRealms, searchCond, pageable, AnyTypeKind.ANY_OBJECT);
        List<AnyObjectTO> result = matching.stream().map(anyObject -> this.binder.getAnyObjectTO(anyObject, details)).toList();
        return new SyncopePage(result, pageable, count);
    }

    public ProvisioningResult<AnyObjectTO> create(AnyObjectCR createReq, boolean nullPriorityAsync) {
        AbstractAnyLogic.BeforeResult<AnyObjectCR> before = this.beforeCreate(createReq);
        if (before.key().getRealm() == null) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
        }
        if (before.key().getType() == null) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
        }
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.CREATE.getFor(before.key().getType()))), (String)before.key().getRealm());
        this.anyObjectDAO.securityChecks(authRealms, null, before.key().getRealm(), (Collection)before.key().getMemberships().stream().filter(Objects::nonNull).map(MembershipTO::getGroupKey).filter(Objects::nonNull).collect(Collectors.toSet()));
        ProvisioningManager.ProvisioningResult created = this.provisioningManager.create((AnyCR)before.key(), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        return this.afterCreate(this.binder.getAnyObjectTO((String)created.key()), created.statuses(), before.actions());
    }

    protected Set<String> groups(AnyObjectTO anyObjectTO) {
        return anyObjectTO.getMemberships().stream().filter(Objects::nonNull).map(MembershipTO::getGroupKey).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public ProvisioningResult<AnyObjectTO> update(AnyObjectUR req, boolean nullPriorityAsync) {
        AnyObjectTO anyObjectTO = this.binder.getAnyObjectTO(req.getKey());
        AbstractAnyLogic.BeforeResult<AnyObjectUR> before = this.beforeUpdate(req, anyObjectTO.getRealm());
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.UPDATE.getFor(anyObjectTO.getType()))), (String)anyObjectTO.getRealm());
        Set<String> groups = this.groups(anyObjectTO);
        groups.removeAll(req.getMemberships().stream().filter(Objects::nonNull).filter(m -> m.getOperation() == PatchOperation.DELETE).map(MembershipUR::getGroup).filter(Objects::nonNull).collect(Collectors.toSet()));
        this.anyObjectDAO.securityChecks(authRealms, before.key().getKey(), anyObjectTO.getRealm(), groups);
        ProvisioningManager.ProvisioningResult after = this.provisioningManager.update((AnyUR)req, Set.of(), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        ProvisioningResult<AnyObjectTO> result = this.afterUpdate(this.binder.getAnyObjectTO(((AnyObjectUR)after.key()).getKey()), after.statuses(), before.actions());
        return result;
    }

    @Override
    public ProvisioningResult<AnyObjectTO> delete(String key, boolean nullPriorityAsync) {
        AnyObjectTO deletedTO;
        AbstractAnyLogic.BeforeResult<AnyObjectTO> before = this.beforeDelete(this.binder.getAnyObjectTO(key));
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.DELETE.getFor(before.key().getType()))), (String)before.key().getRealm());
        this.anyObjectDAO.securityChecks(authRealms, before.key().getKey(), before.key().getRealm(), this.groups(before.key()));
        List statuses = this.provisioningManager.delete(before.key().getKey(), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        if (this.anyObjectDAO.existsById(before.key().getKey())) {
            deletedTO = this.binder.getAnyObjectTO(before.key().getKey());
        } else {
            deletedTO = new AnyObjectTO();
            deletedTO.setKey(before.key().getKey());
        }
        return this.afterDelete(deletedTO, statuses, before.actions());
    }

    protected void updateChecks(String key) {
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.authFind(key);
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.UPDATE.getFor(anyObject.getType().getKey()))), (String)anyObject.getRealm().getFullPath());
        this.anyObjectDAO.securityChecks(authRealms, anyObject.getKey(), anyObject.getRealm().getFullPath(), (Collection)anyObject.getMemberships().stream().map(m -> ((Group)m.getRightEnd()).getKey()).collect(Collectors.toSet()));
    }

    @Override
    public AnyObjectTO unlink(String key, Collection<String> resources) {
        this.updateChecks(key);
        AnyObjectUR req = (AnyObjectUR)((AnyObjectUR.Builder)new AnyObjectUR.Builder(key).resources(resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(r)).build()).toList())).build();
        return this.binder.getAnyObjectTO(this.provisioningManager.unlink((AnyUR)req, AuthContextUtils.getUsername(), "REST"));
    }

    @Override
    public AnyObjectTO link(String key, Collection<String> resources) {
        this.updateChecks(key);
        AnyObjectUR req = (AnyObjectUR)((AnyObjectUR.Builder)new AnyObjectUR.Builder(key).resources(resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(r)).build()).toList())).build();
        return this.binder.getAnyObjectTO(this.provisioningManager.link((AnyUR)req, AuthContextUtils.getUsername(), "REST"));
    }

    @Override
    public ProvisioningResult<AnyObjectTO> unassign(String key, Collection<String> resources, boolean nullPriorityAsync) {
        this.updateChecks(key);
        AnyObjectUR req = (AnyObjectUR)((AnyObjectUR.Builder)new AnyObjectUR.Builder(key).resources(resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(r)).build()).toList())).build();
        return this.update(req, nullPriorityAsync);
    }

    @Override
    public ProvisioningResult<AnyObjectTO> assign(String key, Collection<String> resources, boolean changepwd, String password, boolean nullPriorityAsync) {
        this.updateChecks(key);
        AnyObjectUR req = (AnyObjectUR)((AnyObjectUR.Builder)new AnyObjectUR.Builder(key).resources(resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(r)).build()).toList())).build();
        return this.update(req, nullPriorityAsync);
    }

    @Override
    public ProvisioningResult<AnyObjectTO> deprovision(String key, List<String> resources, boolean nullPriorityAsync) {
        this.updateChecks(key);
        List statuses = this.provisioningManager.deprovision(key, resources, nullPriorityAsync, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getAnyObjectTO(key));
        result.getPropagationStatuses().addAll(statuses);
        result.getPropagationStatuses().sort(Comparator.comparing(item -> resources.indexOf(item.getResource())));
        return result;
    }

    @Override
    public ProvisioningResult<AnyObjectTO> provision(String key, List<String> resources, boolean changePwd, String password, boolean nullPriorityAsync) {
        this.updateChecks(key);
        List statuses = this.provisioningManager.provision(key, resources, nullPriorityAsync, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getAnyObjectTO(key));
        result.getPropagationStatuses().addAll(statuses);
        result.getPropagationStatuses().sort(Comparator.comparing(item -> resources.indexOf(item.getResource())));
        return result;
    }

    @Override
    protected AnyObjectTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (object instanceof AnyObjectTO) {
                    AnyObjectTO anyObjectTO = (AnyObjectTO)object;
                    key = anyObjectTO.getKey();
                    continue;
                }
                object = args[i];
                if (!(object instanceof AnyObjectUR)) continue;
                AnyObjectUR anyObjectUR = (AnyObjectUR)object;
                key = anyObjectUR.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getAnyObjectTO(key);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

