/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf.service;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.core.logic.AnyObjectLogic;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.SCIMDataBinder;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.ListResponse;
import org.apache.syncope.ext.scimv2.api.data.SCIMAnyObject;
import org.apache.syncope.ext.scimv2.api.data.SCIMPatchOp;
import org.apache.syncope.ext.scimv2.api.data.SCIMResource;
import org.apache.syncope.ext.scimv2.api.data.SCIMSearchRequest;
import org.apache.syncope.ext.scimv2.api.service.SCIMAnyObjectService;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.apache.syncope.ext.scimv2.api.type.SortOrder;
import org.apache.syncope.ext.scimv2.cxf.service.AbstractSCIMService;

public class SCIMAnyObjectServiceImpl
extends AbstractSCIMService<SCIMAnyObject>
implements SCIMAnyObjectService {
    public SCIMAnyObjectServiceImpl(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, UserLogic userLogic, GroupLogic groupLogic, AnyObjectLogic anyObjectLogic, SCIMDataBinder binder, SCIMConfManager confManager) {
        super(userDAO, groupDAO, anyObjectDAO, userLogic, groupLogic, anyObjectLogic, binder, confManager);
    }

    public SCIMAnyObject get(String id, String attributes, String excludedAttributes) {
        return this.binder.toSCIMAnyObject(this.anyObjectLogic.read(id), this.uriInfo.getAbsolutePathBuilder().build(new Object[0]).toASCIIString(), List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)attributes, (char)','))), List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)excludedAttributes, (char)','))));
    }

    public ListResponse<SCIMAnyObject> search(String attributes, String excludedAttributes, String filter, String sortBy, SortOrder sortOrder, Integer startIndex, Integer count) {
        Matcher matcher;
        SCIMSearchRequest request = new SCIMSearchRequest(filter, sortBy, sortOrder, startIndex, count);
        if (attributes != null) {
            request.getAttributes().addAll(List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)attributes, (char)','))));
        }
        if (excludedAttributes != null) {
            request.getExcludedAttributes().addAll(List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)excludedAttributes, (char)','))));
        }
        if ((matcher = Pattern.compile("type\\s+eq\\s+\"(.*?)\"").matcher(filter)).find()) {
            return this.doSearch(matcher.group(1), request);
        }
        throw new UnsupportedOperationException("Need to specify type");
    }

    public ListResponse<SCIMAnyObject> search(SCIMSearchRequest request) {
        Matcher matcher = Pattern.compile("type\\s+eq\\s+\"(.*?)\"").matcher(request.getFilter());
        if (matcher.find()) {
            return this.doSearch(matcher.group(1), request);
        }
        throw new UnsupportedOperationException("Need to specify type");
    }

    public Response create(SCIMAnyObject anyObject) {
        ProvisioningResult result = this.anyObjectLogic.create(this.binder.toAnyObjectCR(anyObject), false);
        return this.createResponse(((AnyObjectTO)result.getEntity()).getKey(), (SCIMResource)this.binder.toSCIMAnyObject((AnyObjectTO)result.getEntity(), this.uriInfo.getAbsolutePathBuilder().path(((AnyObjectTO)result.getEntity()).getKey()).build(new Object[0]).toASCIIString(), List.of(), List.of()));
    }

    public Response update(String id, SCIMPatchOp patch) {
        SCIMResource resource = this.getResource(id);
        Response.ResponseBuilder builder = this.checkETag("urn:ietf:params:scim:schemas:extension:syncope:2.0:" + (String)resource.getSchemas().getFirst(), id);
        if (builder != null) {
            return builder.build();
        }
        patch.getOperations().forEach(op -> {
            AnyObjectUR update = this.binder.toAnyObjectUR(this.anyObjectLogic.read(id), op);
            this.anyObjectLogic.update(update, false);
        });
        return this.updateResponse(id, null, true);
    }

    public Response replace(String id, SCIMAnyObject anyObject) {
        if (!id.equals(anyObject.getId())) {
            throw new BadRequestException(ErrorType.invalidPath, "Expected " + id + ", found " + anyObject.getId());
        }
        SCIMResource resource = this.getResource(id);
        Response.ResponseBuilder builder = this.checkETag("urn:ietf:params:scim:schemas:extension:syncope:2.0:" + (String)resource.getSchemas().getFirst(), id);
        if (builder != null) {
            return builder.build();
        }
        AnyObjectTO before = this.anyObjectLogic.read(id);
        AnyObjectUR req = AnyOperations.diff((AnyObjectTO)this.binder.toAnyObjectTO(anyObject, true), (AnyObjectTO)before, (boolean)false);
        req.getResources().clear();
        req.getAuxClasses().clear();
        req.getRelationships().clear();
        ProvisioningResult result = this.anyObjectLogic.update(req, false);
        return this.updateResponse(((AnyObjectTO)result.getEntity()).getKey(), (SCIMResource)this.binder.toSCIMAnyObject((AnyObjectTO)result.getEntity(), this.uriInfo.getAbsolutePathBuilder().path(((AnyObjectTO)result.getEntity()).getKey()).build(new Object[0]).toASCIIString(), List.of(), List.of()), false);
    }

    public Response delete(String id) {
        SCIMResource resource = this.getResource(id);
        Response.ResponseBuilder builder = this.checkETag("urn:ietf:params:scim:schemas:extension:syncope:2.0:" + (String)resource.getSchemas().getFirst(), id);
        if (builder != null) {
            return builder.build();
        }
        this.anyObjectLogic.delete(id, false);
        return Response.noContent().build();
    }

    @Override
    protected SCIMResource getResource(String key) {
        return this.binder.toSCIMAnyObject(this.anyObjectLogic.read(key), this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0]).toASCIIString(), List.of(), List.of());
    }
}

