/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.thymeleaf.context.WebEngineContext;

public class CasThymeleafTemplatesDirector {
    private final CasWebflowExecutionPlan webflowExecutionPlan;

    public String getUrlExternalForm(URL url) {
        String externalForm = url.toExternalForm();
        if (externalForm.contains("?")) {
            return externalForm + "&";
        }
        return externalForm + "?";
    }

    public String getExceptionClassSimpleName(Throwable ex) {
        return ex.getClass().getSimpleName();
    }

    public boolean isLoginFormViewable(WebEngineContext vars) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        Collection providers = this.webflowExecutionPlan.getWebflowLoginContextProviders();
        return requestContext != null && (WebUtils.isCasLoginFormViewable((RequestContext)requestContext) || providers.isEmpty() || providers.stream().noneMatch(provider -> provider.isLoginFormViewable(requestContext)));
    }

    public boolean isLoginFormUsernameInputVisible(WebEngineContext vars) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        Collection providers = this.webflowExecutionPlan.getWebflowLoginContextProviders();
        return requestContext != null && (WebUtils.isCasLoginFormViewable((RequestContext)requestContext) || providers.isEmpty() || providers.stream().anyMatch(provider -> provider.isLoginFormUsernameInputVisible(requestContext)));
    }

    public boolean isLoginFormUsernameInputDisabled(WebEngineContext vars) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        return requestContext == null || !WebUtils.isCasLoginFormViewable((RequestContext)requestContext) || WebUtils.isGraphicalUserAuthenticationEnabled((RequestContext)requestContext) || this.webflowExecutionPlan.getWebflowLoginContextProviders().stream().anyMatch(provider -> provider.isLoginFormUsernameInputDisabled(requestContext));
    }

    public String getLoginFormUsername(WebEngineContext vars) {
        RequestContext context = RequestContextHolder.getRequestContext();
        if (context != null && WebUtils.isCasLoginFormViewable((RequestContext)context)) {
            return this.webflowExecutionPlan.getWebflowLoginContextProviders().stream().map(provider -> provider.getCandidateUsername(context)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse("");
        }
        return "";
    }

    public String format(LocalDateTime dateTime, String pattern) {
        return dateTime.format(DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH));
    }

    @Generated
    public CasThymeleafTemplatesDirector(CasWebflowExecutionPlan webflowExecutionPlan) {
        this.webflowExecutionPlan = webflowExecutionPlan;
    }
}

