/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.X509Certificate;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.principal.AbstractX509PrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;

public class X509SerialNumberAndIssuerDNPrincipalResolver
extends AbstractX509PrincipalResolver {
    private String serialNumberPrefix = "SERIALNUMBER=";
    private String valueDelimiter = ", ";

    public X509SerialNumberAndIssuerDNPrincipalResolver(PrincipalResolutionContext context) {
        super(context);
    }

    @Override
    protected String resolvePrincipalInternal(X509Certificate certificate) {
        return this.serialNumberPrefix + String.valueOf(certificate.getSerialNumber()) + this.valueDelimiter + certificate.getIssuerDN().getName();
    }

    @Override
    @Generated
    public String toString() {
        return "X509SerialNumberAndIssuerDNPrincipalResolver(super=" + super.toString() + ", serialNumberPrefix=" + this.serialNumberPrefix + ", valueDelimiter=" + this.valueDelimiter + ")";
    }

    @Generated
    public void setSerialNumberPrefix(String serialNumberPrefix) {
        this.serialNumberPrefix = serialNumberPrefix;
    }

    @Generated
    public void setValueDelimiter(String valueDelimiter) {
        this.valueDelimiter = valueDelimiter;
    }
}

