/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRemoteLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationServerResult;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationServerResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AssuredReplicationResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String ASSURED_REPLICATION_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.29";
    private static final byte TYPE_LOCAL_LEVEL = -128;
    private static final byte TYPE_LOCAL_SATISFIED = -127;
    private static final byte TYPE_LOCAL_MESSAGE = -126;
    private static final byte TYPE_REMOTE_LEVEL = -125;
    private static final byte TYPE_REMOTE_SATISFIED = -124;
    private static final byte TYPE_REMOTE_MESSAGE = -123;
    private static final byte TYPE_CSN = -122;
    private static final byte TYPE_SERVER_RESULTS = -89;
    @NotNull
    private static final String JSON_FIELD_CSN = "csn";
    @NotNull
    private static final String JSON_FIELD_LOCAL_LEVEL = "local-level";
    @NotNull
    private static final String JSON_FIELD_LOCAL_ASSURANCE_SATISFIED = "local-assurance-satisfied";
    @NotNull
    private static final String JSON_FIELD_LOCAL_ASSURANCE_MESSAGE = "local-assurance-message";
    @NotNull
    private static final String JSON_FIELD_REMOTE_LEVEL = "remote-level";
    @NotNull
    private static final String JSON_FIELD_REMOTE_ASSURANCE_SATISFIED = "remote-assurance-satisfied";
    @NotNull
    private static final String JSON_FIELD_REMOTE_ASSURANCE_MESSAGE = "remote-assurance-message";
    @NotNull
    private static final String JSON_FIELD_SERVER_RESULTS = "server-results";
    @NotNull
    private static final String JSON_FIELD_SERVER_RESULTS_RESULT_CODE_VALUE = "result-code-value";
    @NotNull
    private static final String JSON_FIELD_SERVER_RESULTS_RESULT_CODE_NAME = "result-code-name";
    @NotNull
    private static final String JSON_FIELD_SERVER_RESULTS_REPLICA_ID = "replica-id";
    @NotNull
    private static final String JSON_FIELD_SERVER_RESULTS_REPLICATION_SERVER_ID = "replication-server-id";
    private static final long serialVersionUID = -4521456074629871607L;
    @Nullable
    private final AssuredReplicationLocalLevel localLevel;
    @Nullable
    private final AssuredReplicationRemoteLevel remoteLevel;
    private final boolean localAssuranceSatisfied;
    private final boolean remoteAssuranceSatisfied;
    @NotNull
    private final List<AssuredReplicationServerResult> serverResults;
    @Nullable
    private final String csn;
    @Nullable
    private final String localAssuranceMessage;
    @Nullable
    private final String remoteAssuranceMessage;

    AssuredReplicationResponseControl() {
        this.localLevel = null;
        this.localAssuranceSatisfied = false;
        this.localAssuranceMessage = null;
        this.remoteLevel = null;
        this.remoteAssuranceSatisfied = false;
        this.remoteAssuranceMessage = null;
        this.csn = null;
        this.serverResults = null;
    }

    public AssuredReplicationResponseControl(@Nullable AssuredReplicationLocalLevel localLevel, boolean localAssuranceSatisfied, @Nullable String localAssuranceMessage, @Nullable AssuredReplicationRemoteLevel remoteLevel, boolean remoteAssuranceSatisfied, @Nullable String remoteAssuranceMessage, @Nullable String csn, @Nullable Collection<AssuredReplicationServerResult> serverResults) {
        super(ASSURED_REPLICATION_RESPONSE_OID, false, AssuredReplicationResponseControl.encodeValue(localLevel, localAssuranceSatisfied, localAssuranceMessage, remoteLevel, remoteAssuranceSatisfied, remoteAssuranceMessage, csn, serverResults));
        this.localLevel = localLevel;
        this.localAssuranceSatisfied = localAssuranceSatisfied;
        this.localAssuranceMessage = localAssuranceMessage;
        this.remoteLevel = remoteLevel;
        this.remoteAssuranceSatisfied = remoteAssuranceSatisfied;
        this.remoteAssuranceMessage = remoteAssuranceMessage;
        this.csn = csn;
        this.serverResults = serverResults == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<AssuredReplicationServerResult>(serverResults));
    }

    public AssuredReplicationResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_NO_VALUE.get());
        }
        AssuredReplicationLocalLevel lLevel = null;
        Boolean lSatisfied = null;
        String lMessage = null;
        AssuredReplicationRemoteLevel rLevel = null;
        Boolean rSatisfied = null;
        String rMessage = null;
        String seqNum = null;
        List<Object> sResults = Collections.emptyList();
        try {
            block15: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        int intValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        lLevel = AssuredReplicationLocalLevel.valueOf(intValue);
                        if (lLevel != null) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_INVALID_LOCAL_LEVEL.get(intValue));
                    }
                    case -127: {
                        lSatisfied = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block15;
                    }
                    case -126: {
                        lMessage = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block15;
                    }
                    case -125: {
                        int intValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        rLevel = AssuredReplicationRemoteLevel.valueOf(intValue);
                        if (lLevel != null) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_INVALID_REMOTE_LEVEL.get(intValue));
                    }
                    case -124: {
                        rSatisfied = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block15;
                    }
                    case -123: {
                        rMessage = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block15;
                    }
                    case -122: {
                        seqNum = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block15;
                    }
                    case -89: {
                        ASN1Element[] srElements = ASN1Sequence.decodeAsSequence(e).elements();
                        ArrayList<AssuredReplicationServerResult> srList = new ArrayList<AssuredReplicationServerResult>(srElements.length);
                        for (ASN1Element srElement : srElements) {
                            try {
                                srList.add(AssuredReplicationServerResult.decode(srElement));
                            }
                            catch (Exception ex) {
                                Debug.debugException(ex);
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_ERROR_DECODING_SR.get(StaticUtils.getExceptionMessage(ex)), ex);
                            }
                        }
                        sResults = Collections.unmodifiableList(srList);
                        continue block15;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_UNEXPECTED_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (lSatisfied == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_NO_LOCAL_SATISFIED.get());
        }
        if (rSatisfied == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_NO_REMOTE_SATISFIED.get());
        }
        this.localLevel = lLevel;
        this.localAssuranceSatisfied = lSatisfied;
        this.localAssuranceMessage = lMessage;
        this.remoteLevel = rLevel;
        this.remoteAssuranceSatisfied = rSatisfied;
        this.remoteAssuranceMessage = rMessage;
        this.csn = seqNum;
        this.serverResults = sResults;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable AssuredReplicationLocalLevel localLevel, boolean localAssuranceSatisfied, @Nullable String localAssuranceMessage, @Nullable AssuredReplicationRemoteLevel remoteLevel, boolean remoteAssuranceSatisfied, @Nullable String remoteAssuranceMessage, @Nullable String csn, @Nullable Collection<AssuredReplicationServerResult> serverResults) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(8);
        if (localLevel != null) {
            elements.add(new ASN1Enumerated(-128, localLevel.intValue()));
        }
        elements.add(new ASN1Boolean(-127, localAssuranceSatisfied));
        if (localAssuranceMessage != null) {
            elements.add(new ASN1OctetString(-126, localAssuranceMessage));
        }
        if (remoteLevel != null) {
            elements.add(new ASN1Enumerated(-125, remoteLevel.intValue()));
        }
        elements.add(new ASN1Boolean(-124, remoteAssuranceSatisfied));
        if (remoteAssuranceMessage != null) {
            elements.add(new ASN1OctetString(-123, remoteAssuranceMessage));
        }
        if (csn != null) {
            elements.add(new ASN1OctetString(-122, csn));
        }
        if (serverResults != null && !serverResults.isEmpty()) {
            ArrayList<ASN1Element> srElements = new ArrayList<ASN1Element>(serverResults.size());
            for (AssuredReplicationServerResult r : serverResults) {
                srElements.add(r.encode());
            }
            elements.add(new ASN1Sequence(-89, srElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Override
    @NotNull
    public AssuredReplicationResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new AssuredReplicationResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static AssuredReplicationResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(ASSURED_REPLICATION_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof AssuredReplicationResponseControl) {
            return (AssuredReplicationResponseControl)c;
        }
        return new AssuredReplicationResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    public static List<AssuredReplicationResponseControl> getAll(@NotNull LDAPResult result) throws LDAPException {
        Control[] controls = result.getResponseControls();
        ArrayList<AssuredReplicationResponseControl> decodedControls = new ArrayList<AssuredReplicationResponseControl>(controls.length);
        for (Control c : controls) {
            if (!c.getOID().equals(ASSURED_REPLICATION_RESPONSE_OID)) continue;
            if (c instanceof AssuredReplicationResponseControl) {
                decodedControls.add((AssuredReplicationResponseControl)c);
                continue;
            }
            decodedControls.add(new AssuredReplicationResponseControl(c.getOID(), c.isCritical(), c.getValue()));
        }
        return Collections.unmodifiableList(decodedControls);
    }

    @Nullable
    public AssuredReplicationLocalLevel getLocalLevel() {
        return this.localLevel;
    }

    public boolean localAssuranceSatisfied() {
        return this.localAssuranceSatisfied;
    }

    @Nullable
    public String getLocalAssuranceMessage() {
        return this.localAssuranceMessage;
    }

    @Nullable
    public AssuredReplicationRemoteLevel getRemoteLevel() {
        return this.remoteLevel;
    }

    public boolean remoteAssuranceSatisfied() {
        return this.remoteAssuranceSatisfied;
    }

    @Nullable
    public String getRemoteAssuranceMessage() {
        return this.remoteAssuranceMessage;
    }

    @Nullable
    public String getCSN() {
        return this.csn;
    }

    @NotNull
    public List<AssuredReplicationServerResult> getServerResults() {
        return this.serverResults;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ASSURED_REPLICATION_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> jsonValueFields = new LinkedHashMap<String, JSONValue>();
        if (this.localLevel != null) {
            jsonValueFields.put(JSON_FIELD_LOCAL_LEVEL, new JSONString(this.localLevel.getName()));
        }
        jsonValueFields.put(JSON_FIELD_LOCAL_ASSURANCE_SATISFIED, new JSONBoolean(this.localAssuranceSatisfied));
        if (this.localAssuranceMessage != null) {
            jsonValueFields.put(JSON_FIELD_LOCAL_ASSURANCE_MESSAGE, new JSONString(this.localAssuranceMessage));
        }
        if (this.remoteLevel != null) {
            jsonValueFields.put(JSON_FIELD_REMOTE_LEVEL, new JSONString(this.remoteLevel.getName()));
        }
        jsonValueFields.put(JSON_FIELD_REMOTE_ASSURANCE_SATISFIED, new JSONBoolean(this.remoteAssuranceSatisfied));
        if (this.remoteAssuranceMessage != null) {
            jsonValueFields.put(JSON_FIELD_REMOTE_ASSURANCE_MESSAGE, new JSONString(this.remoteAssuranceMessage));
        }
        if (this.csn != null) {
            jsonValueFields.put(JSON_FIELD_CSN, new JSONString(this.csn));
        }
        if (this.serverResults != null && !this.serverResults.isEmpty()) {
            ArrayList<JSONObject> serverResultValues = new ArrayList<JSONObject>(this.serverResults.size());
            for (AssuredReplicationServerResult serverResult : this.serverResults) {
                Short replicaID;
                LinkedHashMap<String, JSONValue> serverResultFields = new LinkedHashMap<String, JSONValue>();
                serverResultFields.put(JSON_FIELD_SERVER_RESULTS_RESULT_CODE_VALUE, new JSONNumber(serverResult.getResultCode().intValue()));
                serverResultFields.put(JSON_FIELD_SERVER_RESULTS_RESULT_CODE_NAME, new JSONString(serverResult.getResultCode().name()));
                Short replicationServerID = serverResult.getReplicationServerID();
                if (replicationServerID != null) {
                    serverResultFields.put(JSON_FIELD_SERVER_RESULTS_REPLICATION_SERVER_ID, new JSONNumber(replicationServerID.longValue()));
                }
                if ((replicaID = serverResult.getReplicaID()) != null) {
                    serverResultFields.put(JSON_FIELD_SERVER_RESULTS_REPLICA_ID, new JSONNumber(replicaID.longValue()));
                }
                serverResultValues.add(new JSONObject(serverResultFields));
            }
            jsonValueFields.put(JSON_FIELD_SERVER_RESULTS, new JSONArray(serverResultValues));
        }
        return new JSONObject(new JSONField("oid", ASSURED_REPLICATION_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_ASSURED_REPLICATION_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(jsonValueFields)));
    }

    @NotNull
    public static AssuredReplicationResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new AssuredReplicationResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        AssuredReplicationLocalLevel localLevel = null;
        AssuredReplicationRemoteLevel remoteLevel = null;
        Boolean localAssuranceSatisfied = null;
        Boolean remoteAssuranceSatisfied = null;
        String csn = null;
        String localAssuranceMessage = null;
        String remoteAssuranceMessage = null;
        ArrayList<AssuredReplicationServerResult> serverResults = new ArrayList<AssuredReplicationServerResult>();
        JSONObject valueObject = jsonControl.getValueObject();
        String localLevelStr = valueObject.getFieldAsString(JSON_FIELD_LOCAL_LEVEL);
        if (localLevelStr != null && (localLevel = AssuredReplicationLocalLevel.forName(localLevelStr)) == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_JSON_INVALID_LOCAL_LEVEL.get(controlObject.toSingleLineString(), localLevelStr));
        }
        localAssuranceSatisfied = valueObject.getFieldAsBoolean(JSON_FIELD_LOCAL_ASSURANCE_SATISFIED);
        if (localAssuranceSatisfied == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_JSON_MISSING_VALUE_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_LOCAL_ASSURANCE_SATISFIED));
        }
        localAssuranceMessage = valueObject.getFieldAsString(JSON_FIELD_LOCAL_ASSURANCE_MESSAGE);
        String remoteLevelStr = valueObject.getFieldAsString(JSON_FIELD_REMOTE_LEVEL);
        if (remoteLevelStr != null && (remoteLevel = AssuredReplicationRemoteLevel.forName(remoteLevelStr)) == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_JSON_INVALID_REMOTE_LEVEL.get(controlObject.toSingleLineString(), remoteLevelStr));
        }
        remoteAssuranceSatisfied = valueObject.getFieldAsBoolean(JSON_FIELD_REMOTE_ASSURANCE_SATISFIED);
        if (remoteAssuranceSatisfied == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_JSON_MISSING_VALUE_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_REMOTE_ASSURANCE_SATISFIED));
        }
        remoteAssuranceMessage = valueObject.getFieldAsString(JSON_FIELD_REMOTE_ASSURANCE_MESSAGE);
        csn = valueObject.getFieldAsString(JSON_FIELD_CSN);
        List<JSONValue> serverResultValues = valueObject.getFieldAsArray(JSON_FIELD_SERVER_RESULTS);
        if (serverResultValues != null) {
            for (JSONValue serverResultValue : serverResultValues) {
                serverResults.add(AssuredReplicationResponseControl.decodeServerResult(controlObject, serverResultValue, strict));
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_LOCAL_LEVEL, JSON_FIELD_LOCAL_ASSURANCE_SATISFIED, JSON_FIELD_LOCAL_ASSURANCE_MESSAGE, JSON_FIELD_REMOTE_LEVEL, JSON_FIELD_REMOTE_ASSURANCE_SATISFIED, JSON_FIELD_REMOTE_ASSURANCE_MESSAGE, JSON_FIELD_CSN, JSON_FIELD_SERVER_RESULTS)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_JSON_UNRECOGNIZED_VALUE_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new AssuredReplicationResponseControl(localLevel, localAssuranceSatisfied, localAssuranceMessage, remoteLevel, remoteAssuranceSatisfied, remoteAssuranceMessage, csn, serverResults);
    }

    @NotNull
    private static AssuredReplicationServerResult decodeServerResult(@NotNull JSONObject controlObject, @NotNull JSONValue serverResultValue, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        if (!(serverResultValue instanceof JSONObject)) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_JSON_SERVER_RESULT_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_SERVER_RESULTS));
        }
        JSONObject resultObject = (JSONObject)serverResultValue;
        Integer resultCodeValue = resultObject.getFieldAsInteger(JSON_FIELD_SERVER_RESULTS_RESULT_CODE_VALUE);
        if (resultCodeValue == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_JSON_SERVER_RESULT_NO_RC.get(controlObject.toSingleLineString(), JSON_FIELD_SERVER_RESULTS_RESULT_CODE_VALUE));
        }
        AssuredReplicationServerResultCode resultCode = AssuredReplicationServerResultCode.valueOf(resultCodeValue);
        if (resultCode == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_JSON_SERVER_RESULT_UNKNOWN_RC.get(controlObject.toSingleLineString(), resultCodeValue));
        }
        Integer replicationServerID = resultObject.getFieldAsInteger(JSON_FIELD_SERVER_RESULTS_REPLICATION_SERVER_ID);
        Integer replicaID = resultObject.getFieldAsInteger(JSON_FIELD_SERVER_RESULTS_REPLICA_ID);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(resultObject, JSON_FIELD_SERVER_RESULTS_RESULT_CODE_VALUE, JSON_FIELD_SERVER_RESULTS_RESULT_CODE_NAME, JSON_FIELD_SERVER_RESULTS_REPLICATION_SERVER_ID, JSON_FIELD_SERVER_RESULTS_REPLICA_ID)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_RESPONSE_JSON_UNRECOGNIZED_SR_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new AssuredReplicationServerResult(resultCode, replicationServerID != null ? Short.valueOf(replicationServerID.shortValue()) : null, replicaID != null ? Short.valueOf(replicaID.shortValue()) : null);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AssuredReplicationResponseControl(isCritical=");
        buffer.append(this.isCritical());
        if (this.localLevel != null) {
            buffer.append(", localLevel=");
            buffer.append(this.localLevel.name());
        }
        buffer.append(", localAssuranceSatisfied=");
        buffer.append(this.localAssuranceSatisfied);
        if (this.localAssuranceMessage != null) {
            buffer.append(", localMessage='");
            buffer.append(this.localAssuranceMessage);
            buffer.append('\'');
        }
        if (this.remoteLevel != null) {
            buffer.append(", remoteLevel=");
            buffer.append(this.remoteLevel.name());
        }
        buffer.append(", remoteAssuranceSatisfied=");
        buffer.append(this.remoteAssuranceSatisfied);
        if (this.remoteAssuranceMessage != null) {
            buffer.append(", remoteMessage='");
            buffer.append(this.remoteAssuranceMessage);
            buffer.append('\'');
        }
        if (this.csn != null) {
            buffer.append(", csn='");
            buffer.append(this.csn);
            buffer.append('\'');
        }
        if (this.serverResults != null && !this.serverResults.isEmpty()) {
            buffer.append(", serverResults={");
            Iterator<AssuredReplicationServerResult> iterator = this.serverResults.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(buffer);
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

