/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.IOException;
import java.io.Serializable;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaRaftServer$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(types={Type.KRAFT})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\u0004\b\u00011A\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001\u0006\u0005\u00065\u0001!\ta\u0007\u0005\u0006?\u0001!\t\u0001\t\u0005\u0006e\u0001!\t\u0001\t\u0005\u0006i\u0001!I!\u000e\u0002\u001a\t\u0016\u001c8M]5cKF+xN];n%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\t\u0013\u000511/\u001a:wKJT\u0011AC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VMZ\u0001\bG2,8\u000f^3s!\t)\u0002$D\u0001\u0017\u0015\t9\u0012\"\u0001\u0003uKN$\u0018BA\r\u0017\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002\u001d=A\u0011Q\u0004A\u0007\u0002\u000f!)1C\u0001a\u0001)\u0005IC/Z:u\t\u0016\u001c8M]5cKF+xN];n\u001d>$8+\u001e9q_J$X\r\u001a\"z5.\u0014%o\\6feN$\u0012!\t\t\u0003\u001d\tJ!aI\b\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0007\u0015ZC\u0006\u0005\u0002'S5\tqE\u0003\u0002)-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005):#aC\"mkN$XM\u001d+fgR\fQ\u0001^=qKNd\u0013!\f\u0013\u0002]%\u0011q\u0006M\u0001\u00035.S!!M\u0014\u0002\tQK\b/Z\u0001\u0013i\u0016\u001cH\u000fR3tGJL'-Z)v_J,X\u000e\u000b\u0002\u0005K\u0005\t2m\u001c8oK\u000e$\u0018I\u001c3SK\u000e,\u0017N^3\u0016\u0005YRDCA\u001cV)\tAT\n\u0005\u0002:u1\u0001A!B\u001e\u0006\u0005\u0004a$!\u0001+\u0012\u0005u\u0002\u0005C\u0001\b?\u0013\tytBA\u0004O_RD\u0017N\\4\u0011\u0005\u0005[U\"\u0001\"\u000b\u0005\r#\u0015\u0001\u0003:fcV,7\u000f^:\u000b\u0005\u00153\u0015AB2p[6|gN\u0003\u0002\u000b\u000f*\u0011\u0001*S\u0001\u0007CB\f7\r[3\u000b\u0003)\u000b1a\u001c:h\u0013\ta%I\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\")a*\u0002a\u0002\u001f\u0006A1\r\\1tgR\u000bw\rE\u0002Q'bj\u0011!\u0015\u0006\u0003%>\tqA]3gY\u0016\u001cG/\u0003\u0002U#\nA1\t\\1tgR\u000bw\rC\u0003W\u000b\u0001\u0007q+A\u0004sKF,Xm\u001d;\u0011\u0005\u0005C\u0016BA-C\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\u0006\u0002\u0001\\K\u001a\u0004\"\u0001X2\u000e\u0003uS!AX0\u0002\u0007\u0005\u0004\u0018N\u0003\u0002aC\u00069!.\u001e9ji\u0016\u0014(B\u00012J\u0003\u0015QWO\\5u\u0013\t!WLA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003aDC\u0001\u00015f]B\u0011\u0011\u000e\\\u0007\u0002U*\u00111.X\u0001\nKb$XM\\:j_:L!!\u001c6\u0003\u0015\u0015CH/\u001a8e/&$\b\u000eL\u0001pG\u0005\u0001\bCA9t\u001b\u0005\u0011(B\u00012\u0017\u0013\t!(OA\u000bDYV\u001cH/\u001a:UKN$X\t\u001f;f]NLwN\\:)\t\u000118&\u001f\t\u0003M]L!\u0001_\u0014\u0003'\rcWo\u001d;feR+7\u000f\u001e#fM\u0006,H\u000e^:-\u0003i$\u0013a_\u0005\u0003yB\nQa\u0013*B\rRCS\u0001\u0001@f\u0003\u0007\u0001\"\u0001X@\n\u0007\u0005\u0005QLA\u0002UC\u001e\f#!!\u0002\u0002\u0017%tG/Z4sCRLwN\u001c")
public class DescribeQuorumRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest(types={Type.ZK})
    public void testDescribeQuorumNotSupportedByZkBrokers() {
        ApiVersionsRequest apiRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        Assertions.assertNull((Object)((ApiVersionsResponse)this.connectAndReceive((AbstractRequest)apiRequest, ClassTag$.MODULE$.apply(ApiVersionsResponse.class))).apiVersion(ApiKeys.DESCRIBE_QUORUM.id));
        DescribeQuorumRequest describeQuorumRequest = (DescribeQuorumRequest)new DescribeQuorumRequest.Builder(DescribeQuorumRequest.singletonRequest((TopicPartition)KafkaRaftServer$.MODULE$.MetadataPartition())).build();
        Assertions.assertThrows(IOException.class, () -> this.connectAndReceive((AbstractRequest)describeQuorumRequest, ClassTag$.MODULE$.apply(DescribeQuorumResponse.class)));
    }

    @ClusterTest
    public void testDescribeQuorum() {
        CollectionConverters$.MODULE$.ListHasAsScala(ApiKeys.DESCRIBE_QUORUM.allVersions()).asScala().foreach((Function1 & Serializable)version -> {
            DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$1(this, version);
            return BoxedUnit.UNIT;
        });
    }

    private <T extends AbstractResponse> T connectAndReceive(AbstractRequest request, ClassTag<T> classTag) {
        return IntegrationTestUtils$.MODULE$.connectAndReceive(request, (SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener(), classTag);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorum$2(int leaderId$1, DescribeQuorumResponseData.ReplicaState x$1) {
        return x$1.replicaId() == leaderId$1;
    }

    public static final /* synthetic */ void $anonfun$testDescribeQuorum$6(Short version$1, DescribeQuorumResponseData.ReplicaState state) {
        Assertions.assertTrue((0L < state.logEndOffset() ? 1 : 0) != 0);
        if (BoxesRunTime.equalsNumObject((Number)version$1, (Object)BoxesRunTime.boxToInteger((int)0))) {
            Assertions.assertEquals((long)-1L, (long)state.lastFetchTimestamp());
            Assertions.assertEquals((long)-1L, (long)state.lastCaughtUpTimestamp());
            return;
        }
        Assertions.assertNotEquals((long)-1L, (long)state.lastFetchTimestamp());
        Assertions.assertNotEquals((long)-1L, (long)state.lastCaughtUpTimestamp());
    }

    public static final /* synthetic */ void $anonfun$testDescribeQuorum$1(DescribeQuorumRequestTest $this, Short version) {
        DescribeQuorumRequest request = new DescribeQuorumRequest.Builder(DescribeQuorumRequest.singletonRequest((TopicPartition)KafkaRaftServer$.MODULE$.MetadataPartition())).build(Predef$.MODULE$.Short2short(version));
        DescribeQuorumResponse response = (DescribeQuorumResponse)$this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(DescribeQuorumResponse.class));
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)response.data().errorCode()));
        Assertions.assertEquals((int)1, (int)response.data().topics().size());
        DescribeQuorumResponseData.TopicData topicData = (DescribeQuorumResponseData.TopicData)response.data().topics().get(0);
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopic(), (Object)topicData.topicName());
        Assertions.assertEquals((int)1, (int)topicData.partitions().size());
        DescribeQuorumResponseData.PartitionData partitionData = (DescribeQuorumResponseData.PartitionData)topicData.partitions().get(0);
        Assertions.assertEquals((int)KafkaRaftServer$.MODULE$.MetadataPartition().partition(), (int)partitionData.partitionIndex());
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionData.errorCode()));
        Assertions.assertTrue((partitionData.leaderEpoch() > 0 ? 1 : 0) != 0);
        int leaderId = partitionData.leaderId();
        Assertions.assertTrue((leaderId > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((partitionData.leaderEpoch() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((((DescribeQuorumResponseData.ReplicaState)CollectionConverters$.MODULE$.ListHasAsScala(partitionData.currentVoters()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$2(leaderId, x$1))).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)"Failed to find leader among current voter states");
        })).logEndOffset() > 0L ? 1 : 0) != 0);
        Buffer voterData = CollectionConverters$.MODULE$.ListHasAsScala(partitionData.currentVoters()).asScala();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala($this.cluster.controllerIds()).asScala(), (Object)((IterableOnceOps)voterData.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.replicaId()))).toSet());
        Buffer observerData = CollectionConverters$.MODULE$.ListHasAsScala(partitionData.observers()).asScala();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala($this.cluster.brokerIds()).asScala(), (Object)((IterableOnceOps)observerData.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.replicaId()))).toSet());
        ((IterableOnceOps)voterData.$plus$plus((IterableOnce)observerData)).foreach((Function1 & Serializable)state -> {
            DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$6(version, state);
            return BoxedUnit.UNIT;
        });
    }

    public DescribeQuorumRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

