/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i3Aa\u0005\u000b\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0003)\u0003BB\u0015\u0001A\u0003%a\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\t\r=\u0002\u0001\u0015!\u0003-\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015\u0011\u0005\u0001\"\u00012\u0011\u0015!\u0005\u0001\"\u00012\u0011\u00151\u0005\u0001\"\u00012\u0011\u0015A\u0005\u0001\"\u00012\u0011\u0015Q\u0005\u0001\"\u00012\u0011\u0015a\u0005\u0001\"\u00012\u0011\u0015q\u0005\u0001\"\u00012\u0011\u0015\u0001\u0006\u0001\"\u00012\u0011\u0015\u0011\u0006\u0001\"\u00012\u0011\u0015!\u0006\u0001\"\u00012\u0011\u00151\u0006\u0001\"\u00012\u0011\u0015A\u0006\u0001\"\u00012\u0005\u0011\u001auN\u001c;s_2dWM]\"p]\u001aLw-\u001e:bi&|gNV1mS\u0012\fGo\u001c:UKN$(BA\u000b\u0017\u0003\u0019\u0019XM\u001d<fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002)\u000511m\u001c8gS\u001e,\u0012A\n\t\u0003G\u001dJ!\u0001\u000b\u000b\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003%1\u0018\r\\5eCR|'/F\u0001-!\t\u0019S&\u0003\u0002/)\t\u00013i\u001c8ue>dG.\u001a:D_:4\u0017nZ;sCRLwN\u001c,bY&$\u0017\r^8s\u0003)1\u0018\r\\5eCR|'\u000fI\u0001#i\u0016\u001cH\u000fR3gCVdG\u000fV8qS\u000e\u0014Vm]8ve\u000e,\u0017j\u001d*fU\u0016\u001cG/\u001a3\u0015\u0003I\u0002\"aG\u001a\n\u0005Qb\"\u0001B+oSRD#A\u0002\u001c\u0011\u0005]\u0002U\"\u0001\u001d\u000b\u0005eR\u0014aA1qS*\u00111\bP\u0001\bUV\u0004\u0018\u000e^3s\u0015\tid(A\u0003kk:LGOC\u0001@\u0003\ry'oZ\u0005\u0003\u0003b\u0012A\u0001V3ti\u0006aB/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019(b[\u0016\u0014VM[3di\u0016$\u0007FA\u00047\u0003]!Xm\u001d;V].twn\u001e8SKN|WO]2f)f\u0004X\r\u000b\u0002\tm\u0005AB/Z:u\u001dVdG\u000eV8qS\u000e\u001cuN\u001c4jOZ\u000bG.^3)\u0005%1\u0014\u0001\u0006;fgR4\u0016\r\\5e)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\u000bm\u00051B/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\fm\u00059B/Z:u\u0013:4\u0018\r\\5e\u0005J|7.\u001a:F]RLG/\u001f\u0015\u0003\u0019Y\n1\u0004^3ti&sg/\u00197jI:+w-\u0019;jm\u0016\u0014%o\\6fe&#\u0007FA\u00077\u0003q!Xm\u001d;WC2LGm\u00117jK:$X*\u001a;sS\u000e\u001c8i\u001c8gS\u001eD#A\u0004\u001c\u0002]Q,7\u000f^%om\u0006d\u0017\u000eZ*vEN\u001c'/\u001b9uS>tg*Y7f\u00072LWM\u001c;NKR\u0014\u0018nY:D_:4\u0017n\u001a\u0015\u0003\u001fY\na\u0005^3ti&sg/\u00197jI&sG/\u001a:wC2\u001cE.[3oi6+GO]5dg\u000e{gNZ5hQ\t\u0001b'\u0001\u0014uKN$XK\u001c3fM&tW\rZ\"p]\u001aLwm\u00117jK:$X*\u001a;sS\u000e\u001c8i\u001c8gS\u001eD#!\u0005\u001c\u0002GQ,7\u000f^%om\u0006d\u0017\u000eZ'bi\u000eD7\t\\5f]RlU\r\u001e:jGN\u001cuN\u001c4jO\"\u0012!C\u000e")
public class ControllerConfigurationValidatorTest {
    private final KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createDummyBrokerConfig());
    private final ControllerConfigurationValidator validator = new ControllerConfigurationValidator(this.config());

    public KafkaConfig config() {
        return this.config;
    }

    public ControllerConfigurationValidator validator() {
        return this.validator;
    }

    @Test
    public void testDefaultTopicResourceIsRejected() {
        Assertions.assertEquals((Object)"Default topic resources are not allowed.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, ""), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidTopicNameRejected() {
        Assertions.assertEquals((Object)"Topic name is invalid: '(<-invalid->)' contains one or more characters other than ASCII alphanumerics, '.', '_' and '-'", (Object)Assertions.assertThrows(InvalidTopicException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "(<-invalid->)"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUnknownResourceType() {
        Assertions.assertEquals((Object)"Unknown resource type BROKER_LOGGER", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "foo"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullTopicConfigValue() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "10");
        config.put("segment.bytes", null);
        config.put("segment.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for topic configs: segment.bytes,segment.ms", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config)).getMessage());
    }

    @Test
    public void testValidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config);
    }

    @Test
    public void testInvalidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown topic config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config)).getMessage());
    }

    @Test
    public void testInvalidBrokerEntity() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Unable to parse broker name as a base 10 number.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "blah"), (Map)config)).getMessage());
    }

    @Test
    public void testInvalidNegativeBrokerId() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Invalid negative broker ID.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "-1"), (Map)config)).getMessage());
    }

    @Test
    public void testValidClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("interval.ms", "2000");
        config.put("metrics", "org.apache.kafka.client.producer.partition.queue.,org.apache.kafka.client.producer.partition.latency");
        config.put("match", "client_instance_id=b69cc35a-7a54-4790-aa69-cc2bd4ee4538,client_id=1,client_software_name=apache-kafka-java,client_software_version=2.8.0-SNAPSHOT,client_source_address=127.0.0.1,client_source_port=1234");
        this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), config);
    }

    @Test
    public void testInvalidSubscriptionNameClientMetricsConfig() {
        TreeMap config = new TreeMap();
        Assertions.assertEquals((Object)"Subscription name can't be empty", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, ""), (Map)config)).getMessage());
    }

    @Test
    public void testInvalidIntervalClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("interval.ms", "10");
        Assertions.assertEquals((Object)"Invalid value 10 for interval.ms, interval must be between 100 and 3600000 (1 hour)", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config)).getMessage());
        config.put("interval.ms", "3600001");
        Assertions.assertEquals((Object)"Invalid value 3600001 for interval.ms, interval must be between 100 and 3600000 (1 hour)", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config)).getMessage());
    }

    @Test
    public void testUndefinedConfigClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("random", "10");
        Assertions.assertEquals((Object)"Unknown client metrics configuration: random", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config)).getMessage());
    }

    @Test
    public void testInvalidMatchClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("match", "10");
        Assertions.assertEquals((Object)"Illegal client matching pattern: 10", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config)).getMessage());
    }
}

