/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001\u0002\u0010 \u0001\u0011BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004>\u0001\u0001\u0006Ia\u000e\u0005\b}\u0001\u0011\r\u0011\"\u00017\u0011\u0019y\u0004\u0001)A\u0005o!9\u0001\t\u0001b\u0001\n\u0003\t\u0005B\u0002&\u0001A\u0003%!\tC\u0004L\u0001\t\u0007I\u0011\u0001'\t\rM\u0003\u0001\u0015!\u0003N\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u001d\u0011\u0007A1A\u0005\u0002YBaa\u0019\u0001!\u0002\u00139\u0004\"\u00023\u0001\t\u0003)\u0007bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA:\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!a&\u0001\t\u0003\tI\nC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006bBAh\u0001\u0011%\u0011\u0011\u001b\u0005\b\u0003+\u0004A\u0011BAl\u0005-iU\r\u001e:jGN$Vm\u001d;\u000b\u0005\u0001\n\u0013aB7fiJL7m\u001d\u0006\u0002E\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001&WA\u0011a%K\u0007\u0002O)\u0011\u0001&I\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002+O\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002-_5\tQF\u0003\u0002/C\u0005)Q\u000f^5mg&\u0011\u0001'\f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u00025\u00015\tq$\u0001\u0005ok6tu\u000eZ3t+\u00059\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$aA%oi\u0006Ia.^7O_\u0012,7\u000fI\u0001\t]Vl\u0007+\u0019:ug\u0006Ia.^7QCJ$8\u000fI\u0001\u001ae\u0016\fX/\u001b:fI.\u000bgm[1TKJ4XM\u001d)sK\u001aL\u00070F\u0001C!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0003mC:<'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0012\u0013aa\u0015;sS:<\u0017A\u0007:fcVL'/\u001a3LC\u001a\\\u0017mU3sm\u0016\u0014\bK]3gSb\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u00035\u0003\"AT)\u000e\u0003=S!\u0001\u0015$\u0002\tU$\u0018\u000e\\\u0005\u0003%>\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u00051\u0006cA,[96\t\u0001L\u0003\u0002Zs\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005mC&aA*fcB\u0011Q\fY\u0007\u0002=*\u0011q,I\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0005t&aC&bM.\f7i\u001c8gS\u001e\f\u0011B\\'fgN\fw-Z:\u0002\u00159lUm]:bO\u0016\u001c\b%A\u0013uKN$X*\u001a;sS\u000e\u001c(+\u001a9peR,'/\u00114uKJ$U\r\\3uS:<Gk\u001c9jGR\u0011a-\u001b\t\u0003q\u001dL!\u0001[\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006U6\u0001\ra[\u0001\u0007cV|'/^7\u0011\u00051\u001chBA7r!\tq\u0017(D\u0001p\u0015\t\u00018%\u0001\u0004=e>|GOP\u0005\u0003ef\na\u0001\u0015:fI\u00164\u0017BA%u\u0015\t\u0011\u0018\b\u000b\u0002\u000emB\u0019q/!\u0001\u000e\u0003aT!!\u001f>\u0002\rA\f'/Y7t\u0015\tYH0A\u0004kkBLG/\u001a:\u000b\u0005ut\u0018!\u00026v]&$(\"A@\u0002\u0007=\u0014x-C\u0002\u0002\u0004a\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001di\u0011qAA\n\u0003+\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bA\u0018\u0001\u00039s_ZLG-\u001a:\n\t\u0005E\u00111\u0002\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005]\u00111D\u0011\u0003\u00033\t!A_6\"\u0005\u0005u\u0011!B6sC\u001a$\u0018\u0001\u000e;fgR\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:V]J,w-[:uKJ,G-\u00114uKJ$U\r\\3uS:<Gk\u001c9jGR\u0019a-a\t\t\u000b)t\u0001\u0019A6)\u000591\bf\u0002\b\u0002\b\u0005M\u0011\u0011\u0006\u0017\u0005\u0003/\tY\"A\nuKN$8\t\\;ti\u0016\u0014\u0018\nZ'fiJL7\rF\u0002g\u0003_AQA[\bA\u0002-D#a\u0004<)\u000f=\t9!a\u0005\u000261\"\u0011qCA\u000e\u0003U!Xm\u001d;Ce>\\WM]*uCR,W*\u001a;sS\u000e$2AZA\u001e\u0011\u0015Q\u0007\u00031\u0001lQ\t\u0001b\u000fK\u0004\u0011\u0003\u000f\t\u0019\"!\u0011-\t\u0005]\u00111D\u0001\u001di\u0016\u001cH/W1n[\u0016\u0014X*\u001a;sS\u000e\u001c8i\\;oi6+GO]5d)\r1\u0017q\t\u0005\u0006UF\u0001\ra\u001b\u0015\u0003#YDs!EA\u0004\u0003'\ti\u0005\f\u0003\u0002\u0018\u0005m\u0011A\u0005;fgRd\u0015N\\;y\u0013>lU\r\u001e:jGN$2AZA*\u0011\u0015Q'\u00031\u0001lQ\t\u0011b\u000fK\u0004\u0013\u0003\u000f\t\u0019\"!\u0017-\t\u0005]\u00111D\u0001\u000ei\u0016\u001cHOS'Y\r&dG/\u001a:\u0015\u0007\u0019\fy\u0006C\u0003k'\u0001\u00071\u000e\u000b\u0002\u0014m\":1#a\u0002\u0002\u0014\u0005\u0015D\u0006BA\f\u00037\t1\u0003^3tiV\u0003H-\u0019;f\u00156Cf)\u001b7uKJ$2AZA6\u0011\u0015QG\u00031\u0001lQ\t!b\u000fK\u0004\u0015\u0003\u000f\t\u0019\"!\u001d-\t\u0005]\u00111D\u00013i\u0016\u001cHoR3oKJ\fGN\u0011:pW\u0016\u0014Hk\u001c9jG6+GO]5dg\u0006\u0013Xm\u0012:fK\u0012LG.\u001f*fO&\u001cH/\u001a:fIR\u0019a-a\u001e\t\u000b),\u0002\u0019A6)\u0005U1\bfB\u000b\u0002\b\u0005M\u0011Q\u0010\u0017\u0005\u0003/\tY\"\u0001\ruKN$x+\u001b8e_^\u001c8\u000b^=mKR\u000bwMT1nKN$2AZAB\u0011\u0015Qg\u00031\u0001lQ\t1b\u000fK\u0004\u0017\u0003\u000f\t\u0019\"!#-\t\u0005]\u00111D\u0001!i\u0016\u001cHO\u0011:pW\u0016\u0014Hk\u001c9jG6+GO]5dg\nKH/Z:J]>+H\u000fF\u0002g\u0003\u001fCQA[\fA\u0002-D#a\u0006<)\u000f]\t9!a\u0005\u0002\u00162\"\u0011qCA\u000e\u0003]!Xm\u001d;[W\u000e{g\u000e\u001e:pY2,'/T3ue&\u001c7\u000fF\u0002g\u00037CQA\u001b\rA\u0002-D#\u0001\u0007<)\u000fa\t9!a\u0005\u0002\"2\u0012\u0011qC\u0001\u001bi\u0016\u001cHo\u0013*bMR\u001cuN\u001c;s_2dWM]'fiJL7m\u001d\u000b\u0004M\u0006\u001d\u0006\"\u00026\u001a\u0001\u0004Y\u0007FA\rwQ\u001dI\u0012qAA\n\u0003[c#!a\u0007\u0002AQ,7\u000f^*fgNLwN\\#ya&\u0014X\rT5ti\u0016tWM]'fiJL7m\u001d\u000b\u0004M\u0006M\u0006\"\u00026\u001b\u0001\u0004Y\u0007F\u0001\u000ewQ\u001dQ\u0012qAA\n\u0003scC!a\u0006\u0002\u001c\u0005aAo\u001c9jG6+GO]5dgR!\u0011qXAc!\u00119\u0016\u0011Y6\n\u0007\u0005\r\u0007LA\u0002TKRDq!a2\u001c\u0001\u0004\tI-A\u0003u_BL7\r\u0005\u00039\u0003\u0017\\\u0017bAAgs\t1q\n\u001d;j_:\f\u0011\u0003^8qS\u000elU\r\u001e:jG\u001e\u0013x.\u001e9t)\u0011\ty,a5\t\r\u0005\u001dG\u00041\u0001l\u0003a1\u0017\u000e\u001c;fe\nKHk\u001c9jG6+GO]5d%\u0016<W\r\u001f\u000b\u0007\u0003\u007f\u000bI.a7\t\r\u0001j\u0002\u0019AA`\u0011\u001d\t9-\ba\u0001\u0003\u0013Ds\u0001AAp\u0003W\fi\u000f\u0005\u0003\u0002b\u0006\u001dXBAAr\u0015\r\t)O_\u0001\u0004CBL\u0017\u0002BAu\u0003G\u0014q\u0001V5nK>,H/A\u0003wC2,XMH\u0001y\u0001")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final String requiredKafkaServerPrefix;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String requiredKafkaServerPrefix() {
        return this.requiredKafkaServerPrefix;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnectOrNull(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    public int nMessages() {
        return this.nMessages;
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testMetricsReporterAfterDeletingTopic(String quorum) {
        String topic = "test-topic-metric";
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics don't exist");
        this.brokers().foreach((Function1 & Serializable)b -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, b);
            return BoxedUnit.UNIT;
        });
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterIdMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(this, x$2))), (int)1);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerStateMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerStateMetric$1(this, x$3))), (int)1);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testYammerMetricsCountMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testYammerMetricsCountMetric$1(this, x$4))), (int)1);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testLinuxIoMetrics(String quorum) {
        int expectedCount = new LinuxIoMetricsCollector("/proc", Time.SYSTEM, this.logger().underlying()).usable() ? 1 : 0;
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"linux-disk-read-bytes", "linux-disk-write-bytes"}))).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$testLinuxIoMetrics$1(this, metrics, expectedCount, name);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testJMXFilter(String quorum) {
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateJMXFilter(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testUpdateJMXFilter$1(broker);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertTrue((boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty(), (String)"General topic metrics don't exist");
        Assertions.assertEquals((int)((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricMap().size(), (int)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assertions.assertEquals((int)0, (int)((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricGaugeMap().size());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).isEmpty(), (String)"Topic metrics aren't lazily registered");
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics aren't registered");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testWindowsStyleTagNames(String quorum) {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = new KafkaMetricsGroup(this.getClass()).metricName("test-metric", CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava());
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsBytesInOut(String quorum) {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topic).toString();
        String bytesOut = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesOutPerSec()).append(",topic=").append(topic).toString();
        Properties topicConfig = new Properties();
        topicConfig.setProperty("min.insync.replicas", "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        Assertions.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testZkControllerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$1(x$8))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$2(x$9))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$3(x$10))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$4(x$11))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$5(x$12))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$6(x$13))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$7(x$14))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$8(x$15))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$9(x$16))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$10(x$17))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$11(x$18))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$12(x$19))), (int)1);
        MetricName zkStateMetricName = (MetricName)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().filter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$13(x$20)))).head();
        Gauge zkStateGauge = (Gauge)metrics.get(zkStateMetricName);
        Assertions.assertEquals((int)ZkMigrationState.ZK.value(), (int)BoxesRunTime.unboxToInt((Object)zkStateGauge.value()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testKRaftControllerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.controller:type=KafkaController,name=ActiveControllerCount", "kafka.controller:type=KafkaController,name=GlobalPartitionCount", "kafka.controller:type=KafkaController,name=GlobalTopicCount", "kafka.controller:type=KafkaController,name=LastAppliedRecordLagMs", "kafka.controller:type=KafkaController,name=LastAppliedRecordOffset", "kafka.controller:type=KafkaController,name=LastAppliedRecordTimestamp", "kafka.controller:type=KafkaController,name=LastCommittedRecordOffset", "kafka.controller:type=KafkaController,name=MetadataErrorCount", "kafka.controller:type=KafkaController,name=OfflinePartitionsCount", "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount", "kafka.controller:type=KafkaController,name=ZkMigrationState"}))).foreach((Function1 & Serializable)expected -> {
            MetricsTest.$anonfun$testKRaftControllerMetrics$1(metrics, expected);
            return BoxedUnit.UNIT;
        });
        MetricName zkStateMetricName = (MetricName)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().filter((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testKRaftControllerMetrics$3(x$22)))).head();
        Gauge zkStateGauge = (Gauge)metrics.get(zkStateMetricName);
        Assertions.assertEquals((int)ZkMigrationState.NONE.value(), (int)BoxesRunTime.unboxToInt((Object)zkStateGauge.value()));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testSessionExpireListenerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        int expectedNumMetrics = this.isKRaftTest() ? 0 : 1;
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$1(x$23))));
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$2(x$24))));
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$3(x$25))));
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().map((Function1 & Serializable)x$26 -> x$26.getMBeanName());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        Pattern pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(22).append(".*BrokerTopicMetrics.*").append(topic.map((Function1 & Serializable)t -> new StringBuilder(3).append("(").append((String)t).append(")$").toString()).getOrElse((Function0 & Serializable)() -> "")).toString())).pattern();
        return (Set)metrics.filter((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$filterByTopicMetricRegex$3(pattern, x$27)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaBroker b) {
        Assertions.assertNotNull((Object)b.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricsTest $this, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = new StringBuilder(10).append($this.requiredKafkaServerPrefix()).append("=ClusterId").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateMetric$1(MetricsTest $this, MetricName x$3) {
        String string = x$3.getMBeanName();
        String string2 = new StringBuilder(12).append($this.requiredKafkaServerPrefix()).append("=BrokerState").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testYammerMetricsCountMetric$1(MetricsTest $this, MetricName x$4) {
        String string = x$4.getMBeanName();
        String string2 = new StringBuilder(21).append($this.requiredKafkaServerPrefix()).append("=yammer-metrics-count").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLinuxIoMetrics$2(MetricsTest $this, String name$1, MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = new StringBuilder(1).append($this.requiredKafkaServerPrefix()).append("=").append(name$1).toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testLinuxIoMetrics$1(MetricsTest $this, java.util.Map metrics$1, int expectedCount$1, String name) {
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$1.keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testLinuxIoMetrics$2($this, name, x$5))), (int)expectedCount$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdateJMXFilter$1(KafkaBroker broker) {
        broker.kafkaYammerMetrics().reconfigure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics.jmx.exclude"), (Object)"kafka.controller:type=KafkaController,name=ActiveControllerCount")}))).asJava());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(topic$2, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = broker.config().brokerId();
        Option logSize = log.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 > 0L), (String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$1).append(" with positive size, actual: ").append(logSize).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$1(MetricName x$8) {
        String string = x$8.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$2(MetricName x$9) {
        String string = x$9.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$3(MetricName x$10) {
        String string = x$10.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$4(MetricName x$11) {
        String string = x$11.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$5(MetricName x$12) {
        String string = x$12.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$6(MetricName x$13) {
        String string = x$13.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$7(MetricName x$14) {
        String string = x$14.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$8(MetricName x$15) {
        String string = x$15.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$9(MetricName x$16) {
        String string = x$16.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$10(MetricName x$17) {
        String string = x$17.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveBrokerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$11(MetricName x$18) {
        String string = x$18.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=FencedBrokerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$12(MetricName x$19) {
        String string = x$19.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ZkMigrationState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$13(MetricName x$20) {
        String string = x$20.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ZkMigrationState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testKRaftControllerMetrics$2(String expected$1, MetricName x$21) {
        return x$21.getMBeanName().equals(expected$1);
    }

    public static final /* synthetic */ void $anonfun$testKRaftControllerMetrics$1(java.util.Map metrics$2, String expected) {
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$2.keySet()).asScala().count((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testKRaftControllerMetrics$2(expected, x$21))), (String)new StringBuilder(15).append("Unable to find ").append(expected).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testKRaftControllerMetrics$3(MetricName x$22) {
        String string = x$22.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ZkMigrationState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$1(MetricName x$23) {
        String string = x$23.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$2(MetricName x$24) {
        String string = x$24.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$3(MetricName x$25) {
        String string = x$25.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$filterByTopicMetricRegex$3(Pattern pattern$1, String x$27) {
        return pattern$1.matcher(x$27).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.requiredKafkaServerPrefix = "kafka.server:type=KafkaServer,name";
        this.overridingProps().put("num.partitions", Integer.toString(this.numParts()));
        this.overridingProps().put("metrics.jmx.exclude", new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString());
        this.nMessages = 2;
    }
}

