/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.sms.SmsBodyBuilder;
import org.apereo.cas.notifications.sms.SmsRequest;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordResetUrlBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.support.RequestContextUtils;

@Endpoint(id="passwordManagement", defaultAccess=Access.NONE)
public class PasswordManagementEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementEndpoint.class);
    protected static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    protected final ObjectProvider<CommunicationsManager> communicationsManager;
    protected final ObjectProvider<PasswordManagementService> passwordManagementService;
    protected final ObjectProvider<PasswordResetUrlBuilder> passwordResetUrlBuilder;
    protected final ObjectProvider<ServiceFactory<WebApplicationService>> serviceFactory;
    protected final ObjectProvider<ServicesManager> servicesManager;
    protected final ObjectProvider<PrincipalResolver> principalResolver;
    protected final ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    private final ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;

    public PasswordManagementEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<CommunicationsManager> communicationsManager, ObjectProvider<PasswordManagementService> passwordManagementService, ObjectProvider<PasswordResetUrlBuilder> passwordResetUrlBuilder, ObjectProvider<ServiceFactory<WebApplicationService>> serviceFactory, ObjectProvider<ServicesManager> servicesManager, ObjectProvider<PrincipalResolver> principalResolver, ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport, ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer) {
        super(casProperties, applicationContext);
        this.communicationsManager = communicationsManager;
        this.passwordManagementService = passwordManagementService;
        this.passwordResetUrlBuilder = passwordResetUrlBuilder;
        this.serviceFactory = serviceFactory;
        this.servicesManager = servicesManager;
        this.principalResolver = principalResolver;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }

    @Operation(summary="Initiate a password reset operation and notify the user", parameters={@Parameter(name="username", description="The username to reset the password for"), @Parameter(name="service", description="The service requesting the password reset")})
    @PostMapping(path={"/reset/{username}"}, produces={"application/json"})
    public ResponseEntity passwordReset(@PathVariable(value="username") String username, @RequestParam(value="service") String service, HttpServletRequest request) throws Throwable {
        PasswordManagementQuery query = PasswordManagementQuery.builder().username(username).build();
        String email = ((PasswordManagementService)this.passwordManagementService.getObject()).findEmail(query);
        String phone = ((PasswordManagementService)this.passwordManagementService.getObject()).findPhone(query);
        if (StringUtils.isBlank((CharSequence)email) && StringUtils.isBlank((CharSequence)phone)) {
            String message = "No recipient is provided with a valid email/phone for %s".formatted(username);
            LOGGER.warn(message);
            return ResponseEntity.unprocessableEntity().body((Object)message);
        }
        WebApplicationService webApplicationService = (WebApplicationService)((ServiceFactory)this.serviceFactory.getObject()).createService(service);
        RegisteredService registeredService = ((ServicesManager)this.servicesManager.getObject()).findServiceBy((Service)webApplicationService);
        Principal principal = this.resolvedPrincipal(username);
        AuditableContext audit = AuditableContext.builder().registeredService(registeredService).service((Service)webApplicationService).principal(principal).httpRequest((Object)request).build();
        AuditableExecutionResult accessResult = ((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).execute(audit);
        accessResult.throwExceptionIfNeeded();
        URL url = ((PasswordResetUrlBuilder)this.passwordResetUrlBuilder.getObject()).build(username, webApplicationService);
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        Duration duration = Beans.newDuration((String)pm.getReset().getExpiration());
        LOGGER.debug("Generated password reset URL [{}]; Link is only active for the next [{}] minute(s)", (Object)url, (Object)duration);
        EmailCommunicationResult sendEmail = this.sendPasswordResetEmailToAccount(principal, email, url, request);
        boolean sendSms = this.sendPasswordResetSmsToAccount(phone, url);
        return sendEmail.isSuccess() || sendSms ? ResponseEntity.ok().build() : ResponseEntity.unprocessableEntity().body((Object)"Failed to send password reset instructions to %s".formatted(username));
    }

    protected boolean sendPasswordResetSmsToAccount(String to, URL url) throws Throwable {
        if (StringUtils.isNotBlank((CharSequence)to)) {
            LOGGER.debug("Sending password reset URL [{}] via SMS to [{}]", (Object)url.toExternalForm(), (Object)to);
            SmsProperties reset = this.casProperties.getAuthn().getPm().getReset().getSms();
            String message = SmsBodyBuilder.builder().properties(reset).parameters(Map.of("url", url.toExternalForm())).build().get();
            SmsRequest smsRequest = SmsRequest.builder().from(reset.getFrom()).to(List.of(to)).text(message).build();
            return ((CommunicationsManager)this.communicationsManager.getObject()).sms(smsRequest);
        }
        return false;
    }

    protected Principal resolvedPrincipal(String username) throws Throwable {
        Principal resolvedPrincipal = ((PrincipalResolver)this.principalResolver.getObject()).resolve((Credential)new BasicIdentifiableCredential(username));
        return resolvedPrincipal instanceof NullPrincipal ? ((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).getPrincipalFactory().createPrincipal(username) : resolvedPrincipal;
    }

    protected EmailCommunicationResult sendPasswordResetEmailToAccount(Principal principal, String to, URL url, HttpServletRequest request) {
        EmailProperties reset = this.casProperties.getAuthn().getPm().getReset().getMail();
        Map parameters = CollectionUtils.wrap((String)"url", (Object)url.toExternalForm(), (String)"principal", (Object)principal);
        Optional<Locale> locale = Optional.ofNullable(RequestContextUtils.getLocaleResolver((HttpServletRequest)request)).map(resolver -> resolver.resolveLocale(request));
        String text = EmailMessageBodyBuilder.builder().properties(reset).parameters(parameters).locale(locale).build().get();
        LOGGER.debug("Sending password reset URL [{}] via email to [{}] for username [{}]", new Object[]{url, to, principal.getId()});
        EmailMessageRequest emailRequest = EmailMessageRequest.builder().emailProperties(reset).principal(principal).to(List.of(to)).locale(locale.orElseGet(Locale::getDefault)).body(text).build();
        return ((CommunicationsManager)this.communicationsManager.getObject()).email(emailRequest);
    }
}

