/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.account;

import java.io.Serializable;
import java.time.chrono.ChronoZonedDateTime;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.ISOStandardDateFormat;

class AccountSingleSignOnSession
implements Serializable {
    private static final long serialVersionUID = 8935451143814878214L;
    private String payload;
    private final String principal;
    private final String authenticationDate;
    private final String userAgent;
    private final String clientIpAddress;
    private String geoLocation;
    private final String id;

    AccountSingleSignOnSession(TicketGrantingTicket ticket) {
        this.id = ticket.getId();
        this.principal = ticket.getAuthentication().getPrincipal().getId();
        this.userAgent = ticket.getAuthentication().getCredentials().stream().map(Credential::getCredentialMetadata).filter(cred -> cred.getProperties().containsKey("UserAgent")).map(cred -> ((Serializable)cred.getProperties().get("UserAgent")).toString()).findFirst().orElse("");
        this.clientIpAddress = CollectionUtils.firstElement(ticket.getAuthentication().getAttributes().get("clientIpAddress")).map(Object::toString).orElse("");
        ISOStandardDateFormat dateFormat = new ISOStandardDateFormat();
        this.authenticationDate = dateFormat.format(DateTimeUtils.dateOf((ChronoZonedDateTime)ticket.getAuthentication().getAuthenticationDate()));
    }

    @Generated
    public String getPayload() {
        return this.payload;
    }

    @Generated
    public String getPrincipal() {
        return this.principal;
    }

    @Generated
    public String getAuthenticationDate() {
        return this.authenticationDate;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    @Generated
    public String getGeoLocation() {
        return this.geoLocation;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public AccountSingleSignOnSession setPayload(String payload) {
        this.payload = payload;
        return this;
    }

    @Generated
    public AccountSingleSignOnSession setGeoLocation(String geoLocation) {
        this.geoLocation = geoLocation;
        return this;
    }
}

