/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yubico.data.CredentialRegistration;
import com.yubico.webauthn.data.ByteArray;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CompressionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.apereo.cas.webauthn.WebAuthnUtils;
import org.apereo.cas.webauthn.storage.WebAuthnCredentialRepository;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Endpoint(id="webAuthnDevices", defaultAccess=Access.NONE)
public class WebAuthnRegisteredDevicesEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnRegisteredDevicesEndpoint.class);
    private final ObjectProvider<WebAuthnCredentialRepository> registrationStorage;

    public WebAuthnRegisteredDevicesEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<WebAuthnCredentialRepository> registrationStorage) {
        super(casProperties, applicationContext);
        this.registrationStorage = registrationStorage;
    }

    @Operation(summary="Fetch registered devices for username", parameters={@Parameter(name="username", required=true, description="The username to look up")})
    @GetMapping(path={"{username}"}, produces={"application/json"})
    public Collection<? extends CredentialRegistration> fetch(@PathVariable String username) {
        return ((WebAuthnCredentialRepository)this.registrationStorage.getObject()).getRegistrationsByUsername(username);
    }

    @PostMapping(path={"{username}"}, produces={"application/json"})
    @Operation(summary="Add device registration for username", parameters={@Parameter(name="username", required=true, description="The username to look up"), @Parameter(name="record", required=true, description="The device registration record")})
    public boolean write(@PathVariable String username, @RequestParam String record) throws Exception {
        String json = EncodingUtils.decodeBase64ToString((String)record);
        CredentialRegistration registration = (CredentialRegistration)WebAuthnUtils.getObjectMapper().readValue(json, CredentialRegistration.class);
        return ((WebAuthnCredentialRepository)this.registrationStorage.getObject()).addRegistrationByUsername(username, registration);
    }

    @Operation(summary="Remove device registrations for username", parameters={@Parameter(name="username", required=true, description="The username to delete")})
    @DeleteMapping(path={"{username}"}, produces={"application/json"})
    public void delete(@PathVariable String username) {
        ((WebAuthnCredentialRepository)this.registrationStorage.getObject()).removeAllRegistrations(username);
    }

    @Operation(summary="Remove device registration for username and credential id", parameters={@Parameter(name="username", required=true, description="The username to lookup"), @Parameter(name="credentialId", required=true, description="The credential id")})
    @DeleteMapping(path={"{username}/{credentialId}"}, produces={"application/json"})
    public void delete(@PathVariable String username, @PathVariable String credentialId) throws Exception {
        ByteArray ba = ByteArray.fromBase64Url((String)credentialId);
        ((WebAuthnCredentialRepository)this.registrationStorage.getObject()).getRegistrationByUsernameAndCredentialId(username, ba).ifPresent(registration -> ((WebAuthnCredentialRepository)this.registrationStorage.getObject()).removeRegistrationByUsername(username, (CredentialRegistration)registration));
    }

    @GetMapping(path={"/export"}, produces={"application/octet-stream"})
    @Operation(summary="Export device registrations as a zip file")
    @ResponseBody
    public ResponseEntity<Resource> export() {
        WritableResource resource = CompressionUtils.toZipFile(((WebAuthnCredentialRepository)this.registrationStorage.getObject()).stream(), (Function)Unchecked.function(entry -> {
            CredentialRegistration acct = (CredentialRegistration)entry;
            String ba = acct.getCredential().getCredentialId().getBase64Url();
            String fileName = String.format("%s-%s", acct.getUsername(), ba);
            File sourceFile = Files.createTempFile(fileName, ".json", new FileAttribute[0]).toFile();
            WebAuthnUtils.getObjectMapper().writeValue(sourceFile, (Object)acct);
            return sourceFile;
        }), (String)"webauthnbaccts");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDisposition(ContentDisposition.attachment().filename(Objects.requireNonNull(resource.getFilename())).build());
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Import a device registration as a JSON document")
    @PostMapping(path={"/import"}, consumes={"application/json"})
    public ResponseEntity importAccount(HttpServletRequest request) throws Exception {
        String requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        LOGGER.trace("Submitted account: [{}]", (Object)requestBody);
        CredentialRegistration account = (CredentialRegistration)WebAuthnUtils.getObjectMapper().readValue(requestBody, (TypeReference)new TypeReference<CredentialRegistration>(this){});
        LOGGER.trace("Storing account: [{}]", (Object)account);
        ((WebAuthnCredentialRepository)this.registrationStorage.getObject()).addRegistrationByUsername(account.getUsername(), account);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }
}

