/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;

public final class CheckMandatoryAuthentication
extends AbstractMessageHandler {
    @NonnullAfterInit
    private Function<MessageContext, Boolean> authenticationLookupStrategy;

    public void setAuthenticationLookupStrategy(@Nonnull Function<MessageContext, Boolean> strategy) {
        this.checkSetterPreconditions();
        this.authenticationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Message context authentication lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.authenticationLookupStrategy == null) {
            throw new ComponentInitializationException("Message context authentication lookup strategy cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        Boolean authenticated = this.authenticationLookupStrategy.apply(messageContext);
        if (authenticated == null) {
            throw new MessageHandlerException("Message context did not contain any authentication state");
        }
        if (!authenticated.booleanValue()) {
            throw new MessageHandlerException("Message context was not authenticated");
        }
    }
}

