/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.simple;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import java.util.Set;

public class In<O, A>
extends SimpleQuery<O, A> {
    private final Set<A> values;
    private final boolean disjoint;

    public In(Attribute<O, A> attribute, boolean disjoint, Set<A> values) {
        super(attribute);
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("The IN query must have at least one value.");
        }
        this.values = values;
        this.disjoint = disjoint;
    }

    public Set<A> getValues() {
        return this.values;
    }

    public boolean isDisjoint() {
        return this.disjoint;
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        return this.values.contains(attribute.getValue(object, queryOptions));
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        for (A attributeValue : attribute.getValues(object, queryOptions)) {
            if (!this.values.contains(attributeValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.values.hashCode();
        result = 31 * result + (this.disjoint ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof In)) {
            return false;
        }
        In in = (In)o;
        if (this.disjoint != in.disjoint) {
            return false;
        }
        if (!this.attribute.equals(in.attribute)) {
            return false;
        }
        return this.values.equals(in.values);
    }

    public String toString() {
        return "in(" + In.asLiteral(super.getAttributeName()) + ", " + In.asLiteral(this.values) + ")";
    }
}

