/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.support;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.attribute.SimpleNullableAttribute;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.DeduplicationOption;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.In;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.connective.ResultSetUnion;
import com.googlecode.cqengine.resultset.connective.ResultSetUnionAll;

public class IndexSupport {
    private IndexSupport() {
    }

    public static <O, A> ResultSet<O> deduplicateIfNecessary(Iterable<? extends ResultSet<O>> results, Query<O> query, Attribute<O, A> attribute, QueryOptions queryOptions, final int retrievalCost) {
        boolean queryIsADisjointInQuery;
        boolean logicalElimination = DeduplicationOption.isLogicalElimination(queryOptions);
        boolean attributeHasAtMostOneValue = attribute instanceof SimpleAttribute || attribute instanceof SimpleNullableAttribute;
        boolean bl = queryIsADisjointInQuery = query instanceof In && ((In)query).isDisjoint();
        if (!logicalElimination || attributeHasAtMostOneValue || queryIsADisjointInQuery) {
            return new ResultSetUnionAll<O>(results, query, queryOptions){

                @Override
                public int getRetrievalCost() {
                    return retrievalCost;
                }
            };
        }
        return new ResultSetUnion<O>(results, query, queryOptions){

            @Override
            public int getRetrievalCost() {
                return retrievalCost;
            }
        };
    }
}

