/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.surrogate;

import java.util.Collection;
import java.util.Optional;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface SurrogateAuthenticationService {
    public static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationService.class);
    public static final String WILDCARD_ACCOUNT = "*";
    public static final String BEAN_NAME = "surrogateAuthenticationService";
    public static final String AUTHENTICATION_ATTR_SURROGATE_USER = "surrogateUser";
    public static final String AUTHENTICATION_ATTR_SURROGATE_PRINCIPAL = "surrogatePrincipal";
    public static final String AUTHENTICATION_ATTR_SURROGATE_ENABLED = "surrogateEnabled";

    default public boolean canImpersonate(String surrogate, Principal principal, Optional<? extends Service> service) throws Throwable {
        return false;
    }

    public Collection<String> getImpersonationAccounts(String var1, Optional<? extends Service> var2) throws Throwable;

    default public boolean isWildcardedAccount(String surrogate, Principal principal, Optional<? extends Service> service) throws Throwable {
        Collection<String> accounts = this.getImpersonationAccounts(principal.getId(), service);
        return this.isWildcardedAccount(accounts, service);
    }

    default public boolean isWildcardedAccount(Collection<String> accounts, Optional<? extends Service> service) {
        return accounts.size() == 1 && accounts.contains(WILDCARD_ACCOUNT);
    }

    default public void collectSurrogateAttributes(AuthenticationBuilder builder, String surrogateUser, String principal) {
        LOGGER.debug("Recording surrogate username [{}] as an authentication attribute", (Object)surrogateUser);
        builder.addAttribute(AUTHENTICATION_ATTR_SURROGATE_USER, (Object)surrogateUser);
        builder.addAttribute(AUTHENTICATION_ATTR_SURROGATE_PRINCIPAL, (Object)principal);
        builder.addAttribute(AUTHENTICATION_ATTR_SURROGATE_ENABLED, (Object)Boolean.TRUE);
    }
}

