/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.HttpServiceTask;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;

public class HttpTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        HttpTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        HttpTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("HttpTask", HttpTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "HttpTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        HttpServiceTask task = new HttpServiceTask();
        task.setType("http");
        String parallelInSameTransaction = JsonConverterUtil.getPropertyValueAsString("httptaskparallelinsametransaction", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)parallelInSameTransaction)) {
            task.setParallelInSameTransaction(Boolean.valueOf(parallelInSameTransaction));
        }
        HttpTaskJsonConverter.addField("requestMethod", "httptaskrequestmethod", "GET", elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("requestUrl", "httptaskrequesturl", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("requestHeaders", "httptaskrequestheaders", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("requestBody", "httptaskrequestbody", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("requestBodyEncoding", "httptaskrequestbodyencoding", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("requestTimeout", "httptaskrequesttimeout", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("disallowRedirects", "httptaskdisallowredirects", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("failStatusCodes", "httptaskfailstatuscodes", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("handleStatusCodes", "httptaskhandlestatuscodes", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("responseVariableName", "httptaskresponsevariablename", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("ignoreException", "httptaskignoreexception", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("saveRequestVariables", "httptasksaverequestvariables", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("saveResponseParameters", "httptasksaveresponseparameters", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("resultVariablePrefix", "httptaskresultvariableprefix", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("saveResponseParametersTransient", "httptasksaveresponseparameterstransient", null, elementNode, (ServiceTask)task);
        HttpTaskJsonConverter.addField("saveResponseVariableAsJson", "httptasksaveresponseasjson", null, elementNode, (ServiceTask)task);
        task.setSkipExpression(JsonConverterUtil.getPropertyValueAsString("skipexpression", elementNode));
        return task;
    }
}

