/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnDiEdge;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Escalation;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.Lane;
import org.flowable.bpmn.model.Message;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.MessageFlow;
import org.flowable.bpmn.model.Pool;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.editor.constants.EditorJsonConstants;
import org.flowable.editor.constants.StencilConstants;
import org.flowable.editor.language.json.converter.ActivityProcessor;
import org.flowable.editor.language.json.converter.AdhocSubProcessJsonConverter;
import org.flowable.editor.language.json.converter.AssociationJsonConverter;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BoundaryEventJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;
import org.flowable.editor.language.json.converter.BusinessRuleTaskJsonConverter;
import org.flowable.editor.language.json.converter.CallActivityJsonConverter;
import org.flowable.editor.language.json.converter.CamelTaskJsonConverter;
import org.flowable.editor.language.json.converter.CatchEventJsonConverter;
import org.flowable.editor.language.json.converter.DataStoreJsonConverter;
import org.flowable.editor.language.json.converter.DecisionTaskJsonConverter;
import org.flowable.editor.language.json.converter.EndEventJsonConverter;
import org.flowable.editor.language.json.converter.EventGatewayJsonConverter;
import org.flowable.editor.language.json.converter.EventSubProcessJsonConverter;
import org.flowable.editor.language.json.converter.ExclusiveGatewayJsonConverter;
import org.flowable.editor.language.json.converter.ExternalWorkerServiceTaskJsonConverter;
import org.flowable.editor.language.json.converter.HttpTaskJsonConverter;
import org.flowable.editor.language.json.converter.InclusiveGatewayJsonConverter;
import org.flowable.editor.language.json.converter.MailTaskJsonConverter;
import org.flowable.editor.language.json.converter.ManualTaskJsonConverter;
import org.flowable.editor.language.json.converter.MessageFlowJsonConverter;
import org.flowable.editor.language.json.converter.MuleTaskJsonConverter;
import org.flowable.editor.language.json.converter.ParallelGatewayJsonConverter;
import org.flowable.editor.language.json.converter.ReceiveTaskJsonConverter;
import org.flowable.editor.language.json.converter.ScriptTaskJsonConverter;
import org.flowable.editor.language.json.converter.SendEventTaskJsonConverter;
import org.flowable.editor.language.json.converter.SendTaskJsonConverter;
import org.flowable.editor.language.json.converter.SequenceFlowJsonConverter;
import org.flowable.editor.language.json.converter.ServiceTaskJsonConverter;
import org.flowable.editor.language.json.converter.ShellTaskJsonConverter;
import org.flowable.editor.language.json.converter.StandaloneBpmnConverterContext;
import org.flowable.editor.language.json.converter.StartEventJsonConverter;
import org.flowable.editor.language.json.converter.SubProcessJsonConverter;
import org.flowable.editor.language.json.converter.TextAnnotationJsonConverter;
import org.flowable.editor.language.json.converter.ThrowEventJsonConverter;
import org.flowable.editor.language.json.converter.UserTaskJsonConverter;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnJsonConverter
implements EditorJsonConstants,
StencilConstants,
ActivityProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(BpmnJsonConverter.class);
    public static final String MODELER_NAMESPACE = "http://flowable.org/modeler";
    private static final JsonMapper JSON_MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected static final Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> JSON_CONVERTERS = new HashMap<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>>();
    protected static final Map<String, Class<? extends BaseBpmnJsonConverter>> BPMN_CONVERTERS = new HashMap<String, Class<? extends BaseBpmnJsonConverter>>();
    private static final List<String> DI_CIRCLES;
    private static final List<String> DI_RECTANGLES;
    private static final List<String> DI_GATEWAY;
    private static final double LINE_WIDTH = 0.05;

    private static void fillSubShapes(Map<String, SubProcess> subShapesMap, SubProcess subProcess) {
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (flowElement instanceof SubProcess) {
                SubProcess childSubProcess = (SubProcess)flowElement;
                subShapesMap.put(childSubProcess.getId(), subProcess);
                BpmnJsonConverter.fillSubShapes(subShapesMap, childSubProcess);
                continue;
            }
            subShapesMap.put(flowElement.getId(), subProcess);
        }
    }

    private static void postProcessElements(FlowElementsContainer parentContainer, Collection<FlowElement> flowElementList, Map<String, JsonNode> edgeMap, BpmnModel bpmnModel, Map<String, FlowWithContainer> allFlowMap, List<Gateway> gatewayWithOrderList) {
        for (FlowElement flowElement : flowElementList) {
            FlowElement targetFlowElement;
            Event event;
            parentContainer.addFlowElementToMap(flowElement);
            if (flowElement instanceof Event && CollectionUtils.isNotEmpty((event = (Event)flowElement).getEventDefinitions())) {
                MessageEventDefinition messageEventDef;
                EventDefinition eventDef = (EventDefinition)event.getEventDefinitions().get(0);
                if (eventDef instanceof SignalEventDefinition) {
                    SignalEventDefinition signalEventDef = (SignalEventDefinition)eventDef;
                    if (StringUtils.isNotEmpty((CharSequence)signalEventDef.getSignalRef()) && bpmnModel.getSignal(signalEventDef.getSignalRef()) == null) {
                        bpmnModel.addSignal(new Signal(signalEventDef.getSignalRef(), signalEventDef.getSignalRef()));
                    }
                } else if (eventDef instanceof MessageEventDefinition && StringUtils.isNotEmpty((CharSequence)(messageEventDef = (MessageEventDefinition)eventDef).getMessageRef()) && bpmnModel.getMessage(messageEventDef.getMessageRef()) == null) {
                    bpmnModel.addMessage(new Message(messageEventDef.getMessageRef(), messageEventDef.getMessageRef(), null));
                }
            }
            if (flowElement instanceof BoundaryEvent) {
                BoundaryEvent boundaryEvent = (BoundaryEvent)flowElement;
                Activity activity = BpmnJsonConverter.retrieveAttachedRefObject(boundaryEvent.getAttachedToRefId(), parentContainer.getFlowElements());
                if (activity == null) {
                    LOG.warn("Boundary event {} is not attached to any activity", (Object)boundaryEvent.getId());
                    continue;
                }
                boundaryEvent.setAttachedToRef(activity);
                activity.getBoundaryEvents().add(boundaryEvent);
                continue;
            }
            if (flowElement instanceof Gateway) {
                Gateway gateway = (Gateway)flowElement;
                if (!flowElement.getExtensionElements().containsKey("EDITOR_FLOW_ORDER")) continue;
                gatewayWithOrderList.add(gateway);
                continue;
            }
            if (flowElement instanceof SubProcess) {
                SubProcess subProcess = (SubProcess)flowElement;
                BpmnJsonConverter.postProcessElements((FlowElementsContainer)subProcess, subProcess.getFlowElements(), edgeMap, bpmnModel, allFlowMap, gatewayWithOrderList);
                continue;
            }
            if (!(flowElement instanceof SequenceFlow)) continue;
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            FlowElement sourceFlowElement = parentContainer.getFlowElement(sequenceFlow.getSourceRef());
            if (sourceFlowElement instanceof FlowNode) {
                boolean isDefault;
                FlowNode flowNode = (FlowNode)sourceFlowElement;
                FlowWithContainer flowWithContainer = new FlowWithContainer(sequenceFlow, parentContainer);
                if (sequenceFlow.getExtensionElements().get("EDITOR_RESOURCEID") != null && !((List)sequenceFlow.getExtensionElements().get("EDITOR_RESOURCEID")).isEmpty()) {
                    allFlowMap.put(((ExtensionElement)((List)sequenceFlow.getExtensionElements().get("EDITOR_RESOURCEID")).get(0)).getElementText(), flowWithContainer);
                    sequenceFlow.getExtensionElements().remove("EDITOR_RESOURCEID");
                }
                flowNode.getOutgoingFlows().add(sequenceFlow);
                JsonNode edgeNode = edgeMap.get(sequenceFlow.getId());
                if (edgeNode != null && (isDefault = JsonConverterUtil.getPropertyValueAsBoolean("defaultflow", edgeNode))) {
                    if (sourceFlowElement instanceof Activity) {
                        Activity activity = (Activity)sourceFlowElement;
                        activity.setDefaultFlow(sequenceFlow.getId());
                    } else if (sourceFlowElement instanceof Gateway) {
                        Gateway gateway = (Gateway)sourceFlowElement;
                        gateway.setDefaultFlow(sequenceFlow.getId());
                    }
                }
            }
            if (!((targetFlowElement = parentContainer.getFlowElement(sequenceFlow.getTargetRef())) instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)targetFlowElement;
            flowNode.getIncomingFlows().add(sequenceFlow);
        }
    }

    private static Activity retrieveAttachedRefObject(String attachedToRefId, Collection<FlowElement> flowElementList) {
        Activity activity = null;
        if (StringUtils.isNotEmpty((CharSequence)attachedToRefId)) {
            for (FlowElement flowElement : flowElementList) {
                SubProcess subProcess;
                Activity retrievedActivity;
                if (attachedToRefId.equals(flowElement.getId())) {
                    activity = (Activity)flowElement;
                    break;
                }
                if (!(flowElement instanceof SubProcess) || (retrievedActivity = BpmnJsonConverter.retrieveAttachedRefObject(attachedToRefId, (subProcess = (SubProcess)flowElement).getFlowElements())) == null) continue;
                activity = retrievedActivity;
                break;
            }
        }
        return activity;
    }

    private static void readShapeDI(JsonNode objectNode, double parentX, double parentY, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap, BpmnModel bpmnModel) {
        if (objectNode.get("childShapes") == null) {
            return;
        }
        for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
            String stencilId = BpmnJsonConverterUtil.getStencilId(jsonChildNode);
            if ("SequenceFlow".equals(stencilId) || "Association".equals(stencilId)) continue;
            GraphicInfo graphicInfo = new GraphicInfo();
            JsonNode boundsNode = jsonChildNode.get("bounds");
            ObjectNode upperLeftNode = (ObjectNode)boundsNode.get("upperLeft");
            ObjectNode lowerRightNode = (ObjectNode)boundsNode.get("lowerRight");
            graphicInfo.setX(upperLeftNode.get("x").asDouble() + parentX);
            graphicInfo.setY(upperLeftNode.get("y").asDouble() + parentY);
            graphicInfo.setWidth(lowerRightNode.get("x").asDouble() - graphicInfo.getX() + parentX);
            graphicInfo.setHeight(lowerRightNode.get("y").asDouble() - graphicInfo.getY() + parentY);
            String childShapeId = jsonChildNode.get("resourceId").asText();
            bpmnModel.addGraphicInfo(BpmnJsonConverterUtil.getElementId(jsonChildNode), graphicInfo);
            shapeMap.put(childShapeId, jsonChildNode);
            ArrayNode outgoingNode = (ArrayNode)jsonChildNode.get("outgoing");
            if (outgoingNode != null && outgoingNode.size() > 0) {
                for (JsonNode outgoingChildNode : outgoingNode) {
                    JsonNode resourceNode = outgoingChildNode.get("resourceId");
                    if (resourceNode == null) continue;
                    sourceRefMap.put(resourceNode.asText(), jsonChildNode);
                }
            }
            if ("CollapsedSubProcess".equals(stencilId)) {
                BpmnJsonConverter.readShapeDI(jsonChildNode, 0.0, 0.0, shapeMap, sourceRefMap, bpmnModel);
                continue;
            }
            BpmnJsonConverter.readShapeDI(jsonChildNode, graphicInfo.getX(), graphicInfo.getY(), shapeMap, sourceRefMap, bpmnModel);
        }
    }

    private static void filterAllEdges(JsonNode objectNode, Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap) {
        if (objectNode.get("childShapes") == null) {
            return;
        }
        for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
            ObjectNode childNode = (ObjectNode)jsonChildNode;
            String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)childNode);
            if ("SubProcess".equals(stencilId) || "Pool".equals(stencilId) || "Lane".equals(stencilId) || "CollapsedSubProcess".equals(stencilId) || "EventSubProcess".equals(stencilId)) {
                BpmnJsonConverter.filterAllEdges((JsonNode)childNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
                continue;
            }
            if (!"SequenceFlow".equals(stencilId) && !"Association".equals(stencilId)) continue;
            String childEdgeId = BpmnJsonConverterUtil.getElementId((JsonNode)childNode);
            JsonNode targetNode = childNode.get("target");
            if (targetNode != null && !targetNode.isNull()) {
                String targetRefId = targetNode.get("resourceId").asText();
                ArrayList<JsonNode> sourceAndTargetList = new ArrayList<JsonNode>();
                sourceAndTargetList.add(sourceRefMap.get(childNode.get("resourceId").asText()));
                sourceAndTargetList.add(shapeMap.get(targetRefId));
                sourceAndTargetMap.put(childEdgeId, sourceAndTargetList);
            }
            edgeMap.put(childEdgeId, (JsonNode)childNode);
        }
    }

    private static void readEdgeDI(Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, BpmnModel bpmnModel) {
        for (String edgeId : edgeMap.keySet()) {
            Line2D.Double lastLine;
            JsonNode edgeNode = edgeMap.get(edgeId);
            List<JsonNode> sourceAndTargetList = sourceAndTargetMap.get(edgeId);
            JsonNode sourceRefNode = null;
            JsonNode targetRefNode = null;
            if (sourceAndTargetList != null && sourceAndTargetList.size() > 1) {
                sourceRefNode = sourceAndTargetList.get(0);
                targetRefNode = sourceAndTargetList.get(1);
            }
            if (sourceRefNode == null) {
                LOG.info("Skipping edge {} because source ref is null", (Object)edgeId);
                continue;
            }
            if (targetRefNode == null) {
                LOG.info("Skipping edge {} because target ref is null", (Object)edgeId);
                continue;
            }
            JsonNode dockersNode = edgeNode.get("dockers");
            double sourceDockersX = dockersNode.get(0).get("x").asDouble();
            double sourceDockersY = dockersNode.get(0).get("y").asDouble();
            GraphicInfo sourceInfo = bpmnModel.getGraphicInfo(BpmnJsonConverterUtil.getElementId(sourceRefNode));
            GraphicInfo targetInfo = bpmnModel.getGraphicInfo(BpmnJsonConverterUtil.getElementId(targetRefNode));
            double sourceRefLineX = sourceInfo.getX() + sourceDockersX;
            double sourceRefLineY = sourceInfo.getY() + sourceDockersY;
            double nextPointInLineX = dockersNode.get(1).get("x").asDouble();
            double nextPointInLineY = dockersNode.get(1).get("y").asDouble();
            if (dockersNode.size() == 2) {
                nextPointInLineX += targetInfo.getX();
                nextPointInLineY += targetInfo.getY();
            }
            Line2D.Double firstLine = new Line2D.Double(sourceRefLineX, sourceRefLineY, nextPointInLineX, nextPointInLineY);
            String sourceRefStencilId = BpmnJsonConverterUtil.getStencilId(sourceRefNode);
            String targetRefStencilId = BpmnJsonConverterUtil.getStencilId(targetRefNode);
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            Area source2D = null;
            if (DI_CIRCLES.contains(sourceRefStencilId)) {
                source2D = BpmnJsonConverter.createEllipse(sourceInfo, sourceDockersX, sourceDockersY);
            } else if (DI_RECTANGLES.contains(sourceRefStencilId)) {
                source2D = BpmnJsonConverter.createRectangle(sourceInfo);
            } else if (DI_GATEWAY.contains(sourceRefStencilId)) {
                source2D = BpmnJsonConverter.createGateway(sourceInfo);
            }
            if (source2D != null) {
                Collection<Point2D> intersections = BpmnJsonConverter.getIntersections(firstLine, source2D);
                if (intersections != null && !intersections.isEmpty()) {
                    Point2D intersection = intersections.iterator().next();
                    graphicInfoList.add(BpmnJsonConverter.createGraphicInfo(intersection.getX(), intersection.getY()));
                } else {
                    graphicInfoList.add(BpmnJsonConverter.createGraphicInfo(sourceRefLineX, sourceRefLineY));
                }
            }
            if (dockersNode.size() > 2) {
                for (int i = 1; i < dockersNode.size() - 1; ++i) {
                    double x = dockersNode.get(i).get("x").asDouble();
                    double y = dockersNode.get(i).get("y").asDouble();
                    graphicInfoList.add(BpmnJsonConverter.createGraphicInfo(x, y));
                }
                double startLastLineX = dockersNode.get(dockersNode.size() - 2).get("x").asDouble();
                double startLastLineY = dockersNode.get(dockersNode.size() - 2).get("y").asDouble();
                double endLastLineX = dockersNode.get(dockersNode.size() - 1).get("x").asDouble();
                double endLastLineY = dockersNode.get(dockersNode.size() - 1).get("y").asDouble();
                lastLine = new Line2D.Double(startLastLineX, startLastLineY, endLastLineX += targetInfo.getX(), endLastLineY += targetInfo.getY());
            } else {
                lastLine = firstLine;
            }
            BpmnDiEdge edgeInfo = new BpmnDiEdge();
            edgeInfo.setWaypoints(graphicInfoList);
            GraphicInfo sourceDockerInfo = new GraphicInfo();
            sourceDockerInfo.setX(dockersNode.get(0).get("x").asDouble());
            sourceDockerInfo.setY(dockersNode.get(0).get("y").asDouble());
            edgeInfo.setSourceDockerInfo(sourceDockerInfo);
            GraphicInfo targetDockerInfo = new GraphicInfo();
            targetDockerInfo.setX(dockersNode.get(dockersNode.size() - 1).get("x").asDouble());
            targetDockerInfo.setY(dockersNode.get(dockersNode.size() - 1).get("y").asDouble());
            edgeInfo.setTargetDockerInfo(targetDockerInfo);
            bpmnModel.addEdgeInfo(edgeId, edgeInfo);
            Area target2D = null;
            if (DI_RECTANGLES.contains(targetRefStencilId)) {
                target2D = BpmnJsonConverter.createRectangle(targetInfo);
            } else if (DI_CIRCLES.contains(targetRefStencilId)) {
                double targetDockersX = dockersNode.get(dockersNode.size() - 1).get("x").asDouble();
                double targetDockersY = dockersNode.get(dockersNode.size() - 1).get("y").asDouble();
                target2D = BpmnJsonConverter.createEllipse(targetInfo, targetDockersX, targetDockersY);
            } else if (DI_GATEWAY.contains(targetRefStencilId)) {
                target2D = BpmnJsonConverter.createGateway(targetInfo);
            }
            if (target2D != null) {
                Collection<Point2D> intersections = BpmnJsonConverter.getIntersections(lastLine, target2D);
                if (intersections != null && !intersections.isEmpty()) {
                    Point2D intersection = intersections.iterator().next();
                    graphicInfoList.add(BpmnJsonConverter.createGraphicInfo(intersection.getX(), intersection.getY()));
                } else {
                    graphicInfoList.add(BpmnJsonConverter.createGraphicInfo(((Line2D)lastLine).getX2(), ((Line2D)lastLine).getY2()));
                }
            }
            bpmnModel.addFlowGraphicInfoList(edgeId, graphicInfoList);
        }
    }

    private static Area createEllipse(GraphicInfo sourceInfo, double halfWidth, double halfHeight) {
        Area outerCircle = new Area(new Ellipse2D.Double(sourceInfo.getX(), sourceInfo.getY(), 2.0 * halfWidth, 2.0 * halfHeight));
        Area innerCircle = new Area(new Ellipse2D.Double(sourceInfo.getX() + 0.05, sourceInfo.getY() + 0.05, 2.0 * (halfWidth - 0.05), 2.0 * (halfHeight - 0.05)));
        outerCircle.subtract(innerCircle);
        return outerCircle;
    }

    private static Collection<Point2D> getIntersections(Line2D line, Area shape) {
        Area intersectionArea = new Area(BpmnJsonConverter.getLineShape(line));
        intersectionArea.intersect(shape);
        if (!intersectionArea.isEmpty()) {
            Rectangle2D bounds2D = intersectionArea.getBounds2D();
            HashSet<Point2D> intersections = new HashSet<Point2D>(1);
            intersections.add(new Point2D.Double(bounds2D.getX(), bounds2D.getY()));
            return intersections;
        }
        return Collections.emptySet();
    }

    private static Shape getLineShape(Line2D line2D) {
        Path2D.Double line = new Path2D.Double(1, 4);
        ((Path2D)line).moveTo(line2D.getX1(), line2D.getY1());
        ((Path2D)line).lineTo(line2D.getX2(), line2D.getY2());
        ((Path2D)line).lineTo(line2D.getX2() + 0.05, line2D.getY2() + 0.05);
        line.closePath();
        return line;
    }

    private static Area createRectangle(GraphicInfo graphicInfo) {
        Area outerRectangle = new Area(new Rectangle2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight()));
        Area innerRectangle = new Area(new Rectangle2D.Double(graphicInfo.getX() + 0.05, graphicInfo.getY() + 0.05, graphicInfo.getWidth() - 0.1, graphicInfo.getHeight() - 0.1));
        outerRectangle.subtract(innerRectangle);
        return outerRectangle;
    }

    private static Area createGateway(GraphicInfo graphicInfo) {
        Area outerGatewayArea = new Area(BpmnJsonConverter.createGatewayShape(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight()));
        Area innerGatewayArea = new Area(BpmnJsonConverter.createGatewayShape(graphicInfo.getX() + 0.05, graphicInfo.getY() + 0.05, graphicInfo.getWidth() - 0.1, graphicInfo.getHeight() - 0.1));
        outerGatewayArea.subtract(innerGatewayArea);
        return outerGatewayArea;
    }

    private static Path2D.Double createGatewayShape(double x, double y, double width, double height) {
        double middleX = x + width / 2.0;
        double middleY = y + height / 2.0;
        Path2D.Double gatewayShape = new Path2D.Double(1, 4);
        gatewayShape.moveTo(x, middleY);
        gatewayShape.lineTo(middleX, y);
        gatewayShape.lineTo(x + width, middleY);
        gatewayShape.lineTo(middleX, y + height);
        gatewayShape.closePath();
        return gatewayShape;
    }

    private static GraphicInfo createGraphicInfo(double x, double y) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(x);
        graphicInfo.setY(y);
        return graphicInfo;
    }

    public ObjectNode convertToJson(BpmnModel model) {
        return this.convertToJson(model, new StandaloneBpmnConverterContext());
    }

    public ObjectNode convertToJson(BpmnModel model, BpmnJsonConverterContext converterContext) {
        String historyLevel;
        List historyExtensionElements;
        ObjectNode modelNode = JSON_MAPPER.createObjectNode();
        double maxX = 0.0;
        double maxY = 0.0;
        for (GraphicInfo flowInfo : model.getLocationMap().values()) {
            if (flowInfo.getX() + flowInfo.getWidth() > maxX) {
                maxX = flowInfo.getX() + flowInfo.getWidth();
            }
            if (!(flowInfo.getY() + flowInfo.getHeight() > maxY)) continue;
            maxY = flowInfo.getY() + flowInfo.getHeight();
        }
        maxX += 50.0;
        maxY += 50.0;
        if (maxX < 1485.0) {
            maxX = 1485.0;
        }
        if (maxY < 700.0) {
            maxY = 700.0;
        }
        modelNode.set("bounds", (JsonNode)BpmnJsonConverterUtil.createBoundsNode(maxX, maxY, 0.0, 0.0));
        modelNode.put("resourceId", "canvas");
        ObjectNode stencilNode = JSON_MAPPER.createObjectNode();
        stencilNode.put("id", "BPMNDiagram");
        modelNode.set("stencil", (JsonNode)stencilNode);
        ObjectNode stencilsetNode = JSON_MAPPER.createObjectNode();
        stencilsetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        stencilsetNode.put("url", "../editor/stencilsets/bpmn2.0/bpmn2.0.json");
        modelNode.set("stencilset", (JsonNode)stencilsetNode);
        ArrayNode shapesArrayNode = JSON_MAPPER.createArrayNode();
        Process mainProcess = !model.getPools().isEmpty() ? model.getProcess(((Pool)model.getPools().get(0)).getId()) : model.getMainProcess();
        ObjectNode propertiesNode = JSON_MAPPER.createObjectNode();
        if (StringUtils.isNotEmpty((CharSequence)mainProcess.getId())) {
            propertiesNode.put("process_id", mainProcess.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)mainProcess.getName())) {
            propertiesNode.put("name", mainProcess.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)mainProcess.getDocumentation())) {
            propertiesNode.put("documentation", mainProcess.getDocumentation());
        }
        if (!mainProcess.isExecutable()) {
            propertiesNode.put("isexecutable", "false");
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{model.getTargetNamespace()})) {
            propertiesNode.put("process_namespace", model.getTargetNamespace());
        }
        if (CollectionUtils.isNotEmpty(mainProcess.getCandidateStarterGroups())) {
            propertiesNode.put("process_potentialstartergroup", String.join((CharSequence)",", mainProcess.getCandidateStarterGroups()));
        }
        if (CollectionUtils.isNotEmpty(mainProcess.getCandidateStarterUsers())) {
            propertiesNode.put("process_potentialstarteruser", String.join((CharSequence)",", mainProcess.getCandidateStarterUsers()));
        }
        if (mainProcess.getExtensionElements().containsKey("historyLevel") && (historyExtensionElements = (List)mainProcess.getExtensionElements().get("historyLevel")) != null && !historyExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(historyLevel = ((ExtensionElement)historyExtensionElements.get(0)).getElementText()))) {
            propertiesNode.put("process_historylevel", historyLevel);
        }
        propertiesNode.put("iseagerexecutionfetch", Boolean.valueOf(mainProcess.isEnableEagerExecutionTreeFetching()));
        BpmnJsonConverterUtil.convertMessagesToJson(model.getMessages(), propertiesNode);
        BpmnJsonConverterUtil.convertListenersToJson(mainProcess.getExecutionListeners(), true, propertiesNode);
        BpmnJsonConverterUtil.convertEventListenersToJson(mainProcess.getEventListeners(), propertiesNode);
        BpmnJsonConverterUtil.convertSignalDefinitionsToJson(model, propertiesNode);
        BpmnJsonConverterUtil.convertMessagesToJson(model, propertiesNode);
        BpmnJsonConverterUtil.convertEscalationDefinitionsToJson(model, propertiesNode);
        if (CollectionUtils.isNotEmpty(mainProcess.getDataObjects())) {
            BpmnJsonConverterUtil.convertDataPropertiesToJson(mainProcess.getDataObjects(), propertiesNode);
        }
        modelNode.set("properties", (JsonNode)propertiesNode);
        boolean poolHasDI = false;
        if (!model.getPools().isEmpty()) {
            for (Pool pool : model.getPools()) {
                GraphicInfo graphicInfo = model.getGraphicInfo(pool.getId());
                if (graphicInfo == null) continue;
                poolHasDI = true;
                break;
            }
        }
        if (!model.getPools().isEmpty() && poolHasDI) {
            for (Pool pool : model.getPools()) {
                GraphicInfo poolGraphicInfo = model.getGraphicInfo(pool.getId());
                if (poolGraphicInfo == null) continue;
                ObjectNode poolNode = BpmnJsonConverterUtil.createChildShape(pool.getId(), "Pool", poolGraphicInfo.getX() + poolGraphicInfo.getWidth(), poolGraphicInfo.getY() + poolGraphicInfo.getHeight(), poolGraphicInfo.getX(), poolGraphicInfo.getY());
                shapesArrayNode.add((JsonNode)poolNode);
                ObjectNode poolPropertiesNode = JSON_MAPPER.createObjectNode();
                poolPropertiesNode.put("overrideid", pool.getId());
                poolPropertiesNode.put("process_id", pool.getProcessRef());
                if (!pool.isExecutable()) {
                    poolPropertiesNode.put("isexecutable", "false");
                }
                if (StringUtils.isNotEmpty((CharSequence)pool.getName())) {
                    poolPropertiesNode.put("name", pool.getName());
                }
                poolNode.set("properties", (JsonNode)poolPropertiesNode);
                ArrayNode laneShapesArrayNode = JSON_MAPPER.createArrayNode();
                poolNode.set("childShapes", (JsonNode)laneShapesArrayNode);
                ArrayNode outgoingArrayNode = JSON_MAPPER.createArrayNode();
                poolNode.set("outgoing", (JsonNode)outgoingArrayNode);
                Process process = model.getProcess(pool.getId());
                if (process != null) {
                    HashMap<String, ArrayNode> laneMap = new HashMap<String, ArrayNode>();
                    for (Lane lane : process.getLanes()) {
                        GraphicInfo laneGraphicInfo = model.getGraphicInfo(lane.getId());
                        if (laneGraphicInfo == null) continue;
                        ObjectNode laneNode = BpmnJsonConverterUtil.createChildShape(lane.getId(), "Lane", laneGraphicInfo.getX() + laneGraphicInfo.getWidth() - poolGraphicInfo.getX(), laneGraphicInfo.getY() + laneGraphicInfo.getHeight() - poolGraphicInfo.getY(), laneGraphicInfo.getX() - poolGraphicInfo.getX(), laneGraphicInfo.getY() - poolGraphicInfo.getY());
                        laneShapesArrayNode.add((JsonNode)laneNode);
                        ObjectNode lanePropertiesNode = JSON_MAPPER.createObjectNode();
                        lanePropertiesNode.put("overrideid", lane.getId());
                        if (StringUtils.isNotEmpty((CharSequence)lane.getName())) {
                            lanePropertiesNode.put("name", lane.getName());
                        }
                        laneNode.set("properties", (JsonNode)lanePropertiesNode);
                        ArrayNode elementShapesArrayNode = JSON_MAPPER.createArrayNode();
                        laneNode.set("childShapes", (JsonNode)elementShapesArrayNode);
                        laneNode.set("outgoing", (JsonNode)JSON_MAPPER.createArrayNode());
                        laneMap.put(lane.getId(), elementShapesArrayNode);
                    }
                    for (FlowElement flowElement : process.getFlowElements()) {
                        FlowElement lookForElement;
                        Lane laneForElement = null;
                        GraphicInfo laneGraphicInfo = null;
                        if (flowElement instanceof SequenceFlow) {
                            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                            lookForElement = model.getFlowElement(sequenceFlow.getSourceRef());
                        } else {
                            lookForElement = flowElement;
                        }
                        for (Lane lane : process.getLanes()) {
                            if (!lane.getFlowReferences().contains(lookForElement.getId())) continue;
                            laneGraphicInfo = model.getGraphicInfo(lane.getId());
                            if (laneGraphicInfo == null) break;
                            laneForElement = lane;
                            break;
                        }
                        if (!(flowElement instanceof SequenceFlow) && laneForElement == null) continue;
                        this.processFlowElement(flowElement, (FlowElementsContainer)process, model, (ArrayNode)laneMap.get(laneForElement.getId()), converterContext, laneGraphicInfo.getX(), laneGraphicInfo.getY());
                    }
                    this.processArtifacts(converterContext, (FlowElementsContainer)process, model, shapesArrayNode, 0.0, 0.0);
                }
                for (MessageFlow messageFlow : model.getMessageFlows().values()) {
                    if (!messageFlow.getSourceRef().equals(pool.getId())) continue;
                    outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(messageFlow.getId()));
                }
            }
        } else {
            this.processFlowElements((FlowElementsContainer)model.getMainProcess(), model, shapesArrayNode, converterContext, 0.0, 0.0);
        }
        this.processMessageFlows(model, shapesArrayNode, converterContext);
        modelNode.set("childShapes", (JsonNode)shapesArrayNode);
        return modelNode;
    }

    @Override
    public void processFlowElements(FlowElementsContainer container, BpmnModel model, ArrayNode shapesArrayNode, BpmnJsonConverterContext converterContext, double subProcessX, double subProcessY) {
        for (FlowElement flowElement : container.getFlowElements()) {
            this.processFlowElement(flowElement, container, model, shapesArrayNode, converterContext, subProcessX, subProcessY);
        }
        this.processArtifacts(converterContext, container, model, shapesArrayNode, subProcessX, subProcessY);
    }

    private void processFlowElement(FlowElement flowElement, FlowElementsContainer container, BpmnModel model, ArrayNode shapesArrayNode, BpmnJsonConverterContext converterContext, double containerX, double containerY) {
        Optional.ofNullable(JSON_CONVERTERS.get(flowElement.getClass())).ifPresent(converter -> {
            try {
                BaseBpmnJsonConverter converterInstance = (BaseBpmnJsonConverter)converter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                converterInstance.convertToJson(converterContext, (BaseElement)flowElement, this, model, container, shapesArrayNode, containerX, containerY);
            }
            catch (Exception e) {
                LOG.error("Error converting {}", (Object)flowElement, (Object)e);
            }
        });
    }

    private void processArtifacts(BpmnJsonConverterContext converterContext, FlowElementsContainer container, BpmnModel model, ArrayNode shapesArrayNode, double containerX, double containerY) {
        container.getArtifacts().forEach(artifact -> Optional.ofNullable(JSON_CONVERTERS.get(artifact.getClass())).ifPresent(converter -> {
            try {
                ((BaseBpmnJsonConverter)converter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).convertToJson(converterContext, (BaseElement)artifact, this, model, container, shapesArrayNode, containerX, containerY);
            }
            catch (Exception e) {
                LOG.error("Error converting {}", artifact, (Object)e);
            }
        }));
    }

    private void processMessageFlows(BpmnModel model, ArrayNode shapesArrayNode, BpmnJsonConverterContext converterCOntext) {
        for (MessageFlow messageFlow : model.getMessageFlows().values()) {
            MessageFlowJsonConverter jsonConverter = new MessageFlowJsonConverter();
            jsonConverter.convertToJson(converterCOntext, (BaseElement)messageFlow, this, model, null, shapesArrayNode, 0.0, 0.0);
        }
    }

    public BpmnModel convertToBpmnModel(JsonNode modelNode) {
        return this.convertToBpmnModel(modelNode, new StandaloneBpmnConverterContext());
    }

    public BpmnModel convertToBpmnModel(JsonNode modelNode, BpmnJsonConverterContext converterContext) {
        BpmnModel bpmnModel = new BpmnModel();
        bpmnModel.setTargetNamespace("http://flowable.org/test");
        bpmnModel.setExporter("Flowable Open Source Modeler");
        bpmnModel.setExporterVersion(this.getClass().getPackage().getImplementationVersion());
        HashMap<String, JsonNode> shapeMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> sourceRefMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> edgeMap = new HashMap<String, JsonNode>();
        HashMap<String, List<JsonNode>> sourceAndTargetMap = new HashMap<String, List<JsonNode>>();
        BpmnJsonConverter.readShapeDI(modelNode, 0.0, 0.0, shapeMap, sourceRefMap, bpmnModel);
        BpmnJsonConverter.filterAllEdges(modelNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
        BpmnJsonConverter.readEdgeDI(edgeMap, sourceAndTargetMap, bpmnModel);
        ArrayNode shapesArrayNode = (ArrayNode)modelNode.get("childShapes");
        if (shapesArrayNode == null || shapesArrayNode.size() == 0) {
            return bpmnModel;
        }
        boolean nonEmptyPoolFound = false;
        HashMap<String, Lane> elementInLaneMap = new HashMap<String, Lane>();
        for (JsonNode shapeNode : shapesArrayNode) {
            JsonNode processDataPropertiesNode;
            String stencilId = BpmnJsonConverterUtil.getStencilId(shapeNode);
            if (!"Pool".equals(stencilId)) continue;
            Pool pool = new Pool();
            pool.setId(BpmnJsonConverterUtil.getElementId(shapeNode));
            pool.setName(JsonConverterUtil.getPropertyValueAsString("name", shapeNode));
            pool.setProcessRef(JsonConverterUtil.getPropertyValueAsString("process_id", shapeNode));
            pool.setExecutable(JsonConverterUtil.getPropertyValueAsBoolean("isexecutable", shapeNode, true));
            bpmnModel.getPools().add(pool);
            Process process = new Process();
            process.setId(pool.getProcessRef());
            process.setName(pool.getName());
            process.setExecutable(pool.isExecutable());
            process.setEnableEagerExecutionTreeFetching(JsonConverterUtil.getPropertyValueAsBoolean("iseagerexecutionfetch", shapeNode, false));
            BpmnJsonConverterUtil.convertJsonToMessages(modelNode, bpmnModel);
            BpmnJsonConverterUtil.convertJsonToListeners(modelNode, (BaseElement)process);
            JsonNode eventListenersNode = BpmnJsonConverterUtil.getProperty("eventlisteners", modelNode);
            if (eventListenersNode != null) {
                eventListenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(eventListenersNode);
                BpmnJsonConverterUtil.parseEventListeners(eventListenersNode.get("eventListeners"), process);
            }
            if ((processDataPropertiesNode = modelNode.get("properties").get("dataproperties")) != null) {
                List<ValuedDataObject> dataObjects = BpmnJsonConverterUtil.convertJsonToDataProperties(processDataPropertiesNode, (BaseElement)process);
                process.setDataObjects(dataObjects);
                process.getFlowElements().addAll(dataObjects);
            }
            String userStarterValue = BpmnJsonConverterUtil.getPropertyValueAsString("process_potentialstarteruser", modelNode);
            String groupStarterValue = BpmnJsonConverterUtil.getPropertyValueAsString("process_potentialstartergroup", modelNode);
            if (StringUtils.isNotEmpty((CharSequence)userStarterValue)) {
                String[] userStartArray = userStarterValue.split(",");
                ArrayList<String> userStarters = new ArrayList<String>(Arrays.asList(userStartArray));
                process.setCandidateStarterUsers(userStarters);
            }
            if (StringUtils.isNotEmpty((CharSequence)groupStarterValue)) {
                String[] groupStarterArray = groupStarterValue.split(",");
                ArrayList<String> groupStarters = new ArrayList<String>(Arrays.asList(groupStarterArray));
                process.setCandidateStarterGroups((List)groupStarters);
            }
            bpmnModel.addProcess(process);
            ArrayNode laneArrayNode = (ArrayNode)shapeNode.get("childShapes");
            for (JsonNode laneNode : laneArrayNode) {
                String laneStencilId = BpmnJsonConverterUtil.getStencilId(laneNode);
                if (!"Lane".equals(laneStencilId)) continue;
                nonEmptyPoolFound = true;
                Lane lane = new Lane();
                lane.setId(BpmnJsonConverterUtil.getElementId(laneNode));
                lane.setName(JsonConverterUtil.getPropertyValueAsString("name", laneNode));
                lane.setParentProcess(process);
                process.getLanes().add(lane);
                this.processJsonElements(laneNode.get("childShapes"), modelNode, (BaseElement)lane, shapeMap, converterContext, bpmnModel);
                if (!CollectionUtils.isNotEmpty(lane.getFlowReferences())) continue;
                for (String elementRef : lane.getFlowReferences()) {
                    elementInLaneMap.put(elementRef, lane);
                }
            }
        }
        JsonNode signalDefinitionNode = BpmnJsonConverterUtil.getProperty("signaldefinitions", modelNode);
        signalDefinitionNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(signalDefinitionNode);
        if ((signalDefinitionNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(signalDefinitionNode)) != null && signalDefinitionNode instanceof ArrayNode) {
            ArrayNode signalDefinitionArrayNode = (ArrayNode)signalDefinitionNode;
            for (Object signalDefinitionJsonNode : signalDefinitionArrayNode) {
                String signalId = signalDefinitionJsonNode.get("id").asText();
                String signalName = signalDefinitionJsonNode.get("name").asText();
                String signalScope = signalDefinitionJsonNode.get("scope").asText();
                if (!StringUtils.isNotEmpty((CharSequence)signalId) || !StringUtils.isNotEmpty((CharSequence)signalName)) continue;
                Signal signal = new Signal();
                signal.setId(signalId);
                signal.setName(signalName);
                signal.setScope("processinstance".equals(signalScope.toLowerCase()) ? "processInstance" : "global");
                bpmnModel.addSignal(signal);
            }
        }
        JsonNode escalationDefinitionNode = BpmnJsonConverterUtil.getProperty("escalationdefinitions", modelNode);
        escalationDefinitionNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(escalationDefinitionNode);
        if ((escalationDefinitionNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(escalationDefinitionNode)) != null && escalationDefinitionNode instanceof ArrayNode) {
            ArrayNode escalationDefinitionArrayNode = (ArrayNode)escalationDefinitionNode;
            for (JsonNode signalDefinitionJsonNode : escalationDefinitionArrayNode) {
                String escalationId = signalDefinitionJsonNode.get("id").asText();
                String escalationName = signalDefinitionJsonNode.get("name").asText();
                if (!StringUtils.isNotEmpty((CharSequence)escalationId) || !StringUtils.isNotEmpty((CharSequence)escalationName)) continue;
                Escalation escalation = new Escalation();
                escalation.setId(escalationId);
                escalation.setEscalationCode(escalationId);
                escalation.setName(escalationName);
                bpmnModel.addEscalation(escalation);
            }
        }
        if (!nonEmptyPoolFound) {
            JsonNode processDataPropertiesNode;
            String historyLevel;
            Iterator process = new Process();
            bpmnModel.getProcesses().add(process);
            process.setId(BpmnJsonConverterUtil.getPropertyValueAsString("process_id", modelNode));
            process.setName(BpmnJsonConverterUtil.getPropertyValueAsString("name", modelNode));
            String namespace = BpmnJsonConverterUtil.getPropertyValueAsString("process_namespace", modelNode);
            if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                bpmnModel.setTargetNamespace(namespace);
            }
            process.setDocumentation(BpmnJsonConverterUtil.getPropertyValueAsString("documentation", modelNode));
            JsonNode processExecutableNode = JsonConverterUtil.getProperty("isexecutable", modelNode);
            if (processExecutableNode != null && StringUtils.isNotEmpty((CharSequence)processExecutableNode.asText())) {
                process.setExecutable(JsonConverterUtil.getPropertyValueAsBoolean("isexecutable", modelNode));
            }
            if (StringUtils.isNotEmpty((CharSequence)(historyLevel = BpmnJsonConverterUtil.getPropertyValueAsString("process_historylevel", modelNode)))) {
                ExtensionElement historyExtensionElement = new ExtensionElement();
                historyExtensionElement.setName("historyLevel");
                historyExtensionElement.setNamespace("http://flowable.org/bpmn");
                historyExtensionElement.setNamespacePrefix("flowable");
                historyExtensionElement.setElementText(historyLevel);
                process.addExtensionElement(historyExtensionElement);
            }
            BpmnJsonConverterUtil.convertJsonToMessages(modelNode, bpmnModel);
            BpmnJsonConverterUtil.convertJsonToListeners(modelNode, (BaseElement)process);
            JsonNode eventListenersNode = BpmnJsonConverterUtil.getProperty("eventlisteners", modelNode);
            if (eventListenersNode != null) {
                eventListenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(eventListenersNode);
                BpmnJsonConverterUtil.parseEventListeners(eventListenersNode.get("eventListeners"), (Process)process);
            }
            if ((processDataPropertiesNode = modelNode.get("properties").get("dataproperties")) != null) {
                List<ValuedDataObject> dataObjects = BpmnJsonConverterUtil.convertJsonToDataProperties(processDataPropertiesNode, (BaseElement)process);
                process.setDataObjects(dataObjects);
                process.getFlowElements().addAll(dataObjects);
            }
            String userStarterValue = BpmnJsonConverterUtil.getPropertyValueAsString("process_potentialstarteruser", modelNode);
            String groupStarterValue = BpmnJsonConverterUtil.getPropertyValueAsString("process_potentialstartergroup", modelNode);
            if (StringUtils.isNotEmpty((CharSequence)userStarterValue)) {
                String[] userStartArray = userStarterValue.split(",");
                ArrayList<String> userStarters = new ArrayList<String>(Arrays.asList(userStartArray));
                process.setCandidateStarterUsers(userStarters);
            }
            if (StringUtils.isNotEmpty((CharSequence)groupStarterValue)) {
                String[] groupStarterArray = groupStarterValue.split(",");
                ArrayList<String> groupStarters = new ArrayList<String>(Arrays.asList(groupStarterArray));
                process.setCandidateStarterGroups(groupStarters);
            }
            process.setEnableEagerExecutionTreeFetching(JsonConverterUtil.getPropertyValueAsBoolean("iseagerexecutionfetch", modelNode, false));
            this.processJsonElements((JsonNode)shapesArrayNode, modelNode, (BaseElement)process, shapeMap, converterContext, bpmnModel);
        } else {
            for (Object shapeNode : shapesArrayNode) {
                String sourceRef;
                if (!"SequenceFlow".equalsIgnoreCase(BpmnJsonConverterUtil.getStencilId((JsonNode)shapeNode)) && !"Association".equalsIgnoreCase(BpmnJsonConverterUtil.getStencilId((JsonNode)shapeNode)) || (sourceRef = BpmnJsonConverterUtil.lookForSourceRef(shapeNode.get("resourceId").asText(), modelNode.get("childShapes"))) == null) continue;
                Lane lane = (Lane)elementInLaneMap.get(sourceRef);
                SequenceFlowJsonConverter flowConverter = new SequenceFlowJsonConverter();
                if (lane != null) {
                    flowConverter.convertToBpmnModel((JsonNode)shapeNode, modelNode, this, (BaseElement)lane, shapeMap, bpmnModel, converterContext);
                    continue;
                }
                flowConverter.convertToBpmnModel((JsonNode)shapeNode, modelNode, this, (BaseElement)bpmnModel.getProcesses().get(0), shapeMap, bpmnModel, converterContext);
            }
        }
        HashMap<String, SubProcess> subShapesMap = new HashMap<String, SubProcess>();
        for (Process process : bpmnModel.getProcesses()) {
            Object flowElement2;
            for (Object flowElement2 : process.findFlowElementsOfType(SubProcess.class)) {
                SubProcess subProcess = (SubProcess)flowElement2;
                BpmnJsonConverter.fillSubShapes(subShapesMap, subProcess);
            }
            if (subShapesMap.isEmpty()) continue;
            ArrayList<String> removeSubFlowsList = new ArrayList<String>();
            flowElement2 = process.findFlowElementsOfType(SequenceFlow.class).iterator();
            while (flowElement2.hasNext()) {
                SubProcess subProcess;
                FlowElement flowElement3 = (FlowElement)flowElement2.next();
                SequenceFlow sequenceFlow = (SequenceFlow)flowElement3;
                if (!subShapesMap.containsKey(sequenceFlow.getSourceRef()) || (subProcess = (SubProcess)subShapesMap.get(sequenceFlow.getSourceRef())).getFlowElement(sequenceFlow.getId()) != null) continue;
                subProcess.addFlowElement((FlowElement)sequenceFlow);
                removeSubFlowsList.add(sequenceFlow.getId());
            }
            ArrayList<SubProcess> collapsedSubProcess = new ArrayList<SubProcess>();
            for (SubProcess subProcess : subShapesMap.values()) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(subProcess.getId());
                if (graphicInfo == null || !Boolean.FALSE.equals(graphicInfo.getExpanded())) continue;
                collapsedSubProcess.add(subProcess);
            }
            for (String flowId : removeSubFlowsList) {
                process.removeFlowElement(flowId);
                for (SubProcess subProcess : collapsedSubProcess) {
                    subProcess.removeFlowElement(flowId);
                }
            }
        }
        HashMap<String, FlowWithContainer> allFlowMap = new HashMap<String, FlowWithContainer>();
        ArrayList<Gateway> gatewayWithOrderList = new ArrayList<Gateway>();
        for (Process process : bpmnModel.getProcesses()) {
            BpmnJsonConverter.postProcessElements((FlowElementsContainer)process, process.getFlowElements(), edgeMap, bpmnModel, allFlowMap, gatewayWithOrderList);
        }
        for (Gateway gateway : gatewayWithOrderList) {
            List orderList = (List)gateway.getExtensionElements().get("EDITOR_FLOW_ORDER");
            if (CollectionUtils.isNotEmpty(orderList)) {
                for (ExtensionElement orderElement : orderList) {
                    String flowValue = orderElement.getElementText();
                    if (!StringUtils.isNotEmpty((CharSequence)flowValue) || !allFlowMap.containsKey(flowValue)) continue;
                    FlowWithContainer flowWithContainer = (FlowWithContainer)allFlowMap.get(flowValue);
                    flowWithContainer.getFlowContainer().removeFlowElement(flowWithContainer.getSequenceFlow().getId());
                    flowWithContainer.getFlowContainer().addFlowElement((FlowElement)flowWithContainer.getSequenceFlow());
                }
            }
            gateway.getExtensionElements().remove("EDITOR_FLOW_ORDER");
        }
        return bpmnModel;
    }

    @Override
    public void processJsonElements(JsonNode shapesArrayNode, JsonNode modelNode, BaseElement parentElement, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext, BpmnModel bpmnModel) {
        for (JsonNode shapeNode : shapesArrayNode) {
            String stencilId = BpmnJsonConverterUtil.getStencilId(shapeNode);
            Class<? extends BaseBpmnJsonConverter> converter = BPMN_CONVERTERS.get(stencilId);
            try {
                BaseBpmnJsonConverter converterInstance = converter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                converterInstance.convertToBpmnModel(shapeNode, modelNode, this, parentElement, shapeMap, bpmnModel, converterContext);
            }
            catch (Exception e) {
                LOG.error("Error converting {}", (Object)BpmnJsonConverterUtil.getStencilId(shapeNode), (Object)e);
            }
        }
    }

    static {
        StartEventJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        EndEventJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        SequenceFlowJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        MessageFlowJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        AssociationJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        BusinessRuleTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        MailTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        ManualTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        ReceiveTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        ScriptTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        ServiceTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        ShellTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        UserTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        CallActivityJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        CamelTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        MuleTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        HttpTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        SendTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        DecisionTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        SendEventTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        ExternalWorkerServiceTaskJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        ExclusiveGatewayJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        InclusiveGatewayJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        ParallelGatewayJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        EventGatewayJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        SubProcessJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        EventSubProcessJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        AdhocSubProcessJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        CatchEventJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        ThrowEventJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        BoundaryEventJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        TextAnnotationJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        DataStoreJsonConverter.fillTypes(BPMN_CONVERTERS, JSON_CONVERTERS);
        DI_CIRCLES = new ArrayList<String>();
        DI_RECTANGLES = new ArrayList<String>();
        DI_GATEWAY = new ArrayList<String>();
        DI_CIRCLES.add("StartConditionalEvent");
        DI_CIRCLES.add("StartErrorEvent");
        DI_CIRCLES.add("StartEscalationEvent");
        DI_CIRCLES.add("StartMessageEvent");
        DI_CIRCLES.add("StartNoneEvent");
        DI_CIRCLES.add("StartTimerEvent");
        DI_CIRCLES.add("StartSignalEvent");
        DI_CIRCLES.add("StartEventRegistryEvent");
        DI_CIRCLES.add("StartVariableListenerEvent");
        DI_CIRCLES.add("BoundaryConditionalEvent");
        DI_CIRCLES.add("BoundaryErrorEvent");
        DI_CIRCLES.add("BoundaryEscalationEvent");
        DI_CIRCLES.add("BoundarySignalEvent");
        DI_CIRCLES.add("BoundaryTimerEvent");
        DI_CIRCLES.add("BoundaryMessageEvent");
        DI_CIRCLES.add("BoundaryEventRegistryEvent");
        DI_CIRCLES.add("BoundaryVariableListenerEvent");
        DI_CIRCLES.add("BoundaryCancelEvent");
        DI_CIRCLES.add("BoundaryCompensationEvent");
        DI_CIRCLES.add("CatchConditionalEvent");
        DI_CIRCLES.add("CatchMessageEvent");
        DI_CIRCLES.add("CatchSignalEvent");
        DI_CIRCLES.add("CatchTimerEvent");
        DI_CIRCLES.add("CatchEventRegistryEvent");
        DI_CIRCLES.add("CatchVariableListenerEvent");
        DI_CIRCLES.add("ThrowNoneEvent");
        DI_CIRCLES.add("ThrowSignalEvent");
        DI_CIRCLES.add("ThrowEscalationEvent");
        DI_CIRCLES.add("ThrowCompensationEvent");
        DI_CIRCLES.add("EndNoneEvent");
        DI_CIRCLES.add("EndErrorEvent");
        DI_CIRCLES.add("EndEscalationEvent");
        DI_CIRCLES.add("EndCancelEvent");
        DI_CIRCLES.add("EndTerminateEvent");
        DI_RECTANGLES.add("CallActivity");
        DI_RECTANGLES.add("SubProcess");
        DI_RECTANGLES.add("CollapsedSubProcess");
        DI_RECTANGLES.add("EventSubProcess");
        DI_RECTANGLES.add("AdhocSubProcess");
        DI_RECTANGLES.add("BusinessRule");
        DI_RECTANGLES.add("MailTask");
        DI_RECTANGLES.add("ManualTask");
        DI_RECTANGLES.add("ReceiveTask");
        DI_RECTANGLES.add("ReceiveEventTask");
        DI_RECTANGLES.add("ScriptTask");
        DI_RECTANGLES.add("SendTask");
        DI_RECTANGLES.add("SendEventTask");
        DI_RECTANGLES.add("ServiceTask");
        DI_RECTANGLES.add("UserTask");
        DI_RECTANGLES.add("CamelTask");
        DI_RECTANGLES.add("MuleTask");
        DI_RECTANGLES.add("HttpTask");
        DI_RECTANGLES.add("DecisionTask");
        DI_RECTANGLES.add("SendEventTask");
        DI_RECTANGLES.add("ExternalWorkerTask");
        DI_RECTANGLES.add("ShellTask");
        DI_RECTANGLES.add("TextAnnotation");
        DI_GATEWAY.add("EventGateway");
        DI_GATEWAY.add("ExclusiveGateway");
        DI_GATEWAY.add("InclusiveGateway");
        DI_GATEWAY.add("ParallelGateway");
    }

    private static class FlowWithContainer {
        private SequenceFlow sequenceFlow;
        private FlowElementsContainer flowContainer;

        FlowWithContainer(SequenceFlow sequenceFlow, FlowElementsContainer flowContainer) {
            this.sequenceFlow = sequenceFlow;
            this.flowContainer = flowContainer;
        }

        public SequenceFlow getSequenceFlow() {
            return this.sequenceFlow;
        }

        public void setSequenceFlow(SequenceFlow sequenceFlow) {
            this.sequenceFlow = sequenceFlow;
        }

        public FlowElementsContainer getFlowContainer() {
            return this.flowContainer;
        }

        public void setFlowContainer(FlowElementsContainer flowContainer) {
            this.flowContainer = flowContainer;
        }
    }
}

