/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.List;
import lombok.Generated;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20TokenAuthorizationResponseBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.idtoken.IdTokenGenerationContext;
import org.apereo.cas.ticket.idtoken.OidcIdToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder<T extends OidcConfigurationContext>
extends OAuth20TokenAuthorizationResponseBuilder<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder.class);

    public OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder(T configurationContext, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder) {
        super(configurationContext, authorizationModelAndViewBuilder);
    }

    public boolean supports(OAuth20AuthorizationRequest context) {
        return OAuth20Utils.isResponseType((String)context.getResponseType(), (OAuth20ResponseTypes)OAuth20ResponseTypes.IDTOKEN_TOKEN);
    }

    protected ModelAndView buildCallbackUrlResponseType(AccessTokenRequestContext tokenRequestContext, Ticket givenAccessToken, Ticket givenRefreshToken, List<NameValuePair> parameters) throws Throwable {
        OAuth20AccessToken accessToken = this.resolveAccessToken(givenAccessToken);
        IdTokenGenerationContext idTokenContext = IdTokenGenerationContext.builder().accessToken(accessToken).userProfile(tokenRequestContext.getUserProfile()).responseType(OAuth20ResponseTypes.IDTOKEN_TOKEN).grantType(tokenRequestContext.getGrantType()).registeredService(tokenRequestContext.getRegisteredService()).build();
        OidcIdToken idToken = ((OidcConfigurationContext)this.configurationContext).getIdTokenGeneratorService().generate(idTokenContext);
        if (idToken != null) {
            LOGGER.debug("Generated id token [{}]", (Object)idToken);
            parameters.add((NameValuePair)new BasicNameValuePair("id_token", idToken.token()));
        }
        return super.buildCallbackUrlResponseType(tokenRequestContext, (Ticket)accessToken, givenRefreshToken, parameters);
    }
}

