/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.oidc.claims.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.OidcRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceChainingAttributeReleasePolicy;

public class OidcDefaultAttributeToScopeClaimMapper
implements OidcAttributeToScopeClaimMapper {
    private final Map<String, String> claimsToAttribute;

    public String getMappedAttribute(String claim, RegisteredService registeredService) {
        Map<String, String> container = OidcDefaultAttributeToScopeClaimMapper.getClaimMappingsContainer(registeredService);
        return Optional.ofNullable(container.get(claim)).orElseGet(() -> this.claimsToAttribute.get(claim));
    }

    public boolean containsMappedAttribute(String claim, RegisteredService registeredService) {
        Map<String, String> container = OidcDefaultAttributeToScopeClaimMapper.getClaimMappingsContainer(registeredService);
        return this.claimsToAttribute.containsKey(claim) || container.containsKey(claim);
    }

    private static Map<String, String> getClaimMappingsContainer(RegisteredService registeredService) {
        Stream<Object> finalMap = Stream.empty();
        RegisteredServiceAttributeReleasePolicy registeredServiceAttributeReleasePolicy = registeredService.getAttributeReleasePolicy();
        if (registeredServiceAttributeReleasePolicy instanceof RegisteredServiceChainingAttributeReleasePolicy) {
            RegisteredServiceChainingAttributeReleasePolicy chain = (RegisteredServiceChainingAttributeReleasePolicy)registeredServiceAttributeReleasePolicy;
            for (RegisteredServiceAttributeReleasePolicy policy : chain.getPolicies()) {
                Stream<Map.Entry<String, String>> result = OidcDefaultAttributeToScopeClaimMapper.getClaimMappingsForPolicy(policy);
                finalMap = Stream.concat(finalMap, result);
            }
        }
        Stream<Map.Entry<String, String>> result = OidcDefaultAttributeToScopeClaimMapper.getClaimMappingsForPolicy(registeredService.getAttributeReleasePolicy());
        Stream<Map.Entry<String, String>> finalResult = Stream.concat(finalMap, result);
        return finalResult.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Stream<Map.Entry<String, String>> getClaimMappingsForPolicy(RegisteredServiceAttributeReleasePolicy policy) {
        Stream<Map.Entry<String, String>> stream;
        if (policy instanceof OidcRegisteredServiceAttributeReleasePolicy) {
            OidcRegisteredServiceAttributeReleasePolicy oidcPolicy = (OidcRegisteredServiceAttributeReleasePolicy)policy;
            stream = oidcPolicy.getClaimMappings().entrySet().stream();
        } else {
            stream = Stream.empty();
        }
        return stream;
    }

    @Generated
    public OidcDefaultAttributeToScopeClaimMapper(Map<String, String> claimsToAttribute) {
        this.claimsToAttribute = claimsToAttribute;
    }
}

