/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.test;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Optional;
import org.flowable.common.engine.impl.agenda.AgendaOperationExecutionListener;
import org.flowable.common.engine.impl.cfg.CommandExecutorImpl;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.impl.interceptor.CommandInvoker;
import org.flowable.engine.impl.interceptor.LoggingExecutionTreeAgendaOperationExecutionListener;
import org.flowable.engine.impl.test.InternalFlowableExtension;
import org.flowable.engine.test.ConfigurationResource;
import org.flowable.engine.test.EnableVerboseExecutionTreeLogging;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class PluggableFlowableExtension
extends InternalFlowableExtension {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{PluggableFlowableExtension.class});

    @Override
    public void beforeEach(ExtensionContext context) {
        super.beforeEach(context);
        if (AnnotationSupport.isAnnotated((AnnotatedElement)context.getRequiredTestClass(), EnableVerboseExecutionTreeLogging.class)) {
            this.swapCommandInvoker(this.getProcessEngine(context), true);
        }
    }

    @Override
    public void afterEach(ExtensionContext context) throws Exception {
        try {
            super.afterEach(context);
        }
        finally {
            if (AnnotationSupport.isAnnotated((AnnotatedElement)context.getRequiredTestClass(), EnableVerboseExecutionTreeLogging.class)) {
                this.swapCommandInvoker(this.getProcessEngine(context), false);
            }
        }
    }

    @Override
    protected ProcessEngine getProcessEngine(ExtensionContext context) {
        String configurationResource = this.getConfigurationResource(context);
        return (ProcessEngine)this.getStore(context).getOrComputeIfAbsent((Object)configurationResource, this::initializeProcessEngine, ProcessEngine.class);
    }

    protected ProcessEngine initializeProcessEngine(String configurationResource) {
        this.logger.info("No cached process engine found for test. Retrieving engine from {}.", (Object)configurationResource);
        ProcessEngineConfiguration processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(configurationResource);
        ProcessEngine previousProcessEngine = ProcessEngines.getProcessEngine(processEngineConfiguration.getEngineName());
        if (previousProcessEngine != null) {
            ProcessEngines.unregister(previousProcessEngine);
        }
        ProcessEngine processEngine = processEngineConfiguration.buildProcessEngine();
        ProcessEngines.setInitialized(true);
        return processEngine;
    }

    protected String getConfigurationResource(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), ConfigurationResource.class).map(ConfigurationResource::value).orElse("flowable.cfg.xml");
    }

    protected void swapCommandInvoker(ProcessEngine processEngine, boolean debug) {
        CommandExecutor commandExecutor = processEngine.getProcessEngineConfiguration().getCommandExecutor();
        if (commandExecutor instanceof CommandExecutorImpl) {
            CommandExecutorImpl commandExecutorImpl = (CommandExecutorImpl)commandExecutor;
            CommandInterceptor previousCommandInterceptor = null;
            for (CommandInterceptor commandInterceptor = commandExecutorImpl.getFirst(); commandInterceptor != null; commandInterceptor = commandInterceptor.getNext()) {
                if (commandInterceptor instanceof CommandInvoker) {
                    ArrayList<Object> agendaOperationExecutionListeners = processEngine.getProcessEngineConfiguration().getAgendaOperationExecutionListeners();
                    if (debug) {
                        agendaOperationExecutionListeners = agendaOperationExecutionListeners == null ? new ArrayList<AgendaOperationExecutionListener>() : new ArrayList(agendaOperationExecutionListeners);
                        agendaOperationExecutionListeners.add(this.newLoggingExecutionTreeAgendaOperationExecutionListener());
                    }
                    CommandInvoker commandInvoker = new CommandInvoker(processEngine.getProcessEngineConfiguration().getAgendaOperationRunner(), agendaOperationExecutionListeners);
                    if (previousCommandInterceptor != null) {
                        previousCommandInterceptor.setNext((CommandInterceptor)commandInvoker);
                    } else {
                        commandExecutorImpl.setFirst(previousCommandInterceptor);
                    }
                    break;
                }
                previousCommandInterceptor = commandInterceptor;
            }
        } else {
            this.logger.warn("Not using {}, ignoring the {} annotation", CommandExecutorImpl.class, EnableVerboseExecutionTreeLogging.class);
        }
    }

    @Override
    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }

    protected AgendaOperationExecutionListener newLoggingExecutionTreeAgendaOperationExecutionListener() {
        return new LoggingExecutionTreeAgendaOperationExecutionListener();
    }
}

