/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.entitylink.api.EntityLink;

public class GetEntityLinkParentsForProcessInstanceCmd
implements Command<List<EntityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;

    public GetEntityLinkParentsForProcessInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public List<EntityLink> execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExecutionEntity processInstance = (ExecutionEntity)processEngineConfiguration.getExecutionEntityManager().findById(this.processInstanceId);
        if (processInstance == null) {
            throw new FlowableObjectNotFoundException("Cannot find process instance with id " + this.processInstanceId, ExecutionEntity.class);
        }
        return processEngineConfiguration.getEntityLinkServiceConfiguration().getEntityLinkService().findEntityLinksByReferenceScopeIdAndType(this.processInstanceId, "bpmn", "child");
    }
}

