/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FetchTicketGrantingTicketAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchTicketGrantingTicketAction.class);
    private final TicketRegistry ticketRegistry;
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;

    @Override
    protected Event doExecuteInternal(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String cookieResult = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        Optional.ofNullable(cookieResult).ifPresent(cookie -> this.populateWebflowWithTicketFromCookie(requestContext, (String)cookie));
        return null;
    }

    private void populateWebflowWithTicketFromCookie(RequestContext requestContext, String ticketId) {
        LOGGER.debug("Attempting to locate ticket-granting ticket from cookie value [{}]", (Object)ticketId);
        TicketGrantingTicket ticket = (TicketGrantingTicket)FunctionUtils.doAndHandle(() -> (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketId, TicketGrantingTicket.class), throwable -> null).get();
        if (ticket != null) {
            LOGGER.debug("Found ticket-granting ticket [{}]", (Object)ticket.getId());
            WebUtils.putTicketGrantingTicket((RequestContext)requestContext, (Ticket)ticket);
            WebUtils.putTicketGrantingTicketInScopes((RequestContext)requestContext, (Ticket)ticket);
            WebUtils.putAuthentication((Authentication)ticket.getAuthentication(), (RequestContext)requestContext);
        }
    }

    @Generated
    public FetchTicketGrantingTicketAction(TicketRegistry ticketRegistry, CasCookieBuilder ticketGrantingTicketCookieGenerator) {
        this.ticketRegistry = ticketRegistry;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }
}

