/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.utils;

import com.microsoft.graph.models.PasswordProfile;
import net.tirasa.connid.bundles.azure.utils.AzureFilter;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public final class AzureUtils {
    private static final Log LOG = Log.getLog(AzureUtils.class);

    public static PasswordProfile createPassword(String password) {
        PasswordProfile passwordProfile = new PasswordProfile();
        passwordProfile.getBackingStore().set("password", (Object)password);
        return passwordProfile;
    }

    public static void handleGeneralError(String message) {
        LOG.error("General error : {0}", new Object[]{message});
        throw new ConnectorException(message);
    }

    public static void handleGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw new ConnectorException(message, (Throwable)ex);
    }

    public static void wrapGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw ConnectorException.wrap((Throwable)ex);
    }

    public static String getFilter(AzureFilter filters) {
        switch (filters.getFilterOp()) {
            case EQUALS: {
                if (filters.getValue() instanceof String) {
                    return filters.getAttribute().getName() + " eq '" + filters.getValue() + "'";
                }
                return filters.getAttribute().getName() + " eq " + filters.getValue();
            }
            case STARTS_WITH: {
                return "startswith(" + filters.getAttribute().getName() + ",'" + filters.getValue() + "')";
            }
            case ENDS_WITH: {
                return "endswith(" + filters.getAttribute().getName() + ",'" + filters.getValue() + "')";
            }
            case AND: {
                return AzureUtils.getFilter(filters.getFilters().get(0)) + " and " + AzureUtils.getFilter(filters.getFilters().get(1));
            }
            case OR: {
                return AzureUtils.getFilter(filters.getFilters().get(0)) + " or " + AzureUtils.getFilter(filters.getFilters().get(1));
            }
        }
        throw new ConnectorException("Invalid search filter");
    }

    private AzureUtils() {
    }
}

