/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20DefaultAccessToken;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20DefaultCode;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceToken;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.apereo.cas.ticket.refreshtoken.OAuth20DefaultRefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20TicketCatalogConfigurer
extends BaseTicketCatalogConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TicketCatalogConfigurer.class);

    public void configureTicketCatalog(TicketCatalog plan, CasConfigurationProperties casProperties) throws Throwable {
        LOGGER.trace("Registering OAuth protocol ticket definitions...");
        this.buildAndRegisterOAuthCodeDefinition(plan, this.buildTicketDefinition(plan, "OC", OAuth20Code.class, OAuth20DefaultCode.class, Integer.MIN_VALUE), casProperties);
        this.buildAndRegisterAccessTokenDefinition(plan, this.buildTicketDefinition(plan, "AT", OAuth20AccessToken.class, OAuth20DefaultAccessToken.class, Integer.MIN_VALUE), casProperties);
        this.buildAndRegisterRefreshTokenDefinition(plan, this.buildTicketDefinition(plan, "RT", OAuth20RefreshToken.class, OAuth20DefaultRefreshToken.class, Integer.MIN_VALUE), casProperties);
        this.buildAndRegisterDeviceTokenDefinition(plan, this.buildTicketDefinition(plan, "ODT", OAuth20DefaultDeviceToken.class, OAuth20DeviceToken.class), casProperties);
        this.buildAndRegisterDeviceUserCodeDefinition(plan, this.buildTicketDefinition(plan, "ODUC", OAuth20DefaultDeviceUserCode.class, OAuth20DeviceUserCode.class), casProperties);
    }

    protected void buildAndRegisterAccessTokenDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getOauth().getAccessToken().getStorageName());
        long timeout = Beans.newDuration((String)casProperties.getAuthn().getOauth().getAccessToken().getMaxTimeToLiveInSeconds()).toSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        metadata.getProperties().setExcludeFromCascade(casProperties.getTicket().isTrackDescendantTickets());
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterRefreshTokenDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getOauth().getRefreshToken().getStorageName());
        long timeout = Beans.newDuration((String)casProperties.getAuthn().getOauth().getRefreshToken().getTimeToKillInSeconds()).toSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        metadata.getProperties().setExcludeFromCascade(casProperties.getTicket().isTrackDescendantTickets());
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterOAuthCodeDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getOauth().getCode().getStorageName());
        metadata.getProperties().setStorageTimeout(casProperties.getAuthn().getOauth().getCode().getTimeToKillInSeconds());
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterDeviceTokenDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getOauth().getDeviceToken().getStorageName());
        long timeout = Beans.newDuration((String)casProperties.getAuthn().getOauth().getDeviceToken().getMaxTimeToLiveInSeconds()).toSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        metadata.getProperties().setExcludeFromCascade(true);
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterDeviceUserCodeDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getOauth().getDeviceUserCode().getStorageName());
        long timeout = Beans.newDuration((String)casProperties.getAuthn().getOauth().getDeviceUserCode().getMaxTimeToLiveInSeconds()).toSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        metadata.getProperties().setExcludeFromCascade(true);
        this.registerTicketDefinition(plan, metadata);
    }
}

