/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ClientAuthenticationMethods;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.http.credentials.X509Credentials;
import org.pac4j.http.credentials.authenticator.X509Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20X509Authenticator
implements Authenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20X509Authenticator.class);
    private final ServicesManager servicesManager;
    private final OAuth20RequestParameterResolver requestParameterResolver;

    public Optional<Credentials> validate(CallContext ctx, Credentials credentials) {
        Pair clientIdAndSecret = this.requestParameterResolver.resolveClientIdAndClientSecret(ctx);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, (String)clientIdAndSecret.getKey());
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
        if (!this.isAuthenticationMethodSupported(ctx, registeredService)) {
            LOGGER.warn("TLS authentication method is not supported for service [{}]", (Object)registeredService.getName());
            return Optional.empty();
        }
        String allowedSubjectPattern = (String)StringUtils.defaultIfBlank((CharSequence)registeredService.getTlsClientAuthSubjectDn(), (CharSequence)"CN=(.*?)(?:,|$)");
        X509Authenticator x509Authenticator = new X509Authenticator(allowedSubjectPattern);
        Optional result = x509Authenticator.validate(ctx, credentials);
        if (result.isPresent()) {
            UserProfile profile = ((Credentials)result.get()).getUserProfile();
            X509Certificate certificate = ((X509Credentials)credentials).getCertificate();
            String digest = EncodingUtils.encodeBase64((String)DigestUtils.digest((String)"SHA-256", (byte[])certificate.getPublicKey().getEncoded()));
            profile.addAttribute("x509_digest", (Object)digest);
            profile.addAttribute("authenticationMethod", (Object)"X.509");
            profile.addAttribute("client_id", clientIdAndSecret.getKey());
            Map attributeMap = CollectionUtils.wrap((String)"x509-sanEmail", (Object)registeredService.getTlsClientAuthSanEmail(), (String)"x509-sanDNS", (Object)registeredService.getTlsClientAuthSanDns(), (String)"x509-sanIP", (Object)registeredService.getTlsClientAuthSanIp(), (String)"x509-sanURI", (Object)registeredService.getTlsClientAuthSanUri());
            boolean accepted = attributeMap.entrySet().stream().allMatch(entry -> this.isAcceptableX509Attribute(profile, (String)entry.getKey(), (String)entry.getValue()));
            if (!accepted) {
                throw new CredentialsException("Unable to accept certificate");
            }
        }
        return result;
    }

    protected boolean isAuthenticationMethodSupported(CallContext ctx, OAuthRegisteredService registeredService) {
        return OAuth20Utils.isTokenAuthenticationMethodSupportedFor(ctx, registeredService, OAuth20ClientAuthenticationMethods.TLS_CLIENT_AUTH);
    }

    protected boolean isAcceptableX509Attribute(UserProfile profile, String pattern, String attribute) {
        return (Boolean)FunctionUtils.doIfNotBlank((CharSequence)pattern, () -> {
            Set values = CollectionUtils.toCollection((Object)profile.getAttribute(attribute));
            return !values.isEmpty() && values.stream().anyMatch(email -> RegexUtils.find((String)pattern, (String)email.toString()));
        }, () -> Boolean.TRUE);
    }

    @Generated
    public OAuth20X509Authenticator(ServicesManager servicesManager, OAuth20RequestParameterResolver requestParameterResolver) {
        this.servicesManager = servicesManager;
        this.requestParameterResolver = requestParameterResolver;
    }
}

