/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.json.converter;

import org.apache.commons.lang3.StringUtils;
import org.flowable.eventregistry.json.converter.ChannelValidator;
import org.flowable.eventregistry.json.converter.FlowableEventJsonException;
import org.flowable.eventregistry.model.ChannelEventKeyDetection;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;

public class InboundChannelModelValidator
implements ChannelValidator {
    @Override
    public void validateChannel(ChannelModel channelModel) {
        if (channelModel instanceof InboundChannelModel) {
            InboundChannelModel inboundChannelModel = (InboundChannelModel)channelModel;
            this.validateChannel(inboundChannelModel);
        }
    }

    protected void validateChannel(InboundChannelModel inboundChannelModel) {
        if (StringUtils.isEmpty((CharSequence)inboundChannelModel.getPipelineDelegateExpression())) {
            this.validateDeserializer(inboundChannelModel);
        }
    }

    protected void validateDeserializer(InboundChannelModel inboundChannelModel) {
        String deserializerType = inboundChannelModel.getDeserializerType();
        ChannelEventKeyDetection channelEventKeyDetection = inboundChannelModel.getChannelEventKeyDetection();
        if ("json".equalsIgnoreCase(deserializerType)) {
            if (channelEventKeyDetection == null) {
                throw new FlowableEventJsonException("A channel key detection value is required for the channel model with key " + inboundChannelModel.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)channelEventKeyDetection.getFixedValue()) && StringUtils.isEmpty((CharSequence)channelEventKeyDetection.getJsonField()) && StringUtils.isEmpty((CharSequence)channelEventKeyDetection.getJsonPointerExpression()) && StringUtils.isEmpty((CharSequence)channelEventKeyDetection.getDelegateExpression())) {
                throw new FlowableEventJsonException("The channel json key detection value was not found for the channel model with key " + inboundChannelModel.getKey() + ". One of fixedValue, jsonField, jsonPointerExpression, delegateExpression should be set.");
            }
        } else if ("xml".equalsIgnoreCase(deserializerType)) {
            if (channelEventKeyDetection == null) {
                throw new FlowableEventJsonException("A channel key detection value is required for the channel model with key " + inboundChannelModel.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)channelEventKeyDetection.getFixedValue()) && StringUtils.isEmpty((CharSequence)channelEventKeyDetection.getXmlXPathExpression()) && StringUtils.isEmpty((CharSequence)channelEventKeyDetection.getDelegateExpression())) {
                throw new FlowableEventJsonException("The channel xml key detection value was not found for the channel model with key " + inboundChannelModel.getKey() + ". One of fixedValue, xmlPathExpression, delegateExpression should be set.");
            }
        } else if ("expression".equalsIgnoreCase(deserializerType)) {
            if (StringUtils.isEmpty((CharSequence)inboundChannelModel.getDeserializerDelegateExpression())) {
                throw new FlowableEventJsonException("The channel deserializer delegate expression was not set for the channel model with key " + String.valueOf(inboundChannelModel));
            }
        } else if (deserializerType != null) {
            throw new FlowableEventJsonException("The deserializer type is not supported " + deserializerType + " for the channel model with key " + inboundChannelModel.getKey());
        }
    }
}

