/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.List;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.ext.openfga.client.OpenFGAClient;
import org.apache.syncope.ext.openfga.client.OpenFGAClientFactory;
import org.apache.syncope.ext.openfga.client.OpenFGAStoreManager;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class OpenFGAReinit
extends AbstractSchedTaskJobDelegate<SchedTask> {
    @Autowired
    protected OpenFGAStoreManager storeManager;
    @Autowired
    protected OpenFGAClientFactory clientFactory;
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected RelationshipTypeDAO relationshipTypeDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;

    protected String doExecute(JobExecutionContext context) throws JobExecutionException {
        if (!context.isDryRun()) {
            this.setStatus("Start rebuilding OpenFGA authorization model and tuples");
            try {
                OpenFGAClient client = this.clientFactory.get(AuthContextUtils.getDomain());
                this.clientFactory.initAuthorizationModel(client, AuthContextUtils.getDomain(), true);
                List<AnyType> anyTypes = this.anyTypeDAO.findAll().stream().filter(anyType -> anyType.getKind() == AnyTypeKind.ANY_OBJECT).toList();
                for (AnyType anyType2 : anyTypes) {
                    this.storeManager.handle(client, SyncDeltaType.CREATE, anyType2);
                }
                List relationshipTypes = this.relationshipTypeDAO.findAll();
                for (RelationshipType relationshipType : relationshipTypes) {
                    this.storeManager.handle(client, SyncDeltaType.CREATE, relationshipType);
                }
                long l = this.userDAO.count();
                int page = 0;
                while ((long)page <= l / 500L) {
                    PageRequest pageable = PageRequest.of((int)page, (int)500, (Sort)DAO.DEFAULT_SORT);
                    for (User user : this.userDAO.findAll((Pageable)pageable)) {
                        this.storeManager.handle(client, SyncDeltaType.CREATE, (Any)user);
                    }
                    ++page;
                }
                long groups = this.groupDAO.count();
                int page2 = 0;
                while ((long)page2 <= groups / 500L) {
                    PageRequest pageable = PageRequest.of((int)page2, (int)500, (Sort)DAO.DEFAULT_SORT);
                    for (Group group : this.groupDAO.findAll((Pageable)pageable)) {
                        this.storeManager.handle(client, SyncDeltaType.CREATE, (Any)group);
                    }
                    ++page2;
                }
                long anyObjects = this.anyObjectDAO.count();
                int page3 = 0;
                while ((long)page3 <= anyObjects / 500L) {
                    PageRequest pageable = PageRequest.of((int)page3, (int)500, (Sort)DAO.DEFAULT_SORT);
                    for (AnyObject anyObject : this.anyObjectDAO.findAll((Pageable)pageable)) {
                        this.storeManager.handle(client, SyncDeltaType.CREATE, (Any)anyObject);
                    }
                    ++page3;
                }
                this.setStatus("Rebuild for domain " + AuthContextUtils.getDomain() + " successfully completed");
                return "Authorization model replaced with USER, GROUP, " + anyTypes.size() + " AnyTypes, Memberships and " + relationshipTypes.size() + " RelationshipTypes\nTuples:\n * " + l + " Users\n * " + groups + " Groups\n * " + anyObjects + " AnyObjects";
            }
            catch (Exception e) {
                throw new JobExecutionException("While rebuilding for domain " + AuthContextUtils.getDomain(), (Throwable)e);
            }
        }
        return "SUCCESS";
    }

    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return true;
    }
}

