/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.policy;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationPolicyExecutionResult;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.policy.BaseAuthenticationPolicy;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class RequiredAttributesAuthenticationPolicy
extends BaseAuthenticationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RequiredAttributesAuthenticationPolicy.class);
    private static final long serialVersionUID = 8901190843828760737L;
    private final Map<String, String> requiredAttributes;

    public AuthenticationPolicyExecutionResult isSatisfiedBy(Authentication authentication, Set<AuthenticationHandler> authenticationHandlers, ConfigurableApplicationContext applicationContext, Map<String, ? extends Serializable> context) {
        Map<String, List<Object>> allAttributes = CoreAuthenticationUtils.mergeAttributes(authentication.getAttributes(), authentication.getPrincipal().getAttributes());
        boolean result = this.requiredAttributes.entrySet().stream().allMatch(entry -> {
            boolean foundAttribute = allAttributes.containsKey(entry.getKey());
            if (foundAttribute) {
                List attributeValues = (List)allAttributes.get(entry.getKey());
                foundAttribute = RegexUtils.findFirst((String)((String)entry.getValue()), (Collection)attributeValues).isPresent();
            }
            return foundAttribute;
        });
        return AuthenticationPolicyExecutionResult.success((boolean)result);
    }

    @Generated
    public RequiredAttributesAuthenticationPolicy() {
        this.requiredAttributes = null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequiredAttributesAuthenticationPolicy)) {
            return false;
        }
        RequiredAttributesAuthenticationPolicy other = (RequiredAttributesAuthenticationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$requiredAttributes = this.requiredAttributes;
        Map<String, String> other$requiredAttributes = other.requiredAttributes;
        return !(this$requiredAttributes == null ? other$requiredAttributes != null : !((Object)this$requiredAttributes).equals(other$requiredAttributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequiredAttributesAuthenticationPolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $requiredAttributes = this.requiredAttributes;
        result = result * 59 + ($requiredAttributes == null ? 43 : ((Object)$requiredAttributes).hashCode());
        return result;
    }

    @Generated
    public Map<String, String> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    @Generated
    public RequiredAttributesAuthenticationPolicy(Map<String, String> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
    }
}

